/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.GeoRegion;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.processing.CacheImageSize;
import com.supermap.data.processing.CacheImageType;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalGeoRegion;
import com.supermap.data.processing.InternalGeometry;
import com.supermap.data.processing.InternalHandle;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.InternalToolkitProcessing;
import com.supermap.data.processing.MapCache3DBuilderNative;
import com.supermap.data.processing.MapCacheBuilderNative;
import com.supermap.data.processing.StorageType;
import com.supermap.mapping.Map;
import java.util.Vector;

public class MapCache3DBuilder
extends com.supermap.data.processing.InternalHandleDisposable {
    private Map _$4 = null;
    private GeoRegion _$3 = null;
    private long _$2;
    transient Vector<SteppedListener> m_steppedListeners;
    private static String _$1;

    public MapCache3DBuilder() {
        long l = MapCache3DBuilderNative.jni_New();
        this.setHandle(l, true);
        this._$1(null, null, null);
    }

    public MapCache3DBuilder(Map map, String string) {
        long l = MapCache3DBuilderNative.jni_New();
        this.setHandle(l, true);
        this._$1(map, string, null);
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    public MapCache3DBuilder(Map map, String string, String string2) {
        long l = MapCache3DBuilderNative.jni_New();
        this.setHandle(l, true);
        this._$1(map, string, string2);
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    public Map getMap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$4;
    }

    public void setMap(Map map) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (map == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)map) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetMap(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)map));
        this._$4 = map;
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    public GeoRegion getClipRegion() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$3 == null) {
            long l = MapCache3DBuilderNative.jni_GetClipRegion(this.getHandle());
            if (l != 0L) {
                this._$3 = (GeoRegion)InternalGeometry.createInstance(l);
                com.supermap.data.processing.InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)this._$3, false);
            }
        } else {
            long l = MapCache3DBuilderNative.jni_GetClipRegion(this.getHandle());
            if (l != 0L) {
                InternalGeoRegion.clearHandle(this._$3);
                InternalGeoRegion.refreshHandle(this._$3, l);
            } else {
                InternalGeoRegion.clearHandle(this._$3);
                this._$3 = null;
            }
        }
        return this._$3;
    }

    public void setClipRegion(GeoRegion geoRegion) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        GeoRegion geoRegion2 = null;
        if (geoRegion != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion) == 0L) {
                String string = InternalResource.loadString("setClipRegion()", "Handle_ObjectHasBeenDisposed", "processing_resources");
                throw new IllegalStateException(string);
            }
            geoRegion2 = new GeoRegion(geoRegion);
            MapCache3DBuilderNative.jni_SetClipRegion(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)geoRegion));
        } else {
            MapCache3DBuilderNative.jni_SetClipRegion(this.getHandle(), 0L);
        }
        this._$3 = geoRegion2;
        com.supermap.data.processing.InternalHandleDisposable.makeSureNativeObjectLive(geoRegion2);
    }

    public Rectangle2D getBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapCache3DBuilderNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public void setBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (rectangle2D == null) {
            String string = InternalResource.loadString("rect", "Global_ArgumentNull", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getHeight() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsHeightShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getWidth() < 0.0) {
            String string = InternalResource.loadString("rect", "Map_CacheBoundsWidthShouldBePositive", "processing_resources");
            throw new IllegalArgumentException(string);
        }
        MapCache3DBuilderNative.jni_SetBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public String getCacheName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCache3DBuilderNative.jni_GetCacheName(this.getHandle());
        if ((string == null || string.length() == 0) && this._$4 != null) {
            string = this._$4.getName();
        }
        return string;
    }

    public void setCacheName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setCacheName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        MapCache3DBuilderNative.jni_SetCacheName(this.getHandle(), string);
    }

    public CacheImageSize getImageSize() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCache3DBuilderNative.jni_GetImageSize(this.getHandle());
        CacheImageSize cacheImageSize = null;
        switch (n) {
            case 0: {
                cacheImageSize = CacheImageSize.SIZE64;
                break;
            }
            case 1: {
                cacheImageSize = CacheImageSize.SIZE128;
                break;
            }
            case 2: {
                cacheImageSize = CacheImageSize.SIZE256;
                break;
            }
            case 3: {
                cacheImageSize = CacheImageSize.SIZE512;
                break;
            }
            case 4: {
                cacheImageSize = CacheImageSize.SIZE1024;
                break;
            }
            case 5: {
                cacheImageSize = CacheImageSize.SIZE2048;
                break;
            }
            default: {
                cacheImageSize = CacheImageSize.SIZE256;
            }
        }
        return cacheImageSize;
    }

    public void setImageSize(CacheImageSize cacheImageSize) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageSize()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(cacheImageSize);
        MapCache3DBuilderNative.jni_SetIamgeSize(this.getHandle(), n);
    }

    public int getImageCompress() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageCompress()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCache3DBuilderNative.jni_GetImageCompress(this.getHandle());
        return n;
    }

    public void setImageCompress(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageCompress()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetImageCompress(this.getHandle(), n);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCache3DBuilderNative.jni_GetOutputFolder(this.getHandle());
        return string;
    }

    public void setOutputFolder(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        MapCache3DBuilderNative.jni_SetOutputFolder(this.getHandle(), string);
    }

    public boolean isTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isTransparent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_IsTransparent(this.getHandle());
    }

    public void setTransparent(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransparent()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetTransparentc(this.getHandle(), bl);
    }

    public CacheImageType getImageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getImageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCache3DBuilderNative.jni_GetImageType(this.getHandle());
        CacheImageType cacheImageType = null;
        cacheImageType = (CacheImageType)InternalEnum.parseUGCValue(CacheImageType.class, n);
        return cacheImageType;
    }

    public boolean isFillMargin() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isFillMargin()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheBuilderNative.jni_IsFillMargin(this.getHandle());
    }

    public void setFillMargin(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setFillMargin()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheBuilderNative.jni_SetFillMargin(this.getHandle(), bl);
    }

    public void setImageType(CacheImageType cacheImageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(cacheImageType);
        MapCache3DBuilderNative.jni_SetImageType(this.getHandle(), n);
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCache3DBuilderNative.jni_GetStorageType(this.getHandle());
        StorageType storageType = null;
        storageType = (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
        return storageType;
    }

    public void setStorageType(StorageType storageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = InternalEnum.getUGCValue(storageType);
        MapCache3DBuilderNative.jni_SetStorageType(this.getHandle(), n);
    }

    public int getBeginLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getBeginLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_GetBeginLevel(this.getHandle());
    }

    public void setBeginLevel(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setBeginLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetBeginLevel(this.getHandle(), n);
    }

    public int getEndLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEndLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_GetEndlevel(this.getHandle());
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners == null) {
            this.m_steppedListeners = new Vector();
        }
        if (!this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.add(steppedListener);
        }
    }

    public void setEndLevel(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEndLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCache3DBuilderNative.jni_SetEndlevel(this.getHandle(), n);
    }

    public String getPassword() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_GetPassword(this.getHandle());
    }

    public void setPassword(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setPassword()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        MapCache3DBuilderNative.jni_SetPassword(this.getHandle(), string);
    }

    public boolean computeLevel() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeLevel()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCache3DBuilderNative.jni_ComputeLevel(this.getHandle());
    }

    public boolean build() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("build()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getMap() == null) {
            String string = InternalResource.loadString("build()", "MapCache3DBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("build()", "Global_PathIsNotValid", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = MapCache3DBuilderNative.jni_Build(this.getHandle(), this._$2);
        if (n == -1) {
            String string = InternalResource.loadString("build()", "Global_NotEnoughMemory", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (n == 0) {
            bl = false;
        } else if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean buildWithoutConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("buildWithoutConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getOutputFolder().trim().length() == 0) {
            String string = InternalResource.loadString("buildWithoutConfigFile()", "Global_PathIsNotValid", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this.getMap() == null) {
            String string = InternalResource.loadString("buildWithoutConfigFile()", "MapCache3DBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = MapCache3DBuilderNative.jni_BuildWithoutConfig(this.getHandle(), this._$2);
        if (n == -1) {
            String string = InternalResource.loadString("build()", "Global_NotEnoughMemory", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (n == 0) {
            bl = false;
        } else if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean toConfigFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("toConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getMap() == null) {
            String string3 = InternalResource.loadString("toConfigFile()", "MapCache3DBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null) {
            String string4 = InternalResource.loadString("toConfigFile()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string4);
        }
        if (string.length() == 0) {
            String string5 = InternalResource.loadString("toConfigFile()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string5);
        }
        String string6 = ".sci3d";
        if (!string.endsWith(string6)) {
            string = string + string6;
        }
        boolean bl = MapCache3DBuilderNative.jni_ToConfigFile(this.getHandle(), string);
        return bl;
    }

    public boolean fromConfigFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("fromConfigFile()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        if (string.length() == 0) {
            String string4 = InternalResource.loadString("fromConfigFile()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string4);
        }
        boolean bl = MapCache3DBuilderNative.jni_FromConfigFile(this.getHandle(), string);
        return bl;
    }

    public String[] computeImageFileName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null) {
            String string = InternalResource.loadString("computeImageFileName()", "MapCache3DBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCache3DBuilderNative.jni_ComputeImageFileName(this.getHandle());
        return InternalToolkitProcessing.splitString(string, "\\|");
    }

    public String[] computeImageFileName(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("computeImageFileName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (this._$4 == null) {
            String string = InternalResource.loadString("computeImageFileName()", "MapCache3DBuilderAttachedMapIsNull", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCache3DBuilderNative.jni_ComputeImageFileName(this.getHandle(), n);
        return InternalToolkitProcessing.splitString(string, "\\|");
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.m_steppedListeners != null) {
            Vector<SteppedListener> vector = this.m_steppedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                vector.elementAt(i).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(MapCache3DBuilder mapCache3DBuilder, int n, long l, String string, String string2, long l2) {
        if (mapCache3DBuilder != null) {
            _$1 = "build";
            boolean bl = InternalToolkitProcessing.getHandleBooleanValue(l2);
            SteppedEvent steppedEvent = new SteppedEvent((Object)mapCache3DBuilder, n, l, string, string2, _$1, bl);
            mapCache3DBuilder.fireStepped(steppedEvent);
            InternalToolkitProcessing.setHandleBooleanValue(l2, steppedEvent.getCancel());
        }
    }

    public synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (this.m_steppedListeners != null && this.m_steppedListeners.contains(steppedListener)) {
            this.m_steppedListeners.remove(steppedListener);
        }
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MapCache3DBuilderNative.jni_Delete(this.getHandle());
            this.clearHandle();
            this._$1();
        }
    }

    private void _$1() {
        if (this._$2 != 0L) {
            MapCache3DBuilderNative.jni_DeleteSelfEventHandle(this._$2);
            this._$2 = 0L;
        }
    }

    private void _$1(Map map, String string, String string2) {
        if (map != null) {
            this.setMap(map);
        }
        if (string != null) {
            this.setOutputFolder(string);
        }
        if (string2 != null) {
            this.setCacheName(string2);
        }
        this.setTransparent(false);
        this.setImageType(CacheImageType.PNG);
        this._$3 = null;
        this._$2 = MapCache3DBuilderNative.jni_NewSelfEventHandle(this);
    }
}

