/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.LineSetting;
import com.supermap.analyst.trafficanalyst.LineSettings;
import com.supermap.analyst.trafficanalyst.RelationSetting;
import com.supermap.analyst.trafficanalyst.RelationSettings;
import com.supermap.analyst.trafficanalyst.StopSetting;
import com.supermap.analyst.trafficanalyst.StopSettings;
import com.supermap.analyst.trafficanalyst.TransferAnalystSettingNative;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Unit;

public class TransferAnalystSetting {
    private LineSettings _$10;
    private StopSettings _$9;
    private double _$8;
    private double _$7;
    private double _$6;
    private RelationSettings _$5;
    private Unit _$4;
    private double _$3;
    private long _$2 = 0L;
    private long _$1 = 0L;

    public TransferAnalystSetting() {
        this._$8 = 1000.0;
        this._$7 = 10.0;
        this._$6 = 100.0;
        this._$9 = new StopSettings();
        this._$10 = new LineSettings();
        this._$4 = Unit.METER;
        this._$5 = new RelationSettings();
    }

    public TransferAnalystSetting(TransferAnalystSetting transferAnalystSetting) {
        this.setWalkingTolerance(transferAnalystSetting.getWalkingTolerance());
        this.setSnapTolerance(transferAnalystSetting.getSnapTolerance());
        this.setMergeTolerance(transferAnalystSetting.getMergeTolerance());
        this._$9 = new StopSettings(transferAnalystSetting.getStopSettings());
        this._$10 = new LineSettings(transferAnalystSetting.getLineSettings());
        this._$5 = new RelationSettings(transferAnalystSetting.getRelationSettings());
    }

    protected void dispose() {
        if (this._$1 != 0L) {
            TransferAnalystSettingNative.jni_Delete(this._$1);
            this._$1 = 0L;
        }
    }

    LineSettings getLineSettings() {
        return this._$10;
    }

    public LineSetting getLineSetting() {
        return this._$10.get(0);
    }

    void setLineSettings(LineSettings lineSettings) {
        if (lineSettings == null) {
            String string = InternalResource.loadString("lineSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this._$10 = lineSettings;
    }

    public void setLineSetting(LineSetting lineSetting) {
        if (lineSetting == null) {
            String string = InternalResource.loadString("lineSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this._$10.add(lineSetting);
    }

    StopSettings getStopSettings() {
        return this._$9;
    }

    public StopSetting getStopSetting() {
        return this._$9.get(0);
    }

    void setStopSettings(StopSettings stopSettings) {
        if (stopSettings == null) {
            String string = InternalResource.loadString("stopSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this._$9 = stopSettings;
    }

    public void setStopSetting(StopSetting stopSetting) {
        if (stopSetting == null) {
            String string = InternalResource.loadString("stopSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this._$9.add(stopSetting);
    }

    RelationSettings getRelationSettings() {
        return this._$5;
    }

    public RelationSetting getRelationSetting() {
        return this._$5.get(0);
    }

    void setRelationSettings(RelationSettings relationSettings) {
        if (relationSettings == null) {
            String string = InternalResource.loadString("relationSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this._$5 = relationSettings;
    }

    public void setRelationSetting(RelationSetting relationSetting) {
        if (relationSetting == null) {
            String string = InternalResource.loadString("relationSettings", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this._$5.add(relationSetting);
    }

    public double getSnapTolerance() {
        return this._$7;
    }

    public void setSnapTolerance(double d) {
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "TransferAnalystSetting_SnapToleranceShouldNotBeNegative", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this._$7 = d;
    }

    @Deprecated
    public double getMergeTolerance() {
        return this._$6;
    }

    @Deprecated
    public void setMergeTolerance(double d) {
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "TransferAnalystSetting_MergeToleranceShouldNotBeNegative", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this._$6 = d;
    }

    public double getWalkingTolerance() {
        return this._$8;
    }

    public void setWalkingTolerance(double d) {
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "TransferAnalystSetting_WalkingToleranceShouldNotBeNegative", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this._$8 = d;
    }

    public void setUnit(Unit unit) {
        if (this._$4 == Unit.DEGREE || this._$4 == Unit.MINUTE || this._$4 == Unit.SECOND || this._$4 == Unit.RADIAN) {
            String string = InternalResource.loadString("value", "UnitType_UnSupport", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        this._$4 = unit;
    }

    public Unit getUnit() {
        return this._$4;
    }

    long setToUGC() {
        long l;
        this._$1 = l = TransferAnalystSettingNative.jni_New();
        long l2 = this._$10.setToUGC();
        long l3 = this._$9.setToUGC();
        long l4 = 0L;
        if (this._$5 != null) {
            l4 = this._$5.setRelationToUGC();
        }
        long l5 = 0L;
        if (this._$5.get(0).getDatasetPath() != null) {
            l5 = this._$5.setStopExitToUGC();
        }
        long l6 = 0L;
        if (this._$5.get(0).getDatasetNetwork() != null) {
            l6 = this._$5.setNetworkToUGC();
        }
        this._$2 = l6;
        this._$3 = (double)this._$4.value() / (double)Unit.METER.value();
        double d = this._$8 * this._$3;
        double d2 = this._$7 * this._$3;
        double d3 = this._$6 * this._$3;
        TransferAnalystSettingNative.jni_SetAllToUGC(l, l2, l3, l4, l5, l6, d, d2, d3);
        TransferAnalystSettingNative.jni_DeleteLinesInfoHandle(l2);
        TransferAnalystSettingNative.jni_DeleteStopsInfoHandle(l3);
        TransferAnalystSettingNative.jni_DeleteRelationsHandle(l4);
        TransferAnalystSettingNative.jni_DeleteStopExitRelationsHandle(l5);
        TransferAnalystSettingNative.jni_DeleteNetworksHandle(l6);
        return l;
    }

    void getFromUGC(Datasource datasource, long l) {
        double[] dArray = new double[3];
        long[] lArray = new long[5];
        TransferAnalystSettingNative.jni_GetAllFromUGC(l, lArray, dArray);
        this._$10 = new LineSettings();
        this._$10.getFromUGC(datasource, lArray[0]);
        TransferAnalystSettingNative.jni_DeleteLinesInfoHandle(lArray[0]);
        this._$9 = new StopSettings();
        this._$9.getFromUGC(datasource, lArray[1]);
        TransferAnalystSettingNative.jni_DeleteStopsInfoHandle(lArray[1]);
        this._$5 = new RelationSettings();
        this._$5.getRelationFromUGC(datasource, lArray[2]);
        TransferAnalystSettingNative.jni_DeleteRelationsHandle(lArray[2]);
        this._$5.getStopExitFromUGC(datasource, lArray[3]);
        TransferAnalystSettingNative.jni_DeleteStopExitRelationsHandle(lArray[3]);
        this._$5.getNetworkFromUGC(datasource, lArray[4]);
        TransferAnalystSettingNative.jni_DeleteNetworksHandle(lArray[4]);
        this._$3 = (double)this._$4.value() / (double)Unit.METER.value();
        this.setWalkingTolerance(dArray[0] / this._$3);
        this.setSnapTolerance(dArray[1] / this._$3);
        this.setMergeTolerance(dArray[2] / this._$3);
    }

    private static boolean _$1(String[] stringArray, DatasetVector datasetVector) {
        boolean bl = true;
        if (!datasetVector.open()) {
            datasetVector.open();
        }
        if (datasetVector.getChildDataset().isAvailableFieldName(stringArray[0])) {
            return false;
        }
        int n = stringArray.length;
        for (int i = 1; i < n; ++i) {
            if (!datasetVector.isAvailableFieldName(stringArray[i])) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

