/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.BasicStatisticsAnalystResult;
import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.GridHistogram;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsAnnulusParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsCircleParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsParameterNative;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsRectangleParameter;
import com.supermap.analyst.spatialanalyst.NeighbourStatisticsWedgeParameter;
import com.supermap.analyst.spatialanalyst.StatisticsAnalystNative;
import com.supermap.analyst.spatialanalyst.StatisticsCompareType;
import com.supermap.analyst.spatialanalyst.ZonalStatisticsAnalystParameter;
import com.supermap.analyst.spatialanalyst.ZonalStatisticsAnalystResult;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.Enum;
import com.supermap.data.License;
import com.supermap.data.ProductType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class StatisticsAnalyst {
    private static License _$3;
    private static transient Vector _$2;
    private static GridAnalystSetting _$1;

    private StatisticsAnalyst() {
    }

    private static GridAnalystSetting _$2() {
        return _$1;
    }

    private static void _$1(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            _$1 = null;
            return;
        }
        if (_$1 == null) {
            _$1 = new GridAnalystSetting();
        }
        _$1.setBounds(gridAnalystSetting.getBounds());
        _$1.setBoundsType(gridAnalystSetting.getBoundsType());
        _$1.setCellSizeType(gridAnalystSetting.getCellSizeType());
        _$1.setCellSize(gridAnalystSetting.getCellSize());
        _$1.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        _$1.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        _$1.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        _$1.setValidRegion(gridAnalystSetting.getValidRegion());
        _$1.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static GridHistogram createHistogram(DatasetGrid datasetGrid, int n) {
        StatisticsAnalyst._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("groupCount", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = StatisticsAnalystNative.jni_CreateHistogram(l, n);
        GridHistogram gridHistogram = null;
        if (0L != l2) {
            gridHistogram = new GridHistogram(l2);
        }
        return gridHistogram;
    }

    public static BasicStatisticsAnalystResult basicStatistics(DatasetGrid datasetGrid) {
        StatisticsAnalyst._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        double[] dArray = StatisticsAnalystNative.jni_BasicStatistics(l);
        BasicStatisticsAnalystResult basicStatisticsAnalystResult = null;
        if (null != dArray && dArray.length > 0) {
            basicStatisticsAnalystResult = new BasicStatisticsAnalystResult(dArray);
        }
        return basicStatisticsAnalystResult;
    }

    public static DatasetGrid commonStatistics(DatasetGrid datasetGrid, double d, StatisticsCompareType statisticsCompareType, boolean bl, Datasource datasource, String string) {
        StatisticsAnalyst._$1();
        Datasource datasource2 = datasource;
        String string2 = string;
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string3 = InternalResource.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            if (_$1 == null || _$1.getOutputDatasource() == null) {
                String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            datasource2 = _$1.getOutputDatasource();
        }
        if (string2 == null) {
            String string5 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (_$1 != null && _$1.getVectorOutputNamePrefix() != null) {
            string2 = _$1.getVectorOutputNamePrefix() + string2;
        }
        if (!datasource2.getDatasets().isAvailableDatasetName(string2)) {
            String string6 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource2);
        long l3 = 0L;
        l3 = StatisticsAnalystNative.jni_CommonStatistics(l, d, InternalEnum.getUGCValue(statisticsCompareType), bl, l2, string2);
        DatasetGrid datasetGrid2 = null;
        if (l3 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l3, datasource2);
            InternalDatasets.add(datasource2.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    public static DatasetGrid commonStatistics(DatasetGrid datasetGrid, DatasetGrid[] datasetGridArray, StatisticsCompareType statisticsCompareType, boolean bl, Datasource datasource, String string) {
        StatisticsAnalyst._$1();
        Datasource datasource2 = datasource;
        String string2 = string;
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string3 = InternalResource.loadString("statisticsGrid", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            if (_$1 == null || _$1.getOutputDatasource() == null) {
                String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string4);
            }
            datasource2 = _$1.getOutputDatasource();
        }
        if (string2 == null) {
            String string5 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string5);
        }
        if (_$1 != null && _$1.getGridOutputNamePrefix() != null) {
            string2 = _$1.getGridOutputNamePrefix() + string2;
        }
        if (!datasource2.getDatasets().isAvailableDatasetName(string2)) {
            String string6 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string6);
        }
        long[] lArray = new long[datasetGridArray.length];
        for (int i = 0; i < datasetGridArray.length; ++i) {
            long l;
            lArray[i] = l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGridArray[i]);
            if (l != 0L) continue;
            String string7 = InternalResource.loadString("dataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string7);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource2);
        long l3 = 0L;
        l3 = StatisticsAnalystNative.jni_CommonStatistics2(l, lArray, InternalEnum.getUGCValue(statisticsCompareType), bl, l2, string2);
        DatasetGrid datasetGrid2 = null;
        if (l3 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l3, datasource2);
            InternalDatasets.add(datasource2.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    public static DatasetGrid neighbourStatistics(NeighbourStatisticsParameter neighbourStatisticsParameter) {
        StatisticsAnalyst._$1();
        if (neighbourStatisticsParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        Datasource datasource = neighbourStatisticsParameter.getTargetDatasource();
        String string = neighbourStatisticsParameter.getTargetDatasetName();
        if (neighbourStatisticsParameter.getSourceDataset() == null) {
            String string2 = InternalResource.loadString("SourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (neighbourStatisticsParameter.getTargetDatasource() == null) {
            if (_$1 == null || _$1.getOutputDatasource() == null) {
                String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            datasource = _$1.getOutputDatasource();
        }
        if (string == null) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (_$1 != null && _$1.getGridOutputNamePrefix() != null) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = NeighbourStatisticsParameterNative.jni_New();
        int n = InternalEnum.getUGCValue(neighbourStatisticsParameter.getUnitType());
        NeighbourStatisticsParameterNative.jni_SetUnitType(l, n);
        int n2 = InternalEnum.getUGCValue(neighbourStatisticsParameter.getShapeType());
        NeighbourStatisticsParameterNative.jni_SetShapeType(l, n2);
        switch (n2) {
            case 1: {
                NeighbourStatisticsRectangleParameter neighbourStatisticsRectangleParameter = (NeighbourStatisticsRectangleParameter)neighbourStatisticsParameter;
                NeighbourStatisticsParameterNative.jni_SetWidthHeight(l, neighbourStatisticsRectangleParameter.getWidth(), neighbourStatisticsRectangleParameter.getHeight());
                break;
            }
            case 2: {
                NeighbourStatisticsCircleParameter neighbourStatisticsCircleParameter = (NeighbourStatisticsCircleParameter)neighbourStatisticsParameter;
                NeighbourStatisticsParameterNative.jni_SetRadius(l, neighbourStatisticsCircleParameter.getRadius());
                break;
            }
            case 3: {
                NeighbourStatisticsAnnulusParameter neighbourStatisticsAnnulusParameter = (NeighbourStatisticsAnnulusParameter)neighbourStatisticsParameter;
                NeighbourStatisticsParameterNative.jni_SetAnnulusRadius(l, neighbourStatisticsAnnulusParameter.getInnerRadius(), neighbourStatisticsAnnulusParameter.getOuterRadius());
                break;
            }
            case 4: {
                NeighbourStatisticsWedgeParameter neighbourStatisticsWedgeParameter = (NeighbourStatisticsWedgeParameter)neighbourStatisticsParameter;
                NeighbourStatisticsParameterNative.jni_SetRadius(l, neighbourStatisticsWedgeParameter.getRadius());
                NeighbourStatisticsParameterNative.jni_SetWedgeAngle(l, neighbourStatisticsWedgeParameter.getStartAngle(), neighbourStatisticsWedgeParameter.getEndAngle());
                break;
            }
        }
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)neighbourStatisticsParameter.getSourceDataset());
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        int n3 = InternalEnum.getUGCValue(neighbourStatisticsParameter.getStatisticsMode());
        long l4 = 0L;
        l4 = StatisticsAnalystNative.jni_NeighbourStatistics(l2, l, n3, neighbourStatisticsParameter.isIgnoreNoValue(), l3, string);
        NeighbourStatisticsParameterNative.jni_Dispose(l);
        DatasetGrid datasetGrid = null;
        if (l4 != 0L) {
            datasetGrid = InternalDatasetGrid.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
        }
        return datasetGrid;
    }

    public static ZonalStatisticsAnalystResult zonalStatisticsOnRasterValue(ZonalStatisticsAnalystParameter zonalStatisticsAnalystParameter) {
        String string;
        StatisticsAnalyst._$1();
        if (zonalStatisticsAnalystParameter == null) {
            String string2 = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        Datasource datasource = zonalStatisticsAnalystParameter.getTargetDatasource();
        if (zonalStatisticsAnalystParameter.getTargetDatasource() == null) {
            if (_$1 == null || _$1.getOutputDatasource() == null) {
                String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
                throw new NullPointerException(string3);
            }
            datasource = _$1.getOutputDatasource();
        }
        if ((string = zonalStatisticsAnalystParameter.getTargetDatasetName()) == null) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string4);
        }
        if (_$1 != null && _$1.getGridOutputNamePrefix() != null) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)zonalStatisticsAnalystParameter.getZonalDataset());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)zonalStatisticsAnalystParameter.getValueDataset());
        long l3 = 0L;
        if (datasource != null) {
            l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        }
        int n = InternalEnum.getUGCValue(zonalStatisticsAnalystParameter.getStatisticsMode());
        long[] lArray = StatisticsAnalystNative.jni_ZonalStatisticsOnRasterValue(l, zonalStatisticsAnalystParameter.getZonalFieldName(), l2, n, l3, string, l3, zonalStatisticsAnalystParameter.getTargetTableName(), zonalStatisticsAnalystParameter.isIgnoreNoValue());
        ZonalStatisticsAnalystResult zonalStatisticsAnalystResult = null;
        if (null != lArray && lArray.length == 2) {
            DatasetGrid datasetGrid = InternalDatasetGrid.createInstance(lArray[0], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid);
            DatasetVector datasetVector = null;
            datasetVector = InternalDatasetVector.createInstance(lArray[1], datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
            zonalStatisticsAnalystResult = new ZonalStatisticsAnalystResult(datasetGrid, datasetVector);
        }
        return zonalStatisticsAnalystResult;
    }

    private static boolean _$1(ZonalStatisticsAnalystParameter zonalStatisticsAnalystParameter) {
        StatisticsAnalyst._$1();
        if (zonalStatisticsAnalystParameter == null) {
            String string = InternalResource.loadString("parameter", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (zonalStatisticsAnalystParameter.getTargetDatasource() == null) {
            String string = InternalResource.loadString("TargetDatasource", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        if (!zonalStatisticsAnalystParameter.getTargetDatasource().getDatasets().isAvailableDatasetName(zonalStatisticsAnalystParameter.getTargetDatasetName())) {
            String string = InternalResource.loadString("TargetDatasetName", "GlobalDatasetNameInvalide", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)zonalStatisticsAnalystParameter.getZonalDataset());
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)zonalStatisticsAnalystParameter.getValueDataset());
        int n = InternalEnum.getUGCValue((Enum)zonalStatisticsAnalystParameter.getPixelFormat());
        int n2 = InternalEnum.getUGCValue(zonalStatisticsAnalystParameter.getStatisticsMode());
        return StatisticsAnalystNative.jni_ZonalStatisticVectorOnVector(l, zonalStatisticsAnalystParameter.getZonalFieldName(), null, l2, null, 0.0, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$3;
        synchronized (object) {
            n = _$3.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$2 == null) {
            _$2 = new Vector();
        }
        if (!_$2.contains(steppedListener)) {
            _$2.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$2 != null && _$2.contains(steppedListener)) {
            _$2.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$2 != null) {
            Vector vector = _$2;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "StatisticsAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        StatisticsAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$3 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

