/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.json.filter;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.view.json.JsonViewFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePropertyFilter
implements JsonViewFilter {
    private Log log = LogFactory.getLog(SimplePropertyFilter.class);
    private BeanUtilsBean beanUtilsBean;
    private List<String> excludeBeforePropNames;
    private List<String> excludeBeforeErrorsPropNames;
    private List<String> excludeBeforeSuccessPropNames;

    public SimplePropertyFilter() {
        this.setUpBeanUtils();
    }

    protected void setUpBeanUtils() {
        ConvertUtilsBean convertUtilsBean = new ConvertUtilsBean();
        convertUtilsBean.deregister(Boolean.class);
        convertUtilsBean.deregister(Boolean.TYPE);
        convertUtilsBean.deregister(Byte.class);
        convertUtilsBean.deregister(Byte.TYPE);
        convertUtilsBean.deregister(Character.class);
        convertUtilsBean.deregister(Character.TYPE);
        convertUtilsBean.deregister(Double.class);
        convertUtilsBean.deregister(Double.TYPE);
        convertUtilsBean.deregister(Float.class);
        convertUtilsBean.deregister(Float.TYPE);
        convertUtilsBean.deregister(Long.class);
        convertUtilsBean.deregister(Long.TYPE);
        convertUtilsBean.deregister(Short.class);
        convertUtilsBean.deregister(Short.TYPE);
        this.beanUtilsBean = new BeanUtilsBean(convertUtilsBean, new PropertyUtilsBean());
    }

    @Override
    public void filterBeforePopulate(Map model, String commandName) throws Exception {
        this.filter(model, this.excludeBeforePropNames, commandName);
    }

    @Override
    public void filterBeforePopulateErrors(Map model, String commandName) throws Exception {
        this.filter(model, this.excludeBeforeErrorsPropNames, commandName);
    }

    @Override
    public void filterBeforePopulateSuccess(Map model, String commandName) throws Exception {
        this.filter(model, this.excludeBeforeSuccessPropNames, commandName);
    }

    private void filter(Map model, List<String> properties, String commandName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (properties != null) {
            for (String prop : properties) {
                this.removePropertyValue(model, prop, commandName);
            }
        }
    }

    private void removePropertyValue(Map model, String property, String commandName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        block5: {
            String p = null;
            p = property.matches("^\\(.+\\)|^\\(.+\\)\\..+") ? property.replaceFirst("\\(", "").replaceFirst("\\)", "") : commandName + "." + property;
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(p + " = " + BeanUtils.getProperty((Object)model, (String)p)));
                }
                this.beanUtilsBean.setProperty((Object)model, p, null);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(p + " set to " + BeanUtils.getProperty((Object)model, (String)p)));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"======================================");
                }
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug((Object)("Error excluding property: " + p + ": " + e.toString()));
            }
        }
    }

    public List<String> getExcludeBeforePropNames() {
        return this.excludeBeforePropNames;
    }

    public void setExcludeBeforePropNames(List<String> excludeBeforePropNames) {
        this.excludeBeforePropNames = excludeBeforePropNames;
    }

    public List<String> getExcludeBeforeErrorsPropNames() {
        return this.excludeBeforeErrorsPropNames;
    }

    public void setExcludeBeforeErrorsPropNames(List<String> excludeBeforeErrorsPropNames) {
        this.excludeBeforeErrorsPropNames = excludeBeforeErrorsPropNames;
    }

    public List<String> getExcludeBeforeSuccessPropNames() {
        return this.excludeBeforeSuccessPropNames;
    }

    public void setExcludeBeforeSuccessPropNames(List<String> excludeBeforeSuccessPropNames) {
        this.excludeBeforeSuccessPropNames = excludeBeforeSuccessPropNames;
    }
}

