/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.interchange.xmlrpc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Stack;
import net.sf.sojo.common.WalkerInterceptor;
import net.sf.sojo.interchange.xmlrpc.XmlRpcException;

public class XmlRpcWalkerInterceptor
implements WalkerInterceptor {
    private StringBuffer xmlRpcString = new StringBuffer();
    private Object rootObjectArray = null;
    private Stack<Integer> stack = new Stack();

    public String getXmlRpcString() {
        return this.xmlRpcString.toString();
    }

    @Override
    public void startWalk(Object pvStartObject) {
        this.xmlRpcString = new StringBuffer("<params>");
        if (pvStartObject != null && pvStartObject.getClass().isArray()) {
            this.rootObjectArray = pvStartObject;
        }
    }

    @Override
    public void endWalk() {
        this.xmlRpcString.append("</params>");
        this.stack.clear();
    }

    private void createParamTag(String pvPath, String pvParam) {
        if (pvPath.length() == 0 || pvPath.startsWith("[") && pvPath.indexOf(".") < 0 || pvPath.startsWith("[") && pvPath.indexOf(".") == pvPath.length() - 1) {
            this.xmlRpcString.append(pvParam);
        }
    }

    private void createMemberTag(Object pvKey) {
        if (!pvKey.getClass().equals(String.class)) {
            throw new XmlRpcException("Key must be from type String and not: " + pvKey.getClass());
        }
        this.xmlRpcString.append("<member><name>").append(pvKey).append("</name>");
    }

    @Override
    public boolean visitElement(Object pvKey, int pvIndex, Object pvValue, int pvType, String pvPath, int pvNumberOfRecursion) {
        if (pvType == 0) {
            this.createParamTag(pvPath, "<param>");
            this.mapping2XmlRpcDataType(pvValue);
            this.createParamTag(pvPath, "</param>");
        } else if (pvType == 1) {
            this.createParamTag(pvPath, "<param>");
            if (pvKey != null) {
                this.createMemberTag(pvKey);
            }
            this.mapping2XmlRpcDataType(pvValue);
            if (pvKey != null) {
                this.xmlRpcString.append("</member>");
            }
            this.createParamTag(pvPath, "</param>");
        } else if (pvKey != null) {
            this.createMemberTag(pvKey);
            this.stack.push(new Integer(pvType));
        }
        return false;
    }

    @Override
    public void visitIterateableElement(Object pvValue, int pvType, String pvPath, int pvTypeBeginOrEnd) {
        if (pvTypeBeginOrEnd == 1) {
            if (pvType == 7 && !pvValue.equals(this.rootObjectArray)) {
                this.createParamTag(pvPath, "<param>");
                this.xmlRpcString.append("<value><array><data>");
            } else if (pvType == 9) {
                this.createParamTag(pvPath, "<param>");
                this.xmlRpcString.append("<value><struct>");
            }
        } else if (pvTypeBeginOrEnd == 2) {
            if (pvType == 7) {
                Integer i;
                if (!pvValue.equals(this.rootObjectArray)) {
                    this.xmlRpcString.append("</data></array></value>");
                }
                if (this.stack.size() > 0 && (i = this.stack.peek()) == 7) {
                    this.stack.pop();
                    this.xmlRpcString.append("</member>");
                }
                if (!pvValue.equals(this.rootObjectArray)) {
                    this.createParamTag(pvPath, "</param>");
                }
            } else if (pvType == 9) {
                Integer i;
                this.xmlRpcString.append("</struct></value>");
                if (this.stack.size() > 0 && (i = this.stack.peek()) == 9) {
                    this.stack.pop();
                    this.xmlRpcString.append("</member>");
                }
                this.createParamTag(pvPath, "</param>");
            }
        }
    }

    public void mapping2XmlRpcDataType(Object pvValue) {
        this.xmlRpcString.append("<value>");
        if (pvValue == null) {
            this.xmlRpcString.append("<ex:nil>null</ex:nil>");
        } else if (pvValue.getClass().equals(String.class)) {
            String s = pvValue.toString();
            s = s.replaceAll("<", "&lt;");
            s = s.replaceAll(">", "&gt;");
            this.xmlRpcString.append("<string>").append(s).append("</string>");
        } else if (pvValue.getClass().equals(Integer.class)) {
            this.xmlRpcString.append("<i4>").append(pvValue).append("</i4>");
        } else if (pvValue.getClass().equals(Boolean.class)) {
            Boolean lvBoolean = Boolean.valueOf(pvValue.toString());
            int b = lvBoolean.equals(Boolean.TRUE) ? 1 : 0;
            this.xmlRpcString.append("<boolean>").append(b).append("</boolean>");
        } else if (pvValue.getClass().equals(Double.class)) {
            this.xmlRpcString.append("<double>").append(pvValue).append("</double>");
        } else if (pvValue instanceof Date) {
            Date d = (Date)pvValue;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
            String s = sdf.format(d);
            this.xmlRpcString.append("<dateTime.iso8601>").append(s).append("</dateTime.iso8601>");
        } else if (pvValue.getClass().equals(Byte.class)) {
            this.xmlRpcString.append("<ex:i1>").append(pvValue).append("</ex:i1>");
        } else if (pvValue.getClass().equals(Short.class)) {
            this.xmlRpcString.append("<ex:i2>").append(pvValue).append("</ex:i2>");
        } else if (pvValue.getClass().equals(Long.class)) {
            this.xmlRpcString.append("<ex:i8>").append(pvValue).append("</ex:i8>");
        } else if (pvValue.getClass().equals(Float.class)) {
            this.xmlRpcString.append("<ex:float>").append(pvValue).append("</ex:float>");
        } else if (pvValue.getClass().equals(BigDecimal.class)) {
            this.xmlRpcString.append("<ex:bigdecimal>").append(pvValue).append("</ex:bigdecimal>");
        } else if (pvValue.getClass().equals(BigInteger.class)) {
            this.xmlRpcString.append("<ex:biginteger>").append(pvValue).append("</ex:biginteger>");
        } else if (Calendar.class.isAssignableFrom(pvValue.getClass())) {
            Calendar lvCalendar = (Calendar)pvValue;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss.SSS");
            String s = sdf.format(lvCalendar.getTime());
            this.xmlRpcString.append("<ex:dateTime>").append(s).append("</ex:dateTime>");
        }
        this.xmlRpcString.append("</value>");
    }
}

