/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class UniqueIdGenerator {
    public static final String UNIQUE_ID_PROPERTY = "~unique-id~";
    public static final int MINIMAL_UNIQUE_ID = 0;
    private int currentUniqueID = 0;
    private int minimalUniqueID = 0;
    private boolean withHashCodeInUniqueId = false;
    private Map<Object, Object> uniqueIdObjectMap = new HashMap<Object, Object>();

    public void setMinimalUniqueID(int pvMinimalUniqueID) {
        this.minimalUniqueID = pvMinimalUniqueID;
    }

    public int getMinimalUniqueID() {
        return this.minimalUniqueID;
    }

    public void setWithHashCodeInUniqueId(boolean pvWithHashCodeInUniqueId) {
        this.withHashCodeInUniqueId = pvWithHashCodeInUniqueId;
    }

    public boolean getWithHashCodeInUniqueId() {
        return this.withHashCodeInUniqueId;
    }

    public int getCurrentUniqueID() {
        return this.currentUniqueID;
    }

    protected String getStringRepresentationFromId(int pvUniqueId, Object pvObject) {
        String lvUniqueId = Integer.toString(pvUniqueId);
        if (this.getWithHashCodeInUniqueId()) {
            lvUniqueId = lvUniqueId + "-" + pvObject.hashCode();
        }
        return lvUniqueId;
    }

    public final String getUniqueId(Object pvObject) {
        if (pvObject == null) {
            return null;
        }
        String lvUniqueId = null;
        if (!(pvObject instanceof Collection) && !(pvObject instanceof Map) && (lvUniqueId = (String)this.uniqueIdObjectMap.get(pvObject)) == null) {
            lvUniqueId = this.getStringRepresentationFromId(this.currentUniqueID, pvObject);
            ++this.currentUniqueID;
            this.uniqueIdObjectMap.put(pvObject, lvUniqueId);
        }
        return lvUniqueId;
    }

    public static final String getUniqueIdStringByNumber(String pvNumberString) {
        return UNIQUE_ID_PROPERTY + pvNumberString;
    }

    public final boolean isKnownObject(Object pvObject) {
        if (pvObject instanceof Collection || pvObject instanceof Map) {
            return false;
        }
        return this.uniqueIdObjectMap.containsKey(pvObject);
    }

    public Object getObjectByUniqueId(String pvUniqueId) {
        return this.uniqueIdObjectMap.get(pvUniqueId);
    }

    public final Object addObject(String pvUniqueId, Object pvObject) {
        return this.uniqueIdObjectMap.put(pvUniqueId, pvObject);
    }

    public void clear() {
        this.uniqueIdObjectMap.clear();
    }
}

