/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.mapping.InternalGeometry;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.Map;
import com.supermap.mapping.TrackingLayerNative;
import java.util.concurrent.locks.ReentrantLock;

public class TrackingLayer
extends InternalHandle {
    Map m_map;
    ReentrantLock m_lock;

    private TrackingLayer(long l, Map map) {
        this.setHandle(l);
        this.m_map = map;
        this.m_lock = map.m_lock;
        this._$1();
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_GetCount(this.getHandle());
    }

    public boolean isVisible() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsVisible()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_GetIsVisible(this.getHandle());
    }

    public void setVisible(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        TrackingLayerNative.jni_SetIsVisible(this.getHandle(), bl);
    }

    public boolean isSymbolScalable() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIsSymbolScalable()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_GetIsSymbolScalable(this.getHandle());
    }

    public void setSymbolScalable(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIsSymbolScalable(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        TrackingLayerNative.jni_SetIsSymbolScalable(this.getHandle(), bl);
    }

    public double getSymbolScale() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSymbolScale()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_GetSymbolScale(this.getHandle());
    }

    public void setSymbolScale(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSymbolScale(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "TrackingLayer_SymbolScaleShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        TrackingLayerNative.jni_SetSymbolScale(this.getHandle(), d);
    }

    public boolean isAntialias() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isAntialias()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_GetIsAntialias(this.getHandle());
    }

    public void setAntialias(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setAntialias(value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        TrackingLayerNative.jni_SetAntialias(this.getHandle(), bl);
    }

    public int add(Geometry geometry, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("add(Geometry geometry, String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (geometry == null) {
            String string3 = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string4 = InternalResource.loadString("geometry", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (string == null) {
            string = "";
        }
        this.m_lock.lock();
        int n = TrackingLayerNative.jni_Add(this.getHandle(), l, string);
        this._$1((com.supermap.data.InternalHandleDisposable)geometry);
        this.m_lock.unlock();
        return n;
    }

    public boolean remove(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("delete(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.m_lock.lock();
        boolean bl = TrackingLayerNative.jni_Delete(this.getHandle(), n);
        this.m_lock.unlock();
        return bl;
    }

    public Geometry get(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("get(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        Geometry geometry = null;
        long l = TrackingLayerNative.jni_Get(this.getHandle(), n);
        if (l != 0L) {
            geometry = InternalGeometry.createInstance2(l, this.m_map.getWorkspace());
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, true);
        }
        return geometry;
    }

    public boolean set(int n, Geometry geometry) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("set(int index, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (geometry == null) {
            String string = InternalResource.loadString("geometry", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry);
        if (l == 0L) {
            String string = InternalResource.loadString("geometry", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        this.m_lock.lock();
        boolean bl = TrackingLayerNative.jni_Set(this.getHandle(), n, l);
        com.supermap.data.InternalHandleDisposable.makeSureNativeObjectLive((Object)geometry);
        this.m_lock.unlock();
        return bl;
    }

    public String getTag(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTag(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return TrackingLayerNative.jni_GetTag(this.getHandle(), n);
    }

    public boolean setTag(int n, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setTag(int index, String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (n < 0 || n >= this.getCount()) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        if (string == null) {
            string = "";
        }
        this.m_lock.lock();
        boolean bl = TrackingLayerNative.jni_SetTag(this.getHandle(), n, string);
        this.m_lock.unlock();
        return bl;
    }

    public int indexOf(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("indexOf(String tag)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("indexOf(String tag)", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string3);
        }
        return TrackingLayerNative.jni_IndexOf(this.getHandle(), string);
    }

    public boolean setEditBulk(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setEditBulk(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_SetEditBulk(this.getHandle(), bl);
    }

    public boolean flushBulkEdit() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FlushBulkEdit()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_FlushBulkEdit(this.getHandle());
    }

    @Deprecated
    public boolean cancleBulkOperated() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("CancleBulkOperated()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return TrackingLayerNative.jni_CancleBulkOperated(this.getHandle());
    }

    public boolean cancelBulkOperated() {
        return this.cancleBulkOperated();
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        TrackingLayerNative.jni_Clear(this.getHandle());
        this.m_lock.unlock();
    }

    public int hitTest(Point2D point2D, double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("hitTest(Point2D point, double tolerance)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("tolerance", "TrackingLayer_InvalidTolerance", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return TrackingLayerNative.jni_HitTest(this.getHandle(), point2D.getX(), point2D.getY(), d);
    }

    protected static TrackingLayer createInstance(long l, Map map) {
        return new TrackingLayer(l, map);
    }

    protected void clearHandle() {
        this.setHandle(0L);
    }

    private void _$1() {
        TrackingLayerNative.jni_Reset(this.getHandle());
    }

    private void _$1(com.supermap.data.InternalHandleDisposable internalHandleDisposable) {
        InternalHandle.getHandle((com.supermap.data.InternalHandle)internalHandleDisposable);
    }
}

