/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.InternalHandleDisposable;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.SnapMode;
import com.supermap.mapping.SnapSettingNative;
import java.util.ArrayList;

public class SnapSetting
extends InternalHandleDisposable {
    private static final int _$3 = 12;
    private ArrayList<SnapMode> _$2 = null;
    private ArrayList<Integer> _$1 = null;

    public SnapSetting() {
        long l = SnapSettingNative.jni_new();
        this._$1();
        this.setHandle(l, true);
    }

    public SnapSetting(SnapSetting snapSetting) {
        if (snapSetting == null) {
            String string = InternalResource.loadString("SnapSetting setting", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)snapSetting);
        if (l == 0L) {
            String string = InternalResource.loadString("GetTolerance()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        long l2 = SnapSettingNative.jni_Clone(l);
        this._$1();
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)snapSetting));
    }

    SnapSetting(long l) {
        this._$1();
        this.setHandle(l, false);
    }

    public int getTolerance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetTolerance()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetTolerance(this.getHandle());
    }

    public void setTolerance(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetTolerance(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetTolerance(this.getHandle(), n);
    }

    public int getMinSnappedLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetMinSnappedLength()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetMinSnappedLength(this.getHandle());
    }

    public void setMinSnappedLength(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetMinSnappedLength(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetMinSnappedLength(this.getHandle(), n);
    }

    public double getFixedAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetFixedAngle()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetFixedAngle(this.getHandle());
    }

    public void setFixedAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetFixedAngle(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetFixedAngle(this.getHandle(), d);
    }

    public double getFixedLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetFixedLength()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetFixedLength(this.getHandle());
    }

    public void setFixedLength(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetFixedLength(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetFixedLength(this.getHandle(), d);
    }

    public int getMaxSnappedCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetMaxSnappedCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetMaxSnappedCount(this.getHandle());
    }

    public void setMaxSnappedCount(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetMaxSnappedCount(int value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("value", "Global_ArgumentShouldMoreThanZero", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetMaxSnappedCount(this.getHandle(), n);
    }

    public boolean isSnappedLineBroken() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IsSnappedLineBroken()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_IsSnappedLineBroken(this.getHandle());
    }

    public void setSnappedLineBroken(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetSnappedLineBroken(boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetSnappedLineBroken(this.getHandle(), bl);
    }

    public boolean get(SnapMode snapMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Get(SnapMode mode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return SnapSettingNative.jni_GetSnapMode(this.getHandle(), snapMode.value());
    }

    public void set(SnapMode snapMode, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Set(SnapMode mode, boolean value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (snapMode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        SnapSettingNative.jni_SetSnapMode(this.getHandle(), snapMode.value(), bl);
    }

    public int indexOf(SnapMode snapMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("IndexOf(SnapMode mode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (snapMode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$1.indexOf(this._$2.indexOf((Object)snapMode));
    }

    public SnapMode getAt(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetAt(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 && n >= 12) {
            String string = InternalResource.loadString("getAt(int index)", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return this._$2.get(this._$1.get(n));
    }

    public boolean exchange(SnapMode snapMode, SnapMode snapMode2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Exchange(SnapMode mode1, SnapMode mode2)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (snapMode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (snapMode2 == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = this._$1.indexOf(this._$2.indexOf((Object)snapMode));
        int n2 = this._$1.indexOf(this._$2.indexOf((Object)snapMode2));
        return this.exchange(n, n2);
    }

    public boolean exchange(int n, int n2) {
        if (n < 0 || n2 < 0) {
            String string = InternalResource.loadString("exchange(int index1, int index2)", "SnapSetting_IndexShouldNotBeNegative", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (n > 12 || n2 > 12) {
            String string = InternalResource.loadString("exchange(int index1, int index2)", "SnapSetting_IndexShouldLessThanSnapModeCount", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Exchange(int index1, int index2)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n3 = this._$1.get(n);
        this._$1.set(n, this._$1.get(n2));
        this._$1.set(n2, n3);
        return SnapSettingNative.jni_ExchangeByIndex(this.getHandle(), n, n2);
    }

    public boolean moveTo(SnapMode snapMode, int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("MoveTo(SnapMode mode, int targetIndex)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (snapMode == null) {
            String string = InternalResource.loadString("mode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.indexOf(snapMode);
        int n3 = this._$1.get(n2);
        this._$1.remove(n2);
        this._$1.add(n, n3);
        return SnapSettingNative.jni_MoveTo(this.getHandle(), n2, n);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ToString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ FixedAngle=");
        stringBuffer.append(this.getFixedAngle());
        stringBuffer.append(",FixedLength=");
        stringBuffer.append(this.getFixedLength());
        stringBuffer.append(",IsSnapedLineBroen=");
        stringBuffer.append(this.isSnappedLineBroken());
        stringBuffer.append(",MaxSnappedCount=");
        stringBuffer.append(this.getMaxSnappedCount());
        stringBuffer.append(",MinLength=");
        stringBuffer.append(this.getMinSnappedLength());
        stringBuffer.append(",Tolerance=");
        stringBuffer.append(this.getTolerance());
        int n = this.getMaxSnappedCount();
        int[] nArray = SnapMode.getValues(SnapMode.class);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            SnapSettingNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    protected void clearHandle() {
        super.clearHandle();
    }

    protected static void clearHandle(SnapSetting snapSetting) {
        snapSetting.clearHandle();
    }

    protected static SnapSetting creatInstance(long l) {
        if (l == 0L) {
            String string = InternalResource.loadString("handle", "Global_InvalidConstructorArgument", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return new SnapSetting(l);
    }

    private void _$1() {
        this._$2 = new ArrayList();
        this._$2.add(SnapMode.POINT_ON_ENDPOINT);
        this._$2.add(SnapMode.POINT_ON_POINT);
        this._$2.add(SnapMode.POINT_ON_LINE);
        this._$2.add(SnapMode.POINT_ON_MIDPOINT);
        this._$2.add(SnapMode.POINT_ON_EXTENSION);
        this._$2.add(SnapMode.POINT_WITH_HORIZOTAL_OR_VERTICAL);
        this._$2.add(SnapMode.LINE_WITH_FIXED_ANGLE);
        this._$2.add(SnapMode.LINE_WITH_FIXED_LENGTH);
        this._$2.add(SnapMode.LINE_WITH_INTERSECTION);
        this._$2.add(SnapMode.LINE_WITH_HORIZONTAL_OR_VERTICAL);
        this._$2.add(SnapMode.LINE_WITH_PARALLEL);
        this._$2.add(SnapMode.LINE_WITH_PERPENDICULAR);
        this._$1 = new ArrayList();
        this._$1.add(0);
        this._$1.add(1);
        this._$1.add(2);
        this._$1.add(3);
        this._$1.add(4);
        this._$1.add(5);
        this._$1.add(6);
        this._$1.add(8);
        this._$1.add(9);
        this._$1.add(11);
        this._$1.add(10);
        this._$1.add(7);
    }
}

