/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.geoprocessor.common;

import com.supermap.geoprocessor.common.Context;
import com.supermap.geoprocessor.common.DBConnectionManager;
import com.supermap.geoprocessor.common.LogProvider;
import com.supermap.geoprocessor.common.PoolingConnectionProvider;
import com.supermap.geoprocessor.common.SqlSequence;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.commons.logging.Log;

public class SqlProvider {
    private static Log log = LogProvider.getLog(SqlProvider.class);
    private static boolean exist = false;
    private static final String GEOPROCESSOR_DATABASESOURCE = "geoprocessor_databasesource";
    private static Statement statement = null;

    public static synchronized Connection getConnection() {
        if (!exist) {
            SqlProvider.makeDatabaseExist();
        }
        return SqlProvider.getInternalConnection();
    }

    private static synchronized Connection getInternalConnection() {
        String string = Context.getDriver();
        String string2 = Context.getUrl();
        String string3 = Context.getUser();
        String string4 = Context.getPassword();
        PoolingConnectionProvider poolingConnectionProvider = null;
        Connection connection = null;
        try {
            connection = DBConnectionManager.getInstance().getConnection(GEOPROCESSOR_DATABASESOURCE);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (connection == null) {
            try {
                poolingConnectionProvider = new PoolingConnectionProvider(string, string2, string3, string4, 10, "SELECT 1");
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            DBConnectionManager.getInstance().addConnectionProvider(GEOPROCESSOR_DATABASESOURCE, poolingConnectionProvider);
            try {
                connection = poolingConnectionProvider.getConnection();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        return connection;
    }

    public static ResultSet executeQuery(Statement statement, String string) {
        ResultSet resultSet = null;
        if (statement == null) {
            return null;
        }
        try {
            resultSet = statement.executeQuery(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return resultSet;
    }

    public static synchronized boolean executeUpdate(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("update", string);
        SqlSequence.push(hashMap);
        return SqlSequence.execute();
    }

    public static synchronized boolean executeSql(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("insert", string);
        SqlSequence.push(hashMap);
        return SqlSequence.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean updateRecord(String string) throws Exception {
        Connection connection = SqlProvider.getConnection();
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate(string);
        }
        catch (Exception exception) {
            statement.execute(string);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
        return true;
    }

    public static synchronized boolean addOrDeleteRecord(String string) throws Exception {
        Connection connection = SqlProvider.getConnection();
        Statement statement = connection.createStatement();
        log.debug((Object)string);
        statement.execute(string);
        if (statement != null) {
            statement.close();
        }
        if (connection != null) {
            connection.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean makeDatabaseExist() {
        if (!Context.getDriver().equalsIgnoreCase("org.sqlite.jdbc")) {
            return true;
        }
        File file = new File(System.getProperty("user.dir") + File.separator + "modeling.db");
        Connection connection = null;
        Statement statement = null;
        if (file.exists()) {
            return true;
        }
        try {
            file.createNewFile();
            String string = "CREATE TABLE smgroup(id Integer PRIMARY KEY NOT NULL,description VarChar NULL,name VarChar NULL,caption VarChar NULL)";
            String string2 = "CREATE TABLE smlog(id Integer PRIMARY KEY NOT NULL,taskId VarChar NOT NULL,jobId VarChar NOT NULL,message VarChar NULL,logTime TimeStamp NULL)";
            String string3 = "CREATE TABLE smmodel(id Integer PRIMARY KEY NOT NULL,className VarChar NULL,userName VarChar NULL,functionName VarChar NULL,description VarChar NULL,createTime TimeStamp NULL)";
            String string4 = "CREATE TABLE smprocess(id Integer PRIMARY KEY NOT NULL,name VarChar NULL,content BLOB NULL,groupId Integer NULL)";
            String string5 = "CREATE TABLE smprogress(id Integer PRIMARY KEY NOT NULL,taskId VarChar NOT NULL,description VarChar NULL,startDate TimeStamp NULL,progress Double NULL,processId Integer NULL,status Integer NOT NULL DEFAULT 0)";
            String string6 = "CREATE TABLE smtask(id Varchar PRIMARY KEY NOT NULL,jobId VarChar NULL,createTime TimeStamp NULL,status Integer NULL)";
            String[] stringArray = new String[]{string, string2, string3, string4, string5, string6};
            connection = SqlProvider.getInternalConnection();
            statement = connection.createStatement();
            for (int i = 0; i < 6; ++i) {
                statement.execute(stringArray[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        exist = true;
        return true;
    }
}

