/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoPictureNative;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;

public class GeoPicture
extends Geometry {
    public GeoPicture() {
        long l = GeoPictureNative.jni_New();
        this.setHandle(l, true);
    }

    public GeoPicture(GeoPicture geoPicture) {
        if (geoPicture == null) {
            String string = InternalResource.loadString("geoPicture", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoPicture);
        if (l == 0L) {
            String string = InternalResource.loadString("geoPicture", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoPictureNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoPicture);
    }

    public GeoPicture(BufferedImage bufferedImage, Point2D point2D, double d, double d2, double d3) {
        if (d <= 0.0) {
            String string = InternalResource.loadString("width", "GeoPicture_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("height", "GeoPicture_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = bufferedImage.getRGB(j, i);
            }
        }
        long l = GeoPictureNative.jni_New3(nArray, point2D.getX(), point2D.getY(), d, d2, d3, n, n2);
        this.setHandle(l, true);
    }

    public GeoPicture(BufferedImage bufferedImage, Rectangle2D rectangle2D, double d) {
        if (rectangle2D.getWidth() <= 0.0) {
            String string = InternalResource.loadString("bounds", "GeoPicture_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getHeight() <= 0.0) {
            String string = InternalResource.loadString("bounds", "GeoPicture_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = bufferedImage.getRGB(j, i);
            }
        }
        long l = GeoPictureNative.jni_New4(nArray, rectangle2D.getLeft(), rectangle2D.getRight(), rectangle2D.getTop(), rectangle2D.getBottom(), d, n, n2);
        this.setHandle(l, true);
    }

    public GeoPicture(String string, Point2D point2D, double d, double d2, double d3) {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = InternalResource.loadString("imageFile", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (d <= 0.0) {
            String string3 = InternalResource.loadString("width", "GeoPicture_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (d2 <= 0.0) {
            String string4 = InternalResource.loadString("height", "GeoPicture_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        long l = GeoPictureNative.jni_New1(string, point2D.getX(), point2D.getY(), d, d2, d3);
        if (l == 0L) {
            String string5 = InternalResource.loadString("GeoPicture(String imageFile, Point2D center, double width,double height, double rotation)", "GeoPicture_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        this.setHandle(l, true);
    }

    public GeoPicture(String string, Rectangle2D rectangle2D, double d) {
        File file = new File(string);
        if (!file.exists()) {
            String string2 = InternalResource.loadString("imageFile", "Global_FileNotExists", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (rectangle2D.getWidth() <= 0.0) {
            String string3 = InternalResource.loadString("bounds", "GeoPicture_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (rectangle2D.getHeight() <= 0.0) {
            String string4 = InternalResource.loadString("bounds", "GeoPicture_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        long l = GeoPictureNative.jni_New2(string, rectangle2D.getLeft(), rectangle2D.getRight(), rectangle2D.getTop(), rectangle2D.getBottom(), d);
        if (l == 0L) {
            String string5 = InternalResource.loadString("GeoPicture(String imageFile, Rectangle2D bounds, double rotation)", "GeoPicture_FailConstruct", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        this.setHandle(l, true);
    }

    GeoPicture(long l) {
        this.setHandle(l, false);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPictureNative.jni_getAngle(this.getHandle());
    }

    public void setRotation(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPictureNative.jni_setAngle(this.getHandle(), d);
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPictureNative.jni_getWidth(this.getHandle());
    }

    public void setWidth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoPicture_WidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPictureNative.jni_setWidth(this.getHandle(), d);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPictureNative.jni_getHeight(this.getHandle());
    }

    public void setHeight(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoPicture_HeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPictureNative.jni_setHeight(this.getHandle(), d);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoPictureNative.jni_getCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetCenter(Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPictureNative.jni_setCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public BufferedImage getImage() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetImage()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        int[] nArray2 = GeoPictureNative.jni_GetImage(this.getHandle(), nArray, 0);
        BufferedImage bufferedImage = null;
        int n = nArray[0];
        int n2 = nArray[1];
        if (nArray2 != null && n > 0 && n2 > 0) {
            bufferedImage = new BufferedImage(n, n2, 4);
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                bufferedImage.setRGB(j, i, nArray2[i * n + j]);
            }
        }
        return bufferedImage;
    }

    public void setImage(BufferedImage bufferedImage) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImage(value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int[] nArray = new int[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                nArray[i * n + j] = bufferedImage.getRGB(j, i);
            }
        }
        GeoPictureNative.jni_SetImage(this.getHandle(), nArray, n, n2, 0);
    }

    public GeoPicture clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPicture(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPictureNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

