/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoEllipticArcNative;
import com.supermap.data.GeoLine;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point2D;

public class GeoEllipticArc
extends Geometry {
    private double _$6;
    private double _$5;

    public GeoEllipticArc() {
        long l = GeoEllipticArcNative.jni_New();
        this.setHandle(l, true);
        this._$6 = 0.0;
        this._$5 = 180.0;
    }

    public GeoEllipticArc(GeoEllipticArc geoEllipticArc) {
        if (geoEllipticArc == null) {
            String string = InternalResource.loadString("geoEllipticArc", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle(geoEllipticArc);
        if (l == 0L) {
            String string = InternalResource.loadString("geoEllipticArc", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$6 = geoEllipticArc.getStartAngle();
        this._$5 = geoEllipticArc.getSweepAngle();
        long l2 = GeoEllipticArcNative.jni_Clone(l);
        this.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoEllipticArc);
    }

    public GeoEllipticArc(Point2D point2D, double d, double d2, double d3, double d4, double d5) {
        if (d <= 0.0) {
            String string = InternalResource.loadString("semimajorAxis", "GeoEllipticArc_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = InternalResource.loadString("semiminorAxis", "GeoEllipticArc_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d4 <= -360.0 || d4 >= 360.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoEllipticArc_SweepAngleRange(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d4 == 0.0) {
            String string = InternalResource.loadString("sweepAngle", "GeoEllipticArc_StartAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this._$6 = d3;
        this._$5 = d4;
        double d6 = 0.0;
        double d7 = 0.0;
        if (d4 < 0.0) {
            d6 = d3 + d4;
            d7 = d3;
        } else {
            d6 = d3;
            d7 = d3 + d4;
        }
        long l = GeoEllipticArcNative.jni_New1(point2D.getX(), point2D.getY(), d, d2, d6, d7, d5);
        this.setHandle(l, true);
    }

    GeoEllipticArc(long l) {
        this.setHandle(l, false);
        this._$6 = GeoEllipticArcNative.jni_getStartAngle(l);
        this._$5 = GeoEllipticArcNative.jni_getSweepAngle(l);
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoEllipticArcNative.jni_getCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetCenter(Point2D point2D)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipticArcNative.jni_setCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getSemimajorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetSemimajorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getSemimajorAxis(this.getHandle());
    }

    public void setSemimajorAxis(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetSemimajorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoEllipse_SemimajorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoEllipticArcNative.jni_setSemimajorAxis(this.getHandle(), d);
    }

    public double getSemiminorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetSemiminorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getSemiminorAxis(this.getHandle());
    }

    public void setSemiminorAxis(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetSemiminorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("value", "GeoEllipse_SemiMinorAxisShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoEllipticArcNative.jni_setSemiminorAxis(this.getHandle(), d);
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetStartAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$6;
    }

    public void setStartAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("SetStartAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double d2 = this.getSweepAngle();
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = GeoEllipticArc.valueToUGC(d, d2, d3, d4);
        GeoEllipticArcNative.jni_setStartAngle(this.getHandle(), dArray[0], dArray[1]);
        this._$6 = d;
    }

    public double getSweepAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSweepAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this._$5;
    }

    public void setSweepAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSweepAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= -360.0 || d >= 360.0) {
            String string = InternalResource.loadString("value", "GeoEllipticArc_SweepAngleRange(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d == 0.0) {
            String string = InternalResource.loadString("value", "GeoEllipticArc_StartAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = this.getStartAngle();
        double d3 = 0.0;
        double d4 = 0.0;
        double[] dArray = GeoEllipticArc.valueToUGC(d2, d, d3, d4);
        GeoEllipticArcNative.jni_setStartAngle(this.getHandle(), dArray[0], dArray[1]);
        this._$5 = d;
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getAngle(this.getHandle());
    }

    public void setRotation(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoEllipticArcNative.jni_setAngle(this.getHandle(), d);
    }

    public double getLength() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetLength()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoEllipticArcNative.jni_getLength(this.getHandle());
    }

    public GeoLine convertToLine(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("ConvertToLine(int segmentCount)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("ConvertToLine(int segmentCount)", "GeoEllipticArc_GeoLineSegmentCountShouldNotBeNeagtive", "data_resources");
            throw new IllegalStateException(string);
        }
        long l = GeoEllipticArcNative.jni_convertToLine(this.getHandle(), n);
        GeoLine geoLine = null;
        if (l != 0L) {
            geoLine = new GeoLine(l);
            geoLine.setHandle(l, true);
        }
        return geoLine;
    }

    public Point2D findPointOnArc(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("FindPointOnArc(double sweepAngle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d > this.getSweepAngle() || d < 0.0) {
            String string = InternalResource.loadString("FindPointOnArc(double sweepAngle)", "GeoEllipticArc_ArgumentOutOfBounds", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoEllipticArcNative.jni_findPointOnArc(this.getHandle(), d, dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public GeoEllipticArc clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoEllipticArc(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoEllipticArcNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected static double[] valueToUGC(double d, double d2, double d3, double d4) {
        int n = (int)d;
        int n2 = n / 360;
        d -= (double)(360 * n2);
        if (d2 < 0.0) {
            d3 = d + d2;
            d4 = d;
        } else {
            d3 = d;
            d4 = d + d2;
        }
        double[] dArray = new double[]{d3, d4};
        return dArray;
    }
}

