/*
 * Decompiled with CFR 0.152.
 */
package org.smslib.modem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ajwcc.pduUtils.gsm3040.Pdu;
import org.ajwcc.pduUtils.gsm3040.PduParser;
import org.ajwcc.pduUtils.gsm3040.PduUtils;
import org.ajwcc.pduUtils.gsm3040.SmsDeliveryPdu;
import org.ajwcc.pduUtils.gsm3040.SmsStatusReportPdu;
import org.smslib.AGateway;
import org.smslib.Contact;
import org.smslib.GatewayException;
import org.smslib.InboundBinaryMessage;
import org.smslib.InboundEncryptedMessage;
import org.smslib.InboundMessage;
import org.smslib.OutboundMessage;
import org.smslib.Phonebook;
import org.smslib.Service;
import org.smslib.StatusReportMessage;
import org.smslib.TimeoutException;
import org.smslib.USSDRequest;
import org.smslib.UnknownMessage;
import org.smslib.helper.Logger;
import org.smslib.modem.AModemDriver;
import org.smslib.modem.IPModemDriver;
import org.smslib.modem.SerialModemDriver;
import org.smslib.modem.athandler.AATHandler;

public class ModemGateway
extends AGateway {
    private AModemDriver driver;
    private AATHandler atHandler;
    private String modemDevice;
    private int modemParms;
    private IPProtocols ipProtocol;
    private boolean ipEncryption;
    private long lastKeepLinkOpen;
    private String manufacturer;
    private String model;
    private String simPin;
    private String simPin2;
    private String customInitString;
    private String smscNumber;
    private int outMpRefNo;
    private List<List<InboundMessage>> mpMsgList;
    private boolean displayIllegalReceivedMessages;

    public ModemGateway(ModemTypes myType, String id, String myModemDevice, int myModemParms, String myManufacturer, String myModel) {
        super(id);
        this.init(myType, myModemDevice, myModemParms, myManufacturer, myModel, null);
    }

    public ModemGateway(String id, String myModemDevice, int myModemParms, String myManufacturer, String myModel, AModemDriver myDriver) {
        super(id);
        this.init(null, myModemDevice, myModemParms, myManufacturer, myModel, myDriver);
    }

    private void init(ModemTypes myType, String myModemDevice, int myModemParms, String myManufacturer, String myModel, AModemDriver myDriver) {
        this.setModemDevice(myModemDevice);
        this.setModemParms(myModemParms);
        this.setIpProtocol(IPProtocols.BINARY);
        this.setIpEncryption(false);
        this.setLastKeepLinkOpen(-1L);
        this.manufacturer = myManufacturer;
        this.model = myModel;
        this.setAttributes(251);
        if (myDriver != null) {
            this.setDriver(myDriver);
        } else if (myType == ModemTypes.SERIAL) {
            this.setDriver(new SerialModemDriver(this, this.getModemDevice() + ":" + this.getModemParms()));
        } else {
            this.setDriver(new IPModemDriver(this, this.getModemDevice() + ":" + this.getModemParms()));
        }
        this.setAtHandler(AATHandler.load(this, this.manufacturer, this.model));
        this.setSimPin("");
        this.setSimPin2("");
        this.setSmscNumber("");
        this.setCustomInitString("");
        this.outMpRefNo = new Random().nextInt();
        if (this.outMpRefNo < 0) {
            this.outMpRefNo *= -1;
        }
        this.outMpRefNo %= 65536;
        this.mpMsgList = new ArrayList<List<InboundMessage>>();
    }

    public void setIpProtocol(IPProtocols myIpProtocol) {
        this.ipProtocol = myIpProtocol;
    }

    public IPProtocols getIpProtocol() {
        return this.ipProtocol;
    }

    public void setIpEncryption(boolean ipEncryption) {
        this.ipEncryption = ipEncryption;
    }

    public boolean getIpEncryption() {
        return this.ipEncryption;
    }

    @Override
    public void startGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Starting gateway, using " + this.getATHandler().getDescription() + " AT Handler.", null, this.getGatewayId());
        this.getDriver().connect();
        Logger.getInstance().logInfo("Signal level/bit error rate: " + this.getATHandler().getSignalLevel(), null, this.getGatewayId());
        Logger.getInstance().logInfo("Network registration: " + this.getATHandler().getNetworkRegistration(), null, this.getGatewayId());
        Logger.getInstance().logInfo("Network operator: " + this.getATHandler().getNetworkOperator(), null, this.getGatewayId());
        super.startGateway();
        Logger.getInstance().logInfo("Gateway started.", null, this.getGatewayId());
    }

    @Override
    public void stopGateway() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Logger.getInstance().logInfo("Stopping gateway...", null, this.getGatewayId());
        this.getATHandler().done();
        super.stopGateway();
        this.getDriver().disconnect();
        Logger.getInstance().logInfo("Gateway stopped.", null, this.getGatewayId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readMessages(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getStatus() != AGateway.GatewayStatuses.STARTED) {
            return;
        }
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            if (this.getProtocol() == AGateway.Protocols.PDU) {
                this.readMessagesPDU(msgList, msgClass, 0);
            } else if (this.getProtocol() == AGateway.Protocols.TEXT) {
                this.readMessagesTEXT(msgList, msgClass, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InboundMessage readMessage(String memLoc, int memIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getStatus() != AGateway.GatewayStatuses.STARTED) {
            return null;
        }
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            ArrayList<InboundMessage> msgList = new ArrayList<InboundMessage>();
            this.readMessages(msgList, InboundMessage.MessageClasses.ALL);
            for (InboundMessage msg : msgList) {
                if (msg.getMemIndex() != memIndex || !msg.getMemLocation().equals(memLoc)) continue;
                return msg;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendMessage(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        boolean sendKeepLinkOpen = false;
        if (this.getStatus() != AGateway.GatewayStatuses.STARTED) {
            return false;
        }
        if (this.getLastKeepLinkOpen() == -1L) {
            sendKeepLinkOpen = true;
        }
        if (!sendKeepLinkOpen && System.currentTimeMillis() - this.getLastKeepLinkOpen() > 4000L) {
            sendKeepLinkOpen = true;
        }
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            if (sendKeepLinkOpen) {
                this.getAtHandler().keepLinkOpen();
            }
            this.setLastKeepLinkOpen(System.currentTimeMillis());
            if (this.getProtocol() == AGateway.Protocols.PDU) {
                return this.sendMessagePDU(msg);
            }
            if (this.getProtocol() == AGateway.Protocols.TEXT) {
                return this.sendMessageTEXT(msg);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteMessage(InboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (this.getStatus() != AGateway.GatewayStatuses.STARTED) {
            return false;
        }
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            if (msg.getMemIndex() >= 0) {
                return this.deleteMessage(msg.getMemIndex(), msg.getMemLocation());
            }
            if (msg.getMemIndex() == -1 && msg.getMpMemIndex().length() != 0) {
                StringTokenizer tokens = new StringTokenizer(msg.getMpMemIndex(), ",");
                while (tokens.hasMoreTokens()) {
                    this.deleteMessage(Integer.parseInt(tokens.nextToken()), msg.getMemLocation());
                }
            }
            return true;
        }
    }

    @Override
    public int readPhonebook(Phonebook phonebook) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int count = 0;
        String locations = this.getATHandler().readPhonebookLocations();
        if (locations.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(locations, ",");
            while (tokens.hasMoreTokens()) {
                String location = tokens.nextToken().replaceAll("\"", "");
                String entries = this.getATHandler().readPhonebook(location);
                if (entries == null || entries.trim().length() == 0) continue;
                BufferedReader reader = new BufferedReader(new StringReader(entries));
                String entry = reader.readLine().trim();
                while (!entry.equalsIgnoreCase("OK")) {
                    entry = entry.replaceAll("\\s*\\+CPBR:\\s*", "");
                    entry = entry.replaceAll("\"\"", "\" \"");
                    StringTokenizer tokens4 = new StringTokenizer(entry = entry.replaceAll("\"", ""), ",");
                    String index = tokens4.nextToken();
                    index = index == null ? "" : index.trim();
                    String phone = tokens4.nextToken();
                    phone = phone == null ? "" : phone.trim();
                    String type = tokens4.nextToken();
                    type = type == null ? "" : type.trim();
                    String name = tokens4.nextToken();
                    name = name == null ? "" : name.trim();
                    phonebook.getContacts().add(new Contact(name, phone, location, Integer.parseInt(index)));
                    ++count;
                    entry = reader.readLine().trim();
                }
                reader.close();
            }
        }
        return count;
    }

    private boolean deleteMessage(int memIndex, String memLocation) throws TimeoutException, GatewayException, IOException, InterruptedException {
        return this.getATHandler().deleteMessage(memIndex, memLocation);
    }

    private boolean sendMessageTEXT(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        boolean ok = false;
        int refNo = this.getATHandler().sendMessage(0, "", msg.getRecipient(), msg.getText());
        if (refNo >= 0) {
            msg.setGatewayId(this.getGatewayId());
            msg.setRefNo("" + refNo);
            msg.setDispatchDate(new Date());
            msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            this.incOutboundMessageCount();
            ok = true;
        } else {
            msg.setRefNo(null);
            msg.setDispatchDate(null);
            msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
            msg.setErrorMessage(this.driver.getLastErrorText());
        }
        return ok;
    }

    private void readMessagesTEXT(Collection<InboundMessage> msgList, InboundMessage.MessageClasses msgClass, int myLimit) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int limit = myLimit < 0 ? 0 : myLimit;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        for (int ml = 0; ml < this.getATHandler().getStorageLocations().length() / 2; ++ml) {
            String line;
            if (!this.getATHandler().switchStorageLocation(this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2))) continue;
            String response = this.getATHandler().listMessages(msgClass);
            response = response.replaceAll("\\s+OK\\s+", "\nOK");
            BufferedReader reader = new BufferedReader(new StringReader(response));
            while ((line = reader.readLine()) != null && (line = line.trim()).length() <= 0) {
            }
            while (line != null && line.length() > 0 && !line.equalsIgnoreCase("OK")) {
                InboundMessage msg;
                String dateStr;
                int i = line.indexOf(58);
                int j = line.indexOf(44);
                int memIndex = 0;
                try {
                    memIndex = Integer.parseInt(line.substring(i + 1, j).trim());
                }
                catch (NumberFormatException e) {
                    Logger.getInstance().logWarn("Incorrect Memory Index number parsed!", e, this.getGatewayId());
                }
                StringTokenizer tokens = new StringTokenizer(line, ",");
                tokens.nextToken();
                tokens.nextToken();
                String tmpLine = "";
                if (Character.isDigit(tokens.nextToken().trim().charAt(0))) {
                    line = line.replaceAll(",,", ", ,");
                    tokens = new StringTokenizer(line, ",");
                    tokens.nextToken();
                    tokens.nextToken();
                    tokens.nextToken();
                    String refNo = tokens.nextToken();
                    tokens.nextToken();
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(1, 2000 + Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(2, Integer.parseInt(dateStr.substring(3, 5)) - 1);
                    cal1.set(5, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(11, Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(12, Integer.parseInt(dateStr.substring(3, 5)));
                    cal1.set(13, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal2.set(1, 2000 + Integer.parseInt(dateStr.substring(0, 2)));
                    cal2.set(2, Integer.parseInt(dateStr.substring(3, 5)) - 1);
                    cal2.set(5, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal2.set(11, Integer.parseInt(dateStr.substring(0, 2)));
                    cal2.set(12, Integer.parseInt(dateStr.substring(3, 5)));
                    cal2.set(13, Integer.parseInt(dateStr.substring(6, 8)));
                    msg = new StatusReportMessage(refNo, memIndex, this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2), cal1.getTime(), cal2.getTime());
                    msg.setGatewayId(this.getGatewayId());
                    Logger.getInstance().logDebug("IN-DTLS: MI:" + msg.getMemIndex(), null, this.getGatewayId());
                    msgList.add(msg);
                    this.incInboundMessageCount();
                } else {
                    line = line.replaceAll(",,", ", ,");
                    tokens = new StringTokenizer(line, ",");
                    tokens.nextToken();
                    tokens.nextToken();
                    String originator = tokens.nextToken().replaceAll("\"", "");
                    tokens.nextToken();
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(1, 2000 + Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(2, Integer.parseInt(dateStr.substring(3, 5)) - 1);
                    cal1.set(5, Integer.parseInt(dateStr.substring(6, 8)));
                    dateStr = tokens.nextToken().replaceAll("\"", "");
                    cal1.set(11, Integer.parseInt(dateStr.substring(0, 2)));
                    cal1.set(12, Integer.parseInt(dateStr.substring(3, 5)));
                    cal1.set(13, Integer.parseInt(dateStr.substring(6, 8)));
                    String msgText = "";
                    while ((tmpLine = reader.readLine()) != null && !tmpLine.startsWith("+CMGL") && !tmpLine.startsWith("+CMGR")) {
                        msgText = msgText + (msgText.length() == 0 ? "" : "\n") + tmpLine;
                    }
                    msgText = msgText.trim();
                    msg = new InboundMessage(cal1.getTime(), originator, msgText, memIndex, this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2));
                    msg.setGatewayId(this.getGatewayId());
                    Logger.getInstance().logDebug("IN-DTLS: MI:" + msg.getMemIndex(), null, this.getGatewayId());
                    msgList.add(msg);
                    this.incInboundMessageCount();
                }
                do {
                    String string = line = tmpLine == null || tmpLine.length() == 0 ? reader.readLine() : tmpLine;
                } while (line != null && (line = line.trim()).length() <= 0);
                if (limit <= 0 || msgList.size() != limit) continue;
            }
            reader.close();
        }
    }

    private boolean sendMessagePDU(OutboundMessage msg) throws TimeoutException, GatewayException, IOException, InterruptedException {
        boolean ok = false;
        List<String> pdus = msg.getPdus(this.getSmscNumber(), this.outMpRefNo);
        for (String pdu : pdus) {
            Pdu newPdu = new PduParser().parsePdu(pdu);
            Logger.getInstance().logDebug(newPdu.toString(), null, this.getGatewayId());
            int j = pdu.length() / 2;
            if (this.getSmscNumber() != null) {
                if (this.getSmscNumber().length() == 0) {
                    --j;
                } else {
                    int smscNumberLen = this.getSmscNumber().length();
                    if (this.getSmscNumber().charAt(0) == '+') {
                        --smscNumberLen;
                    }
                    if (smscNumberLen % 2 != 0) {
                        ++smscNumberLen;
                    }
                    int smscLen = (2 + smscNumberLen) / 2;
                    j = j - smscLen - 1;
                }
            }
            Logger.getInstance().logDebug("Sending Pdu: " + pdu, null, this.getGatewayId());
            int refNo = this.getATHandler().sendMessage(j, pdu, null, null);
            if (refNo < 0) {
                msg.setRefNo(null);
                msg.setDispatchDate(null);
                msg.setMessageStatus(OutboundMessage.MessageStatuses.FAILED);
                msg.setFailureCause(OutboundMessage.FailureCauses.UNKNOWN);
                ok = false;
                msg.setErrorMessage(this.driver.getLastErrorText());
                break;
            }
            msg.setGatewayId(this.getGatewayId());
            msg.setRefNo(String.valueOf(refNo));
            msg.setDispatchDate(new Date());
            msg.setMessageStatus(OutboundMessage.MessageStatuses.SENT);
            msg.setFailureCause(OutboundMessage.FailureCauses.NO_ERROR);
            this.incOutboundMessageCount();
            ok = true;
            if (ok) continue;
            break;
        }
        if (pdus.size() > 1) {
            this.outMpRefNo = (this.outMpRefNo + 1) % 65536;
        }
        return ok;
    }

    private void readMessagesPDU(Collection<InboundMessage> msgList, InboundMessage.MessageClasses messageClass, int myLimit) throws TimeoutException, GatewayException, IOException, InterruptedException {
        int limit = myLimit < 0 ? 0 : myLimit;
        for (int ml = 0; ml < this.getATHandler().getStorageLocations().length() / 2; ++ml) {
            String line;
            if (!this.getATHandler().switchStorageLocation(this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2))) continue;
            String response = this.getATHandler().listMessages(messageClass);
            response = response.replaceAll("\\s+OK\\s+", "\nOK");
            BufferedReader reader = new BufferedReader(new StringReader(response));
            while ((line = reader.readLine()) != null && (line = line.trim()).length() <= 0) {
            }
            PduParser parser = new PduParser();
            while (line != null && (line = line.trim()).length() > 0 && !line.equalsIgnoreCase("OK") && line.length() > 0 && !line.equalsIgnoreCase("ERROR")) {
                InboundMessage msg;
                int i = line.indexOf(58);
                int j = line.indexOf(44);
                int memIndex = 0;
                try {
                    memIndex = Integer.parseInt(line.substring(i + 1, j).trim());
                }
                catch (NumberFormatException e) {
                    Logger.getInstance().logWarn("Incorrect Memory Index number parsed!", e, this.getGatewayId());
                }
                i = line.lastIndexOf(44);
                j = line.length();
                int pduSize = 0;
                try {
                    pduSize = Integer.parseInt(line.substring(i + 1, j).trim());
                }
                catch (NumberFormatException e) {
                    Logger.getInstance().logWarn("Incorrect pdu size parsed!", e, this.getGatewayId());
                }
                String pduString = reader.readLine().trim();
                if (pduSize > 0 && pduSize * 2 == pduString.length()) {
                    pduString = "00" + pduString;
                }
                try {
                    Logger.getInstance().logDebug("READ PDU: " + pduString, null, this.getGatewayId());
                    Pdu pdu = parser.parsePdu(pduString);
                    if (pdu instanceof SmsDeliveryPdu) {
                        Logger.getInstance().logDebug(pdu.toString(), null, this.getGatewayId());
                        String memLocation = this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2);
                        if (pdu.isBinary()) {
                            msg = new InboundBinaryMessage((SmsDeliveryPdu)pdu, memIndex, memLocation);
                            if (Service.getInstance().getKeyManager().getKey(msg.getOriginator()) != null) {
                                msg = new InboundEncryptedMessage((SmsDeliveryPdu)pdu, memIndex, memLocation);
                            }
                        } else {
                            msg = new InboundMessage((SmsDeliveryPdu)pdu, memIndex, memLocation);
                        }
                        msg.setGatewayId(this.getGatewayId());
                        Logger.getInstance().logDebug("IN-DTLS: MI:" + msg.getMemIndex() + " REF:" + msg.getMpRefNo() + " MAX:" + msg.getMpMaxNo() + " SEQ:" + msg.getMpSeqNo(), null, this.getGatewayId());
                        if (msg.getMpRefNo() == 0) {
                            msgList.add(msg);
                            this.incInboundMessageCount();
                        } else {
                            List<InboundMessage> tmpList;
                            boolean found = false;
                            for (int k = 0; k < this.mpMsgList.size(); ++k) {
                                tmpList = this.mpMsgList.get(k);
                                InboundMessage listMsg = tmpList.get(0);
                                if (listMsg.getMpRefNo() != msg.getMpRefNo()) continue;
                                boolean duplicate = false;
                                for (int l = 0; l < tmpList.size(); ++l) {
                                    listMsg = tmpList.get(l);
                                    if (listMsg.getMpSeqNo() != msg.getMpSeqNo()) continue;
                                    duplicate = true;
                                    break;
                                }
                                if (!duplicate) {
                                    tmpList.add(msg);
                                }
                                found = true;
                                break;
                            }
                            if (!found) {
                                tmpList = new ArrayList<InboundMessage>();
                                tmpList.add(msg);
                                this.mpMsgList.add(tmpList);
                            }
                        }
                    } else if (pdu instanceof SmsStatusReportPdu) {
                        msg = new StatusReportMessage((SmsStatusReportPdu)pdu, memIndex, this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2));
                        msg.setGatewayId(this.getGatewayId());
                        msgList.add(msg);
                        this.incInboundMessageCount();
                    } else if (this.displayIllegalReceivedMessages) {
                        Logger.getInstance().logError("Wrong type of PDU detected: " + pdu.getClass().getName(), null, this.getGatewayId());
                        Logger.getInstance().logError("ERROR PDU: " + pduString, null, this.getGatewayId());
                    }
                }
                catch (Exception e) {
                    msg = new UnknownMessage(pduString, memIndex, this.getATHandler().getStorageLocations().substring(ml * 2, ml * 2 + 2));
                    msg.setGatewayId(this.getGatewayId());
                    msgList.add(msg);
                    this.incInboundMessageCount();
                    Logger.getInstance().logError("Unhandled SMS in inbox, skipping...", e, this.getGatewayId());
                    Logger.getInstance().logError("ERROR PDU: " + pduString, null, this.getGatewayId());
                }
                while ((line = reader.readLine()) != null && (line = line.trim()).length() <= 0) {
                }
                if (limit <= 0 || msgList.size() != limit) continue;
                break;
            }
            reader.close();
        }
        this.checkMpMsgList(msgList);
        for (int k = 0; k < this.mpMsgList.size(); ++k) {
            List<InboundMessage> tmpList = this.mpMsgList.get(k);
            tmpList.clear();
        }
        this.mpMsgList.clear();
    }

    public void setDisplayIllegalReceivedMessages(boolean b) {
        this.displayIllegalReceivedMessages = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageByIndex(int msgIndex) throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().getMessageByIndex(msgIndex);
        }
    }

    private void checkMpMsgList(Collection<InboundMessage> msgList) throws TimeoutException, GatewayException, IOException, InterruptedException {
        InboundMessage mpMsg = null;
        Logger.getInstance().logDebug("CheckMpMsgList(): MAINLIST: " + this.mpMsgList.size(), null, this.getGatewayId());
        for (int k = 0; k < this.mpMsgList.size(); ++k) {
            List<InboundMessage> tmpList = this.mpMsgList.get(k);
            Logger.getInstance().logDebug("CheckMpMsgList(): SUBLIST[" + k + "]: " + tmpList.size(), null, this.getGatewayId());
            InboundMessage listMsg = tmpList.get(0);
            boolean found = false;
            if (listMsg.getMpMaxNo() == tmpList.size()) {
                found = true;
                block3: for (int l = 0; l < tmpList.size(); ++l) {
                    for (int m = 0; m < tmpList.size(); ++m) {
                        listMsg = tmpList.get(m);
                        if (listMsg.getMpSeqNo() != l + 1) continue;
                        if (listMsg.getMpSeqNo() == 1) {
                            mpMsg = listMsg;
                            mpMsg.setMpMemIndex(mpMsg.getMemIndex());
                            if (listMsg.getMpMaxNo() != 1) continue block3;
                            msgList.add(mpMsg);
                            this.incInboundMessageCount();
                            continue block3;
                        }
                        if (mpMsg == null) continue block3;
                        if (mpMsg instanceof InboundBinaryMessage) {
                            InboundBinaryMessage mpMsgBinary = (InboundBinaryMessage)mpMsg;
                            InboundBinaryMessage listMsgBinary = (InboundBinaryMessage)listMsg;
                            mpMsgBinary.addDataBytes(listMsgBinary.getDataBytes());
                        } else {
                            String textToAdd = listMsg.getText();
                            if (mpMsg.getEndsWithMultiChar()) {
                                Logger.getInstance().logDebug("Adjusting dangling multi-char: " + textToAdd.charAt(0) + " --> " + PduUtils.getMultiCharFor(textToAdd.charAt(0)), null, this.getGatewayId());
                                textToAdd = PduUtils.getMultiCharFor(textToAdd.charAt(0)) + textToAdd.substring(1);
                            }
                            mpMsg.setEndsWithMultiChar(listMsg.getEndsWithMultiChar());
                            try {
                                mpMsg.addText(textToAdd);
                            }
                            catch (UnsupportedEncodingException e) {
                                // empty catch block
                            }
                        }
                        mpMsg.setMpSeqNo(listMsg.getMpSeqNo());
                        mpMsg.setMpMemIndex(listMsg.getMemIndex());
                        if (listMsg.getMpSeqNo() != listMsg.getMpMaxNo()) continue block3;
                        mpMsg.setMemIndex(-1);
                        msgList.add(mpMsg);
                        this.incInboundMessageCount();
                        mpMsg = null;
                        continue block3;
                    }
                }
                tmpList.clear();
                tmpList = null;
            }
            if (!found) continue;
            this.mpMsgList.remove(k);
            --k;
        }
        for (List<InboundMessage> remainingList : this.mpMsgList) {
            for (InboundMessage msg : remainingList) {
                if (this.getAgeInHours(msg.getDate()) <= Service.getInstance().getSettings().HOURS_TO_ORPHAN || Service.getInstance().getOrphanedMessageNotification() == null || !Service.getInstance().getOrphanedMessageNotification().process(Service.getInstance().getGateway(msg.getGatewayId()), msg)) continue;
                this.deleteMessage(msg);
            }
        }
    }

    private long getLastKeepLinkOpen() {
        return this.lastKeepLinkOpen;
    }

    private void setLastKeepLinkOpen(long lastKeepLinkOpen) {
        this.lastKeepLinkOpen = lastKeepLinkOpen;
    }

    public void setSimPin(String mySimPin) {
        this.simPin = mySimPin;
    }

    public void setSimPin2(String mySimPin2) {
        this.simPin2 = mySimPin2;
    }

    public String getSimPin() {
        return this.simPin;
    }

    public String getSimPin2() {
        return this.simPin2;
    }

    public AModemDriver getModemDriver() {
        return this.driver;
    }

    public AATHandler getATHandler() {
        return this.atHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManufacturer() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getManufacturer();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getModel();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSerialNo() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getSerialNo();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getImsi() throws TimeoutException, GatewayException, IOException, InterruptedException {
        if (Service.getInstance().getSettings().MASK_IMSI) {
            return "** MASKED **";
        }
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getImsi();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSwVersion() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getSwVersion();
            if (response.indexOf("ERROR") >= 0) {
                return "N/A";
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            return response;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getGprsStatus() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().getGprsStatus().matches("\\+CGATT[\\p{ASCII}]*1\\sOK\\s");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBatteryLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getBatteryLevel();
            if (response.indexOf("ERROR") >= 0) {
                return 0;
            }
            Matcher m = Pattern.compile("\\+CBC: (\\d+),\\s*(\\d+)").matcher(response);
            if (m.find()) {
                return Integer.parseInt(m.group(2));
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSignalLevel() throws TimeoutException, GatewayException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            String response = this.getATHandler().getSignalLevel();
            if (response.indexOf("ERROR") >= 0) {
                return 0;
            }
            response = response.replaceAll("\\s+OK\\s+", "");
            StringTokenizer tokens = new StringTokenizer(response, ":,");
            tokens.nextToken();
            Integer rssi_code = Integer.parseInt(tokens.nextToken().trim());
            if (rssi_code == 99) {
                return 99;
            }
            return -113 + 2 * rssi_code;
        }
    }

    public String getSmscNumber() {
        return this.smscNumber;
    }

    public void setSmscNumber(String mySmscNumber) {
        this.smscNumber = mySmscNumber;
    }

    public String getCustomInitString() {
        return this.customInitString;
    }

    public void setCustomInitString(String myCustomInitString) {
        this.customInitString = myCustomInitString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendCustomATCommand(String atCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendCustomATCommand(atCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendUSSDCommand(String ussdCommand) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendUSSDCommand(ussdCommand);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendUSSDCommand(String ussdCommand, boolean interactive) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendUSSDCommand(ussdCommand, interactive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendUSSDRequest(USSDRequest request) throws GatewayException, TimeoutException, IOException, InterruptedException {
        Object object = this.getDriver().getSYNCCommander();
        synchronized (object) {
            return this.getATHandler().sendUSSDRequest(Integer.toString(request.getResultPresentation().getNumeric()), request.getContent(), Integer.toString(request.getDcs().getNumeric()));
        }
    }

    protected AModemDriver getDriver() {
        return this.driver;
    }

    protected void setDriver(AModemDriver myDriver) {
        this.driver = myDriver;
    }

    protected AATHandler getAtHandler() {
        return this.atHandler;
    }

    protected void setAtHandler(AATHandler myAtHandler) {
        this.atHandler = myAtHandler;
    }

    protected String getModemDevice() {
        return this.modemDevice;
    }

    protected void setModemDevice(String myModemDevice) {
        this.modemDevice = myModemDevice;
    }

    protected int getModemParms() {
        return this.modemParms;
    }

    protected void setModemParms(int myModemParms) {
        this.modemParms = myModemParms;
    }

    protected int getAgeInHours(Date messageDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        long now = cal.getTimeInMillis();
        cal.setTime(messageDate);
        long past = cal.getTimeInMillis();
        return (int)((now - past) / 3600000L);
    }

    @Override
    public int getQueueSchedulingInterval() {
        return Service.getInstance().getSettings().QUEUE_SCHEDULING_INTERNAL;
    }

    public static enum IPProtocols {
        TEXT,
        BINARY;

    }

    public static enum ModemTypes {
        SERIAL,
        IP;

    }
}

