/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.jasig.cas.client.ssl.HttpsURLConnectionFactory;
import org.jasig.cas.client.validation.AbstractTicketValidationFilter;
import org.jasig.cas.client.validation.Saml11TicketValidator;
import org.jasig.cas.client.validation.TicketValidator;

public class Saml11TicketValidationFilter
extends AbstractTicketValidationFilter {
    public Saml11TicketValidationFilter() {
        this.setArtifactParameterName("SAMLart");
        this.setServiceParameterName("TARGET");
    }

    protected final void initInternal(FilterConfig filterConfig) throws ServletException {
        super.initInternal(filterConfig);
        this.logger.warn("SAML1.1 compliance requires the [artifactParameterName] and [serviceParameterName] to be set to specified values.");
        this.logger.warn("This filter will overwrite any user-provided values (if any are provided)");
        this.setArtifactParameterName("SAMLart");
        this.setServiceParameterName("TARGET");
    }

    protected final TicketValidator getTicketValidator(FilterConfig filterConfig) {
        Saml11TicketValidator validator = new Saml11TicketValidator(this.getPropertyFromInitParams(filterConfig, "casServerUrlPrefix", null));
        String tolerance = this.getPropertyFromInitParams(filterConfig, "tolerance", "1000");
        validator.setTolerance(Long.parseLong(tolerance));
        validator.setRenew(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "renew", "false")));
        HttpsURLConnectionFactory factory = new HttpsURLConnectionFactory(this.getHostnameVerifier(filterConfig), this.getSSLConfig(filterConfig));
        validator.setURLConnectionFactory(factory);
        validator.setEncoding(this.getPropertyFromInitParams(filterConfig, "encoding", null));
        validator.setDisableXmlSchemaValidation(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "disableXmlSchemaValidation", "false")));
        return validator;
    }
}

