/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalEnum;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.SolarRadiationParameterNative;
import com.supermap.analyst.spatialanalyst.SolarTimeMode;
import com.supermap.data.InternalHandleDisposable;

public class SolarRadiationParameter
extends InternalHandleDisposable {
    public SolarRadiationParameter() {
        this.setHandle(SolarRadiationParameterNative.jni_New(), true);
    }

    public void dispose() {
        if (super.getHandle() != 0L) {
            SolarRadiationParameterNative.jni_Dispose(this.getHandle());
            this.setHandle(0L);
        }
    }

    public void setLatitude(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setLatitude", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (d < -90.0 || d > 90.0) {
            String string = InternalResource.loadString("Latitude", "IllegalLatitudeValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetLatitude(this.getHandle(), d);
    }

    public double getLatitude() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getLatitude", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetLatitude(this.getHandle());
    }

    public void setTimeMode(SolarTimeMode solarTimeMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTimeMode", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        SolarRadiationParameterNative.jni_SetTimeMode(this.getHandle(), solarTimeMode.value());
    }

    public SolarTimeMode getTimeMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTimeMode", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        int n = SolarRadiationParameterNative.jni_GetTimeMode(this.getHandle());
        SolarTimeMode solarTimeMode = (SolarTimeMode)InternalEnum.parseUGCValue(SolarTimeMode.class, n);
        return solarTimeMode;
    }

    public void setDayStart(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDayStart", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0 || n > 365) {
            String string = InternalResource.loadString("DayStart", "IllegalDayValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetDayStart(this.getHandle(), n);
    }

    public int getDayStart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDayStart", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetDayStart(this.getHandle());
    }

    public void setDayEnd(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDayEnd", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0 || n > 365) {
            String string = InternalResource.loadString("DayEnd", "IllegalDayValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetDayEnd(this.getHandle(), n);
    }

    public int getDayEnd() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDayEnd", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetDayEnd(this.getHandle());
    }

    public void setHourStart(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHourStart", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0 || d > 24.0) {
            String string = InternalResource.loadString("HourStart", "IllegalHourValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetHourStart(this.getHandle(), d);
    }

    public double getHourStart() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHourStart", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetHourStart(this.getHandle());
    }

    public void setHourEnd(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHourEnd", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0 || d > 24.0) {
            String string = InternalResource.loadString("HourEnd", "IllegalHourValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetHourEnd(this.getHandle(), d);
    }

    public double getHourEnd() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHourEnd", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetHourEnd(this.getHandle());
    }

    public void setDayInterval(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setDayInterval", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("DayInterval", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetDayInterval(this.getHandle(), n);
    }

    public int getDayInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getDayInterval", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetDayInterval(this.getHandle());
    }

    public void setHourInterval(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHourInterval", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0 || d > 24.0) {
            String string = InternalResource.loadString("HourInterval", "IllegalHourValue", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetHourInterval(this.getHandle(), d);
    }

    public double getHourInterval() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getHourInterval", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetHourInterval(this.getHandle());
    }

    public void setTransmittance(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setTransmittance", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (d < 0.0 || d > 1.0) {
            String string = InternalResource.loadString("Transmittance", "ShouldBetweenZeroAndOne", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetTransmittance(this.getHandle(), d);
    }

    public double getTransmittance() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTransmittance", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetTransmittance(this.getHandle());
    }

    public void setZFactor(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setZFactor", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("ZFactor", "Global_ShouldGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        SolarRadiationParameterNative.jni_SetZFactor(this.getHandle(), d);
    }

    public double getZFactor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getZFactor", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return SolarRadiationParameterNative.jni_GetZFactor(this.getHandle());
    }
}

