/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InterpolationAlgorithmType;
import com.supermap.analyst.spatialanalyst.InterpolationParameter;
import com.supermap.analyst.spatialanalyst.InterpolationParameterNative;
import com.supermap.analyst.spatialanalyst.SearchMode;

public class InterpolationIDWParameter
extends InterpolationParameter {
    public InterpolationIDWParameter() {
        super(InterpolationAlgorithmType.IDW);
    }

    public InterpolationIDWParameter(double d, SearchMode searchMode, double d2, int n) {
        super(InterpolationAlgorithmType.IDW, d, searchMode, d2, n);
    }

    public InterpolationIDWParameter(double d, SearchMode searchMode, double d2, int n, int n2) {
        this(d, searchMode, d2, n);
        this.setPower(n2);
    }

    public InterpolationAlgorithmType getType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getType()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationAlgorithmType.IDW;
    }

    public int getPower() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPower()", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        return InterpolationParameterNative.jni_GetPower(this.getHandle());
    }

    public void setPower(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPower(int value)", "GlobalHandleObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("value", "GlobalGreaterThanZero", "spatialanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        InterpolationParameterNative.jni_SetPower(this.getHandle(), n);
    }

    public void setSearchMode(SearchMode searchMode) {
        if (searchMode.equals((Object)SearchMode.QUADTREE)) {
            String string = InternalResource.loadString("searchMode", "GlobalUnsportedType", "spatialanalyst_resources");
            throw new IllegalStateException(string);
        }
        super.setSearchMode(searchMode);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(",Power=");
        stringBuffer.append(this.getPower());
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

