/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.util;

import java.lang.reflect.Method;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class Jpa21Utils {
    private static final Method GET_ENTITY_GRAPH_METHOD;
    private static final boolean JPA21_AVAILABLE;

    public static <T extends Query> T tryConfigureFetchGraph(EntityManager em, T query, JpaEntityGraph entityGraph) {
        if (entityGraph == null) {
            return query;
        }
        EntityGraph<?> graph = Jpa21Utils.tryGetFetchGraph(em, entityGraph);
        if (graph == null) {
            return query;
        }
        query.setHint(entityGraph.getType().getKey(), graph);
        return query;
    }

    public static EntityGraph<?> tryGetFetchGraph(EntityManager em, JpaEntityGraph jpaEntityGraph) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        Assert.notNull((Object)jpaEntityGraph, (String)"EntityGraph must not be null!");
        Assert.isTrue((boolean)JPA21_AVAILABLE, (String)"The EntityGraph-Feature requires at least a JPA 2.1 persistence provider!");
        Assert.isTrue((GET_ENTITY_GRAPH_METHOD != null ? 1 : 0) != 0, (String)"It seems that you have the JPA 2.1 API but a JPA 2.0 implementation on the classpath!");
        return em.getEntityGraph(jpaEntityGraph.getName());
    }

    static {
        JPA21_AVAILABLE = ClassUtils.isPresent((String)"javax.persistence.NamedEntityGraph", (ClassLoader)Jpa21Utils.class.getClassLoader());
        GET_ENTITY_GRAPH_METHOD = JPA21_AVAILABLE ? ReflectionUtils.findMethod(EntityManager.class, (String)"getEntityGraph", (Class[])new Class[]{String.class}) : null;
    }
}

