// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom;

/**
<P>This interface represents an entity, either parsed or
      unparsed, in an XML document. Note that this models the entity
      itself <emph>not</emph> the entity declaration. <A HREF='Entity.html'><CODE>Entity</CODE></A>
      declaration modeling has been left for a later Level of the DOM
      specification.
<P>The <code>nodeName</code> attribute that is inherited from
      <A HREF='Node.html'><CODE>Node</CODE></A> contains the name of the entity.
<P>An XML processor may choose to completely expand entities before 
      the structure model is passed to the DOM; in this case there will
      be no <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A> nodes in the document tree.
<P>XML does not mandate that a non-validating XML processor read
      and process entity declarations  made in the external subset or
      declared in external parameter entities. This means
      that parsed entities declared in the external subset
      need not be expanded by some classes of applications, and that
      the replacement value of the entity may not be available. When the
      replacement value is available, the corresponding 
      <A HREF='Entity.html'><CODE>Entity</CODE></A> node's child list represents the structure of
      that replacement text. Otherwise, the child list is empty.
<P>The resolution of the children of the <A HREF='Entity.html'><CODE>Entity</CODE></A> (the 
      replacement value) may be lazily evaluated; actions by the user (such as
      calling the <code>childNodes</code> method on the
      <A HREF='Entity.html'><CODE>Entity</CODE></A> Node) are assumed to trigger the evaluation. 
    
<P>The DOM Level 1 does not support editing <A HREF='Entity.html'><CODE>Entity</CODE></A>
      nodes; if a user wants to make changes to the contents of an
      <A HREF='Entity.html'><CODE>Entity</CODE></A>, every related <A HREF='EntityReference.html'><CODE>EntityReference</CODE></A> node
      has to be replaced in the structure model by a clone of the
      <A HREF='Entity.html'><CODE>Entity</CODE></A>'s contents, and then the desired changes must be made
      to each of those clones instead. All the descendants of an
      <A HREF='Entity.html'><CODE>Entity</CODE></A> node are readonly.
<P>An <A HREF='Entity.html'><CODE>Entity</CODE></A> node does not have any parent.

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-publicId><CODE>&nbsp;publicId</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getPublicId()'>getPublicId</a>
</TD>
<TD><P>The public identifier associated with the entity, if
	specified. If the public identifier was not specified, this
	is <code>null</code>.
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-systemId><CODE>&nbsp;systemId</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getSystemId()'>getSystemId</a>
</TD>
<TD><P>The system identifier associated with the entity, if
	specified. If the system identifier was not specified, this
	is <code>null</code>.
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-notationName><CODE>&nbsp;notationName</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getNotationName()'>getNotationName</a>
</TD>
<TD><P>For unparsed entities, the name of the notation for the
	entity. For parsed entities, this is <code>null</code>. 
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface Entity
extends Node
{
	/**
	 * Returns the value of the <code><a href=#att-publicId>publicId</a></code> property.
	*/
	String getPublicId ();


	/**
	 * Returns the value of the <code><a href=#att-systemId>systemId</a></code> property.
	*/
	String getSystemId ();


	/**
	 * Returns the value of the <code><a href=#att-notationName>notationName</a></code> property.
	*/
	String getNotationName ();


}
