/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingMAPGISNative;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;

public class ImportSettingMAPGIS
extends ImportSetting {
    public ImportSettingMAPGIS() {
        long l = ImportSettingMAPGISNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingMAPGIS(ImportSettingMAPGIS importSettingMAPGIS) {
        if (importSettingMAPGIS == null) {
            String string = InternalResource.loadString("ImportSettingMAPGIS", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = importSettingMAPGIS.getHandle();
        if (l == 0L) {
            String string = InternalResource.loadString("ImportSettingMAPGIS", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingMAPGISNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingMAPGIS.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingMAPGIS.getTargetDatasource());
        this.setColorIndexFilePath(importSettingMAPGIS.getColorIndexFilePath());
        this.setImportingAsCAD(importSettingMAPGIS.isImportingAsCAD());
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingMAPGIS));
    }

    public ImportSettingMAPGIS(String string, DatasourceConnectionInfo datasourceConnectionInfo) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public ImportSettingMAPGIS(String string, Datasource datasource, boolean bl) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasource(datasource);
        this.setImportingAsCAD(bl);
        super.setDataType(DataType.VECTOR);
    }

    public ImportSettingMAPGIS(String string, DatasourceConnectionInfo datasourceConnectionInfo, boolean bl) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        this.setImportingAsCAD(bl);
        super.setDataType(DataType.VECTOR);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)datasourceConnectionInfo);
    }

    public void setImportingAsCAD(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingMAPGISNative.jni_SetImportingAsCAD(this.getHandle(), bl);
    }

    public boolean isImportingAsCAD() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportingAsCAD()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingMAPGISNative.jni_IsImportingAsCAD(this.getHandle());
    }

    public String getColorIndexFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getVisibleFlag()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingMAPGISNative.jni_GetColorIndexFilePath(this.getHandle());
    }

    public void setColorIndexFilePath(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setVisibleFlag()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string2);
        }
        ImportSettingMAPGISNative.jni_SetColorIndexFilePath(this.getHandle(), string);
    }

    public boolean isImportNetworkTopology() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isImportNetworkTopology()", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        return ImportSettingMAPGISNative.jni_GetImportNetworkTopology(this.getHandle());
    }

    public void setImportNetworkTopology(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsCAD(boolean value)", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        ImportSettingMAPGISNative.jni_SetImportNetworkTopology(this.getHandle(), bl);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingMAPGISNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    protected void clearHandle() {
        super.clearHandle();
    }
}

