/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.conversion;

import com.supermap.data.Datasource;
import com.supermap.data.DatasourceConnectionInfo;
import com.supermap.data.InternalHandle;
import com.supermap.data.conversion.DataType;
import com.supermap.data.conversion.IgnoreMode;
import com.supermap.data.conversion.ImportSetting;
import com.supermap.data.conversion.ImportSettingGIFNative;
import com.supermap.data.conversion.InternalEnum;
import com.supermap.data.conversion.InternalHandleDisposable;
import com.supermap.data.conversion.InternalResource;
import java.io.File;

public class ImportSettingGIF
extends ImportSetting {
    public ImportSettingGIF() {
        long l = ImportSettingGIFNative.jni_New();
        this.setHandle(l, true);
        super.setDataType(DataType.RASTER);
    }

    public ImportSettingGIF(ImportSettingGIF importSettingGIF) {
        if (importSettingGIF == null) {
            String string = InternalResource.loadString("importSettingGIF", "Global_ArgumentNull", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l = com.supermap.data.conversion.InternalHandle.getHandle((InternalHandle)importSettingGIF);
        if (l == 0L) {
            String string = InternalResource.loadString("importSettingGIF", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ImportSettingGIFNative.jni_Clone(l);
        this.setHandle(l2, true);
        this.setTargetDatasourceConnectionInfo(importSettingGIF.getTargetDatasourceConnectionInfo());
        this.setTargetDatasource(importSettingGIF.getTargetDatasource());
        this.setTargetPrjCoordSys(importSettingGIF.getTargetPrjCoordSys());
        super.setDataType(DataType.RASTER);
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)importSettingGIF));
    }

    public ImportSettingGIF(String string, DatasourceConnectionInfo datasourceConnectionInfo) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasourceConnectionInfo(datasourceConnectionInfo);
        super.setDataType(DataType.RASTER);
    }

    public ImportSettingGIF(String string, Datasource datasource) {
        this();
        this.setSourceFilePath(string);
        this.setTargetDatasource(datasource);
        super.setDataType(DataType.RASTER);
    }

    public boolean isImportingAsGrid() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTargetDataInfos()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingGIFNative.jni_IsImportingAsGrid(this.getHandle());
    }

    public void setImportingAsGrid(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setImportingAsGrid(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingGIFNative.jni_SetImportingAsGrid(this.getHandle(), bl);
    }

    public boolean isPyramidBuilt() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isPyramidBuilt()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingGIFNative.jni_IsPyramidBuilt(this.getHandle());
    }

    public void setPyramidBuilt(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPyramidBuilt(boolean value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        ImportSettingGIFNative.jni_SetPyramidBuilt(this.getHandle(), bl);
    }

    public String getWorldFilePath() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getWorldFilePath()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        return ImportSettingGIFNative.jni_GetWorldFilePath(this.getHandle());
    }

    public void setWorldFilePath(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setWorldFilePath(String value)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = InternalResource.loadString("", "Global_PathIsNotValid", "conversion_resources");
            throw new IllegalArgumentException(string3);
        }
        ImportSettingGIFNative.jni_SetWorldFilePath(this.getHandle(), string);
    }

    public void setIgnoreMode(IgnoreMode ignoreMode) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreMode(int ignoreMode)", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ignoreMode.value();
        ImportSettingGIFNative.jni_SetIgnorMode(this.getHandle(), n);
    }

    public IgnoreMode getIgnoreMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreMode()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingGIFNative.jni_GetIgnorMode(this.getHandle());
        return (IgnoreMode)InternalEnum.parseUGCValue(IgnoreMode.class, n);
    }

    public double[] getIgnoreValues() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIgnoreValues()", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        int n = ImportSettingGIFNative.jni_GetIgnoreValueCount(this.getHandle());
        double[] dArray = new double[n];
        ImportSettingGIFNative.jni_GetIgnoreValues(this.getHandle(), dArray);
        return dArray;
    }

    public void setIgnoreValues(double[] dArray) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIgnoreValues", "Handle_ObjectHasBeenDisposed", "conversion_resources");
            throw new IllegalStateException(string);
        }
        if (dArray == null) {
            dArray = new double[]{};
        }
        ImportSettingGIFNative.jni_SetIgnoreValues(this.getHandle(), dArray);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "conversion_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ImportSettingGIFNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

