/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ActiveProfilesResolver;
import org.springframework.test.context.support.DefaultActiveProfilesResolver;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class ActiveProfilesUtils {
    private static final Log logger = LogFactory.getLog(ActiveProfilesUtils.class);

    private ActiveProfilesUtils() {
    }

    static String[] resolveActiveProfiles(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        HashSet<String> activeProfiles = new HashSet<String>();
        Class<ActiveProfiles> annotationType = ActiveProfiles.class;
        MetaAnnotationUtils.AnnotationDescriptor<ActiveProfiles> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        if (descriptor == null && logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        }
        while (descriptor != null) {
            String msg;
            Class<DefaultActiveProfilesResolver> resolverClass;
            Class<?> rootDeclaringClass = descriptor.getRootDeclaringClass();
            Class<?> declaringClass = descriptor.getDeclaringClass();
            AnnotationAttributes annAttrs = descriptor.getAnnotationAttributes();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @ActiveProfiles attributes [%s] for declaring class [%s].", annAttrs, declaringClass.getName()));
            }
            if (ActiveProfilesResolver.class == (resolverClass = annAttrs.getClass("resolver"))) {
                resolverClass = DefaultActiveProfilesResolver.class;
            }
            ActiveProfilesResolver resolver = null;
            try {
                resolver = (ActiveProfilesResolver)BeanUtils.instantiateClass(resolverClass, ActiveProfilesResolver.class);
            }
            catch (Exception e) {
                msg = String.format("Could not instantiate ActiveProfilesResolver of type [%s] for test class [%s].", resolverClass.getName(), rootDeclaringClass.getName());
                logger.error((Object)msg);
                throw new IllegalStateException(msg, e);
            }
            String[] profiles = resolver.resolve(rootDeclaringClass);
            if (profiles == null) {
                msg = String.format("ActiveProfilesResolver [%s] returned a null array of bean definition profiles.", resolverClass.getName());
                logger.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            for (String profile : profiles) {
                if (!StringUtils.hasText((String)profile)) continue;
                activeProfiles.add(profile.trim());
            }
            descriptor = annAttrs.getBoolean("inheritProfiles") ? MetaAnnotationUtils.findAnnotationDescriptor(rootDeclaringClass.getSuperclass(), annotationType) : null;
        }
        return StringUtils.toStringArray(activeProfiles);
    }
}

