/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.BitSet;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util._TestUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class SearchEquivalenceTestBase
extends LuceneTestCase {
    protected static IndexSearcher s1;
    protected static IndexSearcher s2;
    protected static Directory directory;
    protected static IndexReader reader;
    protected static Analyzer analyzer;
    protected static String stopword;

    @BeforeClass
    public static void beforeClass() throws Exception {
        directory = SearchEquivalenceTestBase.newDirectory();
        stopword = "" + SearchEquivalenceTestBase.randomChar();
        CharArraySet stopset = new CharArraySet(TEST_VERSION_CURRENT, 1, false);
        stopset.add(stopword);
        analyzer = new MockAnalyzer(random, 0, false, stopset, true);
        RandomIndexWriter iw = new RandomIndexWriter((Random)random, directory, analyzer);
        Document doc = new Document();
        Field id = new Field("id", "", Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
        Field field = new Field("field", "", Field.Store.NO, Field.Index.ANALYZED);
        doc.add((Fieldable)id);
        doc.add((Fieldable)field);
        int numDocs = SearchEquivalenceTestBase.atLeast(1000);
        for (int i = 0; i < numDocs; ++i) {
            id.setValue(Integer.toString(i));
            field.setValue(SearchEquivalenceTestBase.randomFieldContents());
            iw.addDocument(doc);
        }
        int numDeletes = numDocs / 20;
        for (int i = 0; i < numDeletes; ++i) {
            Term toDelete = new Term("id", Integer.toString(random.nextInt(numDocs)));
            if (random.nextBoolean()) {
                iw.deleteDocuments(toDelete);
                continue;
            }
            iw.deleteDocuments((Query)new TermQuery(toDelete));
        }
        reader = iw.getReader();
        s1 = SearchEquivalenceTestBase.newSearcher(reader);
        s2 = SearchEquivalenceTestBase.newSearcher(reader);
        iw.close();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        reader.close();
        directory.close();
        analyzer.close();
        reader = null;
        directory = null;
        analyzer = null;
        s2 = null;
        s1 = null;
    }

    static String randomFieldContents() {
        StringBuilder sb = new StringBuilder();
        int numTerms = random.nextInt(15);
        for (int i = 0; i < numTerms; ++i) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(SearchEquivalenceTestBase.randomChar());
        }
        return sb.toString();
    }

    static char randomChar() {
        return (char)_TestUtil.nextInt(random, 97, 122);
    }

    protected Term randomTerm() {
        return new Term("field", "" + SearchEquivalenceTestBase.randomChar());
    }

    protected Filter randomFilter() {
        return new QueryWrapperFilter((Query)new TermRangeQuery("field", "a", "" + SearchEquivalenceTestBase.randomChar(), true, true));
    }

    public void assertSameSet(Query q1, Query q2) throws Exception {
        this.assertSubsetOf(q1, q2);
        this.assertSubsetOf(q2, q1);
    }

    public void assertSubsetOf(Query q1, Query q2) throws Exception {
        this.assertSubsetOf(q1, q2, null);
        this.assertSubsetOf(q1, q2, this.randomFilter());
    }

    protected void assertSubsetOf(Query q1, Query q2, Filter filter) throws Exception {
        int i;
        TopDocs td1 = s1.search(q1, filter, reader.maxDoc());
        TopDocs td2 = s2.search(q2, filter, reader.maxDoc());
        SearchEquivalenceTestBase.assertTrue((td1.totalHits <= td2.totalHits ? 1 : 0) != 0);
        BitSet bitset = new BitSet();
        for (i = 0; i < td2.scoreDocs.length; ++i) {
            bitset.set(td2.scoreDocs[i].doc);
        }
        for (i = 0; i < td1.scoreDocs.length; ++i) {
            SearchEquivalenceTestBase.assertTrue((boolean)bitset.get(td1.scoreDocs[i].doc));
        }
    }
}

