/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.validation.ProcessValidator;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.Validator;
import org.activiti.validation.validator.ValidatorSet;

public class ProcessValidatorImpl
implements ProcessValidator {
    protected List<ValidatorSet> validatorSets;

    @Override
    public List<ValidationError> validate(BpmnModel bpmnModel) {
        ArrayList<ValidationError> allErrors = new ArrayList<ValidationError>();
        for (ValidatorSet validatorSet : this.validatorSets) {
            for (Validator validator : validatorSet.getValidators()) {
                ArrayList<ValidationError> validatorErrors = new ArrayList<ValidationError>();
                validator.validate(bpmnModel, validatorErrors);
                if (validatorErrors.size() <= 0) continue;
                for (ValidationError error : validatorErrors) {
                    error.setValidatorSetName(validatorSet.getName());
                }
                allErrors.addAll(validatorErrors);
            }
        }
        return allErrors;
    }

    public List<ValidatorSet> getValidatorSets() {
        return this.validatorSets;
    }

    public void setValidatorSets(List<ValidatorSet> validatorSets) {
        this.validatorSets = validatorSets;
    }

    public void addValidatorSet(ValidatorSet validatorSet) {
        if (this.validatorSets == null) {
            this.validatorSets = new ArrayList<ValidatorSet>();
        }
        this.validatorSets.add(validatorSet);
    }
}

