/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.util.Collections;
import java.util.Map;
import net.sf.oval.Check;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCheck
implements Check {
    private static final long serialVersionUID = 1L;
    protected String errorCode;
    protected String message;
    protected int severity;
    protected String[] profiles;
    private boolean messageVariablesUpToDate = true;
    private Map<String, String> messageVariables;
    private Map<String, String> messageVariablesUnmodifiable;

    protected Map<String, String> createMessageVariables() {
        return null;
    }

    @Override
    public String getErrorCode() {
        if (this.errorCode == null) {
            String className = this.getClass().getName();
            this.errorCode = className.endsWith("Check") ? className.substring(0, this.getClass().getName().length() - "Check".length()) : className;
        }
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            String className = this.getClass().getName();
            this.message = className.endsWith("Check") ? String.valueOf(className.substring(0, this.getClass().getName().length() - "Check".length())) + ".violated" : String.valueOf(className) + ".violated";
        }
        return this.message;
    }

    @Override
    public final Map<String, String> getMessageVariables() {
        if (!this.messageVariablesUpToDate) {
            this.messageVariables = this.createMessageVariables();
            this.messageVariablesUnmodifiable = this.messageVariables == null ? null : Collections.unmodifiableMap(this.messageVariables);
            this.messageVariablesUpToDate = true;
        }
        return this.messageVariablesUnmodifiable;
    }

    @Override
    public String[] getProfiles() {
        return this.profiles;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    protected void requireMessageVariablesRecreation() {
        this.messageVariablesUpToDate = false;
    }

    @Override
    public void setErrorCode(String failureCode) {
        this.errorCode = failureCode;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setProfiles(String ... profiles) {
        this.profiles = profiles;
    }

    @Override
    public void setSeverity(int severity) {
        this.severity = severity;
    }
}

