/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigGridDemo {
    private static final String XML_ENCODING = "UTF-8";

    public static void main(String[] args) throws Exception {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("Big Grid");
        Map<String, XSSFCellStyle> styles = BigGridDemo.createStyles(wb);
        String sheetRef = sheet.getPackagePart().getPartName().getName();
        FileOutputStream os = new FileOutputStream("template.xlsx");
        wb.write((OutputStream)os);
        os.close();
        File tmp = File.createTempFile("sheet", ".xml");
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), XML_ENCODING);
        BigGridDemo.generate(fw, styles);
        ((Writer)fw).close();
        FileOutputStream out = new FileOutputStream("big-grid.xlsx");
        BigGridDemo.substitute(new File("template.xlsx"), tmp, sheetRef.substring(1), out);
        out.close();
    }

    private static Map<String, XSSFCellStyle> createStyles(XSSFWorkbook wb) {
        HashMap<String, XSSFCellStyle> styles = new HashMap<String, XSSFCellStyle>();
        XSSFDataFormat fmt = wb.createDataFormat();
        XSSFCellStyle style1 = wb.createCellStyle();
        style1.setAlignment((short)3);
        style1.setDataFormat(fmt.getFormat("0.0%"));
        styles.put("percent", style1);
        XSSFCellStyle style2 = wb.createCellStyle();
        style2.setAlignment((short)2);
        style2.setDataFormat(fmt.getFormat("0.0X"));
        styles.put("coeff", style2);
        XSSFCellStyle style3 = wb.createCellStyle();
        style3.setAlignment((short)3);
        style3.setDataFormat(fmt.getFormat("$#,##0.00"));
        styles.put("currency", style3);
        XSSFCellStyle style4 = wb.createCellStyle();
        style4.setAlignment((short)3);
        style4.setDataFormat(fmt.getFormat("mmm dd"));
        styles.put("date", style4);
        XSSFCellStyle style5 = wb.createCellStyle();
        XSSFFont headerFont = wb.createFont();
        headerFont.setBold(true);
        style5.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style5.setFillPattern((short)1);
        style5.setFont((Font)headerFont);
        styles.put("header", style5);
        return styles;
    }

    private static void generate(Writer out, Map<String, XSSFCellStyle> styles) throws Exception {
        Random rnd = new Random();
        Calendar calendar = Calendar.getInstance();
        SpreadsheetWriter sw = new SpreadsheetWriter(out);
        sw.beginSheet();
        sw.insertRow(0);
        short styleIndex = styles.get("header").getIndex();
        sw.createCell(0, "Title", (int)styleIndex);
        sw.createCell(1, "% Change", (int)styleIndex);
        sw.createCell(2, "Ratio", (int)styleIndex);
        sw.createCell(3, "Expenses", (int)styleIndex);
        sw.createCell(4, "Date", (int)styleIndex);
        sw.endRow();
        for (int rownum = 1; rownum < 100000; ++rownum) {
            sw.insertRow(rownum);
            sw.createCell(0, "Hello, " + rownum + "!");
            sw.createCell(1, (double)rnd.nextInt(100) / 100.0, (int)styles.get("percent").getIndex());
            sw.createCell(2, (double)rnd.nextInt(10) / 10.0, (int)styles.get("coeff").getIndex());
            sw.createCell(3, rnd.nextInt(10000), (int)styles.get("currency").getIndex());
            sw.createCell(4, calendar, (int)styles.get("date").getIndex());
            sw.endRow();
            calendar.roll(6, 1);
        }
        sw.endSheet();
    }

    private static void substitute(File zipfile, File tmpfile, String entry, OutputStream out) throws IOException {
        ZipFile zip = new ZipFile(zipfile);
        ZipOutputStream zos = new ZipOutputStream(out);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            if (ze.getName().equals(entry)) continue;
            zos.putNextEntry(new ZipEntry(ze.getName()));
            InputStream is = zip.getInputStream(ze);
            BigGridDemo.copyStream(is, zos);
            is.close();
        }
        zos.putNextEntry(new ZipEntry(entry));
        FileInputStream is = new FileInputStream(tmpfile);
        BigGridDemo.copyStream(is, zos);
        ((InputStream)is).close();
        zos.close();
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int count;
        byte[] chunk = new byte[1024];
        while ((count = in.read(chunk)) >= 0) {
            out.write(chunk, 0, count);
        }
    }

    public static class SpreadsheetWriter {
        private final Writer _out;
        private int _rownum;

        public SpreadsheetWriter(Writer out) {
            this._out = out;
        }

        public void beginSheet() throws IOException {
            this._out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">");
            this._out.write("<sheetData>\n");
        }

        public void endSheet() throws IOException {
            this._out.write("</sheetData>");
            this._out.write("</worksheet>");
        }

        public void insertRow(int rownum) throws IOException {
            this._out.write("<row r=\"" + (rownum + 1) + "\">\n");
            this._rownum = rownum;
        }

        public void endRow() throws IOException {
            this._out.write("</row>\n");
        }

        public void createCell(int columnIndex, String value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"inlineStr\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<is><t>" + value + "</t></is>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, String value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, double value, int styleIndex) throws IOException {
            String ref = new CellReference(this._rownum, columnIndex).formatAsString();
            this._out.write("<c r=\"" + ref + "\" t=\"n\"");
            if (styleIndex != -1) {
                this._out.write(" s=\"" + styleIndex + "\"");
            }
            this._out.write(">");
            this._out.write("<v>" + value + "</v>");
            this._out.write("</c>");
        }

        public void createCell(int columnIndex, double value) throws IOException {
            this.createCell(columnIndex, value, -1);
        }

        public void createCell(int columnIndex, Calendar value, int styleIndex) throws IOException {
            this.createCell(columnIndex, DateUtil.getExcelDate((Calendar)value, (boolean)false), styleIndex);
        }
    }
}

