/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import org.jasig.cas.client.util.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationFilter
implements Filter {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean ignoreInitConfiguration = false;

    protected final String getPropertyFromInitParams(FilterConfig filterConfig, String propertyName, String defaultValue) {
        InitialContext context;
        String value = filterConfig.getInitParameter(propertyName);
        if (CommonUtils.isNotBlank(value)) {
            if ("renew".equals(propertyName)) {
                throw new IllegalArgumentException("Renew MUST be specified via context parameter or JNDI environment to avoid misconfiguration.");
            }
            this.logger.info("Property [{}] loaded from FilterConfig.getInitParameter with value [{}]", (Object)propertyName, (Object)value);
            return value;
        }
        String value2 = filterConfig.getServletContext().getInitParameter(propertyName);
        if (CommonUtils.isNotBlank(value2)) {
            this.logger.info("Property [{}] loaded from ServletContext.getInitParameter with value [{}]", (Object)propertyName, (Object)value2);
            return value2;
        }
        try {
            context = new InitialContext();
        }
        catch (NamingException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            return defaultValue;
        }
        String shortName = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(".") + 1);
        String value3 = this.loadFromContext(context, "java:comp/env/cas/" + shortName + "/" + propertyName);
        if (CommonUtils.isNotBlank(value3)) {
            this.logger.info("Property [{}] loaded from JNDI Filter Specific Property with value [{}]", (Object)propertyName, (Object)value3);
            return value3;
        }
        String value4 = this.loadFromContext(context, "java:comp/env/cas/" + propertyName);
        if (CommonUtils.isNotBlank(value4)) {
            this.logger.info("Property [{}] loaded from JNDI with value [{}]", (Object)propertyName, (Object)value4);
            return value4;
        }
        this.logger.info("Property [{}] not found.  Using default value [{}]", (Object)propertyName, (Object)defaultValue);
        return defaultValue;
    }

    protected final boolean parseBoolean(String value) {
        return value != null && value.equalsIgnoreCase("true");
    }

    protected final String loadFromContext(InitialContext context, String path) {
        try {
            return (String)context.lookup(path);
        }
        catch (NamingException e) {
            return null;
        }
    }

    public final void setIgnoreInitConfiguration(boolean ignoreInitConfiguration) {
        this.ignoreInitConfiguration = ignoreInitConfiguration;
    }

    protected final boolean isIgnoreInitConfiguration() {
        return this.ignoreInitConfiguration;
    }
}

