/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;
import org.restlet.util.Engine;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Form
extends Series<Parameter> {
    public Form() {
    }

    public Form(int initialCapacity) {
        super(initialCapacity);
    }

    public Form(List<Parameter> delegate) {
        super(delegate);
    }

    @Deprecated
    public Form(Logger logger, Representation representation) {
        Engine.getInstance().parse(this, representation);
    }

    @Deprecated
    public Form(Logger logger, String queryString, CharacterSet characterSet) {
        this(logger, queryString, characterSet, '&');
    }

    @Deprecated
    public Form(Logger logger, String parametersString, CharacterSet characterSet, char separator) {
        Engine.getInstance().parse(this, parametersString, characterSet, true, separator);
    }

    public Form(Representation webForm) {
        this(Logger.getLogger(Form.class.getCanonicalName()), webForm);
    }

    public Form(String queryString) {
        this(queryString, CharacterSet.UTF_8);
    }

    public Form(String parametersString, char separator) {
        this(parametersString, CharacterSet.UTF_8, separator);
    }

    public Form(String queryString, CharacterSet characterSet) {
        this(queryString, characterSet, '&');
    }

    public Form(String parametersString, CharacterSet characterSet, char separator) {
        this(Logger.getLogger(Form.class.getCanonicalName()), parametersString, characterSet, separator);
    }

    @Override
    public Parameter createEntry(String name, String value) {
        return new Parameter(name, value);
    }

    @Override
    public Series<Parameter> createSeries(List<Parameter> delegate) {
        if (delegate != null) {
            return new Form(delegate);
        }
        return new Form();
    }

    public String encode() throws IOException {
        return this.encode(CharacterSet.UTF_8);
    }

    public String encode(CharacterSet characterSet) throws IOException {
        return this.encode(characterSet, '&');
    }

    public String encode(CharacterSet characterSet, char separator) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            ((Parameter)this.get(i)).encode(sb, characterSet);
        }
        return sb.toString();
    }

    public String getMatrixString() {
        return this.getMatrixString(CharacterSet.UTF_8);
    }

    public String getMatrixString(CharacterSet characterSet) {
        try {
            return this.encode(characterSet, ';');
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String getQueryString() {
        return this.getQueryString(CharacterSet.UTF_8);
    }

    public String getQueryString(CharacterSet characterSet) {
        try {
            return this.encode(characterSet);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Representation getWebRepresentation() {
        return this.getWebRepresentation(CharacterSet.UTF_8);
    }

    public Representation getWebRepresentation(CharacterSet characterSet) {
        return new StringRepresentation(this.getQueryString(characterSet), MediaType.APPLICATION_WWW_FORM, null, characterSet);
    }
}

