/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.ui;

import com.supermap.data.EditHistory;
import com.supermap.data.Enum;
import com.supermap.data.GeoCompound;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoText;
import com.supermap.data.Geometry;
import com.supermap.data.IDisposable;
import com.supermap.data.License;
import com.supermap.data.Point2D;
import com.supermap.data.ProductType;
import com.supermap.data.Rectangle2D;
import com.supermap.data.TextPart;
import com.supermap.data.Toolkit;
import com.supermap.data.Workspace;
import com.supermap.layout.MapLayout;
import com.supermap.mapping.Map;
import com.supermap.ui.Action;
import com.supermap.ui.ActionChangedEvent;
import com.supermap.ui.ActionChangedListener;
import com.supermap.ui.ActionCursorChangingEvent;
import com.supermap.ui.ActionCursorChangingListener;
import com.supermap.ui.EditHandleEvent;
import com.supermap.ui.EditHandleMoveListener;
import com.supermap.ui.EditHandleType;
import com.supermap.ui.ElementAddedListener;
import com.supermap.ui.ElementDeletedListener;
import com.supermap.ui.ElementDeletingListener;
import com.supermap.ui.ElementEvent;
import com.supermap.ui.ElementModifiedListener;
import com.supermap.ui.ElementModifyingListener;
import com.supermap.ui.ElementSelectedEvent;
import com.supermap.ui.ElementSelectedListener;
import com.supermap.ui.ElementsAlignment;
import com.supermap.ui.InternalBufferImage;
import com.supermap.ui.InternalEditHistory;
import com.supermap.ui.InternalEnum;
import com.supermap.ui.InternalHandle;
import com.supermap.ui.InternalHandleDisposable;
import com.supermap.ui.InternalLayoutEnvironment;
import com.supermap.ui.InternalLayoutGeometry;
import com.supermap.ui.InternalLayoutMap;
import com.supermap.ui.InternalLayoutResource;
import com.supermap.ui.InternalMapLayout;
import com.supermap.ui.InternalMappingGeometry;
import com.supermap.ui.InternalMappingResource;
import com.supermap.ui.InternalToolkitLayoutUI;
import com.supermap.ui.InternalToolkitMappingUI;
import com.supermap.ui.MapLayoutControlNative;
import com.supermap.ui.MapLayoutControl_this_componentAdapter;
import com.supermap.ui.MapLayoutControl_this_keyAdapter;
import com.supermap.ui.MapLayoutControl_this_mouseAdapter;
import com.supermap.ui.MapLayoutControl_this_mouseMotionAdapter;
import com.supermap.ui.MapLayoutControl_this_mouseWheelAdapter;
import com.supermap.ui.PointInputedEvent;
import com.supermap.ui.PointInputedListener;
import com.supermap.ui.TrackMode;
import com.supermap.ui.TrackedEvent;
import com.supermap.ui.TrackedListener;
import com.supermap.ui.TrackingEvent;
import com.supermap.ui.TrackingListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.Beans;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JScrollBar;

public class MapLayoutControl
extends JComponent
implements Serializable,
IDisposable {
    private static final long serialVersionUID = 1L;
    private boolean _$26;
    private long _$25;
    private MapLayout _$24;
    private Action _$23 = Action.NULL;
    private Action _$22 = Action.NULL;
    private TrackMode _$21;
    private Map _$20;
    private BorderLayout _$19;
    private boolean _$18;
    private InternalBufferImage _$17;
    transient Vector m_actionChangedListeners;
    transient Vector m_elementSelectedListeners;
    transient Vector m_elementDeletingListeners;
    transient Vector m_elementAddedListeners;
    transient Vector m_elementModifyingListeners;
    transient Vector m_elementModifiedListeners;
    transient Vector m_pointInputedListeners;
    transient Vector m_actionCursorChangingListeners;
    transient Vector m_trackingListeners;
    transient Vector m_trackedListeners;
    transient Vector m_elementDeletedListeners;
    transient Vector m_editHandleMoveListeners;
    private License _$16;
    private GeoPoint _$15 = new GeoPoint();
    private double _$14;
    private double _$13;
    private double _$12;
    private double _$11;
    private Action _$10 = Action.NULL;
    private Action _$9 = Action.NULL;
    private JScrollBar _$8;
    private JScrollBar _$7;
    private int _$6;
    private int _$5;
    private boolean _$4 = false;
    private boolean _$3;
    private boolean _$2 = true;
    private EditHistory _$1;

    public MapLayoutControl() {
        this._$5();
        if (!Beans.isDesignTime()) {
            this.getMapLayout().setWorkspace(new Workspace());
        }
    }

    private void _$11() {
        ArrayList<ProductType> arrayList = InternalToolkitLayoutUI.managerProducts(InternalToolkitLayoutUI.getLayoutProducts());
        this._$16 = InternalToolkitLayoutUI.verifyLicense(arrayList);
    }

    private void _$10() {
        if (this._$16 != null) {
            this._$16.disconnect();
            this._$16.dispose();
            this._$16 = null;
        }
    }

    public MapLayout getMapLayout() {
        long l;
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("getMapLayout()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$24 == null && (l = MapLayoutControlNative.jni_GetMapLayout(this._$25, this.getWidth(), this.getHeight())) != 0L) {
            this._$24 = InternalMapLayout.createInstance(l, this);
        }
        return this._$24;
    }

    public Map getActiveMap() {
        long l;
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("getActiveMap()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$20 == null && this.getActiveGeoMapID() != -1 && this._$25 != 0L && this._$17 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$17)) != 0L) {
            long l2 = MapLayoutControlNative.jni_getActiveMap(this._$25, l);
            this._$20 = InternalLayoutMap.createInstance(l2);
            this._$20.setWorkspace(this.getMapLayout().getWorkspace());
        }
        return this._$20;
    }

    public int getActiveGeoMapID() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("getActiveMap()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_GetActiveGeoMapID(this._$25);
    }

    public void setActiveGeoMapID(int n) {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("setActiveGeoMapID(int geoMapID)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$17);
        if (n != -1) {
            MapLayoutControlNative.jni_SetActiveMapID(this._$25, n, l);
        } else {
            MapLayoutControlNative.jni_SetActiveMapID(this._$25, -1, l);
        }
        this.setMapAction(this.getMapAction());
    }

    public Action getLayoutAction() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("getLayoutAction()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        int n = MapLayoutControlNative.jni_GetLayoutUserAction(this._$25);
        this._$23 = (Action)InternalEnum.parseUGCValue(Action.class, (int)n);
        return this._$23;
    }

    public void setLayoutAction(Action action) {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("setLayoutAction(Action layoutAction)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (action == null) {
            String string = InternalLayoutResource.loadString("layoutAction", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        Action action2 = this.getLayoutAction();
        int n = InternalEnum.getUGCValue((Enum)action);
        this._$23 = action;
        int n2 = InternalEnum.getUGCValue((Enum)this._$21);
        MapLayoutControlNative.jni_SetLayoutAction(this._$25, n, n2);
        ActionChangedEvent actionChangedEvent = new ActionChangedEvent((Object)this, action2, this._$23);
        this.fireActionChanged(actionChangedEvent);
        this._$2();
    }

    public Action getMapAction() {
        int n;
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("getMapAction()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this.getActiveGeoMapID() != -1 && (n = MapLayoutControlNative.jni_GetMapAction(this._$25)) >= 0 && n <= Action.getEnums(Action.class).length) {
            this._$22 = (Action)InternalEnum.parseUGCValue(Action.class, (int)n);
        }
        return this._$22;
    }

    public void setMapAction(Action action) {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("setMapAction(Action action)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$22 == null) {
            String string = InternalLayoutResource.loadString("m_geoMapAction", "Global_ArgumentNull", "layout_resources");
            throw new IllegalArgumentException(string);
        }
        int n = InternalEnum.getUGCValue((Enum)action);
        if (this.getActiveGeoMapID() != -1) {
            int n2 = InternalEnum.getUGCValue((Enum)TrackMode.EDIT);
            MapLayoutControlNative.jni_SetMapAction(this._$25, n, n2);
        }
        this._$22 = action;
    }

    public TrackMode getTrackMode() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("getTrackMode()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this._$21;
    }

    public void setTrackMode(TrackMode trackMode) {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("getTrackMode()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (!InternalEnum.isDefined(TrackMode.class, (int)trackMode.value())) {
            String string = InternalLayoutResource.loadString("TrackMode value", "Global_EnumValueIsError", "layout_resources");
            throw new IllegalStateException(string);
        }
        this._$21 = trackMode;
        this.setLayoutAction(this.getLayoutAction());
    }

    public boolean isHorizontalScrollbarVisible() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("isHorizontalScrollbarVisible()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this._$8.isVisible();
    }

    public void setHorizontalScrollbarVisible(boolean bl) {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("setHorizontalScrollbarVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        this._$8.setVisible(bl);
    }

    public boolean isVerticalScrollbarVisible() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("isVerticalScrollbarVisible()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this._$7.isVisible();
    }

    public void setVerticalScrollbarVisible(boolean bl) {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("setVerticalScrollbarVisible(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        this._$7.setVisible(bl);
    }

    public boolean isGridSnapable() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("isSnapable()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_IsSnapable(this._$25);
    }

    public void setGridSnapable(boolean bl) {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("setSnapable(boolean value)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutControlNative.jni_SetSnapable(this._$25, bl);
    }

    public boolean canRedo() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("canRedo()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanRedo(this._$25);
    }

    public boolean canUndo() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("canUndo()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanUndo(this._$25);
    }

    public boolean canCut() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("canCut()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanCut(this._$25);
    }

    public boolean canCopy() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("canCopy()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanCopy(this._$25);
    }

    public boolean canDelete() {
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("canDelete()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this.canCut();
    }

    public boolean canPaste() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("canPaste()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanPaste(this._$25);
    }

    public boolean CanCombination() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("CanCombination()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanCombination(this._$25);
    }

    public boolean CanSplit() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("CanSplit()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_CanSplit(this._$25);
    }

    public boolean delete() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("delete()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Delete2(this._$25);
    }

    public boolean redo() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("redo()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Redo(this._$25);
    }

    public boolean undo() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("undo()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Undo(this._$25);
    }

    public boolean copy() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("copy()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Copy(this._$25);
    }

    public boolean cut() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("cut()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Cut(this._$25);
    }

    public boolean paste() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("paste()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Paste(this._$25);
    }

    public boolean Combination() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("Combination()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Combination(this._$25);
    }

    public boolean Split() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("Split()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_Split(this._$25);
    }

    public boolean align(ElementsAlignment elementsAlignment) {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("align(ElementsAlignment alignment)", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        int n = elementsAlignment.value();
        switch (n) {
            case 10: 
            case 11: {
                bl = true;
                break;
            }
        }
        return MapLayoutControlNative.jni_Align(this._$25, n, bl);
    }

    public boolean makeSameWidth() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("makeSameWidth()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeSameWidth(this._$25);
    }

    public boolean makeSameHeight() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("makeSameHeight()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeSameHeight(this._$25);
    }

    public boolean makeSameSize() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("makeSameSize()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeSameSize(this._$25);
    }

    public boolean makeVerticalSpacingEqual() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("makeVerticalSpacingEqual()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeVerticalSpacingEqual(this._$25);
    }

    public boolean makeHorizontalSpacingEqual() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("makeHorizontalSpacingEqual()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeHorizontalSpacingEqual(this._$25);
    }

    public boolean makeSpacingEqual() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("makeSpacingEqual()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_MakeSpacingEqual(this._$25);
    }

    public boolean bringForward() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("bringForward()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_BringForward(this._$25);
    }

    public boolean sendBackward() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("sendBackward()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_SendBackward(this._$25);
    }

    public boolean bringToFront() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("bringToFront()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_BringToFront(this._$25);
    }

    public boolean sendToBack() {
        this._$9();
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("sendToBack()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_SendToBack(this._$25);
    }

    private void _$9() {
        if (!this._$26) {
            this._$25 = MapLayoutControlNative.jni_New(this);
            this._$3();
            this._$17 = new InternalBufferImage(this.getWidth(), this.getHeight());
            this._$26 = true;
        }
    }

    public void setRefreshAtTracked(boolean bl) {
        if (this._$25 == 0L) {
            String string = InternalMappingResource.loadString((String)"setRefreshAtTracked(boolean value)", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutControlNative.jni_SetRefreshAtTracked(this._$25, bl);
    }

    public boolean refreshAtTracked() {
        if (this._$25 == 0L) {
            String string = InternalMappingResource.loadString((String)"refreshAtTracked()", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_RefreshAtTracked(this._$25);
    }

    public void setRefreshInInvalidArea(boolean bl) {
        if (this._$25 == 0L) {
            String string = InternalMappingResource.loadString((String)"setRefreshInInvalidArea(boolean value)", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        MapLayoutControlNative.jni_SetRefreshInInvalidArea(this._$25, bl);
    }

    public boolean refreshInInvalidArea() {
        if (this._$25 == 0L) {
            String string = InternalMappingResource.loadString((String)"refreshInInvalidArea()", (String)"Handle_ObjectHasBeenDisposed", (String)"ui_mapping_resources");
            throw new IllegalStateException(string);
        }
        return MapLayoutControlNative.jni_RefreshInInvalidArea(this._$25);
    }

    private Rectangle2D _$8() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$17);
        int[] nArray = new int[4];
        MapLayoutControlNative.jni_GetPreferredSize(this._$25, nArray, l);
        return new Rectangle2D((double)nArray[0], (double)nArray[3], (double)nArray[2], (double)nArray[1]);
    }

    public void setSize(int n, int n2) {
        this.resize(n, n2);
    }

    public void setSize(Dimension dimension) {
        this.resize(dimension);
    }

    public void resize(int n, int n2) {
        ComponentListener componentListener = null;
        if (this.getComponentListeners().length > 0) {
            componentListener = this.getComponentListeners()[0];
            this.removeComponentListener(componentListener);
        }
        super.resize(n, n2);
        if (componentListener != null) {
            this.addComponentListener(componentListener);
        }
        this.this_componentResized();
    }

    public void resize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public EditHistory getEditHistory() {
        if (this._$25 == 0L) {
            String string = InternalLayoutResource.loadString("paste()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (this._$1 == null) {
            long l = this._$7();
            this._$1 = InternalEditHistory.createInstance(l);
        }
        return this._$1;
    }

    protected void paintComponent(Graphics graphics) {
        this._$11();
        if (this._$25 != 0L && !Beans.isDesignTime()) {
            if (this._$18) {
                if (this._$2) {
                    this._$2 = false;
                    this.this_componentResized();
                }
                this.setCursor(Cursors.getBusy());
                this._$6();
                this._$18 = false;
                this._$2();
                this._$4 = true;
            }
            if (this._$4) {
                graphics.drawImage(this._$17.getMemoryImage(), 0, 0, null);
            }
        } else {
            graphics.drawString("MapLayoutControl", this.getWidth() / 2 - 30, this.getHeight() / 2);
        }
    }

    private long _$7() {
        long l = MapLayoutControlNative.jni_getEditorHistoryHandle(this._$25);
        return l;
    }

    static void mapLayoutControlInvalidate(MapLayoutControl mapLayoutControl) {
        mapLayoutControl._$18 = true;
        mapLayoutControl.repaint();
    }

    static void mapLayoutControlDrawPaint(MapLayoutControl mapLayoutControl) {
        mapLayoutControl.repaint();
    }

    protected static void onDraw(MapLayoutControl mapLayoutControl) {
        mapLayoutControl._$6();
    }

    private synchronized void _$6() {
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$17);
        if (l != 0L && this._$25 != 0L) {
            MapLayoutControlNative.jni_OnDraw(this._$25, l);
            this._$4();
        }
    }

    private void _$5() {
        this._$19 = new BorderLayout();
        this._$8 = new JScrollBar();
        this._$8.setOrientation(0);
        this._$8.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!MapLayoutControl.this._$3) {
                    MapLayoutControl.this._$1(adjustmentEvent.getValue() - MapLayoutControl.this._$5, 0);
                    MapLayoutControl.this._$5 = adjustmentEvent.getValue();
                }
            }
        });
        this._$7 = new JScrollBar();
        this._$7.setOrientation(1);
        this._$7.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!MapLayoutControl.this._$3) {
                    MapLayoutControl.this._$1(0, MapLayoutControl.this._$6 - adjustmentEvent.getValue());
                    MapLayoutControl.this._$6 = adjustmentEvent.getValue();
                }
            }
        });
        this.setSize(256, 256);
        this.setLayout(this._$19);
        this.setBackground(Color.white);
        this.setFocusable(true);
        this.add((Component)this._$8, "South");
        this.add((Component)this._$7, "East");
        this.addComponentListener(new MapLayoutControl_this_componentAdapter(this));
        this.addMouseListener(new MapLayoutControl_this_mouseAdapter(this));
        this.addMouseMotionListener(new MapLayoutControl_this_mouseMotionAdapter(this));
        this.addMouseWheelListener(new MapLayoutControl_this_mouseWheelAdapter(this));
        this.addKeyListener(new MapLayoutControl_this_keyAdapter(this));
        this.setFocusable(true);
        this._$21 = TrackMode.EDIT;
        this._$22 = Action.PAN2;
    }

    private void _$1(int n, int n2) {
        Point2D point2D = this.getMapLayout().getCenter();
        point2D.offset((double)n, (double)n2);
        this.getMapLayout().setCenter(point2D);
        this.getMapLayout().refresh();
    }

    private void _$4() {
        this._$3 = true;
        Rectangle2D rectangle2D = this.getMapLayout().getViewBounds();
        Rectangle2D rectangle2D2 = this.getMapLayout().getBounds();
        Rectangle2D rectangle2D3 = new Rectangle2D(rectangle2D2.getLeft() - (rectangle2D2.getRight() - rectangle2D2.getLeft()) / 2.0, rectangle2D2.getBottom() - (rectangle2D2.getTop() - rectangle2D2.getBottom()) / 2.0, rectangle2D2.getRight() + (rectangle2D2.getRight() - rectangle2D2.getLeft()) / 2.0, rectangle2D2.getTop() + (rectangle2D2.getTop() - rectangle2D2.getBottom()) / 2.0);
        if ((rectangle2D3.getLeft() > rectangle2D.getLeft() || Toolkit.isZero((double)(rectangle2D3.getLeft() - rectangle2D.getLeft()))) && (rectangle2D3.getRight() < rectangle2D.getRight() || Toolkit.isZero((double)(rectangle2D3.getRight() - rectangle2D.getRight())))) {
            this._$8.setMaximum(0);
            this._$8.setMinimum(0);
            this._$8.setValue(0);
        } else {
            if (rectangle2D.getLeft() < rectangle2D3.getLeft()) {
                rectangle2D3.setLeft(rectangle2D.getLeft());
            } else if (rectangle2D.getRight() > rectangle2D3.getRight()) {
                rectangle2D3.setRight(rectangle2D.getRight());
            }
            this._$8.setMinimum((int)(rectangle2D3.getRight() - rectangle2D3.getLeft()));
            this._$8.setMaximum((int)(2.0 * rectangle2D3.getRight() - 2.0 * rectangle2D3.getLeft()));
            this._$8.setValue((int)(rectangle2D3.getRight() - 2.0 * rectangle2D3.getLeft() + rectangle2D.getLeft()));
            this._$8.setVisibleAmount((int)rectangle2D.getWidth());
        }
        if ((rectangle2D3.getTop() < rectangle2D.getTop() || Toolkit.isZero((double)(rectangle2D3.getTop() - rectangle2D.getTop()))) && (rectangle2D3.getBottom() > rectangle2D.getBottom() || Toolkit.isZero((double)(rectangle2D3.getBottom() - rectangle2D.getBottom())))) {
            this._$7.setMaximum(0);
            this._$7.setMinimum(0);
            this._$7.setValue(0);
        } else {
            if (rectangle2D.getTop() > rectangle2D3.getTop()) {
                rectangle2D3.setTop(rectangle2D.getTop());
            } else if (rectangle2D.getBottom() < rectangle2D3.getBottom()) {
                rectangle2D3.setBottom(rectangle2D.getBottom());
            }
            this._$7.setMinimum((int)(-rectangle2D3.getTop() + 2.0 * rectangle2D3.getTop() - rectangle2D3.getBottom()));
            this._$7.setMaximum((int)(-rectangle2D3.getBottom() + 2.0 * rectangle2D3.getTop() - rectangle2D3.getBottom()));
            this._$7.setValue((int)(-rectangle2D.getTop() + 2.0 * rectangle2D3.getTop() - rectangle2D3.getBottom()));
            this._$7.getModel().setExtent((int)rectangle2D.getHeight());
        }
        this._$8.setBlockIncrement(this._$8.getMaximum() / 10 - this._$8.getMinimum() / 10);
        this._$8.setUnitIncrement(this._$8.getMaximum() / 50 - this._$8.getMinimum() / 50);
        this._$7.setBlockIncrement(this._$7.getMaximum() / 10 - this._$7.getMinimum() / 10);
        this._$7.setUnitIncrement(this._$7.getMaximum() / 50 - this._$7.getMinimum() / 50);
        this._$6 = this._$7.getValue();
        this._$5 = this._$8.getValue();
        this._$3 = false;
    }

    void mouseMoved(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
        this._$2();
    }

    int getMouseFlag(MouseEvent mouseEvent) {
        int n = 0;
        if ((mouseEvent.getModifiers() & 0x80) == 128) {
            n = 8;
        }
        if ((mouseEvent.getModifiers() & 0x40) == 64) {
            n = 4;
        }
        return n;
    }

    void mouseDragged(MouseEvent mouseEvent) {
        long l;
        int n = this.getMouseFlag(mouseEvent);
        if (this._$25 != 0L && this._$17 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$17)) != 0L) {
            this._$2();
            MapLayoutControlNative.jni_mouseMoved(this._$25, l, n, mouseEvent.getX(), mouseEvent.getY());
            this._$2();
        }
    }

    void mousePressed(MouseEvent mouseEvent) {
        long l;
        int n = this.getMouseFlag(mouseEvent);
        this.requestFocusInWindow();
        this._$10 = this.getLayoutAction();
        this._$9 = this.getMapAction();
        if (mouseEvent.getButton() == 1 && this.getLayoutAction().equals((Object)Action.CREATETEXT)) {
            long l2;
            if (this._$25 != 0L && this._$17 != null && (l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$17)) != 0L) {
                GeoText geoText = new GeoText();
                geoText.getTextStyle().setSizeFixed(false);
                geoText.getTextStyle().setFontName("");
                Point2D point2D = this.getMapLayout().pixelToLayout(mouseEvent.getPoint());
                geoText.addPart(new TextPart("", point2D));
                TrackedEvent trackedEvent = new TrackedEvent((Object)this, (Geometry)geoText, this._$14, this._$13, this._$12, this._$11);
                this.fireTracked(trackedEvent);
                if (!geoText.getText().equals("")) {
                    GeoText geoText2 = new GeoText();
                    geoText2.setTextStyle(geoText.getTextStyle());
                    geoText2.addPart(new TextPart(geoText.getText(), point2D));
                    MapLayoutControlNative.jni_AddText(this._$25, l2, InternalHandle.getHandle((com.supermap.data.InternalHandle)geoText2));
                    geoText2.dispose();
                }
            }
        } else if (this._$25 != 0L && this._$17 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$17)) != 0L) {
            if (mouseEvent.getButton() == 2) {
                if (this.getActiveGeoMapID() != -1) {
                    this.setMapAction(Action.PAN);
                } else {
                    this.setLayoutAction(Action.PAN);
                }
                MapLayoutControlNative.jni_mousePressed(this._$25, l, 1, n, mouseEvent.getX(), mouseEvent.getY());
            } else {
                MapLayoutControlNative.jni_mousePressed(this._$25, l, mouseEvent.getButton(), n, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    void mouseReleased(MouseEvent mouseEvent) {
        long l;
        int n = this.getMouseFlag(mouseEvent);
        if (this._$25 != 0L && this._$17 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$17)) != 0L) {
            if (mouseEvent.getButton() == 2) {
                this._$2();
                MapLayoutControlNative.jni_mouseReleased(this._$25, l, 1, n, mouseEvent.getX(), mouseEvent.getY());
                this._$2();
                if (this.getActiveGeoMapID() != -1) {
                    this.setMapAction(this._$9);
                } else {
                    this.setLayoutAction(this._$10);
                }
            } else if (mouseEvent.getButton() == 3 && this.getLayoutAction().equals((Object)Action.CREATE_ALONG_LINE_TEXT)) {
                long l2 = MapLayoutControlNative.jni_getTrackGeometry(this._$25);
                if (l2 != 0L) {
                    Geometry geometry = InternalMappingGeometry.createInstance2((long)l2);
                    InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, (boolean)false);
                    GeoText geoText = new GeoText();
                    geoText.getTextStyle().setSizeFixed(false);
                    geoText.getTextStyle().setFontName("");
                    Point2D point2D = this.getMapLayout().pixelToLayout(mouseEvent.getPoint());
                    geoText.addPart(new TextPart("", point2D));
                    GeoCompound geoCompound = new GeoCompound();
                    geoCompound.addPart((Geometry)geoText);
                    geoCompound.addPart(geometry);
                    geoText.dispose();
                    TrackedEvent trackedEvent = new TrackedEvent((Object)this, (Geometry)geoCompound, this._$14, this._$13, this._$12, this._$11);
                    this.fireTracked(trackedEvent);
                    if (!((GeoText)geoCompound.getPart(0)).getText().equals("")) {
                        GeoText geoText2 = new GeoText();
                        geoText2.setTextStyle(((GeoText)geoCompound.getPart(0)).getTextStyle());
                        geoText2.addPart(new TextPart(((GeoText)geoCompound.getPart(0)).getText(), point2D));
                        MapLayoutControlNative.jni_AddText(this._$25, l, InternalHandle.getHandle((com.supermap.data.InternalHandle)geoText2));
                        geoText2.dispose();
                    }
                }
            } else {
                this._$2();
                MapLayoutControlNative.jni_mouseReleased(this._$25, l, mouseEvent.getButton(), n, mouseEvent.getX(), mouseEvent.getY());
                this._$2();
            }
        }
    }

    void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        long l;
        if (this._$25 != 0L && this._$17 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$17)) != 0L) {
            this.setCursor(Cursors.getBusy());
            Point2D point2D = this.getMapLayout().pixelToLayout(mouseWheelEvent.getPoint());
            double d = 0.0;
            d = -mouseWheelEvent.getUnitsToScroll() > 0 ? 1.25 : 0.75;
            if (this.getActiveGeoMapID() != -1) {
                MapLayoutControlNative.jni_ZoomMap(this._$25, l, d);
            } else {
                this.getMapLayout().zoom(d);
                Point2D point2D2 = this.getMapLayout().pixelToLayout(mouseWheelEvent.getPoint());
                this.getMapLayout().pan(point2D2.getX() - point2D.getX(), point2D2.getY() - point2D.getY());
                this.getMapLayout().refresh();
            }
            this._$2();
        }
    }

    void keyPressed(KeyEvent keyEvent) {
        long l;
        int n = 0;
        if (keyEvent.isShiftDown()) {
            n |= 4;
        }
        if (keyEvent.isControlDown()) {
            n |= 8;
        }
        int n2 = this.getKey(keyEvent);
        boolean bl = true;
        if (this._$25 != 0L && this._$17 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$17)) != 0L) {
            this._$2();
            MapLayoutControlNative.jni_keyPressed(this._$25, l, n2, 1, n);
            this._$2();
        }
    }

    int getKey(KeyEvent keyEvent) {
        int n = 0;
        switch (keyEvent.getKeyCode()) {
            case 127: {
                n = 46;
                break;
            }
            case 27: {
                n = 27;
                break;
            }
            case 36: {
                n = 36;
                break;
            }
            case 35: {
                n = 35;
                break;
            }
            case 33: {
                n = 33;
                break;
            }
            case 34: {
                n = 34;
                break;
            }
            case 38: {
                n = 38;
                break;
            }
            case 40: {
                n = 40;
                break;
            }
            case 37: {
                n = 37;
                break;
            }
            case 39: {
                n = 39;
                break;
            }
            default: {
                n = keyEvent.getKeyCode();
            }
        }
        return n;
    }

    void this_componentResized(ComponentEvent componentEvent) {
        this.this_componentResized();
    }

    synchronized void this_componentResized() {
        long l;
        if (this._$25 != 0L && this._$17 != null && (l = InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$17)) != 0L) {
            this._$17.resize(this.getWidth(), this.getHeight());
            MapLayoutControlNative.jni_OnSize(this._$25, l);
            this._$24.setImageSize(this.getSize());
        }
    }

    private void _$3() {
        MapLayoutControlNative.jni_Reset(this._$25);
    }

    private void _$2() {
        if (this._$25 == 0L) {
            return;
        }
        Cursor cursor = this.getCursor();
        if (cursor != null) {
            Cursor cursor2 = this._$1();
            if (!cursor.equals(cursor2)) {
                ActionCursorChangingEvent actionCursorChangingEvent = new ActionCursorChangingEvent((Object)this, cursor, cursor2);
                this.fireActionCursorChanging(actionCursorChangingEvent);
            }
            try {
                this.setCursor(cursor2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Cursor _$1(int n) {
        int n2 = MapLayoutControlNative.jni_GetCursorShape(this._$25);
        Cursor cursor = null;
        switch (n2) {
            case 1: {
                cursor = Cursors.getBusy();
                break;
            }
            case 2: {
                cursor = Cursors.getArrow();
                break;
            }
            case 3: {
                cursor = Cursors.getMarginPanLeft();
                break;
            }
            case 4: {
                cursor = Cursors.getMarginPanRight();
                break;
            }
            case 5: {
                cursor = Cursors.getMarginPanTop();
                break;
            }
            case 6: {
                cursor = Cursors.getMarginPanBottom();
                break;
            }
            case 7: {
                cursor = Cursors.getMarginPanTopLeft();
                break;
            }
            case 8: {
                cursor = Cursors.getMarginPanTopRight();
                break;
            }
            case 9: {
                cursor = Cursors.getMarginPanBottomRight();
                break;
            }
            case 10: {
                cursor = Cursors.getMarginPanBottomLeft();
                break;
            }
            case 11: {
                cursor = Cursors.getZoomFree();
                break;
            }
            case 12: {
                cursor = Cursors.getZoomFree2();
                break;
            }
            case 13: {
                cursor = Cursors.getPan();
                break;
            }
            case 14: {
                cursor = Cursors.getPan2();
                break;
            }
            case 15: {
                cursor = Cursors.getZoonIn();
                break;
            }
            case 16: {
                cursor = Cursors.getZoonOut();
                break;
            }
            case 17: {
                cursor = Cursors.getSelect();
                break;
            }
            case 18: {
                cursor = Cursors.getSelect2();
                break;
            }
            case 19: {
                cursor = Cursors.getSelectRectangle();
                break;
            }
            case 20: {
                cursor = Cursors.getSelectCircle();
                break;
            }
            case 21: {
                cursor = Cursors.getSelectRegion();
                break;
            }
            case 22: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 23: {
                cursor = Cursors.getCreatePoint();
                break;
            }
            case 24: {
                cursor = Cursors.getCreateLine();
                break;
            }
            case 25: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 26: {
                cursor = Cursors.getCreateEllipseArc();
                break;
            }
            case 27: {
                cursor = Cursors.getCreateArc3P();
                break;
            }
            case 28: {
                cursor = Cursors.getCreateCurve();
                break;
            }
            case 29: {
                cursor = Cursors.getCreateRectangle();
                break;
            }
            case 30: {
                cursor = Cursors.getCreateRoundRectangle();
                break;
            }
            case 31: {
                cursor = Cursors.getCreateCircle();
                break;
            }
            case 32: {
                cursor = Cursors.getCreateCircle3P();
                break;
            }
            case 33: {
                cursor = Cursors.getCreateCircle2P();
                break;
            }
            case 34: {
                cursor = Cursors.getCreateEllipse();
                break;
            }
            case 35: {
                cursor = Cursors.getCreateObliqueEllipse();
                break;
            }
            case 36: {
                cursor = Cursors.getCreatePolygon();
                break;
            }
            case 37: {
                cursor = Cursors.getCreateText();
                break;
            }
            case 38: {
                cursor = Cursors.getCreateAlongLineText();
                break;
            }
            case 39: {
                cursor = Cursors.getCreateParallel();
                break;
            }
            case 40: {
                cursor = Cursors.getCross();
                break;
            }
            case 41: {
                cursor = Cursors.getRotation();
                break;
            }
            case 42: {
                cursor = Cursors.getBeam();
                break;
            }
            case 43: {
                cursor = Cursors.getMove();
                break;
            }
            case 44: {
                cursor = Cursors.getNorthSouth();
                break;
            }
            case 45: {
                cursor = Cursors.getWestEast();
                break;
            }
            case 46: {
                cursor = Cursors.getNorthwestSoutheast();
                break;
            }
            case 47: {
                cursor = Cursors.getNortheastSouthwest();
                break;
            }
            case 48: {
                cursor = Cursors.getSnapPoint();
                break;
            }
            case 49: {
                cursor = Cursors.getSnapVertex();
                break;
            }
            case 50: {
                cursor = Cursors.getSnapMidpoint();
                break;
            }
            case 51: {
                cursor = Cursors.getSnapLine();
                break;
            }
            case 52: {
                cursor = Cursors.getSnapVertical();
                break;
            }
            case 53: {
                cursor = Cursors.getSnapParallel();
                break;
            }
            case 54: {
                cursor = Cursors.getMoveRotationBase();
                break;
            }
            case 55: {
                cursor = Cursors.getCreatePie();
                break;
            }
            case 56: {
                cursor = Cursors.getCreateParallelogram();
            }
        }
        if (this.getLayoutAction().equals((Object)Action.CREATE_NORTHARROW)) {
            cursor = Cursors.getCreateNorthArrow();
        }
        if (this.getLayoutAction().equals((Object)Action.CREATE_MAPSCALE)) {
            cursor = Cursors.getCreateMapScale();
        }
        return cursor;
    }

    private Cursor _$1() {
        int n = MapLayoutControlNative.jni_GetCursorShape(this._$25);
        Cursor cursor = null;
        switch (n) {
            case 1: {
                cursor = Cursors.getBusy();
                break;
            }
            case 2: {
                cursor = Cursors.getArrow();
                break;
            }
            case 3: {
                cursor = Cursors.getMarginPanLeft();
                break;
            }
            case 4: {
                cursor = Cursors.getMarginPanRight();
                break;
            }
            case 5: {
                cursor = Cursors.getMarginPanTop();
                break;
            }
            case 6: {
                cursor = Cursors.getMarginPanBottom();
                break;
            }
            case 7: {
                cursor = Cursors.getMarginPanTopLeft();
                break;
            }
            case 8: {
                cursor = Cursors.getMarginPanTopRight();
                break;
            }
            case 9: {
                cursor = Cursors.getMarginPanBottomRight();
                break;
            }
            case 10: {
                cursor = Cursors.getMarginPanBottomLeft();
                break;
            }
            case 11: {
                cursor = Cursors.getZoomFree();
                break;
            }
            case 12: {
                cursor = Cursors.getZoomFree2();
                break;
            }
            case 13: {
                cursor = Cursors.getPan();
                break;
            }
            case 14: {
                cursor = Cursors.getPan2();
                break;
            }
            case 15: {
                cursor = Cursors.getZoonIn();
                break;
            }
            case 16: {
                cursor = Cursors.getZoonOut();
                break;
            }
            case 17: {
                cursor = Cursors.getSelect();
                break;
            }
            case 18: {
                cursor = Cursors.getSelect2();
                break;
            }
            case 19: {
                cursor = Cursors.getSelectRectangle();
                break;
            }
            case 20: {
                cursor = Cursors.getSelectCircle();
                break;
            }
            case 21: {
                cursor = Cursors.getSelectRegion();
                break;
            }
            case 22: {
                cursor = Cursors.getSelectLine();
                break;
            }
            case 23: {
                cursor = Cursors.getCreatePoint();
                break;
            }
            case 24: {
                cursor = Cursors.getCreateLine();
                break;
            }
            case 25: {
                cursor = Cursors.getCreatePolyline();
                break;
            }
            case 26: {
                cursor = Cursors.getCreateEllipseArc();
                break;
            }
            case 27: {
                cursor = Cursors.getCreateArc3P();
                break;
            }
            case 28: {
                cursor = Cursors.getCreateCurve();
                break;
            }
            case 29: {
                if (this.getLayoutAction().equals((Object)Action.CREATE_NORTHARROW)) {
                    cursor = Cursors.getCreateNorthArrow();
                    break;
                }
                if (this.getLayoutAction().equals((Object)Action.CREATE_MAPSCALE)) {
                    cursor = Cursors.getCreateMapScale();
                    break;
                }
                if (this.getLayoutAction().equals((Object)Action.CREATE_GEOLEGEND)) {
                    cursor = Cursors.getCreateGeoLegend();
                    break;
                }
                cursor = Cursors.getCreateRectangle();
                break;
            }
            case 30: {
                cursor = Cursors.getCreateRoundRectangle();
                break;
            }
            case 31: {
                cursor = Cursors.getCreateCircle();
                break;
            }
            case 32: {
                cursor = Cursors.getCreateCircle3P();
                break;
            }
            case 33: {
                cursor = Cursors.getCreateCircle2P();
                break;
            }
            case 34: {
                cursor = Cursors.getCreateEllipse();
                break;
            }
            case 35: {
                cursor = Cursors.getCreateObliqueEllipse();
                break;
            }
            case 36: {
                cursor = Cursors.getCreatePolygon();
                break;
            }
            case 37: {
                cursor = Cursors.getCreateText();
                break;
            }
            case 38: {
                cursor = Cursors.getCreateAlongLineText();
                break;
            }
            case 39: {
                cursor = Cursors.getCreateParallel();
                break;
            }
            case 40: {
                cursor = Cursors.getCross();
                break;
            }
            case 41: {
                cursor = Cursors.getRotation();
                break;
            }
            case 42: {
                cursor = Cursors.getBeam();
                break;
            }
            case 43: {
                cursor = Cursors.getMove();
                break;
            }
            case 44: {
                cursor = Cursors.getNorthSouth();
                break;
            }
            case 45: {
                cursor = Cursors.getWestEast();
                break;
            }
            case 46: {
                cursor = Cursors.getNorthwestSoutheast();
                break;
            }
            case 47: {
                cursor = Cursors.getNortheastSouthwest();
                break;
            }
            case 48: {
                cursor = Cursors.getSnapPoint();
                break;
            }
            case 49: {
                cursor = Cursors.getSnapVertex();
                break;
            }
            case 50: {
                cursor = Cursors.getSnapMidpoint();
                break;
            }
            case 51: {
                cursor = Cursors.getSnapLine();
                break;
            }
            case 52: {
                cursor = Cursors.getSnapVertical();
                break;
            }
            case 53: {
                cursor = Cursors.getSnapParallel();
                break;
            }
            case 54: {
                cursor = Cursors.getMoveRotationBase();
                break;
            }
            case 55: {
                cursor = Cursors.getCreatePie();
                break;
            }
            case 56: {
                cursor = Cursors.getCreateParallelogram();
            }
        }
        return cursor;
    }

    public synchronized void addLayoutActionChangedListener(ActionChangedListener actionChangedListener) {
        if (this.m_actionChangedListeners == null) {
            this.m_actionChangedListeners = new Vector();
        }
        if (!this.m_actionChangedListeners.contains(actionChangedListener)) {
            this.m_actionChangedListeners.add(actionChangedListener);
        }
    }

    public synchronized void removeLayoutActionChangedListener(ActionChangedListener actionChangedListener) {
        if (this.m_actionChangedListeners != null && this.m_actionChangedListeners.contains(actionChangedListener)) {
            this.m_actionChangedListeners.remove(actionChangedListener);
        }
    }

    protected void fireActionChanged(ActionChangedEvent actionChangedEvent) {
        if (this.m_actionChangedListeners != null) {
            Vector vector = this.m_actionChangedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ActionChangedListener)vector.elementAt(i)).actionChanged(actionChangedEvent);
            }
        }
    }

    public synchronized void addElementSelectedListener(ElementSelectedListener elementSelectedListener) {
        if (this.m_elementSelectedListeners == null) {
            this.m_elementSelectedListeners = new Vector();
        }
        if (!this.m_elementSelectedListeners.contains(elementSelectedListener)) {
            this.m_elementSelectedListeners.add(elementSelectedListener);
        }
    }

    public synchronized void removeElementSelectedListener(ElementSelectedListener elementSelectedListener) {
        if (this.m_elementSelectedListeners != null && this.m_elementSelectedListeners.contains(elementSelectedListener)) {
            this.m_elementSelectedListeners.remove(elementSelectedListener);
        }
    }

    protected void fireElementSelected(ElementSelectedEvent elementSelectedEvent) {
        if (this.m_elementSelectedListeners != null) {
            Vector vector = this.m_elementSelectedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ElementSelectedListener)vector.elementAt(i)).elementSelected(elementSelectedEvent);
            }
        }
    }

    static void elementSelectedCallBack(MapLayoutControl mapLayoutControl, int n) {
        if (mapLayoutControl != null) {
            ElementSelectedEvent elementSelectedEvent = new ElementSelectedEvent(mapLayoutControl, n);
            mapLayoutControl.fireElementSelected(elementSelectedEvent);
        }
    }

    public synchronized void addElementDeletingListener(ElementDeletingListener elementDeletingListener) {
        if (this.m_elementDeletingListeners == null) {
            this.m_elementDeletingListeners = new Vector();
        }
        if (!this.m_elementDeletingListeners.contains(elementDeletingListener)) {
            this.m_elementDeletingListeners.add(elementDeletingListener);
        }
    }

    public synchronized void removeElementDeletingListener(ElementDeletingListener elementDeletingListener) {
        if (this.m_elementDeletingListeners != null && this.m_elementDeletingListeners.contains(elementDeletingListener)) {
            this.m_elementDeletingListeners.remove(elementDeletingListener);
        }
    }

    protected void fireElementDeleting(ElementEvent elementEvent) {
        if (this.m_elementDeletingListeners != null) {
            Vector vector = this.m_elementDeletingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ElementDeletingListener)vector.elementAt(i)).elementDeleting(elementEvent);
            }
        }
    }

    static void elementDeletingCallBack(MapLayoutControl mapLayoutControl, long l, int n) {
        if (mapLayoutControl != null) {
            boolean bl = InternalToolkitLayoutUI.getHandleBooleanValue(l);
            ElementEvent elementEvent = new ElementEvent(mapLayoutControl, n, bl);
            mapLayoutControl.fireElementDeleting(elementEvent);
            InternalToolkitLayoutUI.setHandleBooleanValue(l, elementEvent.getCancel());
        }
    }

    public synchronized void addElementDeletedListener(ElementDeletedListener elementDeletedListener) {
        if (this.m_elementDeletedListeners == null) {
            this.m_elementDeletedListeners = new Vector();
        }
        if (!this.m_elementDeletedListeners.contains(elementDeletedListener)) {
            this.m_elementDeletedListeners.add(elementDeletedListener);
        }
    }

    public synchronized void removeElementDeletedListener(ElementDeletedListener elementDeletedListener) {
        if (this.m_elementDeletedListeners != null && this.m_elementDeletedListeners.contains(elementDeletedListener)) {
            this.m_elementDeletedListeners.remove(elementDeletedListener);
        }
    }

    protected void fireElementDeleted(ElementEvent elementEvent) {
        if (this.m_elementDeletedListeners != null) {
            Vector vector = this.m_elementDeletedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ElementDeletedListener)vector.elementAt(i)).elementDeleted(elementEvent);
            }
        }
    }

    static void elementDeletedCallBack(MapLayoutControl mapLayoutControl, long l, int n) {
        if (mapLayoutControl != null) {
            boolean bl = InternalToolkitLayoutUI.getHandleBooleanValue(l);
            ElementEvent elementEvent = new ElementEvent(mapLayoutControl, n, bl);
            mapLayoutControl.fireElementDeleted(elementEvent);
            InternalToolkitLayoutUI.setHandleBooleanValue(l, elementEvent.getCancel());
        }
    }

    public synchronized void addElementAddedListener(ElementAddedListener elementAddedListener) {
        if (this.m_elementAddedListeners == null) {
            this.m_elementAddedListeners = new Vector();
        }
        if (!this.m_elementAddedListeners.contains(elementAddedListener)) {
            this.m_elementAddedListeners.add(elementAddedListener);
        }
    }

    public synchronized void removeElementAddedListener(ElementAddedListener elementAddedListener) {
        if (this.m_elementAddedListeners != null && this.m_elementAddedListeners.contains(elementAddedListener)) {
            this.m_elementAddedListeners.remove(elementAddedListener);
        }
    }

    protected void fireElementAdded(ElementEvent elementEvent) {
        if (this.m_elementAddedListeners != null) {
            Vector vector = this.m_elementAddedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ElementAddedListener)vector.elementAt(i)).elementAdded(elementEvent);
            }
        }
    }

    static void elementAddedCallBack(MapLayoutControl mapLayoutControl, int n) {
        if (mapLayoutControl != null) {
            boolean bl = false;
            ElementEvent elementEvent = new ElementEvent(mapLayoutControl, n, bl);
            mapLayoutControl.fireElementAdded(elementEvent);
        }
    }

    public synchronized void addElementModifyingListener(ElementModifyingListener elementModifyingListener) {
        if (this.m_elementModifyingListeners == null) {
            this.m_elementModifyingListeners = new Vector();
        }
        if (!this.m_elementModifyingListeners.contains(elementModifyingListener)) {
            this.m_elementModifyingListeners.add(elementModifyingListener);
        }
    }

    public synchronized void removeElementModifyingListener(ElementModifyingListener elementModifyingListener) {
        if (this.m_elementModifyingListeners != null && this.m_elementModifyingListeners.contains(elementModifyingListener)) {
            this.m_elementModifyingListeners.remove(elementModifyingListener);
        }
    }

    protected void fireElementModifying(ElementEvent elementEvent) {
        if (this.m_elementModifyingListeners != null) {
            Vector vector = this.m_elementModifyingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ElementModifyingListener)vector.elementAt(i)).elementModifying(elementEvent);
            }
        }
    }

    static void elementModifyingCallBack(MapLayoutControl mapLayoutControl, long l, int n) {
        if (mapLayoutControl != null) {
            boolean bl = InternalToolkitLayoutUI.getHandleBooleanValue(l);
            ElementEvent elementEvent = new ElementEvent(mapLayoutControl, n, bl);
            mapLayoutControl.fireElementModifying(elementEvent);
            InternalToolkitLayoutUI.setHandleBooleanValue(l, elementEvent.getCancel());
        }
    }

    public synchronized void addElementModifiedListener(ElementModifiedListener elementModifiedListener) {
        if (this.m_elementModifiedListeners == null) {
            this.m_elementModifiedListeners = new Vector();
        }
        if (!this.m_elementModifiedListeners.contains(elementModifiedListener)) {
            this.m_elementModifiedListeners.add(elementModifiedListener);
        }
    }

    public synchronized void removeElementModifiedListener(ElementModifiedListener elementModifiedListener) {
        if (this.m_elementModifiedListeners != null && this.m_elementModifiedListeners.contains(elementModifiedListener)) {
            this.m_elementModifiedListeners.remove(elementModifiedListener);
        }
    }

    protected void fireElementModified(ElementEvent elementEvent) {
        if (this.m_elementModifiedListeners != null) {
            Vector vector = this.m_elementModifiedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ElementModifiedListener)vector.elementAt(i)).elementModified(elementEvent);
            }
        }
    }

    static void elementModifiedCallBack(MapLayoutControl mapLayoutControl, int n) {
        if (mapLayoutControl != null) {
            boolean bl = false;
            ElementEvent elementEvent = new ElementEvent(mapLayoutControl, n, bl);
            mapLayoutControl.fireElementModified(elementEvent);
        }
    }

    public synchronized void addPointInputedListener(PointInputedListener pointInputedListener) {
        if (this.m_pointInputedListeners == null) {
            this.m_pointInputedListeners = new Vector();
        }
        if (!this.m_pointInputedListeners.contains(pointInputedListener)) {
            this.m_pointInputedListeners.add(pointInputedListener);
        }
    }

    public synchronized void removePointInputedListener(PointInputedListener pointInputedListener) {
        if (this.m_pointInputedListeners != null && this.m_pointInputedListeners.contains(pointInputedListener)) {
            this.m_pointInputedListeners.remove(pointInputedListener);
        }
    }

    protected void firePointInputed(PointInputedEvent pointInputedEvent) {
        if (this.m_pointInputedListeners != null) {
            Vector vector = this.m_pointInputedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((PointInputedListener)vector.elementAt(i)).pointInputed(pointInputedEvent);
            }
        }
    }

    static void pointInputedCallBack(MapLayoutControl mapLayoutControl, double d, double d2, double d3) {
        if (mapLayoutControl != null) {
            PointInputedEvent pointInputedEvent = new PointInputedEvent((Object)mapLayoutControl, d, d2, d3);
            mapLayoutControl.firePointInputed(pointInputedEvent);
        }
    }

    public synchronized void addActionCursorChangingListener(ActionCursorChangingListener actionCursorChangingListener) {
        if (this.m_actionCursorChangingListeners == null) {
            this.m_actionCursorChangingListeners = new Vector();
        }
        if (!this.m_actionCursorChangingListeners.contains(actionCursorChangingListener)) {
            this.m_actionCursorChangingListeners.add(actionCursorChangingListener);
        }
    }

    public synchronized void removeActionCursorChangingListener(ActionCursorChangingListener actionCursorChangingListener) {
        if (this.m_actionCursorChangingListeners != null && this.m_actionCursorChangingListeners.contains(actionCursorChangingListener)) {
            this.m_actionCursorChangingListeners.remove(actionCursorChangingListener);
        }
    }

    protected void fireActionCursorChanging(ActionCursorChangingEvent actionCursorChangingEvent) {
        if (this.m_actionCursorChangingListeners != null) {
            Vector vector = this.m_actionCursorChangingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((ActionCursorChangingListener)vector.elementAt(i)).actionCursorChanging(actionCursorChangingEvent);
            }
        }
    }

    public synchronized void addTrackingListener(TrackingListener trackingListener) {
        if (this.m_trackingListeners == null) {
            this.m_trackingListeners = new Vector();
        }
        if (!this.m_trackingListeners.contains(trackingListener)) {
            this.m_trackingListeners.add(trackingListener);
        }
    }

    public synchronized void removeTrackingListener(TrackingListener trackingListener) {
        if (this.m_trackingListeners != null && this.m_trackingListeners.contains(trackingListener)) {
            this.m_trackingListeners.remove(trackingListener);
        }
    }

    protected void fireTracking(TrackingEvent trackingEvent) {
        double d = this._$1(trackingEvent.getX(), trackingEvent.getY());
        this._$15.setX(trackingEvent.getX());
        this._$15.setY(trackingEvent.getY());
        this._$13 = trackingEvent.getAngle();
        this._$11 = trackingEvent.getArea();
        this._$12 = trackingEvent.getCurrentAzimuth();
        this._$14 = trackingEvent.getLength();
        trackingEvent.setCurrentAzimuth(d);
        if (this.m_trackingListeners != null) {
            Vector vector = this.m_trackingListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TrackingListener)vector.elementAt(i)).tracking(trackingEvent);
            }
        }
    }

    private double _$1(double d, double d2) {
        double d3 = 0.0;
        if (this._$15.getX() == -1.7976931348623157E308 && this._$15.getY() == -1.7976931348623157E308) {
            d3 = this._$15.getY() >= d2 ? Math.asin((this._$15.getX() - d) / Math.sqrt((this._$15.getX() - d) * (this._$15.getX() - d) - (this._$15.getY() - d2) * (this._$15.getY() - d2))) / Math.PI * 180.0 - 90.0 : (this._$15.getX() > d ? 0.0 - (Math.asin((this._$15.getX() - d) / Math.sqrt((this._$15.getX() - d) * (this._$15.getX() - d) - (this._$15.getY() - d2) * (this._$15.getY() - d2))) / Math.PI * 180.0 - 90.0) + 360.0 : 270.0 - Math.asin((this._$15.getX() - d) / Math.sqrt((this._$15.getX() - d) * (this._$15.getX() - d) - (this._$15.getY() - d2) * (this._$15.getY() - d2))) / Math.PI * 180.0);
        }
        return d3;
    }

    static void trackingCallBack(MapLayoutControl mapLayoutControl, double d, double d2, double d3, double d4, double d5, double d6) {
        if (mapLayoutControl != null) {
            Geometry geometry = null;
            long l = MapLayoutControlNative.jni_getTrackingGeometry(mapLayoutControl._$25);
            if (l != 0L) {
                geometry = InternalLayoutGeometry.createInstance2(l, null);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, (boolean)false);
            }
            TrackingEvent trackingEvent = new TrackingEvent((Object)mapLayoutControl, d, d2, d3, d5, 0.0, d6, d4, geometry);
            mapLayoutControl.fireTracking(trackingEvent);
        }
    }

    public synchronized void addTrackedListener(TrackedListener trackedListener) {
        if (this.m_trackedListeners == null) {
            this.m_trackedListeners = new Vector();
        }
        if (!this.m_trackedListeners.contains(trackedListener)) {
            this.m_trackedListeners.add(trackedListener);
        }
    }

    public synchronized void removeTrackedListener(TrackedListener trackedListener) {
        if (this.m_trackedListeners != null && this.m_trackedListeners.contains(trackedListener)) {
            this.m_trackedListeners.remove(trackedListener);
        }
    }

    protected void fireTracked(TrackedEvent trackedEvent) {
        trackedEvent.setAngle(this._$13);
        trackedEvent.setArea(this._$11);
        trackedEvent.setAzimuth(this._$12);
        trackedEvent.setLength(this._$14);
        if (this.m_trackedListeners != null) {
            Vector vector = this.m_trackedListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((TrackedListener)vector.elementAt(i)).tracked(trackedEvent);
            }
        }
    }

    static void trackedCallBack(MapLayoutControl mapLayoutControl) {
        if (mapLayoutControl != null) {
            Geometry geometry = null;
            long l = MapLayoutControlNative.jni_getTrackGeometry(mapLayoutControl._$25);
            if (l != 0L) {
                geometry = InternalLayoutGeometry.createInstance2(l, null);
                InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometry, (boolean)false);
            }
            TrackedEvent trackedEvent = new TrackedEvent((Object)mapLayoutControl, geometry, 0.0, 0.0, 0.0, 0.0);
            if (!mapLayoutControl.getLayoutAction().equals((Object)Action.CREATE_ALONG_LINE_TEXT) && !mapLayoutControl.getLayoutAction().equals((Object)Action.CREATETEXT)) {
                mapLayoutControl.fireTracked(trackedEvent);
            }
        }
    }

    Geometry[] getEditGeometries() {
        long[] lArray = MapLayoutControlNative.jni_GetEditGeometries(this._$25);
        Geometry[] geometryArray = new Geometry[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            geometryArray[i] = InternalMappingGeometry.createInstance2((long)lArray[i]);
            InternalHandleDisposable.setIsDisposable((com.supermap.data.InternalHandleDisposable)geometryArray[i], (boolean)false);
        }
        return geometryArray;
    }

    public synchronized void addEditHandleMoveListener(EditHandleMoveListener editHandleMoveListener) {
        if (this.m_editHandleMoveListeners == null) {
            this.m_editHandleMoveListeners = new Vector();
        }
        if (!this.m_editHandleMoveListeners.contains(editHandleMoveListener)) {
            this.m_editHandleMoveListeners.add(editHandleMoveListener);
        }
    }

    public synchronized void removeEditHandleMoveListener(EditHandleMoveListener editHandleMoveListener) {
        if (this.m_editHandleMoveListeners != null && this.m_editHandleMoveListeners.contains(editHandleMoveListener)) {
            this.m_editHandleMoveListeners.remove(editHandleMoveListener);
        }
    }

    protected void fireEditHandleMove(EditHandleEvent editHandleEvent) {
        if (this.m_editHandleMoveListeners != null) {
            Vector vector = this.m_editHandleMoveListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((EditHandleMoveListener)vector.elementAt(i)).editHandleMove(editHandleEvent);
            }
        }
    }

    static void editHandleMoveCallBack(MapLayoutControl mapLayoutControl, int n, long l, int[] nArray, double d, double d2) {
        if (mapLayoutControl != null) {
            EditHandleType editHandleType = null;
            try {
                editHandleType = (EditHandleType)InternalEnum.parse(EditHandleType.class, (int)n);
            }
            catch (Exception exception) {
                editHandleType = null;
            }
            EditHandleEvent editHandleEvent = null;
            boolean bl = InternalToolkitMappingUI.getHandleBooleanValue((long)l);
            Geometry[] geometryArray = mapLayoutControl.getEditGeometries();
            if (nArray.length > 0 && nArray[0] != -1) {
                Geometry geometry = geometryArray[0];
                int[] nArray2 = InternalMappingGeometry.getSpatialData2((long)InternalHandle.getHandle((com.supermap.data.InternalHandle)geometry));
                int n2 = -1;
                int[] nArray3 = new int[nArray.length];
                if (nArray[0] - 10 >= 0) {
                    int n3 = 0;
                    for (int i = 0; i < nArray2.length; ++i) {
                        if (nArray[0] - 10 >= (n3 += nArray2[i])) continue;
                        n2 = i;
                        for (int j = 0; j < nArray3.length; ++j) {
                            nArray3[j] = nArray[j] - 10 - (n3 - nArray2[i]);
                        }
                        break;
                    }
                    editHandleEvent = new EditHandleEvent((Object)mapLayoutControl, d, d2, editHandleType, bl, nArray3, n2, geometryArray);
                } else {
                    editHandleEvent = new EditHandleEvent((Object)mapLayoutControl, d, d2, editHandleType, bl, new int[0], -1, geometryArray);
                }
            } else {
                editHandleEvent = new EditHandleEvent((Object)mapLayoutControl, d, d2, editHandleType, bl, new int[0], -1, geometryArray);
            }
            mapLayoutControl.fireEditHandleMove(editHandleEvent);
            InternalToolkitMappingUI.setHandleBooleanValue((long)l, (boolean)editHandleEvent.getCancel());
        }
    }

    void clearHandle() {
        if (this._$24 != null) {
            InternalMapLayout.clearHandle(this._$24);
            this._$24 = null;
        }
    }

    public void dispose() {
        this.clearHandle();
        if (this._$25 != 0L) {
            MapLayoutControlNative.jni_Delete(this._$25);
            this._$25 = 0L;
        }
        if (this._$17 != null) {
            this._$17.dispose();
        }
        this._$10();
    }

    static {
        InternalLayoutEnvironment.LoadWrapJ();
    }

    public static class Cursors {
        private static Cursor _$62 = null;
        private static Cursor _$61 = null;
        private static Cursor _$60 = null;
        private static Cursor _$59 = null;
        private static Cursor _$58 = null;
        private static Cursor _$57 = null;
        private static Cursor _$56 = null;
        private static Cursor _$55 = null;
        private static Cursor _$54 = null;
        private static Cursor _$53 = null;
        private static Cursor _$52 = null;
        private static Cursor _$51 = null;
        private static Cursor _$50 = null;
        private static Cursor _$49 = null;
        private static Cursor _$48 = null;
        private static Cursor _$47 = null;
        private static Cursor _$46 = null;
        private static Cursor _$45 = null;
        private static Cursor _$44 = null;
        private static Cursor _$43 = null;
        private static Cursor _$42 = null;
        private static Cursor _$41 = null;
        private static Cursor _$40 = null;
        private static Cursor _$39 = null;
        private static Cursor _$38 = null;
        private static Cursor _$37 = null;
        private static Cursor _$36 = null;
        private static Cursor _$35 = null;
        private static Cursor _$34 = null;
        private static Cursor _$33 = null;
        private static Cursor _$32 = null;
        private static Cursor _$31 = null;
        private static Cursor _$30 = null;
        private static Cursor _$29 = null;
        private static Cursor _$28 = null;
        private static Cursor _$27 = null;
        private static Cursor _$26 = null;
        private static Cursor _$25 = null;
        private static Cursor _$24 = null;
        private static Cursor _$23 = null;
        private static Cursor _$22 = null;
        private static Cursor _$21 = null;
        private static Cursor _$20 = null;
        private static Cursor _$19 = null;
        private static Cursor _$18 = null;
        private static Cursor _$17 = null;
        private static Cursor _$16 = null;
        private static Cursor _$15 = null;
        private static Cursor _$14 = null;
        private static Cursor _$13 = null;
        private static Cursor _$12 = null;
        private static Cursor _$11 = null;
        private static Cursor _$10 = null;
        private static Cursor _$9 = null;
        private static Cursor _$8 = null;
        private static Cursor _$7 = null;
        private static Cursor _$6 = null;
        private static Cursor _$5 = null;
        private static Cursor _$4 = null;
        private static Cursor _$3;
        private static Cursor _$2;
        private static String _$1;

        private Cursors() {
        }

        private static Cursor _$1(String string) {
            java.awt.Toolkit toolkit = java.awt.Toolkit.getDefaultToolkit();
            Cursor cursor = null;
            URL uRL = Cursors.class.getResource("/com/supermap/ui/MapControl.class");
            String string2 = uRL.getFile();
            int n = string2.indexOf("com/supermap/ui/MapControl.class");
            string2 = string2.substring(0, n);
            Image image = null;
            String string3 = string2 + "Mapping/Resources/" + string;
            File file = new File(string3);
            if (file.exists()) {
                image = toolkit.createImage(string3);
            } else {
                uRL = Cursors.class.getResource("/com/supermap/ui/image/mappingImage/" + string);
                if (uRL != null) {
                    image = toolkit.createImage(uRL);
                }
            }
            if (image != null) {
                cursor = toolkit.createCustomCursor(image, new Point(1, 1), "");
            }
            return cursor;
        }

        private static Cursor _$1(String string, int n, int n2) {
            java.awt.Toolkit toolkit = java.awt.Toolkit.getDefaultToolkit();
            Cursor cursor = null;
            URL uRL = Cursors.class.getResource("/com/supermap/ui/MapControl.class");
            String string2 = uRL.getFile();
            int n3 = string2.indexOf("com/supermap/ui/MapControl.class");
            string2 = string2.substring(0, n3);
            Image image = null;
            String string3 = string2 + "Mapping/Resources/" + string;
            File file = new File(string3);
            if (file.exists()) {
                image = toolkit.createImage(string3);
            } else {
                uRL = Cursors.class.getResource("/com/supermap/ui/image/mappingImage/" + string);
                if (uRL != null) {
                    image = toolkit.createImage(uRL);
                }
            }
            if (image != null) {
                cursor = toolkit.createCustomCursor(image, new Point(n, n2), "");
            }
            return cursor;
        }

        public static Cursor getBusy() {
            if (_$62 == null) {
                _$62 = Cursors._$1(_$1 + "busy.gif");
            }
            return _$62;
        }

        public static void setBusy(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$62 = cursor;
        }

        public static Cursor getArrow() {
            if (_$61 == null) {
                _$61 = Cursors._$1(_$1 + "null.gif");
            }
            return _$61;
        }

        public static void setArrow(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$61 = cursor;
        }

        public static Cursor getMarginPanLeft() {
            if (_$60 == null) {
                _$60 = Cursors._$1(_$1 + "marginPanLeft.gif", 0, 15);
            }
            return _$60;
        }

        public static void setMarginPanLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$60 = cursor;
        }

        public static Cursor getMarginPanRight() {
            if (_$59 == null) {
                _$59 = Cursors._$1(_$1 + "marginPanRight.gif", 30, 10);
            }
            return _$59;
        }

        public static void setMarginPanRight(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$59 = cursor;
        }

        public static Cursor getMarginPanTop() {
            if (_$58 == null) {
                _$58 = Cursors._$1(_$1 + "marginPanTop.gif", 10, 0);
            }
            return _$58;
        }

        public static void setMarginPanTop(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$58 = cursor;
        }

        public static Cursor getMarginPanBottom() {
            if (_$57 == null) {
                _$57 = Cursors._$1(_$1 + "marginPanBottom.gif", 10, 30);
            }
            return _$57;
        }

        public static void setMarginPanBottom(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$57 = cursor;
        }

        public static Cursor getMarginPanTopLeft() {
            if (_$56 == null) {
                _$56 = Cursors._$1(_$1 + "marginPanBottomLeft.gif");
            }
            return _$56;
        }

        public static void setMarginPanTopLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$56 = cursor;
        }

        public static Cursor getMarginPanTopRight() {
            if (_$55 == null) {
                _$55 = Cursors._$1(_$1 + "marginPanTopRight.gif", 30, 0);
            }
            return _$55;
        }

        public static void setMarginPanTopRight(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$55 = cursor;
        }

        public static Cursor getMarginPanBottomRight() {
            if (_$54 == null) {
                _$54 = Cursors._$1(_$1 + "marginPanBottomRight.gif", 30, 30);
            }
            return _$54;
        }

        public static void setMarginPanBottomRight(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$54 = cursor;
        }

        public static Cursor getMarginPanBottomLeft() {
            if (_$53 == null) {
                _$53 = Cursors._$1(_$1 + "marginPanBottomLeft.gif", 0, 30);
            }
            return _$53;
        }

        public static void setMarginPanBottomLeft(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$53 = cursor;
        }

        public static Cursor getZoomFree() {
            if (_$52 == null) {
                _$52 = Cursors._$1(_$1 + "zoomfree.gif");
            }
            return _$52;
        }

        public static void setZoomFree(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$52 = cursor;
        }

        public static Cursor getZoomFree2() {
            if (_$50 == null) {
                _$50 = Cursors._$1(_$1 + "zoomfree.gif");
            }
            return _$50;
        }

        public static void setZoomFree2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$50 = cursor;
        }

        public static Cursor getPan() {
            if (_$48 == null) {
                _$48 = Cursors._$1(_$1 + "pan.gif");
            }
            return _$48;
        }

        public static void setPan(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$48 = cursor;
        }

        public static Cursor getPan2() {
            if (_$51 == null) {
                _$51 = Cursors._$1(_$1 + "pan.gif");
            }
            return _$51;
        }

        public static void setPan2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$51 = cursor;
        }

        public static Cursor getZoonIn() {
            if (_$46 == null) {
                _$46 = Cursors._$1(_$1 + "zoomin.gif");
            }
            return _$46;
        }

        public static void setZoonIn(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$46 = cursor;
        }

        public static Cursor getZoonOut() {
            if (_$47 == null) {
                _$47 = Cursors._$1(_$1 + "zoomout.gif");
            }
            return _$47;
        }

        public static void setZoonOut(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$47 = cursor;
        }

        public static Cursor getSelect() {
            if (_$49 == null) {
                _$49 = Cursors._$1(_$1 + "select.gif", 4, 5);
            }
            return _$49;
        }

        public static void setSelect(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$49 = cursor;
        }

        public static Cursor getSelect2() {
            if (_$44 == null) {
                _$44 = Cursors._$1(_$1 + "select.gif", 4, 5);
            }
            return _$44;
        }

        public static void setSelect2(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$44 = cursor;
        }

        public static Cursor getSelectCircle() {
            if (_$41 == null) {
                _$41 = Cursors._$1(_$1 + "selectCircle.gif", 0, 0);
            }
            return _$41;
        }

        public static void setSelectCircle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$41 = cursor;
        }

        public static Cursor getSelectRegion() {
            if (_$45 == null) {
                _$45 = Cursors._$1(_$1 + "selectregion.gif", 0, 0);
            }
            return _$45;
        }

        public static void setSelectRegion(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$45 = cursor;
        }

        public static Cursor getCreatePoint() {
            if (_$42 == null) {
                _$42 = Cursors._$1(_$1 + "createPoint.gif");
            }
            return _$42;
        }

        public static void setCreatePoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$42 = cursor;
        }

        public static Cursor getCreateLine() {
            if (_$43 == null) {
                _$43 = Cursors._$1(_$1 + "createline.gif");
            }
            return _$43;
        }

        public static void setCreateLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$43 = cursor;
        }

        public static Cursor getCreatePolyline() {
            if (_$39 == null) {
                _$39 = Cursors._$1(_$1 + "createPolyLine.gif");
            }
            return _$39;
        }

        public static void setCreatePolyline(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$39 = cursor;
        }

        public static Cursor getCreateEllipseArc() {
            if (_$25 == null) {
                _$25 = Cursors._$1(_$1 + "createEllipseArc.gif");
            }
            return _$25;
        }

        public static void setCreateEllipseArc(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$25 = cursor;
        }

        public static Cursor getCreateArc3P() {
            if (_$24 == null) {
                _$24 = Cursors._$1(_$1 + "createArc3p.gif");
            }
            return _$24;
        }

        public static void setCreateArc3P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$24 = cursor;
        }

        public static Cursor getCreateCurve() {
            if (_$23 == null) {
                _$23 = Cursors._$1(_$1 + "createCurve.gif");
            }
            return _$23;
        }

        public static void setCreateCurve(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$23 = cursor;
        }

        public static Cursor getCreateRectangle() {
            if (_$22 == null) {
                _$22 = Cursors._$1(_$1 + "createRectangle.gif");
            }
            return _$22;
        }

        public static void setCreateRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$22 = cursor;
        }

        public static Cursor getCreateRoundRectangle() {
            if (_$29 == null) {
                _$29 = Cursors._$1(_$1 + "createRoundRectangle.gif");
            }
            return _$29;
        }

        public static void setCreateRoundRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$29 = cursor;
        }

        public static Cursor getCreateCircle() {
            if (_$38 == null) {
                _$38 = Cursors._$1(_$1 + "createCircle.gif");
            }
            return _$38;
        }

        public static void setCreateCircle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$38 = cursor;
        }

        public static Cursor getCreateCircle2P() {
            if (_$28 == null) {
                _$28 = Cursors._$1(_$1 + "createCircle2p.gif");
            }
            return _$28;
        }

        public static void setCreateCircle2P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$28 = cursor;
        }

        public static Cursor getCreateCircle3P() {
            if (_$27 == null) {
                _$27 = Cursors._$1(_$1 + "createCircle3p.gif");
            }
            return _$27;
        }

        public static void setCreateCircle3P(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$27 = cursor;
        }

        public static Cursor getCreateEllipse() {
            if (_$26 == null) {
                _$26 = Cursors._$1(_$1 + "createEllipse.gif");
            }
            return _$26;
        }

        public static void setCreateEllipse(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$26 = cursor;
        }

        public static Cursor getCreateObliqueEllipse() {
            if (_$11 == null) {
                _$11 = Cursors._$1(_$1 + "createObliqueEllipse.gif");
            }
            return _$11;
        }

        public static void setCreateObliqueEllipse(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$11 = cursor;
        }

        public static Cursor getCreatePolygon() {
            if (_$37 == null) {
                _$37 = Cursors._$1(_$1 + "createPolygon.gif");
            }
            return _$37;
        }

        public static void setCreatePolygon(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$37 = cursor;
        }

        public static Cursor getCreateText() {
            if (_$36 == null) {
                _$36 = Cursors._$1(_$1 + "createText.gif");
            }
            return _$36;
        }

        public static void setCreateText(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$36 = cursor;
        }

        public static Cursor getCreateAlongLineText() {
            if (_$35 == null) {
                _$35 = Cursors._$1(_$1 + "createAlongLineText.gif");
            }
            return _$35;
        }

        public static void setCreateAlongLineText(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$35 = cursor;
        }

        public static Cursor getCreateParallel() {
            if (_$34 == null) {
                _$34 = Cursors._$1(_$1 + "createparallel.gif");
            }
            return _$34;
        }

        public static void setCreateParallel(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$34 = cursor;
        }

        public static Cursor getCreatePie() {
            if (_$33 == null) {
                _$33 = Cursors._$1(_$1 + "createPie.gif");
            }
            return _$33;
        }

        public static void setCreatePie(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$33 = cursor;
        }

        public static Cursor getCreateParallelogram() {
            if (_$32 == null) {
                _$32 = Cursors._$1(_$1 + "createParallelogram.gif");
            }
            return _$32;
        }

        public static void setCreateParallelogram(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$32 = cursor;
        }

        public static Cursor getCross() {
            if (_$31 == null) {
                _$31 = Cursors._$1(_$1 + "cross.gif");
            }
            return _$31;
        }

        public static void setCross(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$31 = cursor;
        }

        public static Cursor getRotation() {
            if (_$30 == null) {
                _$30 = Cursors._$1(_$1 + "rotation.gif");
            }
            return _$30;
        }

        public static void setRotation(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$30 = cursor;
        }

        public static Cursor getBeam() {
            if (_$21 == null) {
                _$21 = Cursors._$1(_$1 + "beam.gif");
            }
            return _$21;
        }

        public static void setBeam(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$21 = cursor;
        }

        public static Cursor getMove() {
            if (_$20 == null) {
                _$20 = Cursors._$1(_$1 + "move.gif", 0, 0);
            }
            return _$20;
        }

        public static void setMove(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$20 = cursor;
        }

        public static Cursor getNorthSouth() {
            if (_$19 == null) {
                _$19 = Cursors._$1(_$1 + "northSouth.gif");
            }
            return _$19;
        }

        public static void setNorthSouth(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$19 = cursor;
        }

        public static Cursor getSelectLine() {
            if (_$40 == null) {
                _$40 = Cursors._$1(_$1 + "selectLine.gif", 0, 0);
            }
            return _$40;
        }

        public void setSelectLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$40 = cursor;
        }

        public static Cursor getWestEast() {
            if (_$18 == null) {
                _$18 = Cursors._$1(_$1 + "weateast.gif");
            }
            return _$18;
        }

        public static void setWestEast(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$18 = cursor;
        }

        public static Cursor getNortheastSouthwest() {
            if (_$17 == null) {
                _$17 = Cursors._$1(_$1 + "northeastSouthwest.gif");
            }
            return _$17;
        }

        public static void setNortheastSouthwest(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$17 = cursor;
        }

        public static Cursor getNorthwestSoutheast() {
            if (_$16 == null) {
                _$16 = Cursors._$1(_$1 + "northwestSoutheast.gif");
            }
            return _$16;
        }

        public static void setNorthwestSoutheast(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$16 = cursor;
        }

        public static Cursor getSnapPoint() {
            if (_$15 == null) {
                _$15 = Cursors._$1(_$1 + "snapPoint.gif");
            }
            return _$15;
        }

        public static void setSnapPoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$15 = cursor;
        }

        public static Cursor getSnapVertex() {
            if (_$14 == null) {
                _$14 = Cursors._$1(_$1 + "snapVertex.gif");
            }
            return _$14;
        }

        public static void setSnapVertex(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$14 = cursor;
        }

        public static Cursor getSnapMidpoint() {
            if (_$13 == null) {
                _$13 = Cursors._$1(_$1 + "snapMidpoint.gif");
            }
            return _$13;
        }

        public static void setSnapMidpoint(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$13 = cursor;
        }

        public static Cursor getSnapLine() {
            if (_$12 == null) {
                _$12 = Cursors._$1(_$1 + "snapLine.gif");
            }
            return _$12;
        }

        public static void setSnapLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$12 = cursor;
        }

        public static Cursor getSnapVertical() {
            if (_$10 == null) {
                _$10 = Cursors._$1(_$1 + "snapVertical.gif");
            }
            return _$10;
        }

        public static void setSnapVertical(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$10 = cursor;
        }

        public static Cursor getSnapParallel() {
            if (_$9 == null) {
                _$9 = Cursors._$1(_$1 + "snapParallel.gif");
            }
            return _$9;
        }

        public static void setSnapParallel(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$9 = cursor;
        }

        public static Cursor getMoveRotationBase() {
            if (_$8 == null) {
                _$8 = Cursors._$1(_$1 + "moveRotationBase.gif");
            }
            return _$8;
        }

        public static void setMoveRotationBase(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$8 = cursor;
        }

        public static Cursor getSelectRectangle() {
            if (_$7 == null) {
                _$7 = Cursors._$1(_$1 + "selectRect.gif", 0, 0);
            }
            return _$7;
        }

        public static void setSelectRectangle(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$7 = cursor;
        }

        public static Cursor getCreateNorthArrow() {
            if (_$6 == null) {
                _$6 = Cursors._$1(_$1 + "createNorthArrow.gif");
            }
            return _$6;
        }

        public static void setCreateNorthArrow(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$6 = cursor;
        }

        public static Cursor getCreateMapScale() {
            if (_$5 == null) {
                _$5 = Cursors._$1(_$1 + "createMapScale.gif");
            }
            return _$5;
        }

        public static void setCreateMapScale(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$5 = cursor;
        }

        public static Cursor getCreateGeoLegend() {
            if (_$4 == null) {
                _$4 = Cursors._$1(_$1 + "createRectangle.gif");
            }
            return _$4;
        }

        public void setCreateGeoLegend(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$4 = cursor;
        }

        public static Cursor getSelectVerticalRulerLine() {
            if (_$2 == null) {
                _$2 = Cursors._$1(_$1 + "selectverticalrulerline.gif");
            }
            return _$2;
        }

        public void setSelectVerticalRulerLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$2 = cursor;
        }

        public static Cursor getSelectHorizontalRulerLine() {
            if (_$3 == null) {
                _$3 = Cursors._$1(_$1 + "selecthorizontalrulerline.gif");
            }
            return _$3;
        }

        public void setSelectHorizontalRulerLine(Cursor cursor) {
            if (cursor == null) {
                String string = InternalLayoutResource.loadString("cursor", "Global_ArgumentNull", "layout_resources");
                throw new IllegalArgumentException(string);
            }
            _$3 = cursor;
        }

        static {
            _$1 = "";
        }
    }
}

