/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.layout;

import com.supermap.layout.InternalEnum;
import com.supermap.layout.InternalHandle;
import com.supermap.layout.InternalResource;
import com.supermap.layout.MapLayout;
import com.supermap.layout.MapLayoutNative;
import com.supermap.layout.PaperMargin;
import com.supermap.layout.PaperOrientation;
import com.supermap.layout.PaperSize;
import com.supermap.layout.PrinterNative;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.PrinterName;

public class Printer
extends InternalHandle {
    private MapLayout _$5;
    private String _$4;
    private double _$3;
    private double _$2;
    private boolean _$1;

    Printer(MapLayout mapLayout) {
        long l = PrinterNative.jni_New();
        this.setHandle(l);
        this._$5 = mapLayout;
        String string = mapLayout.getName();
        if (string != null && string.length() != 0) {
            this.setPrintFileName(string);
        } else {
            this.setPrintFileName("UnTitled");
        }
        this.setPrinterName("UnTitled");
        this.setMargin(new PaperMargin(200, 200, 200, 200));
        this.setFromPage(0);
        this.setToPage(0);
        this.setOrientation(this._$5.getPaper().getOrientation());
        this._$1();
    }

    public PaperMargin getMargin() {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("getMargin()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[4];
        PrinterNative.jni_GetMargin(this.getHandle(), nArray);
        return new PaperMargin(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public void setMargin(PaperMargin paperMargin) {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("setMargin(PaperMargin paperMargin)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        PrinterNative.jni_SetMargin(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5), paperMargin.getLeft(), paperMargin.getRight(), paperMargin.getTop(), paperMargin.getBottom());
    }

    public PaperOrientation getOrientation() {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("getOrientation()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = PrinterNative.jni_GetOrientation(this.getHandle());
        return bl ? PaperOrientation.PORTRAIT : PaperOrientation.LANDSCAPE;
    }

    public void setOrientation(PaperOrientation paperOrientation) {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("setOrientation(PaperOrientation paperOrientation)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (paperOrientation == null) {
            String string = InternalResource.loadString("paperOrientation", "Global_ArgumentNull", "layout_resources");
            throw new NullPointerException(string);
        }
        int n = paperOrientation.value();
        PrinterNative.jni_SetOrientation(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5), n);
    }

    public PaperSize getPaperSize() {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("getSize()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        int n = PrinterNative.jni_GetSize(this.getHandle());
        return (PaperSize)InternalEnum.parseUGCValue(PaperSize.class, n);
    }

    public void setPaperSize(PaperSize paperSize) {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("setSize(PaperSize size)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (paperSize == null) {
            String string = InternalResource.loadString("size", "Global_ArgumentNull", "layout_resources");
            throw new NullPointerException(string);
        }
        PrinterNative.jni_SetSize(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5), paperSize.value());
        this._$1();
    }

    public int getCopies() {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("getCopies()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return PrinterNative.jni_GetCopies(this.getHandle());
    }

    public void setCopies(int n) {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("setCopies(int value)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("value", "Printer_CopiesShouldBeMoreThanZero", "layout_resources");
            throw new IllegalStateException(string);
        }
        PrinterNative.jni_SetCopies(this.getHandle(), n);
    }

    public boolean isVectorPrint() {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("isVectorPrint()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return PrinterNative.jni_IsVectorPrint(this.getHandle());
    }

    public void setVectorPrint(boolean bl) {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("setVectorPrint(boolean value)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        PrinterNative.jni_SetVectorPrint(this.getHandle(), bl);
    }

    public int getLogicDPI() {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("getLogicDPI()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return PrinterNative.jni_GetLogicDPI(this.getHandle());
    }

    public void setLogicDPI(int n) {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("setLogicDPI(int value)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("value", "Printer_LogicDPIShouldBeMoreThanZero", "layout_resources");
            throw new IllegalStateException(string);
        }
        PrinterNative.jni_SetLogicDPI(this.getHandle(), n);
    }

    public int getFromPage() {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("getFromPage()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return PrinterNative.jni_GetFromPage(this.getHandle());
    }

    public void setFromPage(int n) {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("setFromPage(int value)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("setFromPage(int value)", "Printer_FromPageShouldNotBeLessThanZero", "layout_resources");
            throw new IllegalStateException(string);
        }
        PrinterNative.jni_SetFromPage(this.getHandle(), n);
    }

    public int getToPage() {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("getToPage()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return PrinterNative.jni_GetToPage(this.getHandle());
    }

    public void setToPage(int n) {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("setToPage(int value)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0) {
            String string = InternalResource.loadString("setToPage(int value)", "Printer_ToPageShouldNotBeLessThanZero", "layout_resources");
            throw new IllegalStateException(string);
        }
        PrinterNative.jni_SetToPage(this.getHandle(), n);
    }

    public int getDeviceDPI() {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("getDeviceDPI()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return PrinterNative.jni_GetDeviceDPI(this.getHandle());
    }

    public void setDeviceDPI(int n) {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("setDeviceDPI(int value)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (n <= 0) {
            String string = InternalResource.loadString("setDeviceDPI(int value)", "Printer_DeviceDPIShouldBeMoreThanZero", "layout_resources");
            throw new IllegalStateException(string);
        }
        PrinterNative.jni_SetDeviceDPI(this.getHandle(), n);
    }

    public String getPrinterName() {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("getPrinterName()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this._$4;
    }

    public void setPrinterName(String string) {
        this._$4 = string;
    }

    public String getPrintFileName() {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string = InternalResource.loadString("getPrintFileName()", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return PrinterNative.jni_GetPrintFileName(this.getHandle());
    }

    public void setPrintFileName(String string) {
        if (this._$5 == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
            String string2 = InternalResource.loadString("setPrintFileName(String value)", "Global_OwnerHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = InternalResource.loadString("value", "Global_StringIsNullOrEmpty", "layout_resources");
            throw new IllegalArgumentException(string3);
        }
        PrinterNative.jni_SetPrintFileName(this.getHandle(), string);
    }

    public boolean isValidPrinter() {
        return this._$1(this.getPrinterName());
    }

    public void print() {
        if (this._$5 != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
                String string = InternalResource.loadString("printLayout(boolean isPrintDialogShown)", "Global_OwnerHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = this._$1(this.getPrinterName());
            if (!bl) {
                String string = InternalResource.loadString("print()", "Printer_NotFindThePrinterByName", "layout_resources");
                throw new IllegalStateException(string);
            }
            boolean bl2 = true;
            bl2 = !this.getOrientation().equals((Object)PaperOrientation.LANDSCAPE);
            if (this.getPrintFileName().equals("")) {
                this.setPrintFileName("UnTitled");
            }
            this._$1();
            MapLayoutNative.jni_OnPrint(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5), this.getMargin().getLeft(), this.getMargin().getTop(), this.getMargin().getRight(), this.getMargin().getBottom(), this.getPaperSize().value(), bl2, this.getCopies(), this.getFromPage(), this.getToPage(), this.isVectorPrint(), this.getDeviceDPI(), this.getLogicDPI(), this.getPrinterName(), this.getPrintFileName(), this._$3, this._$2, this._$1, false);
        }
    }

    public void printWithDialog() {
        if (this._$5 != null) {
            if (InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5) == 0L) {
                String string = InternalResource.loadString("printLayout(boolean isPrintDialogShown)", "Global_OwnerHasBeenDisposed", "layout_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = this._$1(this.getPrinterName());
            if (!bl) {
                String string = InternalResource.loadString("print()", "Printer_NotFindThePrinterByName", "layout_resources");
                throw new IllegalStateException(string);
            }
            boolean bl2 = true;
            bl2 = !this.getOrientation().equals((Object)PaperOrientation.LANDSCAPE);
            if (this.getPrintFileName().equals("")) {
                this.setPrintFileName("UnTitled");
            }
            this._$1();
            MapLayoutNative.jni_OnPrint(InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5), this.getMargin().getLeft(), this.getMargin().getTop(), this.getMargin().getRight(), this.getMargin().getBottom(), this.getPaperSize().value(), bl2, this.getCopies(), this.getFromPage(), this.getToPage(), this.isVectorPrint(), this.getDeviceDPI(), this.getLogicDPI(), this.getPrinterName(), this.getPrintFileName(), this._$3, this._$2, this._$1, true);
        }
    }

    public double getPaperWidth() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPaperWidth()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double d = this._$3;
        if (!PrinterNative.jni_GetOrientation(this.getHandle())) {
            d = this._$2;
        }
        return d;
    }

    public void setPaperWidth(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPaperWidth()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (!this.getPaperSize().equals((Object)PaperSize.USERDEFINED)) {
            String string = InternalResource.loadString("setPaperHeight(double value)", "Handle_UndisposableObject", "layout_resources");
            throw new UnsupportedOperationException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("setPaperWidth(double value)", "Printer_PaperWidthShouldBeMoreThanZero", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (PrinterNative.jni_GetOrientation(this.getHandle())) {
            this._$3 = d;
        } else {
            this._$2 = d;
        }
        this._$1();
    }

    public double getPaperHeight() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPaperHeight()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double d = this._$2;
        if (!PrinterNative.jni_GetOrientation(this.getHandle())) {
            d = this._$3;
        }
        return d;
    }

    public void setPaperHeight(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPaperHeight()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (!this.getPaperSize().equals((Object)PaperSize.USERDEFINED)) {
            String string = InternalResource.loadString("setPaperHeight(double value)", "Handle_UndisposableObject", "layout_resources");
            throw new UnsupportedOperationException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("setPaperHeight(double value)", "Printer_PaperHeightShouldBeMoreThanZero", "layout_resources");
            throw new IllegalStateException(string);
        }
        if (PrinterNative.jni_GetOrientation(this.getHandle())) {
            this._$2 = d;
        } else {
            this._$3 = d;
        }
        this._$1();
    }

    protected void internalDispose() {
        if (this.getHandle() != 0L) {
            PrinterNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    protected boolean isOldVersionPrinter() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isOldVersionPrinter()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        return this._$1;
    }

    protected void setOldVersionPrinter(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setOldVersionPrinter()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        this._$1 = bl;
    }

    private boolean _$1(String string) {
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, hashPrintRequestAttributeSet);
        boolean bl = false;
        for (int i = 0; i < printServiceArray.length; ++i) {
            PrinterName printerName = (PrinterName)printServiceArray[i].getAttributes().get(PrinterName.class);
            if (!printerName.getValue().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void _$1() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setPaperSizeToUGC()", "Handle_ObjectHasBeenDisposed", "layout_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        PrinterNative.jni_SetPaperSizeToUGC(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)this._$5), this._$3, this._$2, dArray);
        this._$3 = dArray[0];
        this._$2 = dArray[1];
    }
}

