/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.path;

import java.util.HashMap;
import java.util.Map;
import org.springframework.web.servlet.view.path.CommonsBeanUtilsPath;
import org.springframework.web.servlet.view.path.CommonsBeanUtilsPathElement;

public class CommonsBeanUtilslPathTracker {
    private int pointer;
    private int capacity;
    private CommonsBeanUtilsPathElement[] pathStack;
    private Map[] indexMapStack;
    private CommonsBeanUtilsPath currentPath;

    public CommonsBeanUtilslPathTracker() {
        this(16);
    }

    public CommonsBeanUtilslPathTracker(int initialCapacity) {
        this.capacity = Math.max(1, initialCapacity);
        this.pathStack = new CommonsBeanUtilsPathElement[this.capacity];
        this.indexMapStack = new Map[this.capacity];
    }

    public void pushElement(String name, CommonsBeanUtilsPathElement element) {
        Integer index;
        if (this.pointer + 1 >= this.capacity) {
            this.resizeStacks(this.capacity * 2);
        }
        this.pathStack[this.pointer] = element;
        HashMap indexMap = this.indexMapStack[this.pointer];
        if (indexMap == null) {
            this.indexMapStack[this.pointer] = indexMap = new HashMap();
        }
        if ((index = (Integer)this.indexMapStack[this.pointer].get(this.pathStack[this.pointer].getName())) == null) {
            this.indexMapStack[this.pointer].put(this.pathStack[this.pointer].getName(), new Integer(0));
        } else {
            this.indexMapStack[this.pointer].put(this.pathStack[this.pointer].getName(), index + 1);
        }
        if (this.pointer > 1 && CommonsBeanUtilsPathElement.Typ.SIMPEL.equals((Object)this.pathStack[this.pointer].getTyp()) && CommonsBeanUtilsPathElement.Typ.ARRAY.equals((Object)this.pathStack[this.pointer - 1].getTyp())) {
            index = (Integer)this.indexMapStack[this.pointer - 1].get(this.pathStack[this.pointer - 1].getName());
            this.indexMapStack[this.pointer - 1].put(this.pathStack[this.pointer - 1].getName(), index + 1);
        }
        ++this.pointer;
        this.currentPath = null;
    }

    public void popElement() {
        this.indexMapStack[this.pointer] = null;
        this.currentPath = null;
        --this.pointer;
    }

    private void resizeStacks(int newCapacity) {
        CommonsBeanUtilsPathElement[] newPathStack = new CommonsBeanUtilsPathElement[newCapacity];
        Map[] newIndexMapStack = new Map[newCapacity];
        int min = Math.min(this.capacity, newCapacity);
        System.arraycopy(this.pathStack, 0, newPathStack, 0, min);
        System.arraycopy(this.indexMapStack, 0, newIndexMapStack, 0, min);
        this.pathStack = newPathStack;
        this.indexMapStack = newIndexMapStack;
        this.capacity = newCapacity;
    }

    public CommonsBeanUtilsPath getPath() {
        if (this.currentPath == null) {
            CommonsBeanUtilsPathElement[] chunks = new CommonsBeanUtilsPathElement[this.pointer + 1];
            for (int i = 0; i < this.pointer; ++i) {
                Integer integer = (Integer)this.indexMapStack[i].get(this.pathStack[i].getName());
                this.pathStack[i].setIndex(integer);
                chunks[i] = this.pathStack[i];
            }
            this.currentPath = new CommonsBeanUtilsPath(chunks, 0);
        }
        return this.currentPath;
    }

    protected int getCapacity() {
        return this.capacity;
    }

    protected CommonsBeanUtilsPathElement[] getPathStack() {
        return this.pathStack;
    }

    protected Map[] getIndexMapStack() {
        return this.indexMapStack;
    }

    public int getPointer() {
        return this.pointer;
    }
}

