/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace.spatialanalyst;

import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.License;
import com.supermap.data.ProductType;
import com.supermap.data.ResampleInformation;
import com.supermap.data.ResampleType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.realspace.spatialanalyst.DissolveParameter3D;
import com.supermap.realspace.spatialanalyst.Generalization3DNative;
import com.supermap.realspace.spatialanalyst.InternalDatasetVector;
import com.supermap.realspace.spatialanalyst.InternalDatasets;
import com.supermap.realspace.spatialanalyst.InternalHandle;
import com.supermap.realspace.spatialanalyst.InternalResource;
import com.supermap.realspace.spatialanalyst.InternalToolkitSpatialAnalyst3D;
import java.util.ArrayList;
import java.util.Vector;

public class Generalization3D {
    private static License _$2;
    private static transient Vector _$1;

    private Generalization3D() {
    }

    public static DatasetVector dissolve(DatasetVector datasetVector, Datasource datasource, String string, DissolveParameter3D dissolveParameter3D) {
        Generalization3D._$1();
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string2 = InternalResource.loadString("sourceDatasetVector", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string2);
        }
        if (datasetVector.getType() != DatasetType.LINE3D) {
            String string3 = InternalResource.loadString("sourceDatasetVector", "UnsupprotDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string3);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string4 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string4);
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "Global_DatasetNameInvalid", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string5);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string6 = InternalResource.loadString("targetDatasource", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string6);
        }
        if (dissolveParameter3D == null) {
            String string7 = InternalResource.loadString("dissolveParameter", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string7);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l3 = InternalHandle.getHandle((com.supermap.data.InternalHandle)dissolveParameter3D);
        long l4 = Generalization3DNative.jni_Dissolve(l, l2, string, l3);
        DatasetVector datasetVector2 = null;
        if (l4 != 0L) {
            datasetVector2 = InternalDatasetVector.createInstance(l4, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector2);
        }
        return datasetVector2;
    }

    public static boolean resample(DatasetVector datasetVector, double d) {
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("datasetVector", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        DatasetType datasetType = datasetVector.getType();
        if (datasetType != DatasetType.LINE3D && datasetType != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("datasetVector", "UnsupprotDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("tolerance", "Global_ToleranceShouldGreaterThanZero", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        ResampleInformation resampleInformation = new ResampleInformation();
        resampleInformation.setResampleType(ResampleType.RTBEND);
        resampleInformation.setTolerance(d);
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)resampleInformation);
        boolean bl = Generalization3DNative.jni_Resample(l, l2);
        resampleInformation.dispose();
        return bl;
    }

    public static boolean smooth(DatasetVector datasetVector, int n) {
        if (datasetVector == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("datasetVector", "Global_ArgumentNull", "spatialanalyst3d_resources");
            throw new NullPointerException(string);
        }
        DatasetType datasetType = datasetVector.getType();
        if (datasetType != DatasetType.LINE3D && datasetType != DatasetType.NETWORK3D) {
            String string = InternalResource.loadString("datasetVector", "UnsupprotDatasetType", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        if (n < 2) {
            String string = InternalResource.loadString("DatasetVector", "Global_ArgumentShouldNotSmallerThanTwo", "spatialanalyst3d_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        return Generalization3DNative.jni_Smooth(l, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$2;
        synchronized (object) {
            n = _$2.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$1 == null) {
            _$1 = new Vector();
        }
        if (!_$1.contains(steppedListener)) {
            _$1.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$1 != null && _$1.contains(steppedListener)) {
            _$1.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$1 != null) {
            Vector vector = _$1;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "Generalization";
        boolean bl = InternalToolkitSpatialAnalyst3D.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        Generalization3D.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst3D.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst3D.managerProducts(InternalToolkitSpatialAnalyst3D.getRealspaceSpatialAnalystProducts());
        _$2 = InternalToolkitSpatialAnalyst3D.verifyLicense(arrayList);
    }
}

