/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.geoprocessor.core;

import com.supermap.geoprocessor.common.ProcessStatus;
import com.supermap.geoprocessor.core.DefaultLogListener;
import com.supermap.geoprocessor.core.LogListener;
import com.supermap.geoprocessor.core.Message;
import com.supermap.geoprocessor.persistence.LogEntity;
import com.supermap.geoprocessor.persistence.LogManipulate;
import com.supermap.geoprocessor.persistence.TaskEntity;
import com.supermap.geoprocessor.persistence.TaskManipulate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunningContext {
    private String taskId;
    private int processId = -1;
    private final int maxLevelCount = 4;
    private int currentLevel = 0;
    private double currentProgress = 0.0;
    private boolean isContinue = true;
    private Map<String, RunningContext> children = null;
    private RunningContext parent = null;
    private Vector<LogListener> logListeners = null;
    private Map<String, Object> properties = null;
    private int status = ProcessStatus.DEFAULT;
    private Object progressLock = new Object();
    private RunningContext rootContext = null;
    private long jobId = 0L;
    private String outInput = null;
    private static Map<String, Object> GlobalProperties = new HashMap<String, Object>();
    private Object isContinueLock = new Object();

    public RunningContext(String string) {
        this.taskId = string;
        this.currentLevel = 0;
        this.logListeners = new Vector();
        this.children = new HashMap<String, RunningContext>();
        this.properties = new HashMap<String, Object>();
        this.logListeners.add(new DefaultLogListener(Long.toString(this.jobId), this.taskId));
    }

    public RunningContext(long l) {
        this.taskId = Long.toString(l);
        this.currentLevel = 0;
        this.logListeners = new Vector();
        this.children = new HashMap<String, RunningContext>();
        this.properties = new HashMap<String, Object>();
        this.logListeners.add(new DefaultLogListener(Long.toString(this.jobId), this.taskId));
    }

    public void setTaskId(String string) {
        this.taskId = string;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setProcessId(int n) {
        this.processId = n;
    }

    public long getProcessId() {
        return this.processId;
    }

    void setLevel(int n) {
        this.currentLevel = n;
    }

    int getLevel() {
        return this.currentLevel;
    }

    public Set<String> getPropertyKeySet() {
        return this.properties.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String string, Object object) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(String string) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            return this.properties.get(string);
        }
    }

    public void addLogListener(LogListener logListener) {
        if (this.logListeners.contains(logListener)) {
            return;
        }
        this.logListeners.add(logListener);
    }

    public void removeLogListener(LogListener logListener) {
        if (this.logListeners.contains(logListener)) {
            this.logListeners.remove(logListener);
        }
    }

    public int getStatus() {
        if (this.children.size() == 0) {
            return this.status;
        }
        boolean bl = false;
        Collection<RunningContext> collection = this.children.values();
        for (RunningContext runningContext : collection) {
            int n = runningContext.getStatus();
            if (n == ProcessStatus.FAILED) {
                return ProcessStatus.FAILED;
            }
            if (n != ProcessStatus.RUNNING) continue;
            bl = true;
        }
        if (bl) {
            return ProcessStatus.RUNNING;
        }
        return ProcessStatus.SUCCEED;
    }

    public void writeDebug(String string) {
        if (this.currentLevel < this.maxLevelCount) {
            for (int i = 0; i < this.logListeners.size(); ++i) {
                this.logListeners.get(i).writeDebug(string);
            }
        }
    }

    public void writeInfo(String string) {
        if (this.currentLevel < this.maxLevelCount) {
            for (int i = 0; i < this.logListeners.size(); ++i) {
                this.logListeners.get(i).writeInfo(string);
            }
        }
    }

    public void writeError(String string) {
        if (this.currentLevel < this.maxLevelCount) {
            for (int i = 0; i < this.logListeners.size(); ++i) {
                this.logListeners.get(i).writeError(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(double d) {
        Object object = this.progressLock;
        synchronized (object) {
            if (this.parent != null) {
                this.parent.addProgress(d - this.currentProgress);
            }
            if (this.currentLevel == 1) {
                for (int i = 0; i < this.logListeners.size(); ++i) {
                    this.logListeners.get(i).updateProgress(this.processId, d);
                }
            }
            this.currentProgress = d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addProgress(double d) {
        Object object = this.progressLock;
        synchronized (object) {
            if (this.currentLevel == 1 && this.processId == 3 && Math.abs(d - 100.0) < 0.1) {
                System.out.println("error updateprogress");
            }
            double d2 = 0.0;
            d2 = this.children != null ? this.currentProgress + d * 100.0 / (double)this.children.size() / 100.0 : this.currentProgress + d;
            this.updateProgress(d2);
        }
    }

    public void updateProcessStatus(int n) {
        this.status = n;
        if (this.processId != -1 && this.currentLevel == 1) {
            for (int i = 0; i < this.logListeners.size(); ++i) {
                this.logListeners.get(i).updateProgress(this.processId, n);
            }
        } else if (this.currentLevel == 0) {
            Message.updateTaskStatus(this.taskId, n);
        }
    }

    public RunningContext newRunningContext(int n) {
        RunningContext runningContext = new RunningContext(this.taskId);
        runningContext.setProcessId(n);
        runningContext.setParent(this);
        runningContext.setLevel(this.currentLevel + 1);
        runningContext.properties = this.properties;
        runningContext.logListeners = this.logListeners;
        runningContext.rootContext = this.getRootContext();
        this.children.put(Integer.toString(n), runningContext);
        if (this.currentLevel == 0) {
            Message.addProgress("", (long)n, 0.0, this.taskId);
        }
        return runningContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.isContinueLock;
        synchronized (object) {
            if (this.children.size() > 0) {
                Collection<RunningContext> collection = this.getChildren().values();
                for (RunningContext runningContext : collection) {
                    if (!runningContext.isContinue) continue;
                    runningContext.stop();
                }
            }
            this.isContinue = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isContinue() {
        Object object = this.isContinueLock;
        synchronized (object) {
            return this.isContinue;
        }
    }

    public RunningContext getParent() {
        return this.parent;
    }

    void setParent(RunningContext runningContext) {
        this.parent = runningContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getProgress() {
        Object object = this.progressLock;
        synchronized (object) {
            return (double)((int)(this.currentProgress * 100.0)) / 100.0;
        }
    }

    public Map<String, RunningContext> getChildren() {
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGlobalProperty(String string, Object object) {
        Map<String, Object> map = GlobalProperties;
        synchronized (map) {
            GlobalProperties.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getGlobalProperty(String string) {
        Map<String, Object> map = GlobalProperties;
        synchronized (map) {
            return GlobalProperties.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getGlobalPropertyKeySet() {
        Map<String, Object> map = GlobalProperties;
        synchronized (map) {
            return GlobalProperties.keySet();
        }
    }

    public String getProgressAsXml() {
        String string = "";
        if (this.currentLevel == 1) {
            string = "<process id=\"" + this.processId + "\" progress=\"" + this.getProgress() + "\" status=\"" + this.status + "\"/>";
        } else if (this.currentLevel == 0) {
            string = "<root total=\"" + this.getProgress() + "\">";
            Collection<RunningContext> collection = this.getChildren().values();
            for (RunningContext runningContext : collection) {
                string = string + runningContext.getProgressAsXml();
            }
            string = string + "</root>";
        }
        return string;
    }

    public RunningContext getRootContext() {
        return this.rootContext == null ? this : this.rootContext;
    }

    public void setJobID(long l) {
        this.jobId = l;
    }

    public long getJobID() {
        return this.jobId;
    }

    public String getTaskLog() {
        String string = "";
        LogManipulate logManipulate = new LogManipulate();
        List<LogEntity> list = logManipulate.queryByTaskId(this.taskId);
        string = string + "<resources type=\"logs\">";
        LogEntity logEntity = null;
        for (int i = 0; i < list.size(); ++i) {
            logEntity = list.get(i);
            if (null == logEntity) continue;
            string = string + "<resource type=\"log\">";
            string = string + "<property type=\"date\">";
            string = string + logEntity.getLogTime().toString();
            string = string + "</property>";
            string = string + "<property type=\"message\">";
            string = string + logEntity.getMessage();
            string = string + "</property>";
            string = string + "</resource>";
        }
        string = string + "</resources>";
        return string;
    }

    public void addTask() {
        Message.addTask(this.taskId, Long.toString(this.jobId));
    }

    public static String getTasksFromJobId(String string) {
        String string2 = "";
        TaskManipulate taskManipulate = new TaskManipulate();
        List<TaskEntity> list = taskManipulate.queryByJobId(string);
        string2 = string2 + "<tasks>";
        TaskEntity taskEntity = null;
        for (int i = 0; i < list.size(); ++i) {
            taskEntity = list.get(i);
            if (null == taskEntity) continue;
            string2 = string2 + "<task id=\"" + taskEntity.getId() + "\" createTime=\"" + taskEntity.getCreateTime() + "\" status=\"" + taskEntity.getStatus() + "\"/>";
        }
        string2 = string2 + "</tasks>";
        return string2;
    }

    public void setOutInput(String string) {
        this.outInput = string;
    }

    public String getOutInput() {
        return this.outInput;
    }
}

