/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoPie3DNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoPie3D
extends Geometry3D {
    public GeoPie3D() {
        this.setHandle(GeoPie3DNative.jni_New(), true);
        this.setStartAngle(0.0);
        this.setSweepAngle(180.0);
        this.setSemimajorAxis(1.0);
        this.setSemiminorAxis(1.0);
    }

    public GeoPie3D(GeoPie3D geoPie3D) {
        if (geoPie3D == null) {
            String string = InternalResource.loadString("geoPie3D", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoPie3D);
        if (l == 0L) {
            String string = InternalResource.loadString("geoPie3D", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoPie3DNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoPie3D);
    }

    public GeoPie3D(Point3D point3D, double d, double d2, double d3, double d4) {
        this();
        this.setStartAngle(d3);
        this.setSweepAngle(d4);
        this.setPosition(point3D);
        this.setSemimajorAxis(d);
        this.setSemiminorAxis(d2);
    }

    GeoPie3D(long l) {
        this.setHandle(l, false);
    }

    public double getSemimajorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSemimajorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPie3DNative.jni_GetSemimajorAxis(this.getHandle());
    }

    public void setSemimajorAxis(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSemimajorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("setSemimajorAxis", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPie3DNative.jni_SetSemimajorAxis(this.getHandle(), d);
    }

    public double getSemiminorAxis() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSemiminorAxis()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPie3DNative.jni_GetSemiminorAxis(this.getHandle());
    }

    public void setSemiminorAxis(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSemiminorAxis(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("setSemiminorAxis", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPie3DNative.jni_SetSemiminorAxis(this.getHandle(), d);
    }

    public double getStartAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStartAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPie3DNative.jni_GetStartAngle(this.getHandle());
    }

    public void setStartAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStartAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPie3DNative.jni_SetStartAngle(this.getHandle(), d);
    }

    public double getSweepAngle() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getSweepAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPie3DNative.jni_GetSweepAngle(this.getHandle());
    }

    public void setSweepAngle(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSweepAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= -360.0 || d >= 360.0) {
            String string = InternalResource.loadString("value", "GeoPie3D_SweepAngleRange:(-360,0)||(0,360)", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d == 0.0) {
            String string = InternalResource.loadString("value", "GeoGeoPie3D_SweepAngleShouldNotBeZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoPie3DNative.jni_SetSweepAngle(this.getHandle(), d);
    }

    public GeoPie3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPie3D(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPie3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

