/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.GeoCircle3DNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.InternalResource;
import com.supermap.data.Point3D;

public class GeoCircle3D
extends Geometry3D {
    public GeoCircle3D() {
        this.setHandle(GeoCircle3DNative.jni_New(), true);
        this.setRadius(1.0);
    }

    public GeoCircle3D(GeoCircle3D geoCircle3D) {
        if (geoCircle3D == null) {
            String string = InternalResource.loadString("GeoCircle3D", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle(geoCircle3D);
        if (l == 0L) {
            String string = InternalResource.loadString("GeoCircle3D", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoCircle3DNative.jni_Clone(l);
        super.setHandle(l2, true);
        InternalHandleDisposable.makeSureNativeObjectLive(geoCircle3D);
    }

    public GeoCircle3D(Point3D point3D, double d) {
        this();
        this.setPosition(point3D);
        this.setRadius(d);
    }

    GeoCircle3D(long l) {
        this.setHandle(l, false);
    }

    public double getRadius() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRadius()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoCircle3DNative.jni_GetRadius(this.getHandle());
    }

    public void setRadius(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setRadius(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d <= 0.0) {
            String string = InternalResource.loadString("setRadius()", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoCircle3DNative.jni_SetRadius(this.getHandle(), d);
    }

    public GeoCircle3D clone() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoCircle3D(this);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoCircle3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }
}

