/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.trafficanalyst;

import com.supermap.analyst.trafficanalyst.InternalDatasetVector;
import com.supermap.analyst.trafficanalyst.InternalDatasets;
import com.supermap.analyst.trafficanalyst.InternalHandle;
import com.supermap.analyst.trafficanalyst.InternalHandleDisposable;
import com.supermap.analyst.trafficanalyst.InternalResource;
import com.supermap.analyst.trafficanalyst.InternalToolkitTrafficAnalyst;
import com.supermap.analyst.trafficanalyst.LineInfo;
import com.supermap.analyst.trafficanalyst.LineSetting;
import com.supermap.analyst.trafficanalyst.LineSettings;
import com.supermap.analyst.trafficanalyst.RelationSetting;
import com.supermap.analyst.trafficanalyst.RelationSettings;
import com.supermap.analyst.trafficanalyst.StopInfo;
import com.supermap.analyst.trafficanalyst.StopSetting;
import com.supermap.analyst.trafficanalyst.StopSettings;
import com.supermap.analyst.trafficanalyst.TransferAnalystNative;
import com.supermap.analyst.trafficanalyst.TransferAnalystParameter;
import com.supermap.analyst.trafficanalyst.TransferAnalystResult;
import com.supermap.analyst.trafficanalyst.TransferAnalystResultNative;
import com.supermap.analyst.trafficanalyst.TransferAnalystSetting;
import com.supermap.analyst.trafficanalyst.TransferGuide;
import com.supermap.analyst.trafficanalyst.TransferLine;
import com.supermap.analyst.trafficanalyst.TransferSolutions;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.License;
import com.supermap.data.Point2D;
import com.supermap.data.ProductType;
import com.supermap.data.Recordset;
import com.supermap.data.Unit;
import java.util.ArrayList;

public class TransferAnalyst
extends InternalHandleDisposable {
    private boolean _$5;
    private DatasetVector _$4;
    private long _$3;
    private License _$2;
    private TransferAnalystSetting _$1;

    public TransferAnalyst() {
        this._$3();
        this._$5 = false;
        this.setHandle(TransferAnalystNative.jni_New(), true);
    }

    void addPreferentialLines(DatasetVector datasetVector, int[] nArray) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPreferentialLines(DatasetVector lineDataset, int[] lineIDs)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("addPreferentialLines(DatasetVector lineDataset, int[] lineIDs)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        TransferAnalystNative.jni_AddPreferentialLines(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector), nArray);
    }

    void addPreferentialStops(DatasetVector datasetVector, int[] nArray) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addPreferentialStops (DatasetVector stopDataset,int[] stopIDs)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("addPreferentialStops (DatasetVector stopDataset,int[] stopIDs)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        TransferAnalystNative.jni_AddPreferentialStops(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector), nArray);
    }

    void addEscapedLines(DatasetVector datasetVector, int[] nArray) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addEscapedLines(DatasetVector lineDataset, int[] lineIDs)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("addEscapedLines(DatasetVector lineDataset,int[] lineIDs)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        TransferAnalystNative.jni_AddEscapedLines(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector), nArray);
    }

    void addEscapedStops(DatasetVector datasetVector, int[] nArray) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addEscapedStops(DatasetVector stopDataset, int[] stopIDs)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("addEscapedStops (DatasetVector stopDataset,int[] stopIDs)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector) == 0L) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        TransferAnalystNative.jni_AddEscapedStops(this.getHandle(), InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector), nArray);
    }

    int[] getPreferentialLines(DatasetVector datasetVector) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getPreferentialLines(DatasetVector lineDataset)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("getPreferentialLines(DatasetVector lineDataset)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return TransferAnalystNative.jni_getPreferentialLines(this.getHandle(), l);
    }

    void removePreferentialLines(DatasetVector datasetVector, int[] nArray) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePreferentialLines(DatasetVector lineDataset, int[] lineIDs)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("removePreferentialLines(DatasetVector lineDataset,int[] lineIDs)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        TransferAnalystNative.jni_removePreferentialLines(this.getHandle(), l, nArray);
    }

    void clearPreferentialLines(DatasetVector datasetVector) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clearPreferentialLines(DatasetVector lineDataset)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("clearPreferentialLines(DatasetVector lineDataset)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (!recordset.isEOF()) {
            arrayList.add(recordset.getID());
            recordset.moveNext();
        }
        recordset.dispose();
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        this.removePreferentialLines(datasetVector, nArray);
    }

    int[] getPreferentialStops(DatasetVector datasetVector) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetPreferentialStops(DatasetVector stopDataset)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return TransferAnalystNative.jni_GetPreferentialStops(this.getHandle(), l);
    }

    void removePreferentialStops(DatasetVector datasetVector, int[] nArray) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removePreferentialStops(DatasetVector stopDataset, int[] stopIDs)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        TransferAnalystNative.jni_removePreferentialStops(this.getHandle(), l, nArray);
    }

    void clearPreferentialStops(DatasetVector datasetVector) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clearPreferentialStops(DatasetVector stopDataset)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("clearPreferentialStops(DatasetVector stopDataset)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (!recordset.isEOF()) {
            arrayList.add(recordset.getID());
            recordset.moveNext();
        }
        recordset.dispose();
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        this.removePreferentialStops(datasetVector, nArray);
    }

    int[] getEscapedLines(DatasetVector datasetVector) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getEscapedLines(DatasetVector lineDataset)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return TransferAnalystNative.jni_getEscapedLines(this.getHandle(), l);
    }

    void removeEscapedLines(DatasetVector datasetVector, int[] nArray) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeEscapedLines(DatasetVector lineDataset, int[] lineIDs)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        TransferAnalystNative.jni_removeEscapedLines(this.getHandle(), l, nArray);
    }

    void clearEscapedLines(DatasetVector datasetVector) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString(" clearEscapedLines(DatasetVector lineDataset)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString(" clearEscapedLines(DatasetVector lineDataset)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (!recordset.isEOF()) {
            arrayList.add(recordset.getID());
            recordset.moveNext();
        }
        recordset.dispose();
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        this.removeEscapedLines(datasetVector, nArray);
    }

    int[] getEscapedStops(DatasetVector datasetVector) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("GetEscapedStops(DatasetVector stopDataset)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        return TransferAnalystNative.jni_GetEscapedStops(this.getHandle(), l);
    }

    void removeEscapedStops(DatasetVector datasetVector, int[] nArray) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("removeEscapedStops(DatasetVector stopDataset, int[] stopIDs)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetVector);
        if (l == 0L) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalArgumentException(string);
        }
        TransferAnalystNative.jni_removeEscapedStops(this.getHandle(), l, nArray);
    }

    void clearEscapedStops(DatasetVector datasetVector) {
        this._$1();
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString(" clearEscapedStops(DatasetVector stopDataset)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString(" clearEscapedStops(DatasetVector stopDataset)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (datasetVector == null) {
            String string = InternalResource.loadString("stopDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        Recordset recordset = datasetVector.getRecordset(false, CursorType.STATIC);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (!recordset.isEOF()) {
            arrayList.add(recordset.getID());
            recordset.moveNext();
        }
        recordset.dispose();
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        this.removeEscapedStops(datasetVector, nArray);
    }

    DatasetVector buildTransferModel(TransferAnalystSetting transferAnalystSetting, Datasource datasource, String string) {
        this._$1();
        if (transferAnalystSetting == null) {
            String string2 = InternalResource.loadString("lineDataset", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = transferAnalystSetting.getLineSettings().get(0).getDataset().getDatasource();
        }
        if (datasource.getDatasets().contains(string)) {
            String string3 = InternalResource.loadString("outputDatasource", "Datasource_DatasetNameIsInvalid", "trafficanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        long l2 = transferAnalystSetting.setToUGC();
        long l3 = TransferAnalystNative.jni_BuildTransferModel(l2, l, string);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public boolean load(LineSetting lineSetting, StopSetting stopSetting, RelationSetting relationSetting) {
        if (this._$5) {
            return true;
        }
        if (lineSetting == null) {
            String string = InternalResource.loadString("transferLineSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        if (stopSetting == null) {
            String string = InternalResource.loadString("transferStopSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        if (relationSetting == null) {
            String string = InternalResource.loadString("transferRelationSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        LineSettings lineSettings = new LineSettings();
        lineSettings.add(lineSetting);
        StopSettings stopSettings = new StopSettings();
        stopSettings.add(stopSetting);
        RelationSettings relationSettings = new RelationSettings();
        relationSettings.add(relationSetting);
        long l = this.getHandle();
        long l2 = lineSettings.setToUGC();
        long l3 = stopSettings.setToUGC();
        long l4 = relationSettings.setRelationToUGC();
        Unit unit = Unit.METER;
        double d = (double)unit.value() * 1.0 / (double)lineSettings.get(0).getDataset().getPrjCoordSys().getCoordUnit().value();
        double d2 = 10.0 * d;
        double d3 = 500.0 * d;
        double d4 = 1000.0 * d;
        boolean bl = false;
        this._$5 = bl = TransferAnalystNative.jni_LoadBasicModel(l, l2, l3, l4, d2, d3, d4);
        return bl;
    }

    public boolean load(TransferAnalystSetting transferAnalystSetting) {
        this._$1();
        if (this._$5) {
            return true;
        }
        if (transferAnalystSetting == null) {
            String string = InternalResource.loadString("TransferAnalystSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this._$1 = transferAnalystSetting;
        long l = this.getHandle();
        long l2 = transferAnalystSetting.setToUGC();
        boolean bl = false;
        this._$5 = bl = TransferAnalystNative.jni_LoadAdvancedModel(l, l2);
        return bl;
    }

    public boolean check(TransferAnalystSetting transferAnalystSetting) {
        if (this._$5) {
            return true;
        }
        this._$1();
        if (transferAnalystSetting == null) {
            String string = InternalResource.loadString("TransferAnalystSetting", "Global_ArgumentNull", "trafficanalyst_resources");
            throw new NullPointerException(string);
        }
        this._$1 = transferAnalystSetting;
        long l = transferAnalystSetting.setToUGC();
        boolean bl = true;
        bl = TransferAnalystNative.jni_CheckSetting(l);
        return bl;
    }

    public TransferAnalystResult findTransferLines(TransferAnalystParameter transferAnalystParameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findTransferPath(TransferAnalystParameter parameter)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("findTransferLines( TransferAnalystParameter parameter)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        transferAnalystParameter.setSolutionCount(5);
        TransferAnalystResult transferAnalystResult = null;
        long l = TransferAnalystNative.jni_FindTransferLines(this.getHandle(), transferAnalystParameter.setToUGC());
        if (l != 0L) {
            transferAnalystResult = new TransferAnalystResult(l);
        }
        return transferAnalystResult;
    }

    public TransferSolutions findTransferSolutions(TransferAnalystParameter transferAnalystParameter) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findTransferPath(TransferAnalystParameter parameter)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("findTransferLines( TransferAnalystParameter parameter)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        long l = transferAnalystParameter.setToUGC();
        if (!TransferAnalystNative.jni_CheckStartEndDistance(this.getHandle(), l)) {
            String string = InternalResource.loadString("findTransferLines( TransferAnalystParameter parameter)", "TransferAnalyst_StartEndPointTooClose", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        TransferSolutions transferSolutions = null;
        long l2 = TransferAnalystNative.jni_FindTransferSolutions(this.getHandle(), l);
        if (l2 != 0L) {
            transferSolutions = new TransferSolutions(l2);
        }
        return transferSolutions;
    }

    public LineInfo[] findLinesByStop(long l) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findLines(DatasetVector stopDataset,int stopID)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("findLinesByStop(long stopID)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = null;
        lArray = TransferAnalystNative.jni_FindLinesByStop(this.getHandle(), l);
        int n = lArray.length;
        LineInfo[] lineInfoArray = new LineInfo[n];
        for (int i = 0; i < n; ++i) {
            lineInfoArray[i] = new LineInfo(lArray[i], this);
        }
        return lineInfoArray;
    }

    public StopInfo[] findStopsByLine(long l) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("findStopsByLine(long lineID)", "Handle_ObjectHasBeenDisposed", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        if (!this._$5) {
            String string = InternalResource.loadString("findStopsByLine(long lineID)", "TransferAnalyst_LoadModelNeeded", "trafficanalyst_resources");
            throw new IllegalStateException(string);
        }
        long[] lArray = null;
        lArray = TransferAnalystNative.jni_FindStopsByLine(this.getHandle(), l);
        int n = lArray.length;
        StopInfo[] stopInfoArray = new StopInfo[n];
        for (int i = 0; i < n; ++i) {
            stopInfoArray[i] = new StopInfo(lArray[i], this);
        }
        return stopInfoArray;
    }

    public TransferGuide getDetailInfo(long l, long l2, TransferLine[] transferLineArray) {
        Object[] objectArray;
        Object object;
        int n = 0;
        long l3 = 0L;
        if (transferLineArray == null) {
            l3 = TransferAnalystNative.jni_GetIDDetail(this.getHandle(), l, l2, null, null, null);
        } else {
            n = transferLineArray.length;
            if (n < 1) {
                return null;
            }
            object = new long[n];
            objectArray = new int[n];
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                TransferLine transferLine = transferLineArray[i];
                object[i] = transferLine.getLineID();
                objectArray[i] = transferLine.getStartIndex();
                nArray[i] = transferLine.getEndIndex();
            }
            l3 = TransferAnalystNative.jni_GetIDDetail(this.getHandle(), l, l2, object, objectArray, nArray);
        }
        if (l3 == 0L) {
            return null;
        }
        object = null;
        n = TransferAnalystResultNative.jni_GetTransferGuideCount(l3);
        if (n > 0) {
            objectArray = new long[n];
            TransferAnalystResultNative.jni_GetTransferGuideHandles(l3, objectArray);
            object = new TransferGuide(objectArray[0]);
            TransferAnalystResultNative.jni_Delete(l3);
        }
        return object;
    }

    public TransferGuide getDetailInfo(Point2D point2D, Point2D point2D2, TransferLine[] transferLineArray) {
        Object[] objectArray;
        Object object;
        int n = 0;
        long l = 0L;
        if (transferLineArray == null) {
            l = TransferAnalystNative.jni_GetPointDetail(this.getHandle(), point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), null, null, null);
        } else {
            n = transferLineArray.length;
            if (n < 1) {
                return null;
            }
            object = new long[n];
            objectArray = new int[n];
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                TransferLine transferLine = transferLineArray[i];
                object[i] = transferLine.getLineID();
                objectArray[i] = transferLine.getStartIndex();
                nArray[i] = transferLine.getEndIndex();
            }
            l = TransferAnalystNative.jni_GetPointDetail(this.getHandle(), point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), object, objectArray, nArray);
        }
        if (l == 0L) {
            return null;
        }
        object = null;
        n = TransferAnalystResultNative.jni_GetTransferGuideCount(l);
        if (n > 0) {
            objectArray = new long[n];
            TransferAnalystResultNative.jni_GetTransferGuideHandles(l, objectArray);
            object = new TransferGuide(objectArray[0]);
            TransferAnalystResultNative.jni_Delete(l);
        }
        return object;
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "trafficanalyst_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this._$1.dispose();
            TransferAnalystNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
        this._$5 = false;
        this._$2();
    }

    private void _$3() {
        ArrayList<ProductType> arrayList = InternalToolkitTrafficAnalyst.managerProducts(InternalToolkitTrafficAnalyst.getTrafficAnalystProducts());
        this._$2 = InternalToolkitTrafficAnalyst.verifyLicense(arrayList);
    }

    private void _$2() {
        if (this._$2 != null) {
            this._$2.disconnect();
            this._$2.dispose();
            this._$2 = null;
        }
    }

    private void _$1() {
        int n = this._$2.verify();
        if (n != 0) {
            String string = License.getErrorMessage((int)n);
            throw new IllegalStateException(string);
        }
    }
}

