/*
 * $Id: AttributeListImpl.java,v 1.2 1999/04/11 17:22:53 db Exp $
 * 
 * Copyright (c) 1998-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 */

package com.sun.xml.parser;

import java.util.Vector;

import org.xml.sax.AttributeList;


/**
 * Implementation of the SAX AttributeList interface which
 * provides additional features to support editor-oriented DOM
 * features:  exposing attribute defaulting.
 *
 * @author David Brownell
 * @version $Revision: 1.2 $
 */
final
class AttributeListImpl implements AttributeListEx
{
    // Needed to support basic Attributelist functionality 
    private Vector	names = new Vector();
    private Vector	types = new Vector();
    private Vector	values = new Vector();

    // Boolean.TRUE indicates value was specified
    private Vector	specified = new Vector ();

    // non-null value defines default
    private Vector	defaults = new Vector ();

    // ID attribute name, as declared
    private String	idAttributeName;

    AttributeListImpl ()
    {
    }

    /**
     * Clears the attribute list so it has no members
     */
    public void clear ()
    {
	names.removeAllElements ();
	types.removeAllElements ();
	values.removeAllElements ();
	specified.removeAllElements ();
	defaults.removeAllElements ();
    }


    /**
     * Add an attribute to an attribute list.
     */
    public void addAttribute (
	String	name,
	String	type,
	String	value,
	String	defaultValue,
	boolean	isSpecified
    ) {
	names.addElement (name);
	types.addElement (type);
	values.addElement (value);
	defaults.addElement (defaultValue);
	specified.addElement (isSpecified ? Boolean.TRUE : null);
    }


    /**
     * Return the number of attributes in this list.
     */
    public int getLength ()
    {
	return names.size ();
    }


    /**
     * Return the name of an attribute in this list (by position).
     */
    public String getName (int i)
    {
	try {
	    if (i < 0)
		return null;
	    return (String) names.elementAt (i);
	} catch (IndexOutOfBoundsException e) {
	    return null;
	}
    }


    /**
     * Returns true if the value was specified by a parsed document
     * (by position; no by-name variant).
     */
    public boolean isSpecified (int i)
    {
	Object	value = specified.elementAt (i);
	return value == Boolean.TRUE;
    }


    /**
     * Return the default value of an attribute in this list (by position).
     */
    public String getDefault (int i)
    {
	try {
	    if (i < 0)
		return null;
	    return (String) defaults.elementAt (i);
	} catch (IndexOutOfBoundsException e) {
	    return null;
	}
    }


    /**
     * Return the type of an attribute in this list (by position).
     */
    public String getType (int i)
    {
	try {
	    if (i < 0)
		return null;
	    return (String) types.elementAt (i);
	} catch (IndexOutOfBoundsException e) {
	    return null;
	}
    }


    /**
     * Return the type of an attribute in this list (by name).
     */
    public String getType (String name)
    {
	return getType (names.indexOf (name));
    }


    /**
     * Return the value of an attribute in this list (by position).
     */
    public String getValue (int i)
    {
	try {
	    if (i < 0)
		return null;
	    return (String) values.elementAt (i);
	} catch (IndexOutOfBoundsException e) {
	    return null;
	}
    }


    /**
     * Return the value of an attribute in this list (by name).
     */
    public String getValue (String name)
    {
	return getValue (names.indexOf (name));
    }

    /** Returns the name of the ID attribute. */
    public String getIdAttributeName ()
	{ return idAttributeName; }

    /** Returns the name of the ID attribute. */
    void setIdAttributeName (String name)
	{ idAttributeName  = name; }
}
