/*
 * Decompiled with CFR 0.152.
 */
package org.json.tests;

import java.io.IOException;
import java.io.Writer;
import junit.framework.TestCase;
import org.json.JSONException;
import org.json.JSONStringer;
import org.json.JSONWriter;

public class TestJSONWriter
extends TestCase {
    JSONWriter jsonwriter;

    public void testKey() {
        try {
            this.jsonwriter = new JSONStringer();
            String result = this.jsonwriter.object().key("abc").value("123").key("abc2").value(60L).key("abc3").value(20.98).key("abc4").value(true).endObject().toString();
            TestJSONWriter.assertEquals((String)"{\"abc\":\"123\",\"abc2\":60,\"abc3\":20.98,\"abc4\":true}", (String)result);
        }
        catch (JSONException e) {
            TestJSONWriter.fail((String)e.getMessage());
        }
    }

    public void testValue() {
        try {
            this.jsonwriter = new JSONStringer();
            String result = this.jsonwriter.array().value("123").value(10L).value(30.45).value(false).endArray().toString();
            TestJSONWriter.assertEquals((String)"[\"123\",10,30.45,false]", (String)result);
        }
        catch (JSONException e) {
            TestJSONWriter.fail((String)e.getMessage());
        }
    }

    public void testObject_StopsAtMaxDepth() {
        try {
            this.jsonwriter = new JSONStringer();
            int i = 0;
            while (i < 201) {
                this.jsonwriter.object().key("123");
                ++i;
            }
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Nesting too deep.", (String)e.getMessage());
        }
    }

    public void testArray_StopsAtMaxDepth() {
        try {
            this.jsonwriter = new JSONStringer();
            int i = 0;
            while (i < 201) {
                this.jsonwriter.array();
                ++i;
            }
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Nesting too deep.", (String)e.getMessage());
        }
    }

    public void testValue_OutOfSequence() {
        try {
            this.jsonwriter = new JSONStringer();
            this.jsonwriter.value(true);
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Value out of sequence.", (String)e.getMessage());
        }
    }

    public void testObject_OutOfSequence() {
        try {
            this.jsonwriter = new JSONStringer();
            this.jsonwriter.object().object();
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Misplaced object.", (String)e.getMessage());
        }
    }

    public void testObject_TwoObjectsWithinArray() {
        try {
            this.jsonwriter = new JSONStringer();
            String result = this.jsonwriter.array().object().endObject().object().endObject().endArray().toString();
            TestJSONWriter.assertEquals((String)"[{},{}]", (String)result);
        }
        catch (JSONException e) {
            TestJSONWriter.fail((String)e.getMessage());
        }
    }

    public void testObject_TwoStringsAndAnIntWithinObject() {
        try {
            this.jsonwriter = new JSONStringer();
            String result = this.jsonwriter.object().key("string1").value("abc").key("int").value(35L).key("string2").value("123").endObject().toString();
            TestJSONWriter.assertEquals((String)"{\"string1\":\"abc\",\"int\":35,\"string2\":\"123\"}", (String)result);
        }
        catch (JSONException e) {
            TestJSONWriter.fail((String)e.getMessage());
        }
    }

    public void testKey_MisplacedKey() {
        try {
            this.jsonwriter = new JSONStringer();
            this.jsonwriter.key("123");
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Misplaced key.", (String)e.getMessage());
        }
    }

    public void testKey_CatchesIoexception() {
        try {
            this.jsonwriter = new JSONWriter(new BadWriterThrowsOnNonBrace());
            this.jsonwriter.object().key("123");
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Test Message From Non-Brace", (String)e.getMessage());
        }
    }

    public void testObject_CatchesIoexception() {
        try {
            this.jsonwriter = new JSONWriter(new BadWriterThrowsOnLeftBrace());
            this.jsonwriter.object();
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Test Message From Left Brace", (String)e.getMessage());
        }
    }

    public void testKey_NullKey() {
        try {
            this.jsonwriter = new JSONStringer();
            this.jsonwriter.key(null);
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Null key.", (String)e.getMessage());
        }
    }

    public void testArray_TwoArraysWithinObject() {
        try {
            this.jsonwriter = new JSONStringer();
            String result = this.jsonwriter.object().key("123").array().endArray().key("1234").array().endArray().endObject().toString();
            TestJSONWriter.assertEquals((String)"{\"123\":[],\"1234\":[]}", (String)result);
        }
        catch (JSONException e) {
            TestJSONWriter.fail((String)e.getMessage());
        }
    }

    public void testObject_TwoObjectsWithinObject() {
        try {
            this.jsonwriter = new JSONStringer();
            String result = this.jsonwriter.object().key("123").object().endObject().key("1234").object().endObject().endObject().toString();
            TestJSONWriter.assertEquals((String)"{\"123\":{},\"1234\":{}}", (String)result);
        }
        catch (JSONException e) {
            TestJSONWriter.fail((String)e.getMessage());
        }
    }

    public void testArray_TwoArraysWithinArray() {
        try {
            this.jsonwriter = new JSONStringer();
            String result = this.jsonwriter.array().array().endArray().array().endArray().endArray().toString();
            TestJSONWriter.assertEquals((String)"[[],[]]", (String)result);
        }
        catch (JSONException e) {
            TestJSONWriter.fail((String)e.getMessage());
        }
    }

    public void testArray_MisplacedArray() {
        try {
            this.jsonwriter = new JSONStringer();
            this.jsonwriter.object().array();
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Misplaced array.", (String)e.getMessage());
        }
    }

    public void testEndArray_MisplacedEndArray() {
        try {
            this.jsonwriter = new JSONStringer();
            this.jsonwriter.endArray();
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Misplaced endArray.", (String)e.getMessage());
        }
    }

    public void testEndObject_MisplacedEndObject() {
        try {
            this.jsonwriter = new JSONStringer();
            this.jsonwriter.endObject();
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Misplaced endObject.", (String)e.getMessage());
        }
    }

    public void testEndObject_CatchesIoexception() {
        try {
            this.jsonwriter = new JSONWriter(new BadWriterThrowsOnRightBrace());
            this.jsonwriter.object().endObject();
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Test Message From Right Brace", (String)e.getMessage());
        }
    }

    public void testPop_BadExtensionThatCausesNestingError1() {
        try {
            BadExtensionThatCausesNestingError betcnw = new BadExtensionThatCausesNestingError();
            betcnw.object().endObject();
            betcnw.changeMode('k').endObject();
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Nesting error.", (String)e.getMessage());
        }
    }

    public void testPop_BadExtensionThatCausesNestingError2() {
        try {
            BadExtensionThatCausesNestingError betcnw = new BadExtensionThatCausesNestingError();
            betcnw.array();
            betcnw.changeMode('k').endObject();
            TestJSONWriter.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONWriter.assertEquals((String)"Nesting error.", (String)e.getMessage());
        }
    }

    class BadExtensionThatCausesNestingError
    extends JSONStringer {
        BadExtensionThatCausesNestingError() {
        }

        public JSONWriter changeMode(char c) {
            this.mode = c;
            return this;
        }
    }

    class BadWriterThrowsOnLeftBrace
    extends Writer {
        BadWriterThrowsOnLeftBrace() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (cbuf[0] == '{') {
                throw new IOException("Test Message From Left Brace");
            }
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    class BadWriterThrowsOnNonBrace
    extends Writer {
        BadWriterThrowsOnNonBrace() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (cbuf[0] != '{') {
                throw new IOException("Test Message From Non-Brace");
            }
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    class BadWriterThrowsOnRightBrace
    extends Writer {
        BadWriterThrowsOnRightBrace() {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            if (cbuf[0] == '}') {
                throw new IOException("Test Message From Right Brace");
            }
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

