/*
 * Decompiled with CFR 0.152.
 */
package org.json.tests;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;
import org.json.XML;

public class TestJSONObject
extends TestCase {
    JSONObject jsonobject = new JSONObject();
    Iterator<String> iterator;
    JSONArray jsonarray;
    Object object;
    String string;
    double eps = 2.220446049250313E-16;

    public void testNull() throws Exception {
        this.jsonobject = new JSONObject("{\"message\":\"null\"}");
        TestJSONObject.assertFalse((boolean)this.jsonobject.isNull("message"));
        TestJSONObject.assertEquals((String)"null", (String)this.jsonobject.getString("message"));
        this.jsonobject = new JSONObject("{\"message\":null}");
        TestJSONObject.assertTrue((boolean)this.jsonobject.isNull("message"));
    }

    public void testConstructor_DuplicateKey() {
        try {
            this.string = "{\"koda\": true, \"koda\": true}";
            this.jsonobject = new JSONObject(this.string);
            TestJSONObject.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONObject.assertEquals((String)"Duplicate key \"koda\"", (String)jsone.getMessage());
        }
    }

    public void testConstructor_NullKey() {
        try {
            this.jsonobject.put(null, "howard");
            TestJSONObject.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONObject.assertEquals((String)"Null key.", (String)jsone.getMessage());
        }
    }

    public void testGetDouble_InvalidKeyHoward() {
        try {
            this.jsonobject.getDouble("howard");
            TestJSONObject.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONObject.assertEquals((String)"JSONObject[\"howard\"] not found.", (String)jsone.getMessage());
        }
    }

    public void testGetDouble_InvalidKeyStooge() {
        this.jsonobject = new JSONObject();
        try {
            this.jsonobject.getDouble("stooge");
            TestJSONObject.fail((String)"expecting JSONException here.");
        }
        catch (JSONException jsone) {
            TestJSONObject.assertEquals((String)"JSONObject[\"stooge\"] not found.", (String)jsone.getMessage());
        }
    }

    public void testIsNull() {
        try {
            this.jsonobject = new JSONObject();
            this.object = null;
            this.jsonobject.put("booga", this.object);
            this.jsonobject.put("wooga", JSONObject.NULL);
            TestJSONObject.assertEquals((String)"{\"wooga\":null}", (String)this.jsonobject.toString());
            TestJSONObject.assertTrue((boolean)this.jsonobject.isNull("booga"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.toString());
        }
    }

    public void testIncrement_NewKey() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.increment("two");
            this.jsonobject.increment("two");
            TestJSONObject.assertEquals((String)"{\"two\":2}", (String)this.jsonobject.toString());
            TestJSONObject.assertEquals((int)2, (int)this.jsonobject.getInt("two"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.toString());
        }
    }

    public void testToString_ListofLists() {
        try {
            this.string = "{     \"list of lists\" : [         [1, 2, 3],         [4, 5, 6],     ] }";
            this.jsonobject = new JSONObject(this.string);
            TestJSONObject.assertEquals((String)"{\"list of lists\": [\n    [\n        1,\n        2,\n        3\n    ],\n    [\n        4,\n        5,\n        6\n    ]\n]}", (String)this.jsonobject.toString(4));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.toString());
        }
    }

    public void testToString_Indentation() {
        try {
            this.string = "{ \"entity\": { \"imageURL\": \"\", \"name\": \"IXXXXXXXXXXXXX\", \"id\": 12336, \"ratingCount\": null, \"averageRating\": null } }";
            this.jsonobject = new JSONObject(this.string);
            TestJSONObject.assertEquals((String)"{\"entity\": {\n  \"id\": 12336,\n  \"averageRating\": null,\n  \"ratingCount\": null,\n  \"name\": \"IXXXXXXXXXXXXX\",\n  \"imageURL\": \"\"\n}}", (String)this.jsonobject.toString(2));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.toString());
        }
    }

    public void testMultipleThings() {
        try {
            this.jsonobject = new JSONObject("{foo: [true, false,9876543210,    0.0, 1.00000001,  1.000000000001, 1.00000000000000001, .00000000000000001, 2.00, 0.1, 2e100, -32,[],{}, \"string\"],   to   : null, op : 'Good',ten:10} postfix comment");
            this.jsonobject.put("String", "98.6");
            this.jsonobject.put("JSONObject", new JSONObject());
            this.jsonobject.put("JSONArray", new JSONArray());
            this.jsonobject.put("int", 57);
            this.jsonobject.put("double", 1.2345678901234568E29);
            this.jsonobject.put("true", true);
            this.jsonobject.put("false", false);
            this.jsonobject.put("null", JSONObject.NULL);
            this.jsonobject.put("bool", "true");
            this.jsonobject.put("zero", -0.0);
            this.jsonobject.put("\\u2028", "\u2028");
            this.jsonobject.put("\\u2029", "\u2029");
            this.jsonarray = this.jsonobject.getJSONArray("foo");
            this.jsonarray.put(666);
            this.jsonarray.put(2001.99);
            this.jsonarray.put("so \"fine\".");
            this.jsonarray.put("so <fine>.");
            this.jsonarray.put(true);
            this.jsonarray.put(false);
            this.jsonarray.put(new JSONArray());
            this.jsonarray.put(new JSONObject());
            this.jsonobject.put("keys", JSONObject.getNames(this.jsonobject));
            TestJSONObject.assertEquals((String)"{\n    \"to\": null,\n    \"ten\": 10,\n    \"JSONObject\": {},\n    \"JSONArray\": [],\n    \"op\": \"Good\",\n    \"keys\": [\n        \"to\",\n        \"ten\",\n        \"JSONObject\",\n        \"JSONArray\",\n        \"op\",\n        \"int\",\n        \"true\",\n        \"foo\",\n        \"zero\",\n        \"double\",\n        \"String\",\n        \"false\",\n        \"bool\",\n        \"\\\\u2028\",\n        \"\\\\u2029\",\n        \"null\"\n    ],\n    \"int\": 57,\n    \"true\": true,\n    \"foo\": [\n        true,\n        false,\n        9876543210,\n        0,\n        1.00000001,\n        1.000000000001,\n        1,\n        1.0E-17,\n        2,\n        0.1,\n        2.0E100,\n        -32,\n        [],\n        {},\n        \"string\",\n        666,\n        2001.99,\n        \"so \\\"fine\\\".\",\n        \"so <fine>.\",\n        true,\n        false,\n        [],\n        {}\n    ],\n    \"zero\": -0,\n    \"double\": 1.2345678901234568E29,\n    \"String\": \"98.6\",\n    \"false\": false,\n    \"bool\": \"true\",\n    \"\\\\u2028\": \"\\u2028\",\n    \"\\\\u2029\": \"\\u2029\",\n    \"null\": null\n}", (String)this.jsonobject.toString(4));
            TestJSONObject.assertEquals((String)"<to>null</to><ten>10</ten><JSONObject></JSONObject><op>Good</op><keys>to</keys><keys>ten</keys><keys>JSONObject</keys><keys>JSONArray</keys><keys>op</keys><keys>int</keys><keys>true</keys><keys>foo</keys><keys>zero</keys><keys>double</keys><keys>String</keys><keys>false</keys><keys>bool</keys><keys>\\u2028</keys><keys>\\u2029</keys><keys>null</keys><int>57</int><true>true</true><foo>true</foo><foo>false</foo><foo>9876543210</foo><foo>0.0</foo><foo>1.00000001</foo><foo>1.000000000001</foo><foo>1.0</foo><foo>1.0E-17</foo><foo>2.0</foo><foo>0.1</foo><foo>2.0E100</foo><foo>-32</foo><foo></foo><foo></foo><foo>string</foo><foo>666</foo><foo>2001.99</foo><foo>so &quot;fine&quot;.</foo><foo>so &lt;fine&gt;.</foo><foo>true</foo><foo>false</foo><foo></foo><foo></foo><zero>-0.0</zero><double>1.2345678901234568E29</double><String>98.6</String><false>false</false><bool>true</bool><\\u2028>\u2028</\\u2028><\\u2029>\u2029</\\u2029><null>null</null>", (String)XML.toString(this.jsonobject));
            TestJSONObject.assertEquals((double)98.6, (double)this.jsonobject.getDouble("String"), (double)this.eps);
            TestJSONObject.assertTrue((boolean)this.jsonobject.getBoolean("bool"));
            TestJSONObject.assertEquals((String)"[true,false,9876543210,0,1.00000001,1.000000000001,1,1.0E-17,2,0.1,2.0E100,-32,[],{},\"string\",666,2001.99,\"so \\\"fine\\\".\",\"so <fine>.\",true,false,[],{}]", (String)this.jsonobject.getJSONArray("foo").toString());
            TestJSONObject.assertEquals((String)"Good", (String)this.jsonobject.getString("op"));
            TestJSONObject.assertEquals((int)10, (int)this.jsonobject.getInt("ten"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.optBoolean("oops"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.toString());
        }
    }

    public void testMultipleThings2() {
        try {
            this.jsonobject = new JSONObject("{string: \"98.6\", long: 2147483648, int: 2147483647, longer: 9223372036854775807, double: 9223372036854775808}");
            TestJSONObject.assertEquals((String)"{\n \"int\": 2147483647,\n \"string\": \"98.6\",\n \"longer\": 9223372036854775807,\n \"double\": \"9223372036854775808\",\n \"long\": 2147483648\n}", (String)this.jsonobject.toString(1));
            TestJSONObject.assertEquals((int)Integer.MAX_VALUE, (int)this.jsonobject.getInt("int"));
            TestJSONObject.assertEquals((int)Integer.MIN_VALUE, (int)this.jsonobject.getInt("long"));
            TestJSONObject.assertEquals((int)-1, (int)this.jsonobject.getInt("longer"));
            try {
                this.jsonobject.getInt("double");
                TestJSONObject.fail((String)"should fail with - JSONObject[\"double\"] is not an int.");
            }
            catch (JSONException expected) {
                TestJSONObject.assertEquals((String)"JSONObject[\"double\"] is not an int.", (String)expected.getMessage());
            }
            try {
                this.jsonobject.getInt("string");
                TestJSONObject.fail((String)"should fail with - JSONObject[\"string\"] is not an int.");
            }
            catch (JSONException expected) {
                TestJSONObject.assertEquals((String)"JSONObject[\"string\"] is not an int.", (String)expected.getMessage());
            }
            TestJSONObject.assertEquals((long)Integer.MAX_VALUE, (long)this.jsonobject.getLong("int"));
            TestJSONObject.assertEquals((long)0x80000000L, (long)this.jsonobject.getLong("long"));
            TestJSONObject.assertEquals((long)Long.MAX_VALUE, (long)this.jsonobject.getLong("longer"));
            try {
                this.jsonobject.getLong("double");
                TestJSONObject.fail((String)"should fail with - JSONObject[\"double\"] is not a long.");
            }
            catch (JSONException expected) {
                TestJSONObject.assertEquals((String)"JSONObject[\"double\"] is not a long.", (String)expected.getMessage());
            }
            try {
                this.jsonobject.getLong("string");
                TestJSONObject.fail((String)"should fail with - JSONObject[\"string\"] is not a long.");
            }
            catch (JSONException expected) {
                TestJSONObject.assertEquals((String)"JSONObject[\"string\"] is not a long.", (String)expected.getMessage());
            }
            TestJSONObject.assertEquals((double)2.147483647E9, (double)this.jsonobject.getDouble("int"), (double)this.eps);
            TestJSONObject.assertEquals((double)2.147483648E9, (double)this.jsonobject.getDouble("long"), (double)this.eps);
            TestJSONObject.assertEquals((double)9.223372036854776E18, (double)this.jsonobject.getDouble("longer"), (double)this.eps);
            TestJSONObject.assertEquals((double)9.223372036854776E18, (double)this.jsonobject.getDouble("double"), (double)this.eps);
            TestJSONObject.assertEquals((double)98.6, (double)this.jsonobject.getDouble("string"), (double)this.eps);
            this.jsonobject.put("good sized", Long.MAX_VALUE);
            TestJSONObject.assertEquals((String)"{\n \"int\": 2147483647,\n \"string\": \"98.6\",\n \"longer\": 9223372036854775807,\n \"good sized\": 9223372036854775807,\n \"double\": \"9223372036854775808\",\n \"long\": 2147483648\n}", (String)this.jsonobject.toString(1));
            this.jsonarray = new JSONArray("[2147483647, 2147483648, 9223372036854775807, 9223372036854775808]");
            TestJSONObject.assertEquals((String)"[\n 2147483647,\n 2147483648,\n 9223372036854775807,\n \"9223372036854775808\"\n]", (String)this.jsonarray.toString(1));
            ArrayList<String> expectedKeys = new ArrayList<String>(6);
            expectedKeys.add("int");
            expectedKeys.add("string");
            expectedKeys.add("longer");
            expectedKeys.add("good sized");
            expectedKeys.add("double");
            expectedKeys.add("long");
            this.iterator = this.jsonobject.keys();
            while (this.iterator.hasNext()) {
                this.string = this.iterator.next();
                TestJSONObject.assertTrue((boolean)expectedKeys.remove(this.string));
            }
            TestJSONObject.assertEquals((int)0, (int)expectedKeys.size());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.toString());
        }
    }

    public void testPut_CollectionAndMap() {
        try {
            this.string = "{plist=Apple; AnimalSmells = { pig = piggish; lamb = lambish; worm = wormy; }; AnimalSounds = { pig = oink; lamb = baa; worm = baa;  Lisa = \"Why is the worm talking like a lamb?\" } ; AnimalColors = { pig = pink; lamb = black; worm = pink; } } ";
            this.jsonobject = new JSONObject(this.string);
            TestJSONObject.assertEquals((String)"{\"AnimalColors\":{\"worm\":\"pink\",\"lamb\":\"black\",\"pig\":\"pink\"},\"plist\":\"Apple\",\"AnimalSounds\":{\"worm\":\"baa\",\"Lisa\":\"Why is the worm talking like a lamb?\",\"lamb\":\"baa\",\"pig\":\"oink\"},\"AnimalSmells\":{\"worm\":\"wormy\",\"lamb\":\"lambish\",\"pig\":\"piggish\"}}", (String)this.jsonobject.toString());
            Collection collection = null;
            Map map = null;
            this.jsonobject = new JSONObject(map);
            this.jsonarray = new JSONArray(collection);
            this.jsonobject.append("stooge", "Joe DeRita");
            this.jsonobject.append("stooge", "Shemp");
            this.jsonobject.accumulate("stooges", "Curly");
            this.jsonobject.accumulate("stooges", "Larry");
            this.jsonobject.accumulate("stooges", "Moe");
            this.jsonobject.accumulate("stoogearray", this.jsonobject.get("stooges"));
            this.jsonobject.put("map", map);
            this.jsonobject.put("collection", collection);
            this.jsonobject.put("array", this.jsonarray);
            this.jsonarray.put(map);
            this.jsonarray.put(collection);
            TestJSONObject.assertEquals((String)"{\"stooge\":[\"Joe DeRita\",\"Shemp\"],\"map\":{},\"stooges\":[\"Curly\",\"Larry\",\"Moe\"],\"collection\":[],\"stoogearray\":[[\"Curly\",\"Larry\",\"Moe\"]],\"array\":[{},[]]}", (String)this.jsonobject.toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testAccumulate() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.accumulate("stooge", "Curly");
            this.jsonobject.accumulate("stooge", "Larry");
            this.jsonobject.accumulate("stooge", "Moe");
            this.jsonarray = this.jsonobject.getJSONArray("stooge");
            this.jsonarray.put(5, "Shemp");
            TestJSONObject.assertEquals((String)"{\"stooge\": [\n    \"Curly\",\n    \"Larry\",\n    \"Moe\",\n    null,\n    null,\n    \"Shemp\"\n]}", (String)this.jsonobject.toString(4));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testWrite() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.accumulate("stooge", "Curly");
            this.jsonobject.accumulate("stooge", "Larry");
            this.jsonobject.accumulate("stooge", "Moe");
            this.jsonarray = this.jsonobject.getJSONArray("stooge");
            this.jsonarray.put(5, "Shemp");
            TestJSONObject.assertEquals((String)"{\"stooge\":[\"Curly\",\"Larry\",\"Moe\",null,null,\"Shemp\"]}", (String)this.jsonobject.write(new StringWriter()).toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testToString_Html() {
        try {
            this.jsonobject = new JSONObject("{script: 'It is not allowed in HTML to send a close script tag in a string<script>because it confuses browsers</script>so we insert a backslash before the /'}");
            TestJSONObject.assertEquals((String)"{\"script\":\"It is not allowed in HTML to send a close script tag in a string<script>because it confuses browsers<\\/script>so we insert a backslash before the /\"}", (String)this.jsonobject.toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testToString_MultipleTestCases() {
        try {
            this.jsonobject = new JSONObject("{ fun => with non-standard forms ; forgiving => This package can be used to parse formats that are similar to but not stricting conforming to JSON; why=To make it easier to migrate existing data to JSON,one = [[1.00]]; uno=[[{1=>1}]];'+':+6e66 ;pluses=+++;empty = '' , 'double':0.666,true: TRUE, false: FALSE, null=NULL;[true] = [[!,@;*]]; string=>  o. k. ; \r oct=0666; hex=0x666; dec=666; o=0999; noh=0x0x}");
            TestJSONObject.assertEquals((String)"{\n \"noh\": \"0x0x\",\n \"one\": [[1]],\n \"o\": 999,\n \"+\": 6.0E66,\n \"true\": true,\n \"forgiving\": \"This package can be used to parse formats that are similar to but not stricting conforming to JSON\",\n \"fun\": \"with non-standard forms\",\n \"double\": 0.666,\n \"uno\": [[{\"1\": 1}]],\n \"dec\": 666,\n \"oct\": 666,\n \"hex\": \"0x666\",\n \"string\": \"o. k.\",\n \"empty\": \"\",\n \"false\": false,\n \"[true]\": [[\n  \"!\",\n  \"@\",\n  \"*\"\n ]],\n \"pluses\": \"+++\",\n \"why\": \"To make it easier to migrate existing data to JSON\",\n \"null\": null\n}", (String)this.jsonobject.toString(1));
            TestJSONObject.assertTrue((boolean)this.jsonobject.getBoolean("true"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.getBoolean("false"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testConstructor_PriativeClass() {
        this.jsonobject = new JSONObject(new ObjectWithPrimatives());
        TestJSONObject.assertEquals((String)"{\"l\":5748548957230984584,\"m\":true,\"big\":false,\"j\":\"3\",\"k\":10.03,\"ZERO\":0,\"i\":3}", (String)this.jsonobject.toString());
    }

    public void testConstructor_SubClass() {
        ObjectWithPrimativesExtension ob = new ObjectWithPrimativesExtension();
        this.jsonobject = new JSONObject(ob);
        TestJSONObject.assertEquals((String)"{\"l\":5748548957230984584,\"m\":true,\"big\":false,\"j\":\"3\",\"k\":10.03,\"ZERO\":0,\"i\":3}", (String)this.jsonobject.toString());
    }

    public void testConstructor_PrivateClass() {
        class PrivateObject {
            private int i = 3;

            public int getI() {
                return this.i;
            }
        }
        this.jsonobject = new JSONObject(new PrivateObject());
        TestJSONObject.assertEquals((String)"{}", (String)this.jsonobject.toString());
    }

    public void testConstructor_ArrayList() {
        ArrayList<String> ar = new ArrayList<String>();
        ar.add("test1");
        ar.add("test2");
        this.jsonobject = new JSONObject(ar);
        TestJSONObject.assertEquals((String)"{\"empty\":false}", (String)this.jsonobject.toString());
    }

    public void testConstructor_ClassClass() {
        try {
            this.jsonobject = new JSONObject(((Object)((Object)this)).getClass());
            TestJSONObject.assertEquals((String)"class junit.framework.TestCase", (String)this.jsonobject.get("genericSuperclass").toString());
        }
        catch (Exception e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public static void testConstructor_FrenchResourceBundle() {
        try {
            Locale currentLocale = new Locale("fr", "CA", "UNIX");
            TestJSONObject.assertEquals((String)"{\"ASCII\":\"Number that represent chraracters\",\"JSON\":\"What are we testing?\",\"JAVA\":\"The language you are running to see this\"}", (String)new JSONObject("org.json.tests.SampleResourceBundle", currentLocale).toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public static void testConstructor_UsResourceBundle() {
        try {
            Locale currentLocale = new Locale("en", "US");
            TestJSONObject.assertEquals((String)"{\"ASCII\":\"American Standard Code for Information Interchange\",\"JSON\":\"JavaScript Object Notation\",\"JAVA\":{\"desc\":\"Just Another Vague Acronym\",\"data\":\"Sweet language\"}}", (String)new JSONObject("org.json.tests.SampleResourceBundle", currentLocale).toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testConstructor_ObjectWithStringArray() {
        TestJSONObject.assertEquals((String)"{\"m\":true,\"i\":3}", (String)new JSONObject(new ObjectWithPrimatives(), new String[]{"i", "m", "k"}).toString());
    }

    public void testOpt() {
        try {
            this.jsonobject = new JSONObject("{\"a\":2}");
            TestJSONObject.assertEquals((Object)2, (Object)this.jsonobject.opt("a"));
            TestJSONObject.assertEquals(null, (Object)this.jsonobject.opt("b"));
            TestJSONObject.assertEquals(null, (Object)this.jsonobject.opt(null));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public static void testStringToValue() {
        TestJSONObject.assertEquals((Object)"", (Object)JSONObject.stringToValue(""));
        TestJSONObject.assertEquals((Object)true, (Object)JSONObject.stringToValue("true"));
        TestJSONObject.assertEquals((Object)false, (Object)JSONObject.stringToValue("false"));
        TestJSONObject.assertEquals((Object)JSONObject.NULL, (Object)JSONObject.stringToValue("null"));
        TestJSONObject.assertEquals((Object)10, (Object)JSONObject.stringToValue("10"));
        TestJSONObject.assertEquals((Object)10000.0, (Object)JSONObject.stringToValue("10e3"));
        TestJSONObject.assertEquals((Object)10000.0, (Object)JSONObject.stringToValue("10E3"));
        TestJSONObject.assertEquals((Object)"10E3000000000", (Object)JSONObject.stringToValue("10E3000000000"));
    }

    public static void testQuote() {
        TestJSONObject.assertEquals((String)"\"\"", (String)JSONObject.quote(""));
        TestJSONObject.assertEquals((String)"\"\"", (String)JSONObject.quote(null));
        TestJSONObject.assertEquals((String)"\"true\"", (String)JSONObject.quote("true"));
        TestJSONObject.assertEquals((String)"\"10\"", (String)JSONObject.quote("10"));
        TestJSONObject.assertEquals((String)"\"\\b\\t\\n\\f\\r\"", (String)JSONObject.quote("\b\t\n\f\r"));
        TestJSONObject.assertEquals((String)"\"\\u0012\\u0085\\u2086\u2286\"", (String)JSONObject.quote("\u0012\u0085\u2086\u2286"));
    }

    public void testGetNames() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("a", "123");
            this.jsonobject.put("b", "123");
            this.jsonobject.put("c", "123");
            String[] names = JSONObject.getNames(this.jsonobject);
            TestJSONObject.assertEquals((int)3, (int)names.length);
            TestJSONObject.assertEquals((String)"b", (String)names[0]);
            TestJSONObject.assertEquals((String)"c", (String)names[1]);
            TestJSONObject.assertEquals((String)"a", (String)names[2]);
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetNames_EmptyJsonObject() {
        this.jsonobject = new JSONObject();
        TestJSONObject.assertEquals(null, (Object)JSONObject.getNames(this.jsonobject));
    }

    public void testGetNames_ObjectWithPrimatives() {
        String[] names = JSONObject.getNames(new ObjectWithPrimatives());
        TestJSONObject.assertEquals((int)2, (int)names.length);
        TestJSONObject.assertEquals((String)"i", (String)names[0]);
        TestJSONObject.assertEquals((String)"m", (String)names[1]);
    }

    public static void testGetNames_EmptyObject() {
        class EmptyObject {
            EmptyObject() {
            }
        }
        TestJSONObject.assertEquals(null, (Object)JSONObject.getNames(new EmptyObject()));
    }

    public static void testGetNames_Null() {
        Object owp = null;
        TestJSONObject.assertEquals(null, (Object)JSONObject.getNames(owp));
    }

    public void testGetLong_Long() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "98765432");
            this.jsonobject.put("123", 98765432);
            TestJSONObject.assertEquals((long)98765432L, (long)this.jsonobject.getLong("abc"));
            TestJSONObject.assertEquals((long)98765432L, (long)this.jsonobject.getLong("123"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetJsonObject_JsonObject() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", new JSONObject());
            TestJSONObject.assertEquals((String)"{}", (String)this.jsonobject.getJSONObject("abc").toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetJsonObject_Int() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", 45);
            this.jsonobject.getJSONObject("abc");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] is not a JSONObject.", (String)e.getMessage());
        }
    }

    public void testGetJsonObject_InvalidKey() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.getJSONObject("abc");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] not found.", (String)e.getMessage());
        }
    }

    public void testGetJsonArray_JsonArray() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", new JSONArray());
            TestJSONObject.assertEquals((String)"[]", (String)this.jsonobject.getJSONArray("abc").toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetJsonArray_Int() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", 45);
            this.jsonobject.getJSONArray("abc");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] is not a JSONArray.", (String)e.getMessage());
        }
    }

    public void testGetJsonArray_InvalidKey() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.getJSONArray("abc");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] not found.", (String)e.getMessage());
        }
    }

    public void testGetInt_Int() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", 45);
            TestJSONObject.assertEquals((int)45, (int)this.jsonobject.getInt("abc"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetInt_IntString() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "45");
            TestJSONObject.assertEquals((int)45, (int)this.jsonobject.getInt("abc"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetInt_LetterString() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "def");
            this.jsonobject.getInt("abc");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] is not an int.", (String)e.getMessage());
        }
    }

    public void testGetInt_InvalidKey() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.getInt("abc");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] not found.", (String)e.getMessage());
        }
    }

    public void testGetDouble_Double() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", 45.1);
            TestJSONObject.assertEquals((Object)45.1, (Object)this.jsonobject.getDouble("abc"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetDouble_DoubleString() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "45.20");
            TestJSONObject.assertEquals((Object)45.2, (Object)this.jsonobject.getDouble("abc"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetDouble_LetterString() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "def");
            this.jsonobject.getDouble("abc");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] is not a number.", (String)e.getMessage());
        }
    }

    public void testGetDouble_InvalidKey() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.getDouble("abc");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] not found.", (String)e.getMessage());
        }
    }

    public void testGetBoolean_Boolean() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", true);
            this.jsonobject.put("123", false);
            TestJSONObject.assertTrue((boolean)this.jsonobject.getBoolean("abc"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.getBoolean("123"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetBoolean_BooleanString() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "true");
            this.jsonobject.put("123", "false");
            this.jsonobject.put("ABC", "TRUE");
            this.jsonobject.put("456", "FALSE");
            TestJSONObject.assertTrue((boolean)this.jsonobject.getBoolean("abc"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.getBoolean("123"));
            TestJSONObject.assertTrue((boolean)this.jsonobject.getBoolean("ABC"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.getBoolean("456"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetBoolean_LetterString() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "def");
            this.jsonobject.getBoolean("abc");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] is not a Boolean.", (String)e.getMessage());
        }
    }

    public void testGetBoolean_Int() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", 45);
            this.jsonobject.getBoolean("abc");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] is not a Boolean.", (String)e.getMessage());
        }
    }

    public void testGetBoolean_InvalidKey() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.getBoolean("abc");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] not found.", (String)e.getMessage());
        }
    }

    public void testGet_NullKey() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.get(null);
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"Null key.", (String)e.getMessage());
        }
    }

    public void testToString_Indents() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "123");
            this.jsonobject.put("1235", new JSONObject().put("abc", "123"));
            this.jsonobject.put("1234", "abc");
            this.jsonobject.put("1239", new JSONObject().put("1fd23", new JSONObject()).put("12gfdgfg3", new JSONObject().put("f123", "123").put("12fgfg3", "abc")));
            TestJSONObject.assertEquals((String)"{\n    \"1234\": \"abc\",\n    \"1235\": {\"abc\": \"123\"},\n    \"123\": \"123\",\n    \"1239\": {\n        \"1fd23\": {},\n        \"12gfdgfg3\": {\n            \"f123\": \"123\",\n            \"12fgfg3\": \"abc\"\n        }\n    }\n}", (String)this.jsonobject.toString(4));
            TestJSONObject.assertEquals((String)"{\"1gg23\": \"123\"}", (String)new JSONObject().put("1gg23", "123").toString(4));
            TestJSONObject.assertEquals((String)"{}", (String)new JSONObject().toString(4));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testToString_Exception() {
        try {
            this.jsonobject.put("abc", new BadJsonString());
            TestJSONObject.assertEquals(null, (String)this.jsonobject.toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public static void testNumberToString() {
        try {
            TestJSONObject.assertEquals((String)"30.7", (String)JSONObject.numberToString(30.7));
            TestJSONObject.assertEquals((String)"3.0E71", (String)JSONObject.numberToString(3.0E71));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public static void testNumberToString_Null() {
        try {
            JSONObject.numberToString(null);
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"Null pointer", (String)e.getMessage());
        }
    }

    public void testWrap() {
        try {
            TestJSONObject.assertEquals((Object)true, (Object)JSONObject.wrap(true));
            TestJSONObject.assertEquals((Object)35, (Object)JSONObject.wrap(35));
            TestJSONObject.assertEquals((Object)35.5, (Object)JSONObject.wrap(35.5));
            TestJSONObject.assertEquals((Object)56456456L, (Object)JSONObject.wrap(56456456L));
            TestJSONObject.assertEquals((Object)JSONObject.NULL, (Object)JSONObject.wrap(null));
            TestJSONObject.assertEquals((Object)JSONObject.NULL, (Object)JSONObject.wrap(JSONObject.NULL));
            BadJsonString a = new BadJsonString();
            TestJSONObject.assertEquals((Object)a, (Object)JSONObject.wrap(a));
            NullJsonString q = new NullJsonString();
            TestJSONObject.assertEquals((Object)q, (Object)JSONObject.wrap(q));
            TestJSONObject.assertEquals((Object)12, (Object)JSONObject.wrap((short)12));
            TestJSONObject.assertEquals((Object)Character.valueOf('a'), (Object)JSONObject.wrap(Character.valueOf('a')));
            TestJSONObject.assertEquals((Object)15, (Object)JSONObject.wrap((byte)15));
            TestJSONObject.assertEquals((Object)Float.valueOf(15.2f), (Object)JSONObject.wrap(Float.valueOf(15.2f)));
            JSONObject b = new JSONObject().put("abc", "123");
            TestJSONObject.assertEquals((Object)b, (Object)JSONObject.wrap(b));
            JSONArray c = new JSONArray().put("abc");
            TestJSONObject.assertEquals((Object)c, (Object)JSONObject.wrap(c));
            Stack<String> stringCol = new Stack<String>();
            stringCol.add("string1");
            TestJSONObject.assertEquals((String)"[\"string1\"]", (String)JSONObject.wrap(stringCol).toString());
            TestJSONObject.assertEquals((String)"[\"abc\",\"123\"]", (String)JSONObject.wrap(new String[]{"abc", "123"}).toString());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("abc", "123");
            TestJSONObject.assertEquals((String)"{\"abc\":\"123\"}", (String)JSONObject.wrap(map).toString());
            TestJSONObject.assertEquals((Object)"java.io.IOException", (Object)JSONObject.wrap(new IOException()));
            Class<?> d = ((Object)((Object)this)).getClass();
            TestJSONObject.assertEquals((Object)"class org.json.tests.TestJSONObject", (Object)JSONObject.wrap(d));
            class TestClass {
                TestClass() {
                }
            }
            TestJSONObject.assertEquals((String)"{}", (String)JSONObject.wrap(new TestClass()).toString());
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class BadCollection<E>
                implements Collection<E> {
                    BadCollection() {
                    }

                    @Override
                    public int size() {
                        return 0;
                    }

                    @Override
                    public boolean isEmpty() {
                        return false;
                    }

                    @Override
                    public boolean contains(Object o) {
                        return false;
                    }

                    @Override
                    public Iterator<E> iterator() {
                        Iterator[] i = new Iterator[]{};
                        return i[1];
                    }

                    @Override
                    public Object[] toArray() {
                        return null;
                    }

                    @Override
                    public Object[] toArray(Object[] Type2) {
                        return null;
                    }

                    @Override
                    public boolean add(Object e) {
                        return false;
                    }

                    @Override
                    public boolean remove(Object o) {
                        return false;
                    }

                    @Override
                    public boolean containsAll(Collection<?> collection) {
                        return false;
                    }

                    @Override
                    public boolean addAll(Collection<? extends E> collection) {
                        return false;
                    }

                    @Override
                    public boolean removeAll(Collection<?> collection) {
                        return false;
                    }

                    @Override
                    public boolean retainAll(Collection<?> collection) {
                        return false;
                    }

                    @Override
                    public void clear() {
                    }
                }
                JSONObject.wrap(new BadCollection()).toString();
                TestJSONObject.fail((String)"Should have thrown exception.");
            }
            catch (Exception e) {
                TestJSONObject.assertEquals(null, (String)e.getMessage());
            }
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testWriter() {
        try {
            StringWriter sw = new StringWriter();
            this.jsonobject = new JSONObject();
            this.jsonobject.put("1ghr23", "123");
            this.jsonobject.put("1ss23", "-12");
            this.jsonobject.put("1tr23", 45);
            this.jsonobject.put("1trt23", -98);
            this.jsonobject.put("1hh23", new JSONObject().put("123", "abc"));
            this.jsonobject.put("1er23", "-12");
            this.jsonobject.put("1re23", "abc");
            this.jsonobject.put("1fde23", "123");
            this.jsonobject.put("1fd23", "123");
            this.jsonobject.put("1ffdsf23", new JSONObject().put("abc", "123"));
            this.jsonobject.put("fd123", "abc");
            this.jsonobject.put("12fdsf3", "123");
            this.jsonobject.write(sw);
            TestJSONObject.assertEquals((String)"{\"1tr23\":45,\"1ss23\":\"-12\",\"1fd23\":\"123\",\"1trt23\":-98,\"1ffdsf23\":{\"abc\":\"123\"},\"1ghr23\":\"123\",\"1fde23\":\"123\",\"fd123\":\"abc\",\"12fdsf3\":\"123\",\"1hh23\":{\"123\":\"abc\"},\"1re23\":\"abc\",\"1er23\":\"-12\"}", (String)sw.toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testWriter_BadWriter() {
        try {
            class BadWriter
            extends Writer {
                BadWriter() {
                }

                public void write(char[] cbuf, int off, int len) throws IOException {
                    throw new IOException("Test Message From Bad Writer");
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                }
            }
            BadWriter sw = new BadWriter();
            this.jsonobject = new JSONObject();
            this.jsonobject.put("1ghr23", "123");
            this.jsonobject.put("1ss23", "-12");
            this.jsonobject.put("1tr23", 45);
            this.jsonobject.put("1trt23", -98);
            this.jsonobject.put("1hh23", new JSONObject().put("123", "abc"));
            this.jsonobject.put("1er23", "-12");
            this.jsonobject.put("1re23", "abc");
            this.jsonobject.put("1fde23", "123");
            this.jsonobject.put("1fd23", "123");
            this.jsonobject.put("1ffdsf23", new JSONObject().put("abc", "123"));
            this.jsonobject.put("fd123", "abc");
            this.jsonobject.put("12fdsf3", "123");
            this.jsonobject.write(sw);
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"Test Message From Bad Writer", (String)e.getMessage());
        }
    }

    public void testIncrement() {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("1ghr23", 30.56);
            map.put("1ss23", -12.22);
            map.put("1tr23", 45);
            map.put("1trt23", -98);
            map.put("1hh23", Float.valueOf(12.6f));
            map.put("1er23", Float.valueOf(-456.255f));
            map.put("1re23", 5543L);
            map.put("1fde23", -46546546L);
            this.jsonobject = new JSONObject(map);
            this.jsonobject.increment("1ghr23");
            this.jsonobject.increment("1ss23");
            this.jsonobject.increment("1tr23");
            this.jsonobject.increment("1trt23");
            this.jsonobject.increment("1hh23");
            this.jsonobject.increment("1er23");
            this.jsonobject.increment("1re23");
            this.jsonobject.increment("1fde23");
            TestJSONObject.assertEquals((Object)31.56, (Object)this.jsonobject.get("1ghr23"));
            TestJSONObject.assertEquals((Object)-11.22, (Object)this.jsonobject.get("1ss23"));
            TestJSONObject.assertEquals((Object)46, (Object)this.jsonobject.get("1tr23"));
            TestJSONObject.assertEquals((Object)-97, (Object)this.jsonobject.get("1trt23"));
            TestJSONObject.assertEquals((double)13.6f, (double)((Double)this.jsonobject.get("1hh23")), (double)this.eps);
            TestJSONObject.assertEquals((double)-455.255f, (double)((Double)this.jsonobject.get("1er23")), (double)this.eps);
            TestJSONObject.assertEquals((Object)5544L, (Object)this.jsonobject.get("1re23"));
            TestJSONObject.assertEquals((Object)-46546545L, (Object)this.jsonobject.get("1fde23"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testIncrement_String() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "abc");
            this.jsonobject.increment("123");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"Unable to increment [\"123\"].", (String)e.getMessage());
        }
    }

    public void testGet_InvalidIndex() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("554", "123");
            this.jsonobject.get("abc");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"abc\"] not found.", (String)e.getMessage());
        }
    }

    public void testGet_ValidIndex() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "123");
            TestJSONObject.assertEquals((Object)"123", (Object)this.jsonobject.get("abc"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetBoolean() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("1gg23", "true");
            this.jsonobject.put("1dd23", "false");
            this.jsonobject.put("1ff23", true);
            this.jsonobject.put("1rr23", false);
            this.jsonobject.put("1hh23", "TRUE");
            this.jsonobject.put("1hhhgf23", "FALSE");
            TestJSONObject.assertTrue((boolean)this.jsonobject.getBoolean("1gg23"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.getBoolean("1dd23"));
            TestJSONObject.assertTrue((boolean)this.jsonobject.getBoolean("1ff23"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.getBoolean("1rr23"));
            TestJSONObject.assertTrue((boolean)this.jsonobject.getBoolean("1hh23"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.getBoolean("1hhhgf23"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetBoolean_NonBoolean() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "123");
            this.jsonobject.getBoolean("123");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"123\"] is not a Boolean.", (String)e.getMessage());
        }
    }

    public void testOptBoolean() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("1gg23", "true");
            this.jsonobject.put("1dd23", "false");
            this.jsonobject.put("1ff23", true);
            this.jsonobject.put("1rr23", false);
            this.jsonobject.put("1hh23", "TRUE");
            this.jsonobject.put("1hhhgf23", "FALSE");
            TestJSONObject.assertTrue((boolean)this.jsonobject.optBoolean("1gg23"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.optBoolean("1dd23"));
            TestJSONObject.assertTrue((boolean)this.jsonobject.optBoolean("1ff23"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.optBoolean("1rr23"));
            TestJSONObject.assertTrue((boolean)this.jsonobject.optBoolean("1hh23"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.optBoolean("1hhhgf23"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.optBoolean("chicken"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetInt() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("1gg23", "123");
            this.jsonobject.put("1g23", "-12");
            this.jsonobject.put("123", 45);
            this.jsonobject.put("1rr23", -98);
            TestJSONObject.assertEquals((int)123, (int)this.jsonobject.getInt("1gg23"));
            TestJSONObject.assertEquals((int)-12, (int)this.jsonobject.getInt("1g23"));
            TestJSONObject.assertEquals((int)45, (int)this.jsonobject.getInt("123"));
            TestJSONObject.assertEquals((int)-98, (int)this.jsonobject.getInt("1rr23"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetInt_NonInteger() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "abc");
            this.jsonobject.getInt("123");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"123\"] is not an int.", (String)e.getMessage());
        }
    }

    public void testOptInt() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("1gg23", "123");
            this.jsonobject.put("1g23", "-12");
            this.jsonobject.put("123", 45);
            this.jsonobject.put("1rr23", -98);
            TestJSONObject.assertEquals((int)123, (int)this.jsonobject.optInt("1gg23"));
            TestJSONObject.assertEquals((int)-12, (int)this.jsonobject.optInt("1g23"));
            TestJSONObject.assertEquals((int)45, (int)this.jsonobject.optInt("123"));
            TestJSONObject.assertEquals((int)-98, (int)this.jsonobject.optInt("1rr23"));
            TestJSONObject.assertEquals((int)0, (int)this.jsonobject.optInt("catfish"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetDouble() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "123");
            this.jsonobject.put("1fd23", "-12");
            this.jsonobject.put("1gfd23", 45);
            this.jsonobject.put("1gg23", -98);
            this.jsonobject.put("1f23", "123.5");
            this.jsonobject.put("1ss23", "-12.87");
            this.jsonobject.put("1ew23", 45.22);
            this.jsonobject.put("1tt23", -98.18);
            TestJSONObject.assertEquals((Object)123.0, (Object)this.jsonobject.getDouble("123"));
            TestJSONObject.assertEquals((Object)-12.0, (Object)this.jsonobject.getDouble("1fd23"));
            TestJSONObject.assertEquals((Object)45.0, (Object)this.jsonobject.getDouble("1gfd23"));
            TestJSONObject.assertEquals((Object)-98.0, (Object)this.jsonobject.getDouble("1gg23"));
            TestJSONObject.assertEquals((Object)123.5, (Object)this.jsonobject.getDouble("1f23"));
            TestJSONObject.assertEquals((Object)-12.87, (Object)this.jsonobject.getDouble("1ss23"));
            TestJSONObject.assertEquals((Object)45.22, (Object)this.jsonobject.getDouble("1ew23"));
            TestJSONObject.assertEquals((Object)-98.18, (Object)this.jsonobject.getDouble("1tt23"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetDouble_NonDouble() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "abc");
            this.jsonobject.getDouble("123");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"123\"] is not a number.", (String)e.getMessage());
        }
    }

    public void testOptDouble() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "123");
            this.jsonobject.put("1fd23", "-12");
            this.jsonobject.put("1gfd23", 45);
            this.jsonobject.put("1gg23", -98);
            this.jsonobject.put("1f23", "123.5");
            this.jsonobject.put("1ss23", "-12.87");
            this.jsonobject.put("1ew23", 45.22);
            this.jsonobject.put("1tt23", -98.18);
            TestJSONObject.assertEquals((Object)123.0, (Object)this.jsonobject.optDouble("123"));
            TestJSONObject.assertEquals((Object)-12.0, (Object)this.jsonobject.optDouble("1fd23"));
            TestJSONObject.assertEquals((Object)45.0, (Object)this.jsonobject.optDouble("1gfd23"));
            TestJSONObject.assertEquals((Object)-98.0, (Object)this.jsonobject.optDouble("1gg23"));
            TestJSONObject.assertEquals((Object)123.5, (Object)this.jsonobject.optDouble("1f23"));
            TestJSONObject.assertEquals((Object)-12.87, (Object)this.jsonobject.optDouble("1ss23"));
            TestJSONObject.assertEquals((Object)45.22, (Object)this.jsonobject.optDouble("1ew23"));
            TestJSONObject.assertEquals((Object)-98.18, (Object)this.jsonobject.optDouble("1tt23"));
            TestJSONObject.assertEquals((Object)Double.NaN, (Object)this.jsonobject.optDouble("rabbit"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetLong() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "123");
            this.jsonobject.put("12gh3", "-12");
            this.jsonobject.put("1f23", 45L);
            this.jsonobject.put("1re23", -98L);
            TestJSONObject.assertEquals((long)123L, (long)this.jsonobject.getLong("123"));
            TestJSONObject.assertEquals((long)-12L, (long)this.jsonobject.getLong("12gh3"));
            TestJSONObject.assertEquals((long)45L, (long)this.jsonobject.getLong("1f23"));
            TestJSONObject.assertEquals((long)-98L, (long)this.jsonobject.getLong("1re23"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetLong_NonLong() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "abc");
            this.jsonobject.getLong("123");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"123\"] is not a long.", (String)e.getMessage());
        }
    }

    public void testOptLong() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "123");
            this.jsonobject.put("12gh3", "-12");
            this.jsonobject.put("1f23", 45L);
            this.jsonobject.put("1re23", -98L);
            TestJSONObject.assertEquals((long)123L, (long)this.jsonobject.optLong("123"));
            TestJSONObject.assertEquals((long)-12L, (long)this.jsonobject.optLong("12gh3"));
            TestJSONObject.assertEquals((long)45L, (long)this.jsonobject.optLong("1f23"));
            TestJSONObject.assertEquals((long)-98L, (long)this.jsonobject.optLong("1re23"));
            TestJSONObject.assertEquals((long)0L, (long)this.jsonobject.optLong("randomString"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetString() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "123");
            this.jsonobject.put("12gf3", "-12");
            this.jsonobject.put("1fg23", "abc");
            this.jsonobject.put("1d23", "123");
            TestJSONObject.assertEquals((String)"123", (String)this.jsonobject.getString("123"));
            TestJSONObject.assertEquals((String)"-12", (String)this.jsonobject.getString("12gf3"));
            TestJSONObject.assertEquals((String)"abc", (String)this.jsonobject.getString("1fg23"));
            TestJSONObject.assertEquals((String)"123", (String)this.jsonobject.getString("1d23"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testGetString_NonString() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", 123);
            this.jsonobject.getString("123");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"JSONObject[\"123\"] not a string.", (String)e.getMessage());
        }
    }

    public void testOptString() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "123");
            this.jsonobject.put("12gf3", "-12");
            this.jsonobject.put("1fg23", "abc");
            this.jsonobject.put("1d23", "123");
            TestJSONObject.assertEquals((String)"123", (String)this.jsonobject.optString("123"));
            TestJSONObject.assertEquals((String)"-12", (String)this.jsonobject.optString("12gf3"));
            TestJSONObject.assertEquals((String)"abc", (String)this.jsonobject.optString("1fg23"));
            TestJSONObject.assertEquals((String)"123", (String)this.jsonobject.optString("1d23"));
            TestJSONObject.assertEquals((String)"", (String)this.jsonobject.optString("pandora"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testOptJSONObject_SimpleObject() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", new JSONObject().put("abc", "123"));
            TestJSONObject.assertEquals((String)"{\"abc\":\"123\"}", (String)this.jsonobject.optJSONObject("123").toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testOptJSONObject_NonJsonObject() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "123");
            TestJSONObject.assertEquals(null, (Object)this.jsonobject.optJSONObject("123"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testOptJSONArray() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", new JSONArray().put("abc"));
            TestJSONObject.assertEquals((String)"[\"abc\"]", (String)this.jsonobject.optJSONArray("123").toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testOptJSONArray_NonJsonArray() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "123");
            TestJSONObject.assertEquals(null, (Object)this.jsonobject.optJSONArray("123"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testHas() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("123", "123");
            TestJSONObject.assertTrue((boolean)this.jsonobject.has("123"));
            TestJSONObject.assertFalse((boolean)this.jsonobject.has("124"));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testAppend() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("string", "123");
            this.jsonobject.put("jsonarray", new JSONArray().put("abc"));
            this.jsonobject.append("jsonarray", "123");
            this.jsonobject.append("george", "def");
            try {
                this.jsonobject.append("string", "abc");
                TestJSONObject.fail((String)"Should have thrown exception.");
            }
            catch (JSONException e) {
                TestJSONObject.assertEquals((String)"JSONObject[string] is not a JSONArray.", (String)e.getMessage());
            }
            TestJSONObject.assertEquals((String)"{\"george\":[\"def\"],\"string\":\"123\",\"jsonarray\":[\"abc\",\"123\"]}", (String)this.jsonobject.toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testConstuctor_Strings() {
        try {
            this.jsonobject = new JSONObject("123");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"A JSONObject text must begin with '{' at 1 [character 2 line 1]", (String)e.getMessage());
        }
        try {
            this.jsonobject = new JSONObject("{\"123\":34");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"Expected a ',' or '}' at 10 [character 11 line 1]", (String)e.getMessage());
        }
        try {
            this.jsonobject = new JSONObject("{\"123\",34}");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"Expected a ':' after a key at 7 [character 8 line 1]", (String)e.getMessage());
        }
        try {
            this.jsonobject = new JSONObject("{");
            TestJSONObject.fail((String)"Should have thrown exception.");
        }
        catch (JSONException e) {
            TestJSONObject.assertEquals((String)"A JSONObject text must end with '}' at 2 [character 3 line 1]", (String)e.getMessage());
        }
    }

    public static void testTestValidity() {
        try {
            JSONObject.testValidity(null);
            JSONObject.testValidity(50.4);
            JSONObject.testValidity(70.8);
            JSONObject.testValidity(Float.valueOf(50.4f));
            JSONObject.testValidity(Float.valueOf(70.8f));
            try {
                JSONObject.testValidity(Double.NaN);
                TestJSONObject.fail((String)"Should have throw exception.");
            }
            catch (JSONException e) {
                TestJSONObject.assertEquals((String)"JSON does not allow non-finite numbers.", (String)e.getMessage());
            }
            try {
                JSONObject.testValidity(Double.NEGATIVE_INFINITY);
                TestJSONObject.fail((String)"Should have throw exception.");
            }
            catch (JSONException e) {
                TestJSONObject.assertEquals((String)"JSON does not allow non-finite numbers.", (String)e.getMessage());
            }
            try {
                JSONObject.testValidity(Double.POSITIVE_INFINITY);
                TestJSONObject.fail((String)"Should have throw exception.");
            }
            catch (JSONException e) {
                TestJSONObject.assertEquals((String)"JSON does not allow non-finite numbers.", (String)e.getMessage());
            }
            try {
                JSONObject.testValidity(Float.valueOf(Float.NaN));
                TestJSONObject.fail((String)"Should have throw exception.");
            }
            catch (JSONException e) {
                TestJSONObject.assertEquals((String)"JSON does not allow non-finite numbers.", (String)e.getMessage());
            }
            try {
                JSONObject.testValidity(Float.valueOf(Float.NEGATIVE_INFINITY));
                TestJSONObject.fail((String)"Should have throw exception.");
            }
            catch (JSONException e) {
                TestJSONObject.assertEquals((String)"JSON does not allow non-finite numbers.", (String)e.getMessage());
            }
            try {
                JSONObject.testValidity(Float.valueOf(Float.POSITIVE_INFINITY));
                TestJSONObject.fail((String)"Should have throw exception.");
            }
            catch (JSONException e) {
                TestJSONObject.assertEquals((String)"JSON does not allow non-finite numbers.", (String)e.getMessage());
            }
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testNames() {
        try {
            this.jsonobject = new JSONObject();
            TestJSONObject.assertEquals(null, (Object)this.jsonobject.names());
            this.jsonobject.put("abc", "123");
            TestJSONObject.assertEquals((String)"[\"abc\"]", (String)this.jsonobject.names().toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testConstructor_CopySubset() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "123");
            this.jsonobject.put("abcd", "1234");
            this.jsonobject.put("abcde", "12345");
            this.jsonobject.put("abcdef", "123456");
            TestJSONObject.assertEquals((String)"{\"abc\":\"123\",\"abcde\":\"12345\"}", (String)new JSONObject(this.jsonobject, new String[]{"abc", "abc", "abcde"}).toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testPutOnce() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.putOnce("abc", "123").putOnce("abcd", "1234").putOnce(null, "12345").putOnce("abcdef", null);
            TestJSONObject.assertEquals((String)"{\"abc\":\"123\",\"abcd\":\"1234\"}", (String)this.jsonobject.toString());
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testToJsonArray() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "123");
            this.jsonobject.put("abcd", "1234");
            this.jsonobject.put("abcde", "12345");
            this.jsonobject.put("abcdef", "123456");
            TestJSONObject.assertEquals((String)"[\"123\",\"123\",\"12345\"]", (String)this.jsonobject.toJSONArray(new JSONArray(new String[]{"abc", "abc", "abcde"})).toString());
            TestJSONObject.assertEquals(null, (Object)this.jsonobject.toJSONArray(new JSONArray()));
            TestJSONObject.assertEquals(null, (Object)this.jsonobject.toJSONArray(null));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testValueToString() {
        try {
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "123");
            this.jsonobject.put("abcd", "1234");
            BadJsonString bjs = new BadJsonString();
            this.jsonobject.put("cd", bjs);
            this.jsonobject.put("acd", new GoodJsonString());
            NullJsonString q = new NullJsonString();
            this.jsonobject.put("zzz", q);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("abc", "123");
            Stack<String> stringCol = new Stack<String>();
            stringCol.add("string1");
            this.jsonobject.put("de", map);
            this.jsonobject.put("e", stringCol);
            this.jsonobject.put("abcde", new JSONArray().put("123"));
            this.jsonobject.put("abcdef", new JSONObject().put("123", "123456"));
            Object nulljo = null;
            Object nullja = null;
            this.jsonobject.put("bcde", (Object)nulljo);
            this.jsonobject.put("bcdef", (Object)nullja);
            TestJSONObject.assertEquals((String)("{\n    \"de\": {\"abc\": \"123\"},\n    \"abc\": \"123\",\n    \"e\": [\"string1\"],\n    \"zzz\": \"" + q.toString() + "\",\n    \"abcdef\": {\"123\": \"123456\"},\n    \"abcde\": [\"123\"],\n    \"acd\": jsonstring,\n    \"abcd\": \"1234\",\n    \"cd\": \"" + bjs.toString() + "\"\n}"), (String)this.jsonobject.toString(4));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public void testValueToString_Object() {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("abcd", "1234");
            Stack<String> stringCol = new Stack<String>();
            stringCol.add("string1");
            this.jsonobject = new JSONObject();
            this.jsonobject.put("abc", "123");
            TestJSONObject.assertEquals((String)"{\"abc\":\"123\"}", (String)JSONObject.valueToString(this.jsonobject));
            TestJSONObject.assertEquals((String)"{\"abcd\":\"1234\"}", (String)JSONObject.valueToString(map));
            TestJSONObject.assertEquals((String)"[\"string1\"]", (String)JSONObject.valueToString(stringCol));
            try {
                JSONObject.valueToString(new BadJsonString());
                TestJSONObject.fail((String)"Should have thrown exception.");
            }
            catch (JSONException e) {
                TestJSONObject.assertEquals((String)"1", (String)e.getMessage());
            }
            try {
                JSONObject.valueToString(new NullJsonString());
                TestJSONObject.fail((String)"Should have thrown exception.");
            }
            catch (JSONException e) {
                TestJSONObject.assertEquals((String)"Bad value from toJSONString: null", (String)e.getMessage());
            }
            TestJSONObject.assertEquals((String)"jsonstring", (String)JSONObject.valueToString(new GoodJsonString()));
            TestJSONObject.assertEquals((String)"null", (String)JSONObject.valueToString(null));
            TestJSONObject.assertEquals((String)"null", (String)JSONObject.valueToString(JSONObject.NULL));
            TestJSONObject.assertEquals((String)"[\"abc\",\"123\"]", (String)JSONObject.valueToString(new String[]{"abc", "123"}));
        }
        catch (JSONException e) {
            TestJSONObject.fail((String)e.getMessage());
        }
    }

    public static void testDoubleToString() {
        TestJSONObject.assertEquals((String)"10.66", (String)JSONObject.doubleToString(10.66));
        TestJSONObject.assertEquals((String)"10", (String)JSONObject.doubleToString(10.0));
        TestJSONObject.assertEquals((String)"null", (String)JSONObject.doubleToString(Double.NaN));
        TestJSONObject.assertEquals((String)"null", (String)JSONObject.doubleToString(Double.NEGATIVE_INFINITY));
        TestJSONObject.assertEquals((String)"null", (String)JSONObject.doubleToString(Double.POSITIVE_INFINITY));
        TestJSONObject.assertEquals((String)"1.0E89", (String)JSONObject.doubleToString(1.0E89));
        TestJSONObject.assertEquals((String)"1.0E89", (String)JSONObject.doubleToString(1.0E89));
    }

    public class BadJsonString
    implements JSONString {
        public String toJSONString() {
            String[] arString = new String[]{"abc"};
            return arString[1];
        }
    }

    public class GoodJsonString
    implements JSONString {
        public String toJSONString() {
            return "jsonstring";
        }
    }

    public class NullJsonString
    implements JSONString {
        public String toJSONString() {
            return null;
        }
    }

    public class ObjectWithPrimatives {
        public int i = 3;
        private String nullString = null;
        private String j = "3";
        private double k = 10.03;
        private long l = 5748548957230984584L;
        public boolean m = true;

        public int getI() {
            return this.i;
        }

        public String getJ() {
            return this.j;
        }

        public double getK() {
            return this.k;
        }

        public long getL() {
            return this.l;
        }

        public boolean getM() {
            return this.m;
        }

        public boolean getM(Boolean test) {
            return this.m;
        }

        public String getNullString() {
            return this.nullString;
        }

        public int getZERO() {
            return 0;
        }

        public int getone() {
            return 1;
        }

        public boolean isBig() {
            return false;
        }

        private boolean isSmall() {
            return true;
        }
    }

    public class ObjectWithPrimativesExtension
    extends ObjectWithPrimatives {
    }
}

