/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.NameValueExpression;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

public class RequestMappingHandlerMapping
extends RequestMappingInfoHandlerMapping
implements EmbeddedValueResolverAware {
    private boolean useSuffixPatternMatch = true;
    private boolean useRegisteredSuffixPatternMatch = false;
    private boolean useTrailingSlashMatch = true;
    private ContentNegotiationManager contentNegotiationManager = new ContentNegotiationManager();
    private StringValueResolver embeddedValueResolver;
    private RequestMappingInfo.BuilderConfiguration config = new RequestMappingInfo.BuilderConfiguration();

    public void setUseSuffixPatternMatch(boolean useSuffixPatternMatch) {
        this.useSuffixPatternMatch = useSuffixPatternMatch;
    }

    public void setUseRegisteredSuffixPatternMatch(boolean useRegisteredSuffixPatternMatch) {
        this.useRegisteredSuffixPatternMatch = useRegisteredSuffixPatternMatch;
        this.useSuffixPatternMatch = useRegisteredSuffixPatternMatch || this.useSuffixPatternMatch;
    }

    public void setUseTrailingSlashMatch(boolean useTrailingSlashMatch) {
        this.useTrailingSlashMatch = useTrailingSlashMatch;
    }

    public void setContentNegotiationManager(ContentNegotiationManager contentNegotiationManager) {
        Assert.notNull((Object)contentNegotiationManager, (String)"ContentNegotiationManager must not be null");
        this.contentNegotiationManager = contentNegotiationManager;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    @Override
    public void afterPropertiesSet() {
        this.config = new RequestMappingInfo.BuilderConfiguration();
        this.config.setPathHelper(this.getUrlPathHelper());
        this.config.setPathMatcher(this.getPathMatcher());
        this.config.setSuffixPatternMatch(this.useSuffixPatternMatch);
        this.config.setTrailingSlashMatch(this.useTrailingSlashMatch);
        this.config.setRegisteredSuffixPatternMatch(this.useRegisteredSuffixPatternMatch);
        this.config.setContentNegotiationManager(this.getContentNegotiationManager());
        super.afterPropertiesSet();
    }

    public boolean useSuffixPatternMatch() {
        return this.useSuffixPatternMatch;
    }

    public boolean useRegisteredSuffixPatternMatch() {
        return this.useRegisteredSuffixPatternMatch;
    }

    public boolean useTrailingSlashMatch() {
        return this.useTrailingSlashMatch;
    }

    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public List<String> getFileExtensions() {
        return this.config.getFileExtensions();
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, Controller.class) != null || AnnotationUtils.findAnnotation(beanType, RequestMapping.class) != null;
    }

    @Override
    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        RequestMappingInfo typeInfo;
        RequestMappingInfo info = this.createRequestMappingInfo(method);
        if (info != null && (typeInfo = this.createRequestMappingInfo(handlerType)) != null) {
            info = typeInfo.combine(info);
        }
        return info;
    }

    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        return null;
    }

    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        return null;
    }

    private RequestMappingInfo createRequestMappingInfo(AnnotatedElement annotatedElement) {
        RequestCondition<?> customCondition;
        AnnotationAttributes attributes;
        RequestMapping annotation;
        String annotationType = RequestMapping.class.getName();
        if (annotatedElement instanceof Class) {
            Class type = (Class)annotatedElement;
            annotation = (RequestMapping)AnnotationUtils.findAnnotation((Class)type, RequestMapping.class);
            attributes = AnnotatedElementUtils.findAnnotationAttributes((AnnotatedElement)type, (String)annotationType);
            customCondition = this.getCustomTypeCondition(type);
        } else {
            Method method = (Method)annotatedElement;
            annotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
            attributes = AnnotatedElementUtils.findAnnotationAttributes((AnnotatedElement)method, (String)annotationType);
            customCondition = this.getCustomMethodCondition(method);
        }
        RequestMappingInfo info = null;
        if (annotation != null && (info = this.createRequestMappingInfo(annotation, customCondition)) == null) {
            info = this.createRequestMappingInfo(attributes, customCondition);
        }
        return info;
    }

    @Deprecated
    protected RequestMappingInfo createRequestMappingInfo(RequestMapping annotation, RequestCondition<?> customCondition) {
        return null;
    }

    protected RequestMappingInfo createRequestMappingInfo(AnnotationAttributes attributes, RequestCondition<?> customCondition) {
        Object[] paths = attributes.getStringArray("path");
        paths = ObjectUtils.isEmpty((Object[])paths) ? attributes.getStringArray("value") : paths;
        paths = this.resolveEmbeddedValuesInPatterns((String[])paths);
        return RequestMappingInfo.paths((String[])paths).methods((RequestMethod[])attributes.get((Object)"method")).params(attributes.getStringArray("params")).headers(attributes.getStringArray("headers")).consumes(attributes.getStringArray("consumes")).produces(attributes.getStringArray("produces")).mappingName(attributes.getString("name")).customCondition(customCondition).options(this.config).build();
    }

    protected String[] resolveEmbeddedValuesInPatterns(String[] patterns) {
        if (this.embeddedValueResolver == null) {
            return patterns;
        }
        String[] resolvedPatterns = new String[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            resolvedPatterns[i] = this.embeddedValueResolver.resolveStringValue(patterns[i]);
        }
        return resolvedPatterns;
    }

    @Override
    protected CorsConfiguration initCorsConfiguration(Object handler, Method method, RequestMappingInfo mappingInfo) {
        HandlerMethod handlerMethod = this.createHandlerMethod(handler, method);
        CrossOrigin typeAnnotation = (CrossOrigin)AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), CrossOrigin.class);
        CrossOrigin methodAnnotation = (CrossOrigin)AnnotationUtils.findAnnotation((Method)method, CrossOrigin.class);
        if (typeAnnotation == null && methodAnnotation == null) {
            return null;
        }
        CorsConfiguration config = new CorsConfiguration();
        this.updateCorsConfig(config, typeAnnotation);
        this.updateCorsConfig(config, methodAnnotation);
        if (CollectionUtils.isEmpty((Collection)config.getAllowedMethods())) {
            for (RequestMethod requestMethod : mappingInfo.getMethodsCondition().getMethods()) {
                config.addAllowedMethod(requestMethod.name());
            }
        }
        if (CollectionUtils.isEmpty((Collection)config.getAllowedHeaders())) {
            for (NameValueExpression nameValueExpression : mappingInfo.getHeadersCondition().getExpressions()) {
                if (nameValueExpression.isNegated()) continue;
                config.addAllowedHeader(nameValueExpression.getName());
            }
        }
        return config;
    }

    private void updateCorsConfig(CorsConfiguration config, CrossOrigin annotation) {
        if (annotation == null) {
            return;
        }
        for (String string : annotation.origin()) {
            config.addAllowedOrigin(string);
        }
        for (String string : annotation.method()) {
            config.addAllowedMethod(string.name());
        }
        for (String string : annotation.allowedHeaders()) {
            config.addAllowedHeader(string);
        }
        for (String string : annotation.exposedHeaders()) {
            config.addExposedHeader(string);
        }
        if (annotation.allowCredentials().equalsIgnoreCase("true")) {
            config.setAllowCredentials(Boolean.valueOf(true));
        } else if (annotation.allowCredentials().equalsIgnoreCase("false")) {
            config.setAllowCredentials(Boolean.valueOf(false));
        } else if (!annotation.allowCredentials().isEmpty()) {
            throw new IllegalStateException("AllowCredentials value must be \"true\", \"false\" or \"\" (empty string), current value is " + annotation.allowCredentials());
        }
        if (annotation.maxAge() != -1L && config.getMaxAge() == null) {
            config.setMaxAge(Long.valueOf(annotation.maxAge()));
        }
    }
}

