/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import org.h2.command.CommandInterface;
import org.h2.constant.SysProperties;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.SessionInterface;
import org.h2.engine.SessionRemote;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcCallableStatement;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcDatabaseMetaData;
import org.h2.jdbc.JdbcPreparedStatement;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcSavepoint;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.message.TraceObject;
import org.h2.result.ResultInterface;
import org.h2.util.CloseWatcher;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;

public class JdbcConnection
extends TraceObject
implements Connection {
    private static boolean keepOpenStackTrace;
    private final String url;
    private final String user;
    private int holdability = 1;
    private SessionInterface session;
    private CommandInterface commit;
    private CommandInterface rollback;
    private CommandInterface getReadOnly;
    private CommandInterface getGeneratedKeys;
    private CommandInterface setLockMode;
    private CommandInterface getLockMode;
    private CommandInterface setQueryTimeout;
    private CommandInterface getQueryTimeout;
    private int savepointId;
    private String catalog;
    private Statement executingStatement;
    private final CompareMode compareMode = CompareMode.getInstance(null, 0);
    private final CloseWatcher watcher;
    private int queryTimeoutCache = -1;

    public JdbcConnection(String string, Properties properties) throws SQLException {
        this(new ConnectionInfo(string, properties), true);
    }

    public JdbcConnection(ConnectionInfo connectionInfo, boolean bl) throws SQLException {
        try {
            String string;
            if (bl && (string = SysProperties.getBaseDir()) != null) {
                connectionInfo.setBaseDir(string);
            }
            JdbcConnection.checkJavaVersion();
            this.session = new SessionRemote(connectionInfo).connectEmbeddedOrServer(false);
            this.trace = this.session.getTrace();
            int n = JdbcConnection.getNextId(1);
            this.setTrace(this.trace, 1, n);
            this.user = connectionInfo.getUserName();
            if (this.isInfoEnabled()) {
                this.trace.infoCode("Connection " + this.getTraceObjectName() + " = DriverManager.getConnection(" + JdbcConnection.quote(connectionInfo.getOriginalURL()) + ", " + JdbcConnection.quote(this.user) + ", \"\");");
            }
            this.url = connectionInfo.getURL();
            this.closeOld();
            this.watcher = CloseWatcher.register(this, this.session, keepOpenStackTrace);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public JdbcConnection(JdbcConnection jdbcConnection) {
        this.session = jdbcConnection.session;
        this.trace = this.session.getTrace();
        int n = JdbcConnection.getNextId(1);
        this.setTrace(this.trace, 1, n);
        this.user = jdbcConnection.user;
        this.url = jdbcConnection.url;
        this.catalog = jdbcConnection.catalog;
        this.commit = jdbcConnection.commit;
        this.getGeneratedKeys = jdbcConnection.getGeneratedKeys;
        this.getLockMode = jdbcConnection.getLockMode;
        this.getQueryTimeout = jdbcConnection.getQueryTimeout;
        this.getReadOnly = jdbcConnection.getReadOnly;
        this.rollback = jdbcConnection.rollback;
        this.watcher = null;
    }

    public JdbcConnection(SessionInterface sessionInterface, String string, String string2) {
        this.session = sessionInterface;
        this.trace = sessionInterface.getTrace();
        int n = JdbcConnection.getNextId(1);
        this.setTrace(this.trace, 1, n);
        this.user = string;
        this.url = string2;
        this.watcher = null;
    }

    private void closeOld() {
        CloseWatcher closeWatcher;
        while ((closeWatcher = CloseWatcher.pollUnclosed()) != null) {
            try {
                closeWatcher.getCloseable().close();
            }
            catch (Exception exception) {
                this.trace.error(exception, "closing session");
            }
            keepOpenStackTrace = true;
            String string = closeWatcher.getOpenStackTrace();
            DbException dbException = DbException.get(90018);
            this.trace.error(dbException, string);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n, "createStatement()");
            }
            this.checkClosed();
            return new JdbcStatement(this, n, 1003, 1007, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        try {
            int n3 = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n3, "createStatement(" + n + ", " + n2 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            this.checkClosed();
            return new JdbcStatement(this, n3, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            int n4 = JdbcConnection.getNextId(8);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Statement", 8, n4, "createStatement(" + n + ", " + n2 + ", " + n3 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            JdbcConnection.checkHoldability(n3);
            this.checkClosed();
            return new JdbcStatement(this, n4, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + JdbcConnection.quote(string) + ")");
            }
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n, 1003, 1007, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    PreparedStatement prepareAutoCloseStatement(String string) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n, "prepareStatement(" + JdbcConnection.quote(string) + ")");
            }
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n, 1003, 1007, true);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(2);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("DatabaseMetaData", 2, n, "getMetaData()");
            }
            this.checkClosed();
            return new JdbcDatabaseMetaData(this, this.trace, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public SessionInterface getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            if (this.session == null) {
                return;
            }
            CloseWatcher.unregister(this.watcher);
            this.session.cancel();
            if (this.executingStatement != null) {
                try {
                    this.executingStatement.cancel();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                block19: {
                    try {
                        if (this.session.isClosed()) break block19;
                        try {
                            if (this.session.getUndoLogPos() != 0) {
                                block20: {
                                    if (!this.session.isReconnectNeeded(true)) {
                                        try {
                                            this.rollbackInternal();
                                        }
                                        catch (DbException dbException) {
                                            if (dbException.getErrorCode() == 90067) break block20;
                                            throw dbException;
                                        }
                                    }
                                }
                                this.session.afterWriting();
                            }
                            this.closePreparedCommands();
                        }
                        finally {
                            this.session.close();
                        }
                    }
                    finally {
                        this.session = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void closePreparedCommands() {
        this.commit = JdbcConnection.closeAndSetNull(this.commit);
        this.rollback = JdbcConnection.closeAndSetNull(this.rollback);
        this.getReadOnly = JdbcConnection.closeAndSetNull(this.getReadOnly);
        this.getGeneratedKeys = JdbcConnection.closeAndSetNull(this.getGeneratedKeys);
        this.getLockMode = JdbcConnection.closeAndSetNull(this.getLockMode);
        this.setLockMode = JdbcConnection.closeAndSetNull(this.setLockMode);
        this.getQueryTimeout = JdbcConnection.closeAndSetNull(this.getQueryTimeout);
        this.setQueryTimeout = JdbcConnection.closeAndSetNull(this.setQueryTimeout);
    }

    private static CommandInterface closeAndSetNull(CommandInterface commandInterface) {
        if (commandInterface != null) {
            commandInterface.close();
        }
        return null;
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAutoCommit(" + bl + ");");
            }
            this.checkClosed();
            if (bl && !this.session.getAutoCommit()) {
                this.commit();
            }
            this.session.setAutoCommit(bl);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            this.checkClosed();
            this.debugCodeCall("getAutoCommit");
            return this.session.getAutoCommit();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void commit() throws SQLException {
        try {
            this.debugCodeCall("commit");
            this.checkClosedForWrite();
            try {
                this.commit = this.prepareCommand("COMMIT", this.commit);
                this.commit.executeUpdate();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() throws SQLException {
        try {
            this.debugCodeCall("rollback");
            this.checkClosedForWrite();
            try {
                this.rollbackInternal();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.session == null || this.session.isClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String nativeSQL(String string) throws SQLException {
        try {
            this.debugCodeCall("nativeSQL", string);
            this.checkClosed();
            return JdbcConnection.translateSQL(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setReadOnly(" + bl + ");");
            }
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            this.debugCodeCall("isReadOnly");
            this.checkClosed();
            this.getReadOnly = this.prepareCommand("CALL READONLY()", this.getReadOnly);
            ResultInterface resultInterface = this.getReadOnly.executeQuery(0, false);
            resultInterface.next();
            boolean bl = resultInterface.currentRow()[0].getBoolean();
            return bl;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setCatalog(String string) throws SQLException {
        try {
            this.debugCodeCall("setCatalog", string);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            this.debugCodeCall("getCatalog");
            this.checkClosed();
            if (this.catalog == null) {
                CommandInterface commandInterface = this.prepareCommand("CALL DATABASE()", Integer.MAX_VALUE);
                ResultInterface resultInterface = commandInterface.executeQuery(0, false);
                resultInterface.next();
                this.catalog = resultInterface.currentRow()[0].getString();
                commandInterface.close();
            }
            return this.catalog;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            int n3 = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n3, "prepareStatement(" + JdbcConnection.quote(string) + ", " + n + ", " + n2 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n3, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        try {
            int n2;
            this.debugCodeCall("setTransactionIsolation", n);
            this.checkClosed();
            switch (n) {
                case 1: {
                    n2 = 0;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 8: {
                    n2 = 1;
                    break;
                }
                default: {
                    throw DbException.getInvalidValueException("level", n);
                }
            }
            this.commit();
            this.setLockMode = this.prepareCommand("SET LOCK_MODE ?", this.setLockMode);
            this.setLockMode.getParameters().get(0).setValue(ValueInt.get(n2), false);
            this.setLockMode.executeUpdate();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", n);
            this.checkClosed();
            this.setQueryTimeout = this.prepareCommand("SET QUERY_TIMEOUT ?", this.setQueryTimeout);
            this.setQueryTimeout.getParameters().get(0).setValue(ValueInt.get(n * 1000), false);
            this.setQueryTimeout.executeUpdate();
            this.queryTimeoutCache = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            this.debugCodeCall("getQueryTimeout");
            if (this.queryTimeoutCache == -1) {
                this.checkClosed();
                this.getQueryTimeout = this.prepareCommand("SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME=?", this.getQueryTimeout);
                this.getQueryTimeout.getParameters().get(0).setValue(ValueString.get("QUERY_TIMEOUT"), false);
                ResultInterface resultInterface = this.getQueryTimeout.executeQuery(0, false);
                resultInterface.next();
                int n = resultInterface.currentRow()[0].getInt();
                resultInterface.close();
                if (n != 0) {
                    n = (n + 999) / 1000;
                }
                this.queryTimeoutCache = n;
            }
            return this.queryTimeoutCache;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            int n;
            this.debugCodeCall("getTransactionIsolation");
            this.checkClosed();
            this.getLockMode = this.prepareCommand("CALL LOCK_MODE()", this.getLockMode);
            ResultInterface resultInterface = this.getLockMode.executeQuery(0, false);
            resultInterface.next();
            int n2 = resultInterface.currentRow()[0].getInt();
            resultInterface.close();
            switch (n2) {
                case 0: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n = 8;
                    break;
                }
                default: {
                    throw DbException.throwInternalError("lockMode:" + n2);
                }
            }
            return n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        try {
            this.debugCodeCall("setHoldability", n);
            this.checkClosed();
            JdbcConnection.checkHoldability(n);
            this.holdability = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            this.debugCodeCall("getHoldability");
            this.checkClosed();
            return this.holdability;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.debugCodeCall("getTypeMap");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            this.debugCode("setTypeMap(" + JdbcConnection.quoteMap(map) + ");");
            JdbcConnection.checkMap(map);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n, "prepareCall(" + JdbcConnection.quote(string) + ")");
            }
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcCallableStatement(this, string, n, 1003, 1007);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            int n3 = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n3, "prepareCall(" + JdbcConnection.quote(string) + ", " + n + ", " + n2 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcCallableStatement(this, string, n3, n, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            int n4 = JdbcConnection.getNextId(0);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("CallableStatement", 0, n4, "prepareCall(" + JdbcConnection.quote(string) + ", " + n + ", " + n2 + ", " + n3 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            JdbcConnection.checkHoldability(n3);
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcCallableStatement(this, string, n4, n, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            int n = JdbcConnection.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, n, "setSavepoint()");
            }
            this.checkClosed();
            CommandInterface commandInterface = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(null, this.savepointId), Integer.MAX_VALUE);
            commandInterface.executeUpdate();
            JdbcSavepoint jdbcSavepoint = new JdbcSavepoint(this, this.savepointId, null, this.trace, n);
            ++this.savepointId;
            return jdbcSavepoint;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        try {
            int n = JdbcConnection.getNextId(6);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("Savepoint", 6, n, "setSavepoint(" + JdbcConnection.quote(string) + ")");
            }
            this.checkClosed();
            CommandInterface commandInterface = this.prepareCommand("SAVEPOINT " + JdbcSavepoint.getName(string, 0), Integer.MAX_VALUE);
            commandInterface.executeUpdate();
            JdbcSavepoint jdbcSavepoint = new JdbcSavepoint(this, 0, string, this.trace, n);
            return jdbcSavepoint;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            JdbcSavepoint jdbcSavepoint = JdbcConnection.convertSavepoint(savepoint);
            this.debugCode("rollback(" + jdbcSavepoint.getTraceObjectName() + ");");
            this.checkClosedForWrite();
            try {
                jdbcSavepoint.rollback();
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.debugCode("releaseSavepoint(savepoint);");
            this.checkClosed();
            JdbcConnection.convertSavepoint(savepoint).release();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private static JdbcSavepoint convertSavepoint(Savepoint savepoint) {
        if (!(savepoint instanceof JdbcSavepoint)) {
            throw DbException.get(90063, "" + savepoint);
        }
        return (JdbcSavepoint)savepoint;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            int n4 = JdbcConnection.getNextId(3);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("PreparedStatement", 3, n4, "prepareStatement(" + JdbcConnection.quote(string) + ", " + n + ", " + n2 + ", " + n3 + ")");
            }
            JdbcConnection.checkTypeConcurrency(n, n2);
            JdbcConnection.checkHoldability(n3);
            this.checkClosed();
            string = JdbcConnection.translateSQL(string);
            return new JdbcPreparedStatement(this, string, n4, n, n2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("prepareStatement(" + JdbcConnection.quote(string) + ", " + n + ");");
            }
            return this.prepareStatement(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("prepareStatement(" + JdbcConnection.quote(string) + ", " + JdbcConnection.quoteIntArray(nArray) + ");");
            }
            return this.prepareStatement(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("prepareStatement(" + JdbcConnection.quote(string) + ", " + JdbcConnection.quoteArray(stringArray) + ");");
            }
            return this.prepareStatement(string);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private static void checkJavaVersion() {
        try {
            Class<Savepoint> clazz = Savepoint.class;
            clazz.getClass();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw DbException.get(90092);
        }
    }

    CommandInterface prepareCommand(String string, int n) {
        return this.session.prepareCommand(string, n);
    }

    private CommandInterface prepareCommand(String string, CommandInterface commandInterface) {
        return commandInterface == null ? this.session.prepareCommand(string, Integer.MAX_VALUE) : commandInterface;
    }

    private static int translateGetEnd(String string, int n, char c) {
        int n2 = string.length();
        switch (c) {
            case '$': {
                if (n < n2 - 1 && string.charAt(n + 1) == '$' && (n == 0 || string.charAt(n - 1) <= ' ')) {
                    int n3 = string.indexOf("$$", n + 2);
                    if (n3 < 0) {
                        throw DbException.getSyntaxError(string, n);
                    }
                    return n3 + 1;
                }
                return n;
            }
            case '\'': {
                int n4 = string.indexOf(39, n + 1);
                if (n4 < 0) {
                    throw DbException.getSyntaxError(string, n);
                }
                return n4;
            }
            case '\"': {
                int n5 = string.indexOf(34, n + 1);
                if (n5 < 0) {
                    throw DbException.getSyntaxError(string, n);
                }
                return n5;
            }
            case '/': {
                JdbcConnection.checkRunOver(n + 1, n2, string);
                if (string.charAt(n + 1) == '*') {
                    int n6 = string.indexOf("*/", n + 2);
                    if (n6 < 0) {
                        throw DbException.getSyntaxError(string, n);
                    }
                    n = n6 + 1;
                } else if (string.charAt(n + 1) == '/') {
                    n += 2;
                    while (n < n2 && (c = string.charAt(n)) != '\r' && c != '\n') {
                        ++n;
                    }
                }
                return n;
            }
            case '-': {
                JdbcConnection.checkRunOver(n + 1, n2, string);
                if (string.charAt(n + 1) == '-') {
                    n += 2;
                    while (n < n2 && (c = string.charAt(n)) != '\r' && c != '\n') {
                        ++n;
                    }
                }
                return n;
            }
        }
        throw DbException.throwInternalError("c=" + c);
    }

    private static String translateSQL(String string) {
        return JdbcConnection.translateSQL(string, true);
    }

    static String translateSQL(String string, boolean bl) {
        if (string == null) {
            throw DbException.getInvalidValueException("SQL", null);
        }
        if (!bl) {
            return string;
        }
        if (string.indexOf(123) < 0) {
            return string;
        }
        int n = string.length();
        char[] cArray = null;
        int n2 = 0;
        block9: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '-': 
                case '/': {
                    i = JdbcConnection.translateGetEnd(string, i, c);
                    continue block9;
                }
                case '{': {
                    ++n2;
                    if (cArray == null) {
                        cArray = string.toCharArray();
                    }
                    cArray[i] = 32;
                    while (Character.isSpaceChar(cArray[i])) {
                        JdbcConnection.checkRunOver(++i, n, string);
                    }
                    int n3 = i;
                    if (cArray[i] >= '0' && cArray[i] <= '9') {
                        cArray[i - 1] = 123;
                        while (true) {
                            JdbcConnection.checkRunOver(i, n, string);
                            c = cArray[i];
                            if (c == '}') break;
                            switch (c) {
                                case '\"': 
                                case '\'': 
                                case '-': 
                                case '/': {
                                    i = JdbcConnection.translateGetEnd(string, i, c);
                                    break;
                                }
                            }
                            ++i;
                        }
                        --n2;
                        continue block9;
                    }
                    if (cArray[i] == '?') {
                        JdbcConnection.checkRunOver(++i, n, string);
                        while (Character.isSpaceChar(cArray[i])) {
                            JdbcConnection.checkRunOver(++i, n, string);
                        }
                        if (string.charAt(i) != '=') {
                            throw DbException.getSyntaxError(string, i, "=");
                        }
                        JdbcConnection.checkRunOver(++i, n, string);
                        while (Character.isSpaceChar(cArray[i])) {
                            JdbcConnection.checkRunOver(++i, n, string);
                        }
                    }
                    while (!Character.isSpaceChar(cArray[i])) {
                        JdbcConnection.checkRunOver(++i, n, string);
                    }
                    int n4 = 0;
                    if (JdbcConnection.found(string, n3, "fn")) {
                        n4 = 2;
                    } else {
                        if (JdbcConnection.found(string, n3, "escape") || JdbcConnection.found(string, n3, "call")) continue block9;
                        if (JdbcConnection.found(string, n3, "oj")) {
                            n4 = 2;
                        } else if (JdbcConnection.found(string, n3, "ts")) {
                            n4 = 2;
                        } else if (JdbcConnection.found(string, n3, "t")) {
                            n4 = 1;
                        } else if (JdbcConnection.found(string, n3, "d")) {
                            n4 = 1;
                        } else if (JdbcConnection.found(string, n3, "params")) {
                            n4 = "params".length();
                        }
                    }
                    i = n3;
                    while (n4 > 0) {
                        cArray[i] = 32;
                        ++i;
                        --n4;
                    }
                    continue block9;
                }
                case '}': {
                    if (--n2 < 0) {
                        throw DbException.getSyntaxError(string, i);
                    }
                    cArray[i] = 32;
                    continue block9;
                }
                case '$': {
                    i = JdbcConnection.translateGetEnd(string, i, c);
                    continue block9;
                }
            }
        }
        if (n2 != 0) {
            throw DbException.getSyntaxError(string, string.length() - 1);
        }
        if (cArray != null) {
            string = new String(cArray);
        }
        return string;
    }

    private static void checkRunOver(int n, int n2, String string) {
        if (n >= n2) {
            throw DbException.getSyntaxError(string, n);
        }
    }

    private static boolean found(String string, int n, String string2) {
        return string.regionMatches(true, n, string2, 0, string2.length());
    }

    private static void checkTypeConcurrency(int n, int n2) {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("resultSetType", n);
            }
        }
        switch (n2) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw DbException.getInvalidValueException("resultSetConcurrency", n2);
            }
        }
    }

    private static void checkHoldability(int n) {
        if (n != 1 && n != 2) {
            throw DbException.getInvalidValueException("resultSetHoldability", n);
        }
    }

    protected void checkClosed() {
        this.checkClosed(false);
    }

    private void checkClosedForWrite() {
        this.checkClosed(true);
    }

    protected void checkClosed(boolean bl) {
        if (this.session == null) {
            throw DbException.get(90007);
        }
        if (this.session.isClosed()) {
            throw DbException.get(90121);
        }
        if (this.session.isReconnectNeeded(bl)) {
            this.trace.debug("reconnect");
            this.closePreparedCommands();
            this.session = this.session.reconnect(bl);
            this.trace = this.session.getTrace();
        }
    }

    protected void afterWriting() {
        if (this.session != null) {
            this.session.afterWriting();
        }
    }

    String getURL() {
        this.checkClosed();
        return this.url;
    }

    String getUser() {
        this.checkClosed();
        return this.user;
    }

    private void rollbackInternal() {
        this.rollback = this.prepareCommand("ROLLBACK", this.rollback);
        this.rollback.executeUpdate();
    }

    public int getPowerOffCount() {
        return this.session == null || this.session.isClosed() ? 0 : this.session.getPowerOffCount();
    }

    public void setPowerOffCount(int n) {
        if (this.session != null) {
            this.session.setPowerOffCount(n);
        }
    }

    public void setExecutingStatement(Statement statement) {
        this.executingStatement = statement;
    }

    ResultSet getGeneratedKeys(JdbcStatement jdbcStatement, int n) {
        this.getGeneratedKeys = this.prepareCommand("SELECT SCOPE_IDENTITY() WHERE SCOPE_IDENTITY() IS NOT NULL", this.getGeneratedKeys);
        ResultInterface resultInterface = this.getGeneratedKeys.executeQuery(0, false);
        JdbcResultSet jdbcResultSet = new JdbcResultSet(this, jdbcStatement, resultInterface, n, false, true, false);
        return jdbcResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob createClob() throws SQLException {
        int n = JdbcConnection.getNextId(10);
        this.debugCodeAssign("Clob", 10, n, "createClob()");
        this.checkClosedForWrite();
        try {
            Value value = this.session.getDataHandler().getLobStorage().createClob(new InputStreamReader(new ByteArrayInputStream(Utils.EMPTY_BYTES)), 0L);
            JdbcClob jdbcClob = new JdbcClob(this, value, n);
            this.afterWriting();
            return jdbcClob;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob createBlob() throws SQLException {
        int n = JdbcConnection.getNextId(9);
        this.debugCodeAssign("Blob", 9, n, "createClob()");
        this.checkClosedForWrite();
        try {
            Value value = this.session.getDataHandler().getLobStorage().createBlob(new ByteArrayInputStream(Utils.EMPTY_BYTES), 0L);
            JdbcBlob jdbcBlob = new JdbcBlob(this, value, n);
            this.afterWriting();
            return jdbcBlob;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob createNClob() throws SQLException {
        int n = JdbcConnection.getNextId(10);
        this.debugCodeAssign("NClob", 10, n, "createNClob()");
        this.checkClosedForWrite();
        try {
            Value value = this.session.getDataHandler().getLobStorage().createClob(new InputStreamReader(new ByteArrayInputStream(Utils.EMPTY_BYTES)), 0L);
            JdbcClob jdbcClob = new JdbcClob(this, value, n);
            this.afterWriting();
            return jdbcClob;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw this.unsupported("createArray");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw this.unsupported("Struct");
    }

    @Override
    public synchronized boolean isValid(int n) {
        try {
            this.debugCodeCall("isValid", n);
            if (this.session == null || this.session.isClosed()) {
                return false;
            }
            this.getTransactionIsolation();
            return true;
        }
        catch (Exception exception) {
            this.logAndConvert(exception);
            return false;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public Properties getClientInfo() throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        throw this.unsupported("clientInfo");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw this.unsupported("unwrap");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw this.unsupported("isWrapperFor");
    }

    public Value createClob(Reader reader, long l) {
        if (reader == null) {
            return ValueNull.INSTANCE;
        }
        if (l <= 0L) {
            l = -1L;
        }
        Value value = this.session.getDataHandler().getLobStorage().createClob(reader, l);
        return value;
    }

    public Value createBlob(InputStream inputStream, long l) {
        if (inputStream == null) {
            return ValueNull.INSTANCE;
        }
        if (l <= 0L) {
            l = -1L;
        }
        Value value = this.session.getDataHandler().getLobStorage().createBlob(inputStream, l);
        return value;
    }

    private static void checkMap(Map<String, Class<?>> map) {
        if (map != null && map.size() > 0) {
            throw DbException.getUnsupportedException("map.size > 0");
        }
    }

    public String toString() {
        return this.getTraceObjectName() + ": url=" + this.url + " user=" + this.user;
    }

    Object convertToDefaultObject(Value value) {
        Object object;
        switch (value.getType()) {
            case 16: {
                int n = JdbcConnection.getNextId(10);
                object = new JdbcClob(this, value, n);
                break;
            }
            case 15: {
                int n = JdbcConnection.getNextId(9);
                object = new JdbcBlob(this, value, n);
                break;
            }
            case 19: {
                if (SysProperties.serializeJavaObject) {
                    object = Utils.deserialize(value.getBytesNoCopy());
                    break;
                }
            }
            default: {
                object = value.getObject();
            }
        }
        return object;
    }

    CompareMode getCompareMode() {
        return this.compareMode;
    }

    public void setTraceLevel(int n) {
        this.trace.setLevel(n);
    }
}

