/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.event.logger.handler;

import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEntityWithVariablesEvent;
import org.activiti.engine.impl.event.logger.handler.AbstractTaskEventHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventLogEntryEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class TaskCompletedEventHandler
extends AbstractTaskEventHandler {
    @Override
    public EventLogEntryEntity generateEventLogEntry(CommandContext commandContext) {
        ActivitiEntityWithVariablesEvent eventWithVariables = (ActivitiEntityWithVariablesEvent)this.event;
        TaskEntity task = (TaskEntity)eventWithVariables.getEntity();
        Map<String, Object> data = this.handleCommonTaskFields(task);
        long duration = this.timeStamp.getTime() - task.getCreateTime().getTime();
        this.putInMapIfNotNull(data, "duration", duration);
        if (eventWithVariables.getVariables() != null && eventWithVariables.getVariables().size() > 0) {
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            for (Object variableName : eventWithVariables.getVariables().keySet()) {
                this.putInMapIfNotNull(variableMap, (String)variableName, eventWithVariables.getVariables().get(variableName));
            }
            if (eventWithVariables.isLocalScope()) {
                this.putInMapIfNotNull(data, "localVariables", variableMap);
            } else {
                this.putInMapIfNotNull(data, "variables", variableMap);
            }
        }
        return this.createEventLogEntry(task.getProcessDefinitionId(), task.getProcessInstanceId(), task.getExecutionId(), task.getId(), data);
    }
}

