/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.util.List;
import org.jasig.cas.client.util.XmlUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.InvalidProxyChainTicketValidationException;
import org.jasig.cas.client.validation.ProxyList;
import org.jasig.cas.client.validation.TicketValidationException;

public class Cas20ProxyTicketValidator
extends Cas20ServiceTicketValidator {
    private boolean acceptAnyProxy;
    private ProxyList allowedProxyChains = new ProxyList();
    private boolean allowEmptyProxyChain = true;

    public Cas20ProxyTicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
    }

    protected final ProxyList getAllowedProxyChains() {
        return this.allowedProxyChains;
    }

    protected String getUrlSuffix() {
        return "proxyValidate";
    }

    protected void customParseResponse(String response, Assertion assertion) throws TicketValidationException {
        List<String> proxies = XmlUtils.getTextForElements(response, "proxy");
        if (this.allowEmptyProxyChain && proxies.isEmpty() || this.acceptAnyProxy) {
            return;
        }
        String[] proxiedList = proxies.toArray(new String[proxies.size()]);
        if (this.allowedProxyChains.contains(proxiedList)) {
            return;
        }
        throw new InvalidProxyChainTicketValidationException("Invalid proxy chain: " + proxies.toString());
    }

    public final void setAcceptAnyProxy(boolean acceptAnyProxy) {
        this.acceptAnyProxy = acceptAnyProxy;
    }

    public final void setAllowedProxyChains(ProxyList allowedProxyChains) {
        this.allowedProxyChains = allowedProxyChains;
    }

    protected final boolean isAcceptAnyProxy() {
        return this.acceptAnyProxy;
    }

    protected final boolean isAllowEmptyProxyChain() {
        return this.allowEmptyProxyChain;
    }

    public final void setAllowEmptyProxyChain(boolean allowEmptyProxyChain) {
        this.allowEmptyProxyChain = allowEmptyProxyChain;
    }
}

