/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionProviderFactory;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizedTextUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LocalizedTextUtil.class);
    private static final String TOMCAT_RESOURCE_ENTRIES_FIELD = "resourceEntries";
    private static final ConcurrentMap<Integer, List<String>> classLoaderMap = new ConcurrentHashMap<Integer, List<String>>();
    private static boolean reloadBundles = false;
    private static boolean devMode;
    private static final ConcurrentMap<String, ResourceBundle> bundlesMap;
    private static final ConcurrentMap<MessageFormatKey, MessageFormat> messageFormats;
    private static final ConcurrentMap<Integer, ClassLoader> delegatedClassLoaderMap;
    private static final String RELOADED = "com.opensymphony.xwork2.util.LocalizedTextUtil.reloaded";
    private static final String XWORK_MESSAGES_BUNDLE = "com/opensymphony/xwork2/xwork-messages";

    public static void clearDefaultResourceBundles() {
        ClassLoader ccl = LocalizedTextUtil.getCurrentThreadContextClassLoader();
        ArrayList<String> bundles = new ArrayList<String>();
        classLoaderMap.put(ccl.hashCode(), bundles);
        bundles.add(0, XWORK_MESSAGES_BUNDLE);
    }

    public static void setReloadBundles(boolean reloadBundles) {
        LocalizedTextUtil.reloadBundles = reloadBundles;
    }

    public static void setDevMode(boolean devMode) {
        LocalizedTextUtil.devMode = devMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultResourceBundle(String resourceBundleName) {
        String string = XWORK_MESSAGES_BUNDLE;
        synchronized (XWORK_MESSAGES_BUNDLE) {
            ClassLoader ccl = LocalizedTextUtil.getCurrentThreadContextClassLoader();
            ArrayList<String> bundles = (ArrayList<String>)classLoaderMap.get(ccl.hashCode());
            if (bundles == null) {
                bundles = new ArrayList<String>();
                classLoaderMap.put(ccl.hashCode(), bundles);
                bundles.add(XWORK_MESSAGES_BUNDLE);
            }
            bundles.remove(resourceBundleName);
            bundles.add(0, resourceBundleName);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added default resource bundle '{}' to default resource bundles for the following classloader '{}'", resourceBundleName, ccl.toString());
            }
            return;
        }
    }

    public static Locale localeFromString(String localeStr, Locale defaultLocale) {
        if (localeStr == null || localeStr.trim().length() == 0 || "_".equals(localeStr)) {
            if (defaultLocale != null) {
                return defaultLocale;
            }
            return Locale.getDefault();
        }
        int index = localeStr.indexOf(95);
        if (index < 0) {
            return new Locale(localeStr);
        }
        String language = localeStr.substring(0, index);
        if (index == localeStr.length()) {
            return new Locale(language);
        }
        if ((index = (localeStr = localeStr.substring(index + 1)).indexOf(95)) < 0) {
            return new Locale(language, localeStr);
        }
        String country = localeStr.substring(0, index);
        if (index == localeStr.length()) {
            return new Locale(language, country);
        }
        localeStr = localeStr.substring(index + 1);
        return new Locale(language, country, localeStr);
    }

    public static String findDefaultText(String aTextName, Locale locale) {
        List localList = (List)classLoaderMap.get(Thread.currentThread().getContextClassLoader().hashCode());
        for (String bundleName : localList) {
            ResourceBundle bundle = LocalizedTextUtil.findResourceBundle(bundleName, locale);
            if (bundle == null) continue;
            LocalizedTextUtil.reloadBundles();
            try {
                return bundle.getString(aTextName);
            }
            catch (MissingResourceException e) {
            }
        }
        if (devMode) {
            LOG.warn("Missing key [#0] in bundles [#1]!", aTextName, localList);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Missing key [#0] in bundles [#1]!", aTextName, localList);
        }
        return null;
    }

    public static String findDefaultText(String aTextName, Locale locale, Object[] params) {
        String defaultText = LocalizedTextUtil.findDefaultText(aTextName, locale);
        if (defaultText != null) {
            MessageFormat mf = LocalizedTextUtil.buildMessageFormat(defaultText, locale);
            return LocalizedTextUtil.formatWithNullDetection(mf, params);
        }
        return null;
    }

    public static ResourceBundle findResourceBundle(String aBundleName, Locale locale) {
        ResourceBundle bundle;
        block8: {
            bundle = null;
            ClassLoader classLoader = LocalizedTextUtil.getCurrentThreadContextClassLoader();
            String key = LocalizedTextUtil.createMissesKey(String.valueOf(classLoader.hashCode()), aBundleName, locale);
            try {
                if (!bundlesMap.containsKey(key)) {
                    bundle = ResourceBundle.getBundle(aBundleName, locale, classLoader);
                    bundlesMap.putIfAbsent(key, bundle);
                } else {
                    bundle = (ResourceBundle)bundlesMap.get(key);
                }
            }
            catch (MissingResourceException ex) {
                if (!delegatedClassLoaderMap.containsKey(classLoader.hashCode())) break block8;
                try {
                    if (!bundlesMap.containsKey(key)) {
                        bundle = ResourceBundle.getBundle(aBundleName, locale, (ClassLoader)delegatedClassLoaderMap.get(classLoader.hashCode()));
                        bundlesMap.putIfAbsent(key, bundle);
                    } else {
                        bundle = (ResourceBundle)bundlesMap.get(key);
                    }
                }
                catch (MissingResourceException e) {
                    if (!LOG.isDebugEnabled()) break block8;
                    LOG.debug("Missing resource bundle [#0]!", aBundleName);
                }
            }
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDelegatedClassLoader(ClassLoader classLoader) {
        ConcurrentMap<String, ResourceBundle> concurrentMap = bundlesMap;
        synchronized (concurrentMap) {
            delegatedClassLoaderMap.put(LocalizedTextUtil.getCurrentThreadContextClassLoader().hashCode(), classLoader);
        }
    }

    public static void clearBundle(String bundleName) {
        bundlesMap.remove(LocalizedTextUtil.getCurrentThreadContextClassLoader().hashCode() + bundleName);
    }

    private static String createMissesKey(String prefix, String aBundleName, Locale locale) {
        return prefix + aBundleName + "_" + locale.toString();
    }

    public static String findText(Class aClass, String aTextName, Locale locale) {
        return LocalizedTextUtil.findText(aClass, aTextName, locale, aTextName, new Object[0]);
    }

    public static String findText(Class aClass, String aTextName, Locale locale, String defaultMessage, Object[] args) {
        ValueStack valueStack = ActionContext.getContext().getValueStack();
        return LocalizedTextUtil.findText(aClass, aTextName, locale, defaultMessage, args, valueStack);
    }

    public static String findText(Class aClass, String aTextName, Locale locale, String defaultMessage, Object[] args, ValueStack valueStack) {
        GetDefaultMessageReturnArg result;
        Object model;
        Object action;
        ActionContext context;
        ActionInvocation actionInvocation;
        String msg;
        String indexedTextName = null;
        if (aTextName == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Trying to find text with null key!", new String[0]);
            }
            aTextName = "";
        }
        if (aTextName.contains("[")) {
            int i = -1;
            indexedTextName = aTextName;
            while ((i = indexedTextName.indexOf("[", i + 1)) != -1) {
                int j = indexedTextName.indexOf("]", i);
                String a = indexedTextName.substring(0, i);
                String b = indexedTextName.substring(j);
                indexedTextName = a + "[*" + b;
            }
        }
        if ((msg = LocalizedTextUtil.findMessage(aClass, aTextName, indexedTextName, locale, args, null, valueStack)) != null) {
            return msg;
        }
        if (ModelDriven.class.isAssignableFrom(aClass) && (actionInvocation = (context = ActionContext.getContext()).getActionInvocation()) != null && (action = actionInvocation.getAction()) instanceof ModelDriven && (model = ((ModelDriven)action).getModel()) != null && (msg = LocalizedTextUtil.findMessage(model.getClass(), aTextName, indexedTextName, locale, args, null, valueStack)) != null) {
            return msg;
        }
        for (Class clazz = aClass; clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            String basePackageName = clazz.getName();
            while (basePackageName.lastIndexOf(46) != -1) {
                String packageName = (basePackageName = basePackageName.substring(0, basePackageName.lastIndexOf(46))) + ".package";
                msg = LocalizedTextUtil.getMessage(packageName, locale, aTextName, valueStack, args);
                if (msg != null) {
                    return msg;
                }
                if (indexedTextName == null || (msg = LocalizedTextUtil.getMessage(packageName, locale, indexedTextName, valueStack, args)) == null) continue;
                return msg;
            }
        }
        int idx = aTextName.indexOf(".");
        if (idx != -1) {
            String newKey = null;
            String prop = null;
            if (aTextName.startsWith("invalid.fieldvalue.")) {
                idx = aTextName.indexOf(".", "invalid.fieldvalue.".length());
                if (idx != -1) {
                    prop = aTextName.substring("invalid.fieldvalue.".length(), idx);
                    newKey = "invalid.fieldvalue." + aTextName.substring(idx + 1);
                }
            } else {
                prop = aTextName.substring(0, idx);
                newKey = aTextName.substring(idx + 1);
            }
            if (prop != null) {
                Object obj = valueStack.findValue(prop);
                try {
                    Class<?> clazz;
                    PropertyDescriptor propertyDescriptor;
                    Object actionObj = ReflectionProviderFactory.getInstance().getRealTarget(prop, valueStack.getContext(), valueStack.getRoot());
                    if (actionObj != null && (propertyDescriptor = ReflectionProviderFactory.getInstance().getPropertyDescriptor(actionObj.getClass(), prop)) != null && (clazz = propertyDescriptor.getPropertyType()) != null) {
                        if (obj != null) {
                            valueStack.push(obj);
                        }
                        msg = LocalizedTextUtil.findText(clazz, newKey, locale, null, args);
                        if (obj != null) {
                            valueStack.pop();
                        }
                        if (msg != null) {
                            return msg;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.debug("unable to find property " + prop, e, new String[0]);
                }
            }
        }
        if (indexedTextName == null) {
            result = LocalizedTextUtil.getDefaultMessage(aTextName, locale, valueStack, args, defaultMessage);
        } else {
            result = LocalizedTextUtil.getDefaultMessage(aTextName, locale, valueStack, args, null);
            if (result != null && result.message != null) {
                return result.message;
            }
            result = LocalizedTextUtil.getDefaultMessage(indexedTextName, locale, valueStack, args, defaultMessage);
        }
        if (LocalizedTextUtil.unableToFindTextForKey(result) && LOG.isDebugEnabled()) {
            String warn = "Unable to find text for key '" + aTextName + "' ";
            if (indexedTextName != null) {
                warn = warn + " or indexed key '" + indexedTextName + "' ";
            }
            warn = warn + "in class '" + aClass.getName() + "' and locale '" + locale + "'";
            LOG.debug(warn, new String[0]);
        }
        return result != null ? result.message : null;
    }

    private static boolean unableToFindTextForKey(GetDefaultMessageReturnArg result) {
        if (result == null || result.message == null) {
            return true;
        }
        return !result.foundInBundle;
    }

    public static String findText(ResourceBundle bundle, String aTextName, Locale locale) {
        return LocalizedTextUtil.findText(bundle, aTextName, locale, aTextName, new Object[0]);
    }

    public static String findText(ResourceBundle bundle, String aTextName, Locale locale, String defaultMessage, Object[] args) {
        ValueStack valueStack = ActionContext.getContext().getValueStack();
        return LocalizedTextUtil.findText(bundle, aTextName, locale, defaultMessage, args, valueStack);
    }

    public static String findText(ResourceBundle bundle, String aTextName, Locale locale, String defaultMessage, Object[] args, ValueStack valueStack) {
        try {
            LocalizedTextUtil.reloadBundles(valueStack.getContext());
            String message = TextParseUtil.translateVariables(bundle.getString(aTextName), valueStack);
            MessageFormat mf = LocalizedTextUtil.buildMessageFormat(message, locale);
            return LocalizedTextUtil.formatWithNullDetection(mf, args);
        }
        catch (MissingResourceException ex) {
            if (devMode) {
                LOG.warn("Missing key [#0] in bundle [#1]!", aTextName, bundle);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Missing key [#0] in bundle [#1]!", aTextName, bundle);
            }
            GetDefaultMessageReturnArg result = LocalizedTextUtil.getDefaultMessage(aTextName, locale, valueStack, args, defaultMessage);
            if (LOG.isWarnEnabled() && LocalizedTextUtil.unableToFindTextForKey(result)) {
                LOG.warn("Unable to find text for key '" + aTextName + "' in ResourceBundles for locale '" + locale + "'", new String[0]);
            }
            return result != null ? result.message : null;
        }
    }

    private static GetDefaultMessageReturnArg getDefaultMessage(String key, Locale locale, ValueStack valueStack, Object[] args, String defaultMessage) {
        GetDefaultMessageReturnArg result = null;
        boolean found = true;
        if (key != null) {
            String message = LocalizedTextUtil.findDefaultText(key, locale);
            if (message == null) {
                message = defaultMessage;
                found = false;
            }
            if (message != null) {
                MessageFormat mf = LocalizedTextUtil.buildMessageFormat(TextParseUtil.translateVariables(message, valueStack), locale);
                String msg = LocalizedTextUtil.formatWithNullDetection(mf, args);
                result = new GetDefaultMessageReturnArg(msg, found);
            }
        }
        return result;
    }

    private static String getMessage(String bundleName, Locale locale, String key, ValueStack valueStack, Object[] args) {
        ResourceBundle bundle = LocalizedTextUtil.findResourceBundle(bundleName, locale);
        if (bundle == null) {
            return null;
        }
        LocalizedTextUtil.reloadBundles(valueStack.getContext());
        try {
            String message = TextParseUtil.translateVariables(bundle.getString(key), valueStack);
            MessageFormat mf = LocalizedTextUtil.buildMessageFormat(message, locale);
            return LocalizedTextUtil.formatWithNullDetection(mf, args);
        }
        catch (MissingResourceException e) {
            if (devMode) {
                LOG.warn("Missing key [#0] in bundle [#1]!", key, bundleName);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Missing key [#0] in bundle [#1]!", key, bundleName);
            }
            return null;
        }
    }

    private static String formatWithNullDetection(MessageFormat mf, Object[] args) {
        String message = mf.format(args);
        if ("null".equals(message)) {
            return null;
        }
        return message;
    }

    private static MessageFormat buildMessageFormat(String pattern, Locale locale) {
        MessageFormatKey key = new MessageFormatKey(pattern, locale);
        MessageFormat format = (MessageFormat)messageFormats.get(key);
        if (format == null) {
            format = new MessageFormat(pattern);
            format.setLocale(locale);
            format.applyPattern(pattern);
            messageFormats.put(key, format);
        }
        return format;
    }

    private static String findMessage(Class clazz, String key, String indexedKey, Locale locale, Object[] args, Set<String> checked, ValueStack valueStack) {
        Class<?>[] interfaces;
        if (checked == null) {
            checked = new TreeSet<String>();
        } else if (checked.contains(clazz.getName())) {
            return null;
        }
        String msg = LocalizedTextUtil.getMessage(clazz.getName(), locale, key, valueStack, args);
        if (msg != null) {
            return msg;
        }
        if (indexedKey != null && (msg = LocalizedTextUtil.getMessage(clazz.getName(), locale, indexedKey, valueStack, args)) != null) {
            return msg;
        }
        for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
            msg = LocalizedTextUtil.getMessage(anInterface.getName(), locale, key, valueStack, args);
            if (msg != null) {
                return msg;
            }
            if (indexedKey == null || (msg = LocalizedTextUtil.getMessage(anInterface.getName(), locale, indexedKey, valueStack, args)) == null) continue;
            return msg;
        }
        if (clazz.isInterface()) {
            for (Class<?> anInterface : interfaces = clazz.getInterfaces()) {
                msg = LocalizedTextUtil.findMessage(anInterface, key, indexedKey, locale, args, checked, valueStack);
                if (msg == null) continue;
                return msg;
            }
        } else if (!clazz.equals(Object.class) && !clazz.isPrimitive()) {
            return LocalizedTextUtil.findMessage(clazz.getSuperclass(), key, indexedKey, locale, args, checked, valueStack);
        }
        return null;
    }

    private static void reloadBundles() {
        LocalizedTextUtil.reloadBundles(ActionContext.getContext() != null ? ActionContext.getContext().getContextMap() : null);
    }

    private static void reloadBundles(Map<String, Object> context) {
        block7: {
            if (reloadBundles) {
                try {
                    Boolean reloaded = context != null ? (Boolean)ObjectUtils.defaultIfNull((Object)context.get(RELOADED), (Object)Boolean.FALSE) : Boolean.FALSE;
                    if (reloaded.booleanValue()) break block7;
                    bundlesMap.clear();
                    try {
                        LocalizedTextUtil.clearMap(ResourceBundle.class, null, "cacheList");
                    }
                    catch (NoSuchFieldException e) {
                        LocalizedTextUtil.clearMap(ResourceBundle.class, null, "cache");
                    }
                    LocalizedTextUtil.clearTomcatCache();
                    if (context != null) {
                        context.put(RELOADED, true);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resource bundles reloaded", new String[0]);
                    }
                }
                catch (Exception e) {
                    LOG.error("Could not reload resource bundles", e, new String[0]);
                }
            }
        }
    }

    private static void clearTomcatCache() {
        block11: {
            ClassLoader loader = LocalizedTextUtil.getCurrentThreadContextClassLoader();
            Class<?> cl = loader.getClass();
            try {
                if ("org.apache.catalina.loader.WebappClassLoader".equals(cl.getName())) {
                    LocalizedTextUtil.clearMap(cl, loader, TOMCAT_RESOURCE_ENTRIES_FIELD);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("class loader " + cl.getName() + " is not tomcat loader.", new String[0]);
                }
            }
            catch (NoSuchFieldException nsfe) {
                if ("org.apache.catalina.loader.WebappClassLoaderBase".equals(cl.getSuperclass().getName())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Base class #0 doesn't contain '#1' field, trying with parent!", nsfe, cl.getName(), TOMCAT_RESOURCE_ENTRIES_FIELD);
                    }
                    try {
                        LocalizedTextUtil.clearMap(cl.getSuperclass(), loader, TOMCAT_RESOURCE_ENTRIES_FIELD);
                    }
                    catch (Exception e) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn("Couldn't clear tomcat cache using #0", e, cl.getSuperclass().getName());
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block11;
                LOG.warn("Couldn't clear tomcat cache", e, cl.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearMap(Class cl, Object obj, String name) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object cache;
        Field field = cl.getDeclaredField(name);
        field.setAccessible(true);
        Object object = cache = field.get(obj);
        synchronized (object) {
            Class<?> ccl = cache.getClass();
            Method clearMethod = ccl.getMethod("clear", new Class[0]);
            clearMethod.invoke(cache, new Object[0]);
        }
    }

    public static void reset() {
        LocalizedTextUtil.clearDefaultResourceBundles();
        bundlesMap.clear();
        messageFormats.clear();
    }

    private static ClassLoader getCurrentThreadContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    static {
        bundlesMap = new ConcurrentHashMap<String, ResourceBundle>();
        messageFormats = new ConcurrentHashMap<MessageFormatKey, MessageFormat>();
        delegatedClassLoaderMap = new ConcurrentHashMap<Integer, ClassLoader>();
        LocalizedTextUtil.clearDefaultResourceBundles();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyResourceBundle
    extends ResourceBundle {
        private EmptyResourceBundle() {
        }

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }
    }

    static class GetDefaultMessageReturnArg {
        String message;
        boolean foundInBundle;

        public GetDefaultMessageReturnArg(String message, boolean foundInBundle) {
            this.message = message;
            this.foundInBundle = foundInBundle;
        }
    }

    static class MessageFormatKey {
        String pattern;
        Locale locale;

        MessageFormatKey(String pattern, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MessageFormatKey)) {
                return false;
            }
            MessageFormatKey messageFormatKey = (MessageFormatKey)o;
            if (this.locale != null ? !this.locale.equals(messageFormatKey.locale) : messageFormatKey.locale != null) {
                return false;
            }
            return !(this.pattern != null ? !this.pattern.equals(messageFormatKey.pattern) : messageFormatKey.pattern != null);
        }

        public int hashCode() {
            int result = this.pattern != null ? this.pattern.hashCode() : 0;
            result = 29 * result + (this.locale != null ? this.locale.hashCode() : 0);
            return result;
        }
    }
}

