/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jasig.services.persondir.IPersonAttributes;
import org.jasig.services.persondir.support.AbstractQueryPersonAttributeDao;
import org.jasig.services.persondir.support.AttributeNamedPersonImpl;
import org.jasig.services.persondir.support.BasePersonImpl;
import org.jasig.services.persondir.support.IUsernameAttributeProvider;
import org.jasig.services.persondir.support.NamedPersonImpl;
import org.jasig.services.persondir.util.PatternHelper;

public class ComplexStubPersonAttributeDao
extends AbstractQueryPersonAttributeDao<String> {
    private Map<String, Map<String, List<Object>>> backingMap = Collections.emptyMap();
    private Set<String> possibleUserAttributeNames = Collections.emptySet();
    private String queryAttributeName = null;

    public ComplexStubPersonAttributeDao() {
    }

    public ComplexStubPersonAttributeDao(Map<String, Map<String, List<Object>>> backingMap) {
        this.setBackingMap(backingMap);
    }

    public ComplexStubPersonAttributeDao(String queryAttributeName, Map<String, Map<String, List<Object>>> backingMap) {
        this.setQueryAttributeName(queryAttributeName);
        this.setBackingMap(backingMap);
    }

    public String getQueryAttributeName() {
        return this.queryAttributeName;
    }

    public void setQueryAttributeName(String queryAttributeName) {
        this.queryAttributeName = queryAttributeName;
    }

    public Map<String, Map<String, List<Object>>> getBackingMap() {
        return this.backingMap;
    }

    public void setBackingMap(Map<String, Map<String, List<Object>>> backingMap) {
        if (backingMap == null) {
            this.backingMap = Collections.emptyMap();
            this.possibleUserAttributeNames = Collections.emptySet();
        } else {
            this.backingMap = Collections.unmodifiableMap(new LinkedHashMap<String, Map<String, List<Object>>>(backingMap));
            this.initializePossibleAttributeNames();
        }
    }

    @Override
    public Set<String> getPossibleUserAttributeNames() {
        return this.possibleUserAttributeNames;
    }

    @Override
    public Set<String> getAvailableQueryAttributes() {
        IUsernameAttributeProvider usernameAttributeProvider = this.getUsernameAttributeProvider();
        String usernameAttribute = usernameAttributeProvider.getUsernameAttribute();
        return Collections.singleton(usernameAttribute);
    }

    @Override
    protected String appendAttributeToQuery(String queryBuilder, String dataAttribute, List<Object> queryValues) {
        String keyAttributeName;
        if (queryBuilder != null) {
            return queryBuilder;
        }
        if (this.queryAttributeName != null) {
            keyAttributeName = this.queryAttributeName;
        } else {
            IUsernameAttributeProvider usernameAttributeProvider = this.getUsernameAttributeProvider();
            keyAttributeName = usernameAttributeProvider.getUsernameAttribute();
        }
        if (keyAttributeName.equals(dataAttribute)) {
            return String.valueOf(queryValues.get(0));
        }
        return null;
    }

    @Override
    protected List<IPersonAttributes> getPeopleForQuery(String seedValue, String queryUserName) {
        if (seedValue != null && seedValue.contains("*")) {
            Pattern seedPattern = PatternHelper.compilePattern(seedValue);
            LinkedList<IPersonAttributes> results = new LinkedList<IPersonAttributes>();
            for (Map.Entry<String, Map<String, List<Object>>> attributesEntry : this.backingMap.entrySet()) {
                Map<String, List<Object>> attributes;
                String attributesKey = attributesEntry.getKey();
                Matcher keyMatcher = seedPattern.matcher(attributesKey);
                if (!keyMatcher.matches() || (attributes = attributesEntry.getValue()) == null) continue;
                IPersonAttributes person = this.createPerson(null, queryUserName, attributes);
                results.add(person);
            }
            if (results.size() == 0) {
                return null;
            }
            return results;
        }
        Map<String, List<Object>> attributes = this.backingMap.get(seedValue);
        if (attributes == null) {
            return null;
        }
        IPersonAttributes person = this.createPerson(seedValue, queryUserName, attributes);
        return Collections.singletonList(person);
    }

    private IPersonAttributes createPerson(String seedValue, String queryUserName, Map<String, List<Object>> attributes) {
        BasePersonImpl person;
        if (queryUserName != null) {
            person = new NamedPersonImpl(queryUserName, attributes);
        } else {
            String usernameAttribute = this.getConfiguredUserNameAttribute();
            person = seedValue != null && usernameAttribute.equals(this.queryAttributeName) ? new NamedPersonImpl(seedValue, attributes) : new AttributeNamedPersonImpl(usernameAttribute, attributes);
        }
        return person;
    }

    private void initializePossibleAttributeNames() {
        LinkedHashSet<String> possibleAttribNames = new LinkedHashSet<String>();
        for (Map<String, List<Object>> attributeMapForSomeUser : this.backingMap.values()) {
            Set<String> keySet = attributeMapForSomeUser.keySet();
            possibleAttribNames.addAll(keySet);
        }
        this.possibleUserAttributeNames = Collections.unmodifiableSet(possibleAttribNames);
    }
}

