/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

class HashEntry {
    private static final AtomicReferenceFieldUpdater<HashEntry, Object> ELEMENT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(HashEntry.class, Object.class, "element");
    protected final Object key;
    protected final int hash;
    protected final HashEntry next;
    private volatile Object element;

    HashEntry(Object key, int hash, HashEntry next, Object element) {
        this.key = key;
        this.hash = hash;
        this.next = next;
        this.setElement(element);
    }

    Object getElement() {
        return ELEMENT_UPDATER.get(this);
    }

    void setElement(Object element) {
        ELEMENT_UPDATER.set(this, element);
    }

    boolean casElement(Object expect, Object update) {
        return ELEMENT_UPDATER.compareAndSet(this, expect, update);
    }

    Object gasElement(Object element) {
        return ELEMENT_UPDATER.getAndSet(this, element);
    }
}

