/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.ColorGradientType;
import com.supermap.data.DatasetGrid;
import com.supermap.data.Enum;
import com.supermap.data.Toolkit;
import com.supermap.mapping.InternalEnum;
import com.supermap.mapping.InternalHandle;
import com.supermap.mapping.InternalHandleDisposable;
import com.supermap.mapping.InternalResource;
import com.supermap.mapping.RangeMode;
import com.supermap.mapping.Theme;
import com.supermap.mapping.ThemeGridRangeItem;
import com.supermap.mapping.ThemeGridRangeNative;
import java.awt.Color;
import java.util.ArrayList;

public class ThemeGridRange
extends Theme {
    private ArrayList _$1 = null;

    public ThemeGridRange() {
        long l = ThemeGridRangeNative.jni_New();
        this.setHandle(l, true);
        this._$1 = new ArrayList();
    }

    public ThemeGridRange(ThemeGridRange themeGridRange) {
        if (themeGridRange == null) {
            String string = InternalResource.loadString("themeGridRange", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (themeGridRange.getHandle() == 0L) {
            String string = InternalResource.loadString("themeGridRange", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = ThemeGridRangeNative.jni_Clone(themeGridRange.getHandle());
        this.setHandle(l, true);
        this._$1 = new ArrayList();
        int n = themeGridRange.getGridRangeItemsList().size();
        InternalHandleDisposable.makeSureNativeObjectLive((Object)((Object)themeGridRange));
        for (int i = 0; i < n; ++i) {
            ThemeGridRangeItem themeGridRangeItem = new ThemeGridRangeItem(this);
            this._$1.add(themeGridRangeItem);
        }
    }

    ThemeGridRange(long l, boolean bl) {
        this.setHandle(l, bl);
        this._$1 = new ArrayList();
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeGridRangeItem themeGridRangeItem = new ThemeGridRangeItem(this);
            this._$1.add(themeGridRangeItem);
        }
    }

    public RangeMode getRangeMode() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getRangeMode()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGridRangeNative.jni_GetRangeMode(this.getHandle());
        return (RangeMode)Enum.parse(RangeMode.class, (int)n);
    }

    public ThemeGridRangeItem getItem(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getItem(int index)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (n < 0 || n >= this.getCount()) {
            String string = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        return (ThemeGridRangeItem)this._$1.get(n);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCount()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGridRangeNative.jni_GetCount(this.getHandle());
        int n2 = 0;
        n2 = n == 0 || n == 1 ? 0 : n - 1;
        return n2;
    }

    public boolean addToHead(ThemeGridRangeItem themeGridRangeItem) {
        return this.addToHead(themeGridRangeItem, false);
    }

    public boolean addToTail(ThemeGridRangeItem themeGridRangeItem) {
        return this.addToTail(themeGridRangeItem, false);
    }

    public boolean addToHead(ThemeGridRangeItem themeGridRangeItem, boolean bl) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToHead(ThemeGridRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeGridRangeItem.getStart() >= themeGridRangeItem.getEnd()) {
            if (bl) {
                if (Toolkit.isZero((double)(themeGridRangeItem.getStart() - themeGridRangeItem.getEnd()))) {
                    return false;
                }
                Double d = themeGridRangeItem.getStart();
                themeGridRangeItem.setStart(themeGridRangeItem.getEnd());
                themeGridRangeItem.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeGridRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), 0);
            double d3 = themeGridRangeItem.getEnd();
            double d4 = d3 - d2;
            boolean bl2 = Toolkit.isZero((double)d4);
            if (!bl2) {
                if (bl) {
                    themeGridRangeItem.setEnd(d2);
                } else {
                    String string = InternalResource.loadString("item.getEnd()", "ThemeGridRange_InvalidEndOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl2 = Toolkit.isZero((double)(d4 = (d = themeGridRangeItem.getStart()) - d2))) || d > d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeGridRangeItem themeGridRangeItem2 = new ThemeGridRangeItem(themeGridRangeItem);
        boolean bl3 = ThemeGridRangeNative.jni_AddToHead(this.getHandle(), themeGridRangeItem2.getCaption(), themeGridRangeItem2.isVisible(), themeGridRangeItem2.getColor().getRGB(), themeGridRangeItem2.getStart(), themeGridRangeItem2.getEnd());
        if (bl3) {
            ThemeGridRangeItem themeGridRangeItem3 = new ThemeGridRangeItem(this);
            this._$1.add(0, themeGridRangeItem3);
        }
        this.m_lock.unlock();
        return bl3;
    }

    public boolean addToTail(ThemeGridRangeItem themeGridRangeItem, boolean bl) {
        int n;
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("addToTail(ThemeGridRangeItem item)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        if (themeGridRangeItem.getStart() >= themeGridRangeItem.getEnd()) {
            if (bl) {
                if (Toolkit.isZero((double)(themeGridRangeItem.getStart() - themeGridRangeItem.getEnd()))) {
                    return false;
                }
                Double d = themeGridRangeItem.getStart();
                themeGridRangeItem.setStart(themeGridRangeItem.getEnd());
                themeGridRangeItem.setEnd(d);
            } else {
                String string = InternalResource.loadString("item", "ThemeGridRange_TheEndShouldBeBiggerTheStart", "mapping_resources");
                throw new IllegalArgumentException(string);
            }
        }
        if ((n = this.getCount()) > 0) {
            double d;
            double d2 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), n);
            double d3 = themeGridRangeItem.getStart();
            double d4 = d3 - d2;
            boolean bl2 = Toolkit.isZero((double)d4);
            if (!bl2) {
                if (bl) {
                    themeGridRangeItem.setStart(d2);
                } else {
                    String string = InternalResource.loadString("item.getStart()", "ThemeGridRange_InavlidStartOfItem", "mapping_resources");
                    throw new IllegalArgumentException(string);
                }
            }
            if ((bl2 = Toolkit.isZero((double)(d4 = d2 - (d = themeGridRangeItem.getEnd())))) || d < d2) {
                return false;
            }
        }
        this.m_lock.lock();
        ThemeGridRangeItem themeGridRangeItem2 = new ThemeGridRangeItem(themeGridRangeItem);
        boolean bl3 = ThemeGridRangeNative.jni_AddToTail(this.getHandle(), themeGridRangeItem2.getCaption(), themeGridRangeItem2.isVisible(), themeGridRangeItem2.getColor().getRGB(), themeGridRangeItem2.getStart(), themeGridRangeItem2.getEnd());
        if (bl3) {
            ThemeGridRangeItem themeGridRangeItem3 = new ThemeGridRangeItem(this);
            this._$1.add(themeGridRangeItem3);
        }
        this.m_lock.unlock();
        return bl3;
    }

    public boolean split(int n, double d, Color color, String string, Color color2, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("split()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        int n2 = this.getCount();
        if (n < 0 || n >= n2) {
            String string4 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string4);
        }
        if (color == null) {
            String string5 = InternalResource.loadString("color1", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (color2 == null) {
            String string6 = InternalResource.loadString("color2", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        double d2 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), n);
        double d3 = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), n + 1);
        if (d <= d2 || d >= d3) {
            String string7 = InternalResource.loadString("splitValue", "ThemeGridRange_InvalidSplitValue", "mapping_resources");
            throw new IllegalArgumentException(string7);
        }
        if (string == null || string.trim().length() == 0) {
            String string8 = InternalResource.loadString("caption1", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string8);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string9 = InternalResource.loadString("caption2", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string9);
        }
        this.m_lock.lock();
        boolean bl = ThemeGridRangeNative.jni_Split(this.getHandle(), n, d, color.getRGB(), string, color2.getRGB(), string2);
        if (bl) {
            ThemeGridRangeItem themeGridRangeItem = (ThemeGridRangeItem)this._$1.get(n);
            themeGridRangeItem.setEnd(d);
            themeGridRangeItem.setCaption(string);
            themeGridRangeItem.setColor(color);
            ThemeGridRangeItem themeGridRangeItem2 = new ThemeGridRangeItem(this);
            this._$1.add(n + 1, themeGridRangeItem2);
        }
        this.m_lock.unlock();
        return bl;
    }

    public boolean merge(int n, int n2, Color color, String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("merge(int index1, int count, Color color, String caption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        int n3 = this.getCount();
        if (n < 0 || n >= n3) {
            String string3 = InternalResource.loadString("index", "Global_IndexOutOfBounds", "mapping_resources");
            throw new IndexOutOfBoundsException(string3);
        }
        if (n + n2 < n || n + n2 > n3) {
            String string4 = InternalResource.loadString("count", "ThemeGridRange_TheCountIsInvalid", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        if (color == null) {
            String string5 = InternalResource.loadString("color", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string5);
        }
        if (string == null || string.trim().length() == 0) {
            String string6 = InternalResource.loadString("name", "Global_StringIsNullOrEmpty", "mapping_resources");
            throw new IllegalArgumentException(string6);
        }
        this.m_lock.lock();
        boolean bl = false;
        if (n2 == 0) {
            bl = true;
        } else {
            bl = ThemeGridRangeNative.jni_Merge(this.getHandle(), n, n2, color.getRGB(), string);
            if (bl) {
                ThemeGridRangeItem themeGridRangeItem = (ThemeGridRangeItem)this._$1.get(n);
                double d = ThemeGridRangeNative.jni_GetValueAt(this.getHandle(), n + 1);
                themeGridRangeItem.setEnd(d);
                themeGridRangeItem.setCaption(string);
                themeGridRangeItem.setColor(color);
                for (int i = 0; i < n2 - 1; ++i) {
                    this._$1.remove(n + 1);
                }
            }
        }
        this.m_lock.unlock();
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("clear()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGridRangeNative.jni_Clear(this.getHandle());
        if (this._$1 != null) {
            this._$1.clear();
        }
        this.m_lock.unlock();
    }

    public static ThemeGridRange makeDefault(DatasetGrid datasetGrid, RangeMode rangeMode, double d, ColorGradientType colorGradientType) {
        if (datasetGrid == null) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        if (l == 0L) {
            String string = InternalResource.loadString("dataset", "Global_ArgumentObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode == null) {
            String string = InternalResource.loadString("rangeMode", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode.equals((Object)RangeMode.STDDEVIATION) || rangeMode.equals((Object)RangeMode.QUANTILE)) {
            String string = InternalResource.loadString("rangeMode", "ThemeGridRange_TheRangeModeIsUnsupported", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if ((rangeMode.equals((Object)RangeMode.EQUALINTERVAL) || rangeMode.equals((Object)RangeMode.SQUAREROOT) || rangeMode.equals((Object)RangeMode.LOGARITHM)) && d < 1.0) {
            String string = InternalResource.loadString("rangeParameter", "ThemeGridRange_TheArgumentOfRangeParameterShouldNotBeLessThanOneRange", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (rangeMode.equals((Object)RangeMode.CUSTOMINTERVAL) && d < 0.0) {
            String string = InternalResource.loadString("rangeParameter", "ThemeGridRange_TheArgumentOfRangeParameterShouldBePositive", "mapping_resources");
            throw new IllegalArgumentException(string);
        }
        if (colorGradientType == null) {
            colorGradientType = ColorGradientType.TERRAIN;
        }
        int n = InternalEnum.getUGCValue(rangeMode);
        int n2 = InternalEnum.getUGCValue((Enum)colorGradientType);
        long l2 = ThemeGridRangeNative.jni_MakeDefault(l, n, d, n2);
        ThemeGridRange themeGridRange = null;
        if (l2 != 0L) {
            themeGridRange = new ThemeGridRange(l2, true);
        }
        return themeGridRange;
    }

    public static ThemeGridRange makeDefault(DatasetGrid datasetGrid, RangeMode rangeMode, double d) {
        return ThemeGridRange.makeDefault(datasetGrid, rangeMode, d, null);
    }

    public int indexOf(double d) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("indexOf(double value)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        int n = ThemeGridRangeNative.jni_GetCount(this.getHandle());
        double[] dArray = new double[n];
        ThemeGridRangeNative.jni_GetValues(this.getHandle(), dArray);
        for (int i = 0; i < n - 1; ++i) {
            if (!(dArray[i] <= d) || !(d < dArray[i + 1])) continue;
            return i;
        }
        return -1;
    }

    public void reverseColor() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("reverseColor()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        this.m_lock.lock();
        ThemeGridRangeNative.jni_ReverseColor(this.getHandle());
        this.m_lock.unlock();
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toString()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Count = ");
        stringBuffer.append(this.getCount());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "mapping_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ThemeGridRangeNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromXML(String string) {
        boolean bl = false;
        try {
            this.m_lock.lock();
            bl = super.fromXML(string);
            if (bl) {
                this._$1();
            }
        }
        finally {
            this.m_lock.unlock();
        }
        return bl;
    }

    protected void clearHandle() {
        if (this._$1 != null) {
            this._$1.clear();
            this._$1 = null;
        }
        this.setHandle(0L);
    }

    ArrayList getGridRangeItemsList() {
        return this._$1;
    }

    private void _$1() {
        if (this._$1 != null) {
            this._$1.clear();
        }
        int n = this.getCount();
        for (int i = 0; i < n; ++i) {
            ThemeGridRangeItem themeGridRangeItem = new ThemeGridRangeItem(this);
            this._$1.add(themeGridRangeItem);
        }
    }

    public void setSpecialValueTransparent(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGridRangeNative.jni_SetSpecialValueTransparent1(this.getHandle(), bl);
    }

    public boolean isSpecialValueTransparent() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGridRangeNative.jni_IsSpecialValueTransparent1(this.getHandle());
    }

    public void setSpecialValue(int n) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        ThemeGridRangeNative.jni_SetSpecialValue1(this.getHandle(), n);
    }

    public int GetSpecialValue() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isSpecialValueTransparent()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string);
        }
        return ThemeGridRangeNative.jni_GetSpecialValue1(this.getHandle());
    }
}

