/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data.processing;

import com.supermap.data.InternalHandle;
import com.supermap.data.Rectangle2D;
import com.supermap.data.processing.InternalEnum;
import com.supermap.data.processing.InternalHandleDisposable;
import com.supermap.data.processing.InternalResource;
import com.supermap.data.processing.MapCacheFile;
import com.supermap.data.processing.MapCacheProviderNative;
import com.supermap.data.processing.StorageType;
import com.supermap.data.processing.Tile;
import com.supermap.data.processing.TileFormat;
import com.supermap.data.processing.TileSize;
import com.supermap.data.processing.Tiles;
import com.supermap.mapping.Map;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MapCacheProvider
extends InternalHandleDisposable {
    private Map _$2 = null;
    private List<MapCacheFile> _$1 = new ArrayList<MapCacheFile>();

    public MapCacheProvider() {
        this.setHandle(MapCacheProviderNative.jni_New(), true);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = InternalResource.loadString("dispose()", "Handle_UndisposableObject", "processing_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            MapCacheProviderNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheProviderNative.jni_GetName(this.getHandle());
    }

    public void setName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setName()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("setName()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        if (string.length() == 0) {
            String string4 = InternalResource.loadString("setName()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string4);
        }
        MapCacheProviderNative.jni_SetName(this.getHandle(), string);
    }

    public boolean fromConfigFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("fromConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = InternalResource.loadString("fromConfigFile()", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        if (string.length() == 0) {
            String string4 = InternalResource.loadString("fromConfigFile()", "Global_ArgumentNull", "processing_resources");
            throw new IllegalStateException(string4);
        }
        boolean bl = MapCacheProviderNative.jni_FromConfigFile(this.getHandle(), string);
        return bl;
    }

    public Map getMap() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return this._$2;
    }

    public void setMap(Map map) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setMap()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        if (map != null && com.supermap.data.processing.InternalHandle.getHandle((InternalHandle)map) == 0L) {
            String string = InternalResource.loadString("value", "Global_ArgumentObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        this._$2 = map;
        if (this._$2 != null) {
            MapCacheProviderNative.jni_SetMap(this.getHandle(), com.supermap.data.processing.InternalHandle.getHandle((InternalHandle)map));
        } else {
            MapCacheProviderNative.jni_SetMap(this.getHandle(), 0L);
        }
        InternalHandleDisposable.makeSureNativeObjectLive((Object)map);
    }

    public String getOutputFolder() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheProviderNative.jni_GetOutputFolder(this.getHandle());
    }

    public void setOutputFolder(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("setOutputFolder()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        if (string.trim().length() == 0) {
            String string3 = InternalResource.loadString("setOutputFolder()", "OutputFolderNotExists", "processing_resources");
            throw new IllegalStateException(string3);
        }
        MapCacheProviderNative.jni_SetOutputFolder(this.getHandle(), string);
    }

    public boolean toConfigFile() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("toConfigFile()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = this._$2();
        return MapCacheProviderNative.jni_ToConfigFile(this.getHandle(), string);
    }

    private boolean _$1(File file, String string) {
        int n = -1;
        File file2 = file.getParentFile();
        for (File file3 : file2.listFiles()) {
            File file4;
            if (!file3.isDirectory() || !(file4 = new File(file3, file3.getName() + ".inf")).exists()) continue;
            try {
                String string2 = file4.getCanonicalPath();
                boolean bl = MapCacheProviderNative.jni_AddMapCache(this.getHandle(), string2, string);
                if (!bl) {
                    n = 0;
                    continue;
                }
                if (n == 0) continue;
                n = 1;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n == 1;
    }

    public boolean addMapCache(String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = InternalResource.loadString("addMapCache()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string3);
        }
        File file = new File(string);
        if (file.exists()) {
            return this._$1(file, string2);
        }
        return false;
    }

    public boolean removeMapCache(String string) {
        if (this.getHandle() == 0L) {
            String string2 = InternalResource.loadString("removeMapCache()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            return false;
        }
        File file2 = file.getParentFile();
        for (File file3 : file2.listFiles()) {
            File file4;
            if (!file3.isDirectory() || !(file4 = new File(file3, file3.getName() + ".inf")).exists()) continue;
            try {
                String string3 = file4.getCanonicalPath();
                MapCacheProviderNative.jni_RemoveMapCache(this.getHandle(), string3);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    public Tile[] getTiles(Rectangle2D rectangle2D, double d, boolean bl, TileSize tileSize, TileFormat tileFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tile[] tileArray = new Tile[]{};
        if (rectangle2D.isEmpty()) {
            return tileArray;
        }
        if (d <= 0.0 || d > 1.0) {
            return tileArray;
        }
        Tiles tiles = null;
        long l = MapCacheProviderNative.jni_GetTiles(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom(), d, bl, InternalEnum.getUGCValue(tileSize), InternalEnum.getUGCValue(tileFormat));
        tiles = new Tiles(l);
        tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public Tile[] getTiles(Rectangle2D rectangle2D, double d, boolean bl, TileSize tileSize, TileFormat tileFormat, boolean bl2) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getTilesEx()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tile[] tileArray = new Tile[]{};
        if (rectangle2D.isEmpty()) {
            return tileArray;
        }
        if (d <= 0.0 || d > 1.0) {
            return tileArray;
        }
        Tiles tiles = null;
        long l = MapCacheProviderNative.jni_GetTilesEx(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom(), d, bl, InternalEnum.getUGCValue(tileSize), InternalEnum.getUGCValue(tileFormat), bl2);
        tiles = new Tiles(l);
        tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public Tile[] getMixedTiles(Rectangle2D rectangle2D, double d, boolean bl, TileSize tileSize, TileFormat tileFormat) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getMixedTiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        Tile[] tileArray = new Tile[]{};
        if (rectangle2D.isEmpty()) {
            return tileArray;
        }
        if (d <= 0.0 || d > 1.0) {
            return tileArray;
        }
        Tiles tiles = null;
        long l = MapCacheProviderNative.jni_GetMixedTiles(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom(), d, bl, InternalEnum.getUGCValue(tileSize), InternalEnum.getUGCValue(tileFormat));
        tiles = new Tiles(l);
        tileArray = new Tile[tiles.getCount()];
        for (int i = 0; i < tiles.getCount(); ++i) {
            tileArray[i] = tiles.get(i);
        }
        return tileArray;
    }

    public String[] getCacheFiles() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getCacheFiles()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        String string = MapCacheProviderNative.jni_GetCacheFiles(this.getHandle());
        String[] stringArray = string.split(";");
        return stringArray;
    }

    public Rectangle2D getIndexBounds() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getIndexBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        MapCacheProviderNative.jni_GetIndexBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[3], dArray[2], dArray[1]);
        return rectangle2D;
    }

    public void setIndexBounds(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setIndexBounds()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheProviderNative.jni_SetIndexBounds(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom());
    }

    public boolean clear(Rectangle2D rectangle2D, boolean bl) {
        if (bl) {
            this._$2(rectangle2D);
        }
        return this._$1(rectangle2D);
    }

    private void _$2(Rectangle2D rectangle2D) {
        for (int i = 0; i < this._$1.size(); ++i) {
            double[] dArray;
            for (double d : dArray = this._$1.get(i).getScales()) {
                this._$1.get(i).clear(d, rectangle2D);
            }
        }
    }

    private boolean _$1(Rectangle2D rectangle2D) {
        MapCacheProviderNative.jni_ClearDynamicCache(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom());
        return true;
    }

    public StorageType getStorageType() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("getStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        int n = MapCacheProviderNative.jni_GetStorageType(this.getHandle());
        return (StorageType)InternalEnum.parseUGCValue(StorageType.class, n);
    }

    public void setStorageType(StorageType storageType) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setStorageType()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheProviderNative.jni_SetStorageType(this.getHandle(), InternalEnum.getUGCValue(storageType));
    }

    public void setHashCodeIgnored(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("setHashCodeIgnored()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        MapCacheProviderNative.jni_SetHashCodeIgnored(this.getHandle(), bl);
    }

    public boolean isHashCodeIgnored() {
        if (this.getHandle() == 0L) {
            String string = InternalResource.loadString("isHashCodeIgnored()", "Handle_ObjectHasBeenDisposed", "processing_resources");
            throw new IllegalStateException(string);
        }
        return MapCacheProviderNative.jni_IsHashCodeIgnored(this.getHandle());
    }

    private String _$2() {
        String string = "";
        string = this.getOutputFolder().isEmpty() ? "./" : this.getOutputFolder();
        if (!string.endsWith("/") || !string.endsWith("\\")) {
            string = string + "/";
        }
        string = string + this._$1();
        string = string + ".xml";
        return string;
    }

    private String _$1() {
        String string = "";
        string = !this.getName().isEmpty() ? this.getName() : (this._$2 != null ? this._$2.getName() : "Provider");
        return string;
    }
}

