/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.analyst.spatialanalyst;

import com.supermap.analyst.spatialanalyst.GridAnalystSetting;
import com.supermap.analyst.spatialanalyst.InternalDatasetGrid;
import com.supermap.analyst.spatialanalyst.InternalDatasetVector;
import com.supermap.analyst.spatialanalyst.InternalDatasets;
import com.supermap.analyst.spatialanalyst.InternalGeometry;
import com.supermap.analyst.spatialanalyst.InternalHandle;
import com.supermap.analyst.spatialanalyst.InternalResource;
import com.supermap.analyst.spatialanalyst.InternalToolkitSpatialAnalyst;
import com.supermap.analyst.spatialanalyst.ViewShedType;
import com.supermap.analyst.spatialanalyst.VisibilityAnalystNative;
import com.supermap.analyst.spatialanalyst.VisibleResult;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetGrid;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.GeoLine;
import com.supermap.data.License;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.data.ProductType;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import java.util.ArrayList;
import java.util.Vector;

public class VisibilityAnalyst {
    private static transient Vector _$3;
    private static License _$2;
    private static GridAnalystSetting _$1;

    private VisibilityAnalyst() {
        _$1 = null;
    }

    public static GridAnalystSetting getAnalystSetting() {
        return _$1;
    }

    public static void setAnalystSetting(GridAnalystSetting gridAnalystSetting) {
        if (gridAnalystSetting == null) {
            _$1 = null;
            return;
        }
        if (_$1 == null) {
            _$1 = new GridAnalystSetting();
        }
        _$1.setBounds(gridAnalystSetting.getBounds());
        _$1.setBoundsType(gridAnalystSetting.getBoundsType());
        _$1.setCellSizeType(gridAnalystSetting.getCellSizeType());
        _$1.setCellSize(gridAnalystSetting.getCellSize());
        _$1.setOutputDatasource(gridAnalystSetting.getOutputDatasource());
        _$1.setGridOutputNamePrefix(gridAnalystSetting.getGridOutputNamePrefix());
        _$1.setVectorOutputNamePrefix(gridAnalystSetting.getVectorOutputNamePrefix());
        _$1.setValidRegion(gridAnalystSetting.getValidRegion());
        _$1.setShowProgress(gridAnalystSetting.isShowProgress());
    }

    public static VisibleResult isVisible(DatasetGrid datasetGrid, Point3D point3D, Point3D point3D2) {
        VisibilityAnalyst._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = point3D.getX();
        dArray[1] = point3D.getY();
        dArray[2] = point3D.getZ();
        dArray2[0] = point3D2.getX();
        dArray2[1] = point3D2.getY();
        dArray2[2] = point3D2.getZ();
        boolean[] blArray = new boolean[1];
        int[] nArray = new int[2];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[1];
        VisibilityAnalystNative.jni_IsVisible(l, dArray, dArray2, blArray, nArray, dArray3, dArray4);
        Point3D point3D3 = new Point3D();
        point3D3.setX(dArray3[0]);
        point3D3.setY(dArray3[1]);
        point3D3.setZ(dArray3[2]);
        VisibleResult visibleResult = new VisibleResult(blArray[0], nArray[0], nArray[1], point3D3, dArray4[0]);
        return visibleResult;
    }

    private static DatasetVector _$1(DatasetGrid datasetGrid, Point3D point3D, Point3D point3D2, Datasource datasource, String string) {
        VisibilityAnalyst._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != _$1 && null != _$1.getVectorOutputNamePrefix()) {
            string = _$1.getVectorOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = point3D.getX();
        dArray[1] = point3D.getY();
        dArray[2] = point3D.getZ();
        dArray2[0] = point3D2.getX();
        dArray2[1] = point3D2.getY();
        dArray2[2] = point3D2.getZ();
        long l3 = VisibilityAnalystNative.jni_LineOfSight(l, dArray, dArray2, l2, string);
        DatasetVector datasetVector = null;
        if (l3 != 0L) {
            datasetVector = InternalDatasetVector.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetVector);
        }
        return datasetVector;
    }

    public static GeoLine[] lineOfSight(DatasetGrid datasetGrid, Point3D point3D, Point3D point3D2) {
        VisibilityAnalyst._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        dArray[0] = point3D.getX();
        dArray[1] = point3D.getY();
        dArray[2] = point3D.getZ();
        dArray2[0] = point3D2.getX();
        dArray2[1] = point3D2.getY();
        dArray2[2] = point3D2.getZ();
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long[] lArray = VisibilityAnalystNative.jni_LineOfSightGeoLine(l, dArray, dArray2);
        int n = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n];
        for (int i = 0; i < n; ++i) {
            geoLineArray[i] = (GeoLine)InternalGeometry.createInstance(lArray[i]);
        }
        return geoLineArray;
    }

    public static VisibleResult[] isVisible(DatasetGrid datasetGrid, Point3Ds point3Ds, Point3Ds point3Ds2) {
        int n;
        VisibilityAnalyst._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string);
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        double[] dArray = new double[point3Ds.getCount() * 3];
        double[] dArray2 = new double[point3Ds2.getCount() * 3];
        for (n = 0; n < point3Ds.getCount(); ++n) {
            dArray[3 * n] = point3Ds.getItem(n).getX();
            dArray[3 * n + 1] = point3Ds.getItem(n).getY();
            dArray[3 * n + 2] = point3Ds.getItem(n).getZ();
        }
        for (n = 0; n < point3Ds2.getCount(); ++n) {
            dArray2[3 * n] = point3Ds2.getItem(n).getX();
            dArray2[3 * n + 1] = point3Ds2.getItem(n).getY();
            dArray2[3 * n + 2] = point3Ds2.getItem(n).getZ();
        }
        n = point3Ds.getCount() * point3Ds2.getCount();
        boolean[] blArray = new boolean[n];
        int[] nArray = new int[n * 2];
        double[] dArray3 = new double[n * 3];
        double[] dArray4 = new double[n];
        VisibilityAnalystNative.jni_IsVisible(l, dArray, dArray2, blArray, nArray, dArray3, dArray4);
        VisibleResult[] visibleResultArray = new VisibleResult[n];
        for (int i = 0; i < n; ++i) {
            Point3D point3D = new Point3D();
            point3D.setX(dArray3[3 * i]);
            point3D.setY(dArray3[3 * i + 1]);
            point3D.setZ(dArray3[3 * i + 2]);
            visibleResultArray[i] = new VisibleResult(blArray[i], nArray[2 * i], nArray[2 * i + 1], point3D, dArray4[i]);
        }
        return visibleResultArray;
    }

    public static DatasetGrid calculateViewShed(DatasetGrid datasetGrid, Point3D point3D, double d, double d2, double d3, Datasource datasource, String string) {
        VisibilityAnalyst._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        double[] dArray = new double[]{point3D.getX(), point3D.getY(), point3D.getZ()};
        long l3 = VisibilityAnalystNative.jni_CalculateViewShed(l, dArray, d, d2, d3, l2, string, bl);
        DatasetGrid datasetGrid2 = null;
        if (l3 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    public static DatasetGrid calculateViewShed(DatasetGrid datasetGrid, Point3Ds point3Ds, double[] dArray, double[] dArray2, double[] dArray3, Datasource datasource, String string, ViewShedType viewShedType) {
        VisibilityAnalyst._$1();
        if (datasetGrid == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid) == 0L) {
            String string2 = InternalResource.loadString("sourceDataset", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new NullPointerException(string2);
        }
        if (datasource == null || InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            datasource = _$1 != null && _$1.getOutputDatasource() != null ? _$1.getOutputDatasource() : datasetGrid.getDatasource();
        }
        if (InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource) == 0L) {
            String string3 = InternalResource.loadString("targetDatasource", "Global_ArgumentObjectHasBeenDisposed", "spatialanalyst_resources");
            throw new IllegalArgumentException(string3);
        }
        if (null == string) {
            String string4 = InternalResource.loadString("targetDatasetName", "Global_ArgumentNull", "spatialanalyst_resources");
            throw new IllegalArgumentException(string4);
        }
        if (null != _$1 && null != _$1.getGridOutputNamePrefix()) {
            string = _$1.getGridOutputNamePrefix() + string;
        }
        if (!datasource.getDatasets().isAvailableDatasetName(string)) {
            String string5 = InternalResource.loadString("targetDatasetName", "GlobalDatasetNameInvalid", "spatialanalyst_resources");
            throw new IllegalArgumentException(string5);
        }
        boolean bl = false;
        if (null != _$1) {
            bl = _$1.isShowProgress();
        }
        long l = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasetGrid);
        long l2 = InternalHandle.getHandle((com.supermap.data.InternalHandle)datasource);
        double[] dArray4 = new double[point3Ds.getCount() * 3];
        for (int i = 0; i < point3Ds.getCount(); ++i) {
            dArray4[3 * i] = point3Ds.getItem(i).getX();
            dArray4[3 * i + 1] = point3Ds.getItem(i).getY();
            dArray4[3 * i + 2] = point3Ds.getItem(i).getZ();
        }
        long l3 = VisibilityAnalystNative.jni_CalculateViewShed2(l, dArray4, dArray, dArray2, dArray3, l2, string, viewShedType.value(), bl);
        DatasetGrid datasetGrid2 = null;
        if (l3 != 0L) {
            datasetGrid2 = InternalDatasetGrid.createInstance(l3, datasource);
            InternalDatasets.add(datasource.getDatasets(), (Dataset)datasetGrid2);
        }
        return datasetGrid2;
    }

    public static synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (_$3 == null) {
            _$3 = new Vector();
        }
        if (!_$3.contains(steppedListener)) {
            _$3.add(steppedListener);
        }
    }

    public static synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (_$3 != null && _$3.contains(steppedListener)) {
            _$3.remove(steppedListener);
        }
    }

    protected static void fireStepped(SteppedEvent steppedEvent) {
        if (_$3 != null) {
            Vector vector = _$3;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SteppedListener)vector.elementAt(i)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(int n, long l, String string, String string2, long l2) {
        String string3 = "VisibilityAnalyst";
        boolean bl = InternalToolkitSpatialAnalyst.getHandleBooleanValue(l2);
        Object object = new Object();
        SteppedEvent steppedEvent = new SteppedEvent(object, n, l, string, string2, string3);
        VisibilityAnalyst.fireStepped(steppedEvent);
        InternalToolkitSpatialAnalyst.setHandleBooleanValue(l2, steppedEvent.getCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _$1() {
        int n = -1;
        Object object = _$2;
        synchronized (object) {
            n = _$2.verify();
        }
        if (n != 0) {
            object = License.getErrorMessage((int)n);
            throw new IllegalStateException((String)object);
        }
    }

    static {
        ArrayList<ProductType> arrayList = InternalToolkitSpatialAnalyst.managerProducts(InternalToolkitSpatialAnalyst.getSpatialAnalystProducts());
        _$2 = InternalToolkitSpatialAnalyst.verifyLicense(arrayList);
    }
}

