// Copyright (c) 1998 by W3C
//
// DOM is a trademark of W3C
// The DOM level 1 specification, from which this
// source is derived, is copyright by W3C.
// See: http://www.w3.org/TR/REC-DOM-Level-1/
//

package org.w3c.dom.html;

import org.w3c.dom.*;

/**

  <P>The 
    <code>LINK</code> element specifies a link to an external resource, and defines this document's relationship to that resource (or vice versa). See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#edef-LINK">LINK element definition</A>
 in HTML 4.0.
  
</P>

<HR>

<!-- ======== PROPERTY SUMMARY ======== -->

<A NAME="property_summary"><!-- --></A>
<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0 WIDTH=100%>
<TR BGCOLOR=#CCCCFF ID=TableHeadingColor>
<TD COLSPAN=3><FONT SIZE=+2><B>Property Summary</B>
</FONT></TD></TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-disabled><CODE>&nbsp;disabled</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getDisabled()'>getDisabled</a>
<a href='#setDisabled(java.lang.String)'>setDisabled</a>
</TD>
<TD>
  <P>Enables/disables the link. This is currently only used for style sheet links, and may be used to activate or deactivate style sheets. 
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-charset><CODE>&nbsp;charset</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getCharset()'>getCharset</a>
<a href='#setCharset(java.lang.String)'>setCharset</a>
</TD>
<TD>
  <P>The character encoding of the resource being linked to. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-charset">charset attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-href><CODE>&nbsp;href</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHref()'>getHref</a>
<a href='#setHref(java.lang.String)'>setHref</a>
</TD>
<TD>
  <P>The URI of the linked resource. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-href">href attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-hreflang><CODE>&nbsp;hreflang</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getHreflang()'>getHreflang</a>
<a href='#setHreflang(java.lang.String)'>setHreflang</a>
</TD>
<TD>
  <P>Language code of the linked resource. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-hreflang">hreflang attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-media><CODE>&nbsp;media</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getMedia()'>getMedia</a>
<a href='#setMedia(java.lang.String)'>setMedia</a>
</TD>
<TD>
  <P>Designed for use with one or more target media. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/styles.html#adef-media">media attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-rel><CODE>&nbsp;rel</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getRel()'>getRel</a>
<a href='#setRel(java.lang.String)'>setRel</a>
</TD>
<TD>
  <P>Forward link type. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-rel">rel attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-rev><CODE>&nbsp;rev</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getRev()'>getRev</a>
<a href='#setRev(java.lang.String)'>setRev</a>
</TD>
<TD>
  <P>Reverse link type. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-rev">rev attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-target><CODE>&nbsp;target</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getTarget()'>getTarget</a>
<a href='#setTarget(java.lang.String)'>setTarget</a>
</TD>
<TD>
  <P>Frame to render the resource in. See the 
    <A  href="http://www.w3.org/TR/REC-html40/present/frames.html#adef-target">target attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
<TR><TD ALIGN=right VALIGN=top WIDTH=1%>
<a name=att-type><CODE>&nbsp;type</CODE></a></TD>
<TD ALIGN=center VALIGN=top WIDTH=1%>
<a href='#getType()'>getType</a>
<a href='#setType(java.lang.String)'>setType</a>
</TD>
<TD>
  <P>Advisory content type. See the 
    <A  href="http://www.w3.org/TR/REC-html40/struct/links.html#adef-type-A">type attribute definition</A>
 in HTML 4.0.
  
</P>
</TD>
</TR>
</TABLE>
&nbsp;
*/
public interface HTMLLinkElement
extends HTMLElement
{
	/** Assigns the value of the <code><a href=#att-disabled>disabled</a></code> property.
	 */
	void setDisabled (boolean disabled);

	/**
	 * Returns the value of the <code><a href=#att-disabled>disabled</a></code> property.
	*/
	boolean getDisabled ();


	/** Assigns the value of the <code><a href=#att-charset>charset</a></code> property.
	 */
	void setCharset (String charset);

	/**
	 * Returns the value of the <code><a href=#att-charset>charset</a></code> property.
	*/
	String getCharset ();


	/** Assigns the value of the <code><a href=#att-href>href</a></code> property.
	 */
	void setHref (String href);

	/**
	 * Returns the value of the <code><a href=#att-href>href</a></code> property.
	*/
	String getHref ();


	/** Assigns the value of the <code><a href=#att-hreflang>hreflang</a></code> property.
	 */
	void setHreflang (String hreflang);

	/**
	 * Returns the value of the <code><a href=#att-hreflang>hreflang</a></code> property.
	*/
	String getHreflang ();


	/** Assigns the value of the <code><a href=#att-media>media</a></code> property.
	 */
	void setMedia (String media);

	/**
	 * Returns the value of the <code><a href=#att-media>media</a></code> property.
	*/
	String getMedia ();


	/** Assigns the value of the <code><a href=#att-rel>rel</a></code> property.
	 */
	void setRel (String rel);

	/**
	 * Returns the value of the <code><a href=#att-rel>rel</a></code> property.
	*/
	String getRel ();


	/** Assigns the value of the <code><a href=#att-rev>rev</a></code> property.
	 */
	void setRev (String rev);

	/**
	 * Returns the value of the <code><a href=#att-rev>rev</a></code> property.
	*/
	String getRev ();


	/** Assigns the value of the <code><a href=#att-target>target</a></code> property.
	 */
	void setTarget (String target);

	/**
	 * Returns the value of the <code><a href=#att-target>target</a></code> property.
	*/
	String getTarget ();


	/** Assigns the value of the <code><a href=#att-type>type</a></code> property.
	 */
	void setType (String type);

	/**
	 * Returns the value of the <code><a href=#att-type>type</a></code> property.
	*/
	String getType ();


}
