/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.io.ASCII85InputStream;
import org.apache.pdfbox.io.ASCII85OutputStream;

public class ASCII85Filter
implements Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        ASCII85InputStream is = null;
        try {
            is = new ASCII85InputStream(compressedData);
            byte[] buffer = new byte[1024];
            int amountRead = 0;
            while ((amountRead = is.read(buffer, 0, 1024)) != -1) {
                result.write(buffer, 0, amountRead);
            }
            result.flush();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        ASCII85OutputStream os = new ASCII85OutputStream(result);
        byte[] buffer = new byte[1024];
        int amountRead = 0;
        while ((amountRead = rawData.read(buffer, 0, 1024)) != -1) {
            os.write(buffer, 0, amountRead);
        }
        os.close();
        result.flush();
    }
}

