/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.core.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.lucene.messages.NLS;
import org.apache.lucene.queryParser.core.messages.QueryParserMessages;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryNodeImpl
implements QueryNode,
Cloneable {
    private static final long serialVersionUID = 5569870883474845989L;
    public static final String PLAINTEXT_FIELD_NAME = "_plain";
    private boolean isLeaf = true;
    private Hashtable<String, Object> tags = new Hashtable();
    private List<QueryNode> clauses = null;
    private QueryNode parent = null;
    protected boolean toQueryStringIgnoreFields = false;

    protected void allocate() {
        if (this.clauses == null) {
            this.clauses = new ArrayList<QueryNode>();
        } else {
            this.clauses.clear();
        }
    }

    @Override
    public final void add(QueryNode child) {
        if (this.isLeaf() || this.clauses == null || child == null) {
            throw new IllegalArgumentException(NLS.getLocalizedMessage(QueryParserMessages.NODE_ACTION_NOT_SUPPORTED));
        }
        this.clauses.add(child);
        ((QueryNodeImpl)child).setParent(this);
    }

    @Override
    public final void add(List<QueryNode> children) {
        if (this.isLeaf() || this.clauses == null) {
            throw new IllegalArgumentException(NLS.getLocalizedMessage(QueryParserMessages.NODE_ACTION_NOT_SUPPORTED));
        }
        for (QueryNode child : children) {
            this.add(child);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public final void set(List<QueryNode> children) {
        if (this.isLeaf() || this.clauses == null) {
            ResourceBundle bundle = ResourceBundle.getBundle("org.apache.lucene.queryParser.messages.QueryParserMessages");
            String message = bundle.getObject("Q0008E.NODE_ACTION_NOT_SUPPORTED").toString();
            throw new IllegalArgumentException(message);
        }
        for (QueryNode child : children) {
            ((QueryNodeImpl)child).setParent(null);
        }
        this.allocate();
        for (QueryNode child : children) {
            this.add(child);
        }
    }

    @Override
    public QueryNode cloneTree() throws CloneNotSupportedException {
        QueryNodeImpl clone = (QueryNodeImpl)super.clone();
        clone.isLeaf = this.isLeaf;
        clone.tags = new Hashtable();
        if (this.clauses != null) {
            ArrayList<QueryNode> localClauses = new ArrayList<QueryNode>();
            for (QueryNode clause : this.clauses) {
                localClauses.add(clause.cloneTree());
            }
            clone.clauses = localClauses;
        }
        return clone;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.cloneTree();
    }

    protected void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    @Override
    public final List<QueryNode> getChildren() {
        if (this.isLeaf() || this.clauses == null) {
            return null;
        }
        return this.clauses;
    }

    @Override
    @Deprecated
    public void setTag(CharSequence tagName, Object value) {
        this.tags.put(((Object)tagName).toString().toLowerCase(), value);
    }

    @Override
    public void setTag(String tagName, Object value) {
        this.tags.put(tagName.toLowerCase(), value);
    }

    @Override
    public void unsetTag(String tagName) {
        this.tags.remove(tagName.toLowerCase());
    }

    @Override
    @Deprecated
    public void unsetTag(CharSequence tagName) {
        this.tags.remove(((Object)tagName).toString().toLowerCase());
    }

    @Override
    @Deprecated
    public boolean containsTag(CharSequence tagName) {
        return this.tags.containsKey(((Object)tagName).toString().toLowerCase());
    }

    @Override
    public boolean containsTag(String tagName) {
        return this.tags.containsKey(tagName.toLowerCase());
    }

    @Override
    @Deprecated
    public Object getTag(CharSequence tagName) {
        return this.tags.get(((Object)tagName).toString().toLowerCase());
    }

    @Override
    public Object getTag(String tagName) {
        return this.tags.get(tagName.toString().toLowerCase());
    }

    private void setParent(QueryNode parent) {
        this.parent = parent;
    }

    @Override
    public QueryNode getParent() {
        return this.parent;
    }

    protected boolean isRoot() {
        return this.getParent() == null;
    }

    protected boolean isDefaultField(CharSequence fld) {
        if (this.toQueryStringIgnoreFields) {
            return true;
        }
        if (fld == null) {
            return true;
        }
        return PLAINTEXT_FIELD_NAME.equals(StringUtils.toString(fld));
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    @Deprecated
    public Map<CharSequence, Object> getTags() {
        Map map = (Map)this.tags.clone();
        HashMap<CharSequence, Object> charSeqMap = new HashMap<CharSequence, Object>();
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            charSeqMap.put(key, obj);
        }
        return charSeqMap;
    }

    @Override
    public Map<String, Object> getTagMap() {
        return (Map)this.tags.clone();
    }
}

